/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart;

import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.lang.reflect.Field;
import org.jCharts.axisChart.Axis;
import org.jCharts.axisChart.AxisChart;
import org.jCharts.chartData.interfaces.IDataSeries;
import org.jCharts.chartData.processors.AxisChartDataProcessor;
import org.jCharts.chartData.processors.TextProcessor;
import org.jCharts.properties.AxisProperties;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.HTMLTestable;

final class XAxis
extends Axis
implements HTMLTestable {
    private int xLabelFilter = 1;
    private float tickStartX;

    public XAxis(AxisChart axisChart) {
        super(axisChart);
    }

    void computeMinimumHeightNeeded(IDataSeries iDataSeries, AxisChartDataProcessor axisChartDataProcessor) {
        float f;
        if (super.getAxisChart().getAxisProperties().getXAxisVerticalScaleFlag()) {
            f = axisChartDataProcessor.getAxisLabelProcessor().getWidestLabel();
        } else {
            f = axisChartDataProcessor.getAxisLabelProcessor().getTallestLabel();
            f += 3.0f;
        }
        if (super.getAxisChart().getAxisProperties().getShowTicks(0) != 0) {
            f += super.getAxisChart().getAxisProperties().getPaddingBetweenLabelsAndTicks(0);
            f += super.getAxisChart().getAxisProperties().getAxisTickMarkPixelLength(0);
        } else {
            f += super.getAxisChart().getAxisProperties().getPaddingBetweenAxisAndLabels(0);
        }
        if (iDataSeries.getXAxisTitle() != null) {
            super.computeAxisTitleDimensions(iDataSeries.getXAxisTitle());
            f += super.getTitleHeight();
            f += super.getAxisChart().getAxisProperties().getPaddingBetweenAxisTitleAndLabels(0);
        }
        super.setMinimumHeightNeeded(f);
    }

    void computeScalePixelWidth(int n) {
        super.setScalePixelWidth(super.getPixelLength() / (float)n);
    }

    void render(Graphics2D graphics2D, AxisProperties axisProperties, IDataSeries iDataSeries, TextProcessor textProcessor) {
        float f;
        if (iDataSeries.getXAxisTitle() != null) {
            f = super.getAxisChart().getYAxis().getOrigin() + this.getMinimumHeightNeeded() - super.getTitleHeight();
            float f2 = super.getTitleWidth() > super.getPixelLength() ? ((float)super.getAxisChart().getImageWidth() - super.getTitleWidth()) / 2.0f : super.getOrigin() + (super.getPixelLength() - super.getTitleWidth()) / 2.0f;
            graphics2D.setFont(axisProperties.getAxisTitleFont());
            graphics2D.setPaint(axisProperties.getAxisTitleColor());
            graphics2D.drawString(iDataSeries.getXAxisTitle(), f2, f);
        }
        this.tickStartX = super.getOrigin() + super.getScalePixelWidth() / 2.0f;
        Line2D.Float float_ = new Line2D.Float(this.tickStartX, 0.0f, this.tickStartX, 0.0f);
        f = super.getAxisChart().getYAxis().getOrigin();
        float f3 = super.getAxisChart().getYAxis().getOrigin() + super.getAxisChart().getAxisProperties().getAxisTickMarkPixelLength(0);
        float f4 = super.getAxisChart().getYAxis().getOrigin();
        float f5 = super.getAxisChart().getYAxis().getOrigin() - super.getAxisChart().getYAxis().getPixelLength();
        float f6 = this.tickStartX;
        float f7 = super.getAxisChart().getYAxis().getOrigin();
        f7 = axisProperties.getShowTicks(0) != 0 ? (f7 += super.getAxisChart().getAxisProperties().getAxisTickMarkPixelLength(0) + super.getAxisChart().getAxisProperties().getPaddingBetweenLabelsAndTicks(0)) : (f7 += super.getAxisChart().getAxisProperties().getPaddingBetweenAxisAndLabels(0));
        if (!super.getAxisChart().getAxisProperties().getXAxisVerticalScaleFlag()) {
            f7 += textProcessor.getTallestLabel();
            graphics2D.setFont(axisProperties.getScaleFont());
        } else {
            graphics2D.setFont(axisProperties.getScaleFont().deriveFont(Axis.VERTICAL_LABEL_ROTATION));
        }
        int n = 0;
        while (n < iDataSeries.getNumberOfXAxisLabels()) {
            if (axisProperties.getShowGridLine(0) == 1 || axisProperties.getShowGridLine(0) == 2 && n % this.xLabelFilter == 0) {
                float_.y1 = f4;
                float_.y2 = f5;
                if (n < iDataSeries.getNumberOfXAxisLabels() || n == iDataSeries.getNumberOfXAxisLabels() && !axisProperties.getShowRightBorder()) {
                    graphics2D.setStroke(axisProperties.getGridLineStroke(0));
                    graphics2D.setPaint(axisProperties.getGridLineColor(0));
                    graphics2D.draw(float_);
                }
            }
            if (n != iDataSeries.getNumberOfXAxisLabels() && (axisProperties.getShowTicks(0) == 1 || axisProperties.getShowTicks(0) == 2 && n % this.xLabelFilter == 0)) {
                float_.y1 = f;
                float_.y2 = f3;
                graphics2D.setStroke(axisProperties.getTickStroke(0));
                graphics2D.setPaint(axisProperties.getTickColor(0));
                graphics2D.draw(float_);
            }
            float_.x1 += super.getScalePixelWidth();
            float_.x2 = float_.x1;
            if (n % this.xLabelFilter == 0) {
                graphics2D.setPaint(axisProperties.getScaleFontColor());
                if (!super.getAxisChart().getAxisProperties().getXAxisVerticalScaleFlag()) {
                    graphics2D.drawString(iDataSeries.getXAxisLabel(n), f6 - textProcessor.getLabelWidth(n) / 2.0f, f7);
                } else {
                    graphics2D.drawString(iDataSeries.getXAxisLabel(n), f6 + textProcessor.getFontDescent() / 2.0f, f7 + textProcessor.getLabelWidth(n));
                }
            }
            f6 += super.getScalePixelWidth();
            ++n;
        }
        if (axisProperties.getShowRightBorder()) {
            float_.x2 = float_.x1 = super.getOrigin() + super.getPixelLength() + 1.0f;
            float_.y1 = f4;
            float_.y2 = f5;
            graphics2D.setStroke(axisProperties.getAxisStroke(1));
            graphics2D.setPaint(axisProperties.getAxisColor(1));
            graphics2D.draw(float_);
        }
        float_.x1 = super.getOrigin();
        float_.x2 = super.getOrigin() + super.getPixelLength();
        float_.y2 = float_.y1 = super.getAxisChart().getYAxis().getOrigin();
        graphics2D.setStroke(axisProperties.getAxisStroke(0));
        graphics2D.setPaint(axisProperties.getAxisColor(0));
        graphics2D.draw(float_);
    }

    void computeLabelFilter(int n, TextProcessor textProcessor) {
        float f = super.getAxisChart().getAxisProperties().getXAxisVerticalScaleFlag() ? textProcessor.getTallestLabel() : textProcessor.getWidestLabel();
        double d = this.getPixelLength() / (f + super.getAxisChart().getAxisProperties().getPaddingBetweenXAxisLabels());
        this.xLabelFilter = (int)Math.ceil((double)n / d);
    }

    float getTickStartX() {
        return this.tickStartX;
    }

    public void toHTML(HTMLGenerator hTMLGenerator) {
        hTMLGenerator.propertiesTableStart(this.getClass().getName());
        super.toHTML(hTMLGenerator);
        Field[] fieldArray = this.getClass().getDeclaredFields();
        int n = 0;
        while (n < fieldArray.length) {
            try {
                hTMLGenerator.addField(fieldArray[n].getName(), fieldArray[n].get(this));
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            ++n;
        }
        hTMLGenerator.propertiesTableEnd();
    }
}

