/*
 * Decompiled with CFR 0.152.
 */
package net.sf.ehcache.distribution;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Properties;
import java.util.StringTokenizer;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.distribution.ManualRMICacheManagerPeerProvider;
import net.sf.ehcache.distribution.MulticastRMICacheManagerPeerProvider;
import net.sf.ehcache.distribution.RMICacheManagerPeerProvider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class RMICacheManagerPeerProviderFactory
extends CacheManagerPeerProviderFactory {
    private static final Log LOG = LogFactory.getLog((String)(class$net$sf$ehcache$distribution$RMICacheManagerPeerProviderFactory == null ? (class$net$sf$ehcache$distribution$RMICacheManagerPeerProviderFactory = RMICacheManagerPeerProviderFactory.class$("net.sf.ehcache.distribution.RMICacheManagerPeerProviderFactory")) : class$net$sf$ehcache$distribution$RMICacheManagerPeerProviderFactory).getName());
    private static final String PEER_DISCOVERY = "peerDiscovery";
    private static final String AUTOMATIC_PEER_DISCOVERY = "automatic";
    private static final String MANUALLY_CONFIGURED_PEER_DISCOVERY = "manual";
    private static final String RMI_URLS = "rmiUrls";
    private static final String MULTICAST_GROUP_PORT = "multicastGroupPort";
    private static final String MULTICAST_GROUP_ADDRESS = "multicastGroupAddress";
    static /* synthetic */ Class class$net$sf$ehcache$distribution$RMICacheManagerPeerProviderFactory;

    public final CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) throws CacheException {
        String peerDiscovery = RMICacheManagerPeerProviderFactory.extractAndLogProperty(PEER_DISCOVERY, properties);
        if (peerDiscovery.equalsIgnoreCase(AUTOMATIC_PEER_DISCOVERY)) {
            try {
                return RMICacheManagerPeerProviderFactory.createAutomaticallyConfiguredCachePeerProvider(cacheManager, properties);
            }
            catch (IOException e) {
                throw new CacheException("Could not create CacheManagerPeerProvider. Initial cause was " + e.getMessage(), e);
            }
        }
        if (peerDiscovery.equalsIgnoreCase(MANUALLY_CONFIGURED_PEER_DISCOVERY)) {
            return RMICacheManagerPeerProviderFactory.createManuallyConfiguredCachePeerProvider(properties);
        }
        return null;
    }

    private static CacheManagerPeerProvider createManuallyConfiguredCachePeerProvider(Properties properties) {
        String rmiUrls = RMICacheManagerPeerProviderFactory.extractAndLogProperty(RMI_URLS, properties);
        if (rmiUrls == null || rmiUrls.length() == 0) {
            throw new CacheException("rmiUrls must be specified when peerDiscovery is manual");
        }
        rmiUrls = rmiUrls.trim();
        StringTokenizer stringTokenizer = new StringTokenizer(rmiUrls, "|");
        ManualRMICacheManagerPeerProvider rmiPeerProvider = new ManualRMICacheManagerPeerProvider();
        while (stringTokenizer.hasMoreTokens()) {
            String rmiUrl = stringTokenizer.nextToken();
            rmiUrl = rmiUrl.trim();
            ((RMICacheManagerPeerProvider)rmiPeerProvider).registerPeer(rmiUrl);
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Registering peer " + rmiUrl));
        }
        return rmiPeerProvider;
    }

    private static CacheManagerPeerProvider createAutomaticallyConfiguredCachePeerProvider(CacheManager cacheManager, Properties properties) throws IOException {
        String groupAddressString = RMICacheManagerPeerProviderFactory.extractAndLogProperty(MULTICAST_GROUP_ADDRESS, properties);
        InetAddress groupAddress = InetAddress.getByName(groupAddressString);
        String multicastPortString = RMICacheManagerPeerProviderFactory.extractAndLogProperty(MULTICAST_GROUP_PORT, properties);
        Integer multicastPort = new Integer(multicastPortString);
        return new MulticastRMICacheManagerPeerProvider(cacheManager, groupAddress, multicastPort);
    }

    private static String extractAndLogProperty(String name, Properties properties) {
        String foundValue = (String)properties.get(name);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Value found for " + name + ": " + foundValue));
        }
        return foundValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

