/*
 * Decompiled with CFR 0.152.
 */
package mondrian.mdx;

import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.MdxVisitor;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.type.DimensionType;
import mondrian.olap.type.Type;

public class DimensionExpr
extends ExpBase
implements Exp {
    private final Dimension dimension;

    public DimensionExpr(Dimension dimension) {
        Util.assertPrecondition(dimension != null, "dimension != null");
        this.dimension = dimension;
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public String toString() {
        return this.dimension.getUniqueName();
    }

    public Type getType() {
        return DimensionType.forDimension(this.dimension);
    }

    public DimensionExpr clone() {
        return new DimensionExpr(this.dimension);
    }

    public int getCategory() {
        return 2;
    }

    public Exp accept(Validator validator) {
        return this;
    }

    public Calc accept(ExpCompiler compiler) {
        return ConstantCalc.constantDimension(this.dimension);
    }

    public Object accept(MdxVisitor visitor) {
        return visitor.visit(this);
    }
}

