/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.queryframework;

import java.util.HashMap;
import java.util.Map;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.exceptions.QueryException;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.internal.localization.ExceptionLocalization;
import oracle.toplink.essentials.internal.queryframework.JoinedAttributeManager;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;
import oracle.toplink.essentials.queryframework.FieldResult;
import oracle.toplink.essentials.queryframework.ResultSetMappingQuery;
import oracle.toplink.essentials.queryframework.SQLResult;
import oracle.toplink.essentials.sessions.DatabaseRecord;

public class EntityResult
extends SQLResult {
    protected String entityClassName;
    protected Class entityClass;
    protected Map fieldResults;
    protected String discriminatorColumn;

    public EntityResult(Class entityClass) {
        this.entityClass = entityClass;
        if (this.entityClass == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_entity_result"));
        }
    }

    public EntityResult(String entityClassName) {
        this.entityClassName = entityClassName;
        if (this.entityClassName == null) {
            throw new IllegalArgumentException(ExceptionLocalization.buildMessage("null_value_for_entity_result"));
        }
    }

    public void addFieldResult(FieldResult fieldResult) {
        if (fieldResult == null || fieldResult.getAttributeName() == null) {
            return;
        }
        FieldResult existingFieldResult = (FieldResult)this.getFieldResults().get(fieldResult.getAttributeName());
        if (existingFieldResult == null) {
            this.getFieldResults().put(fieldResult.getAttributeName(), fieldResult);
        } else {
            existingFieldResult.add(fieldResult);
        }
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        Class entityClass = null;
        try {
            entityClass = PrivilegedAccessController.getClassForName(this.entityClassName, true, classLoader);
        }
        catch (ClassNotFoundException exc) {
            throw ValidationException.classNotFoundWhileConvertingClassNames(this.entityClassName, exc);
        }
        this.entityClass = entityClass;
    }

    public Map getFieldResults() {
        if (this.fieldResults == null) {
            this.fieldResults = new HashMap();
        }
        return this.fieldResults;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(String column) {
        if (column == null) {
            return;
        }
        this.discriminatorColumn = column;
    }

    public Object getValueFromRecord(DatabaseRecord record, ResultSetMappingQuery query) {
        ClassDescriptor descriptor = query.getSession().getDescriptor(this.entityClass);
        DatabaseRecord entityRecord = new DatabaseRecord(descriptor.getFields().size());
        if (descriptor.hasInheritance()) {
            if (this.discriminatorColumn != null) {
                Object value = record.get(this.discriminatorColumn);
                if (value == null) {
                    throw QueryException.discriminatorColumnNotSelected(this.discriminatorColumn, query.getSQLResultSetMapping().getName());
                }
                entityRecord.put(descriptor.getInheritancePolicy().getClassIndicatorField(), record.get(this.discriminatorColumn));
            } else {
                entityRecord.put(descriptor.getInheritancePolicy().getClassIndicatorField(), record.get(descriptor.getInheritancePolicy().getClassIndicatorField()));
            }
            if (descriptor.hasInheritance() && descriptor.getInheritancePolicy().shouldReadSubclasses()) {
                Class classValue = descriptor.getInheritancePolicy().classFromRow(entityRecord, query.getSession());
                descriptor = query.getSession().getDescriptor(classValue);
            }
        }
        for (DatabaseMapping mapping : descriptor.getMappings()) {
            FieldResult fieldResult = (FieldResult)this.getFieldResults().get(mapping.getAttributeName());
            if (fieldResult != null) {
                if (mapping.getFields().size() == 1) {
                    entityRecord.put(mapping.getFields().firstElement(), record.get(fieldResult.getColumnName()));
                    continue;
                }
                if (mapping.getFields().size() <= 1) continue;
                this.getValueFromRecordForMapping(entityRecord, mapping, fieldResult, record);
                continue;
            }
            for (DatabaseField field : mapping.getFields()) {
                entityRecord.put(field, record.get(field));
            }
        }
        query.setReferenceClass(this.entityClass);
        query.setDescriptor(descriptor);
        return descriptor.getObjectBuilder().buildObject(query, entityRecord, new JoinedAttributeManager(descriptor, null, query));
    }

    public boolean isEntityResult() {
        return true;
    }

    public void getValueFromRecordForMapping(DatabaseRecord entityRecord, DatabaseMapping mapping, FieldResult fieldResult, DatabaseRecord databaseRecord) {
        ClassDescriptor currentDescriptor = mapping.getReferenceDescriptor();
        if (fieldResult.getFieldResults() == null) {
            DatabaseField dbfield = this.processValueFromRecordForMapping(currentDescriptor, fieldResult.getMultipleFieldIdentifiers(), 1);
            if (mapping.isOneToOneMapping()) {
                dbfield = (DatabaseField)((OneToOneMapping)mapping).getTargetToSourceKeyFields().get(dbfield);
            }
            entityRecord.put(dbfield, databaseRecord.get(fieldResult.getColumnName()));
            return;
        }
        for (FieldResult tempFieldResult : fieldResult.getFieldResults()) {
            DatabaseField dbfield = this.processValueFromRecordForMapping(currentDescriptor, tempFieldResult.getMultipleFieldIdentifiers(), 1);
            if (mapping.isOneToOneMapping()) {
                dbfield = (DatabaseField)((OneToOneMapping)mapping).getTargetToSourceKeyFields().get(dbfield);
            }
            entityRecord.put(dbfield, databaseRecord.get(tempFieldResult.getColumnName()));
        }
    }

    public DatabaseField processValueFromRecordForMapping(ClassDescriptor descriptor, String[] attributeNames, int currentLoc) {
        DatabaseMapping mapping = descriptor.getMappingForAttributeName(attributeNames[currentLoc]);
        if (mapping == null) {
            throw QueryException.mappingForFieldResultNotFound(attributeNames, currentLoc);
        }
        if (attributeNames.length != ++currentLoc) {
            ClassDescriptor currentDescriptor = mapping.getReferenceDescriptor();
            DatabaseField df = this.processValueFromRecordForMapping(currentDescriptor, attributeNames, currentLoc);
            if (mapping.isOneToOneMapping()) {
                return (DatabaseField)((OneToOneMapping)mapping).getTargetToSourceKeyFields().get(df);
            }
            return df;
        }
        return (DatabaseField)mapping.getFields().firstElement();
    }
}

