/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.logging;

import java.util.Hashtable;
import java.util.ListResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.toplink.essentials.internal.localization.i18n.LoggingLocalizationResource;
import oracle.toplink.essentials.internal.localization.i18n.TraceLocalizationResource;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.logging.SessionLogEntry;
import oracle.toplink.essentials.logging.TopLinkLogRecord;
import oracle.toplink.essentials.sessions.Session;

public class JavaLog
extends AbstractSessionLog {
    private Hashtable nameSpaceTable;
    private Hashtable loggerTable;
    private Hashtable shouldLogTable;
    private Level[] levels = new Level[]{Level.ALL, Level.FINEST, Level.FINER, Level.FINE, Level.CONFIG, Level.INFO, Level.WARNING, Level.SEVERE, Level.OFF};
    private int elementCount = 9;
    private String sessionNameSpace;
    private Logger defaultTopLinkLogger;
    private Logger sessionLogger;
    private Boolean defaultTopLinkShouldLog;
    private Boolean sessionShouldLog;
    protected static final String DEFAULT_SESSION_NAME = "defaultsessionname";
    public static final String DEFAULT_TOPLINK_NAMESPACE = "oracle.toplink.essentials";
    protected static final String LOGGING_LOCALIZATION_STRING = "oracle.toplink.essentials.internal.localization.i18n.LoggingLocalizationResource";
    protected static final String TRACE_LOCALIZATION_STRING = "oracle.toplink.essentials.internal.localization.i18n.TraceLocalizationResource";

    public JavaLog() {
        this.initializeHashtables();
    }

    protected void initializeHashtables() {
        this.nameSpaceTable = new Hashtable();
        this.loggerTable = new Hashtable();
        this.shouldLogTable = new Hashtable();
    }

    public int getLevel(String category) {
        Logger logger;
        for (logger = this.getLogger(category); logger != null && logger.getLevel() == null; logger = logger.getParent()) {
        }
        if (logger == null) {
            return 8;
        }
        int logLevel = logger.getLevel().intValue();
        for (int i = 0; i < this.elementCount; ++i) {
            if (logLevel != this.levels[i].intValue()) continue;
            return i;
        }
        return 8;
    }

    public void setLevel(int level, String category) {
        Logger logger = this.getLogger(category);
        logger.setLevel(this.getJavaLevel(level));
        Boolean shouldLog = new Boolean(logger.isLoggable(this.getJavaLevel(level)));
        if (this.session == null) {
            this.defaultTopLinkShouldLog = shouldLog;
            return;
        }
        if (category == null || category.length() == 0) {
            this.sessionShouldLog = shouldLog;
            return;
        }
        this.shouldLogTable.put(category, shouldLog);
    }

    public String getNameSpaceString(String category) {
        if (this.session == null) {
            return DEFAULT_TOPLINK_NAMESPACE;
        }
        if (category == null || category.length() == 0) {
            return this.sessionNameSpace;
        }
        String nameSpaceString = (String)this.nameSpaceTable.get(category);
        if (nameSpaceString == null) {
            nameSpaceString = this.sessionNameSpace + "." + category;
            this.nameSpaceTable.put(category, nameSpaceString);
        }
        return nameSpaceString;
    }

    public Logger getLogger(String category) {
        if (this.session == null) {
            if (this.defaultTopLinkLogger == null) {
                this.defaultTopLinkLogger = Logger.getLogger(DEFAULT_TOPLINK_NAMESPACE);
            }
            return this.defaultTopLinkLogger;
        }
        if (category == null || category.length() == 0) {
            if (this.sessionLogger == null) {
                this.sessionLogger = Logger.getLogger(this.sessionNameSpace);
            }
            return this.sessionLogger;
        }
        Logger logger = (Logger)this.loggerTable.get(category);
        if (logger == null) {
            logger = Logger.getLogger(this.getNameSpaceString(category));
            this.loggerTable.put(category, logger);
        }
        return logger;
    }

    public void setSession(Session session) {
        super.setSession(session);
        if (session != null) {
            String sessionName = session.getName() != null && session.getName().length() != 0 ? session.getName() : DEFAULT_SESSION_NAME;
            this.sessionNameSpace = "oracle.toplink.essentials." + sessionName;
        }
    }

    private Level getJavaLevel(int level) {
        return this.levels[level];
    }

    public boolean shouldLog(int level, String category) {
        if (this.session == null) {
            if (this.defaultTopLinkShouldLog == null) {
                this.defaultTopLinkShouldLog = new Boolean(this.getLogger(DEFAULT_TOPLINK_NAMESPACE).isLoggable(this.getJavaLevel(level)));
            }
            return this.defaultTopLinkShouldLog;
        }
        if (category == null || category.length() == 0) {
            if (this.sessionShouldLog == null) {
                this.sessionShouldLog = new Boolean(this.getLogger(this.sessionNameSpace).isLoggable(this.getJavaLevel(level)));
            }
            return this.sessionShouldLog;
        }
        Boolean shouldLog = (Boolean)this.shouldLogTable.get(category);
        if (shouldLog == null) {
            shouldLog = new Boolean(this.getLogger(category).isLoggable(this.getJavaLevel(level)));
            this.shouldLogTable.put(category, shouldLog);
        }
        return shouldLog;
    }

    public void log(SessionLogEntry entry) {
        if (!this.shouldLog(entry.getLevel(), entry.getNameSpace())) {
            return;
        }
        Logger logger = this.getLogger(entry.getNameSpace());
        Level javaLevel = this.getJavaLevel(entry.getLevel());
        this.internalLog(entry, javaLevel, logger);
    }

    protected void internalLog(SessionLogEntry entry, Level javaLevel, Logger logger) {
        TopLinkLogRecord lr = new TopLinkLogRecord(javaLevel, entry.getMessage());
        lr.setSourceClassName(null);
        lr.setSourceMethodName(null);
        lr.setParameters(entry.getParameters());
        lr.setLoggerName(this.getNameSpaceString(entry.getNameSpace()));
        if (entry.shouldTranslate()) {
            ListResourceBundle resourceBundle;
            String bundleName;
            if (entry.getLevel() > 3) {
                bundleName = LOGGING_LOCALIZATION_STRING;
                resourceBundle = new LoggingLocalizationResource();
            } else {
                bundleName = TRACE_LOCALIZATION_STRING;
                resourceBundle = new TraceLocalizationResource();
            }
            lr.setResourceBundleName(bundleName);
            lr.setResourceBundle(resourceBundle);
        }
        if (this.shouldPrintSession()) {
            lr.setSessionString(this.getSessionString(entry.getSession()));
        }
        if (this.shouldPrintConnection()) {
            lr.setConnection(entry.getConnection());
        }
        lr.setThrown(entry.getException());
        lr.setShouldLogExceptionStackTrace(this.shouldLogExceptionStackTrace());
        lr.setShouldPrintDate(this.shouldPrintDate());
        lr.setShouldPrintThread(this.shouldPrintThread());
        logger.log(lr);
    }

    public void throwing(Throwable throwable) {
        this.getLogger(null).throwing(null, null, throwable);
    }

    public Object clone() {
        JavaLog cloneLog = (JavaLog)super.clone();
        if (cloneLog != null) {
            cloneLog.initializeHashtables();
            return cloneLog;
        }
        return null;
    }
}

