/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.ParseTree;
import oracle.toplink.essentials.internal.parsing.SelectGenerationContext;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.queryframework.DatabaseQuery;
import oracle.toplink.essentials.queryframework.DeleteAllQuery;
import oracle.toplink.essentials.queryframework.ObjectLevelReadQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;
import oracle.toplink.essentials.queryframework.UpdateAllQuery;

public class EJBQLParseTree
extends ParseTree {
    public GenerationContext buildContext(ReadQuery readQuery, AbstractSession session) {
        GenerationContext contextForGeneration = super.buildContext(readQuery, session);
        contextForGeneration.setBaseQueryClass(readQuery.getReferenceClass());
        return contextForGeneration;
    }

    private GenerationContext buildSubqueryContext(ReadQuery readQuery, GenerationContext outer) {
        SelectGenerationContext context = new SelectGenerationContext(outer, this);
        context.setBaseQueryClass(readQuery.getReferenceClass());
        return context;
    }

    public GenerationContext populateSubquery(ObjectLevelReadQuery readQuery, GenerationContext outer) {
        GenerationContext innerContext = this.buildSubqueryContext(readQuery, outer);
        this.populateReadQueryInternal(readQuery, innerContext);
        return innerContext;
    }

    public void populateQuery(DatabaseQuery query, AbstractSession session) {
        if (query.isObjectLevelReadQuery()) {
            ObjectLevelReadQuery objectQuery = (ObjectLevelReadQuery)query;
            GenerationContext generationContext = this.buildContext(objectQuery, session);
            this.populateReadQueryInternal(objectQuery, generationContext);
        } else if (query.isUpdateAllQuery()) {
            UpdateAllQuery updateQuery = (UpdateAllQuery)query;
            GenerationContext generationContext = this.buildContext(updateQuery, session);
            this.applyQueryNodeToQuery(updateQuery, generationContext);
            if (updateQuery.getReferenceClass() == null) {
                this.adjustReferenceClassForQuery(updateQuery, generationContext);
            }
            updateQuery.setSession(session);
            this.addUpdatesToQuery(updateQuery, generationContext);
            this.setSelectionCriteriaForQuery(updateQuery, generationContext);
        } else if (query.isDeleteAllQuery()) {
            DeleteAllQuery deleteQuery = (DeleteAllQuery)query;
            GenerationContext generationContext = this.buildContext(deleteQuery, session);
            this.applyQueryNodeToQuery(deleteQuery, generationContext);
            if (deleteQuery.getReferenceClass() == null) {
                this.adjustReferenceClassForQuery(deleteQuery, generationContext);
            }
            deleteQuery.setSession(session);
            this.setSelectionCriteriaForQuery(deleteQuery, generationContext);
        }
    }

    private void populateReadQueryInternal(ObjectLevelReadQuery objectQuery, GenerationContext generationContext) {
        if (objectQuery.getReferenceClass() == null) {
            this.adjustReferenceClassForQuery(objectQuery, generationContext);
        }
        this.initBaseExpression(objectQuery, generationContext);
        this.validate(generationContext.getSession(), this.getClassLoader());
        this.applyQueryNodeToQuery(objectQuery, generationContext);
        this.verifySelect(objectQuery, generationContext);
        this.setSelectionCriteriaForQuery(objectQuery, generationContext);
        this.addOrderingToQuery(objectQuery, generationContext);
        this.addGroupingToQuery(objectQuery, generationContext);
        this.addHavingToQuery(objectQuery, generationContext);
        this.addNonFetchJoinAttributes(objectQuery, generationContext);
    }
}

