/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.indirection;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.exceptions.IntegrityChecker;
import oracle.toplink.essentials.internal.descriptors.DescriptorIterator;
import oracle.toplink.essentials.internal.sessions.AbstractRecord;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.MergeManager;
import oracle.toplink.essentials.internal.sessions.UnitOfWorkImpl;
import oracle.toplink.essentials.mappings.CollectionMapping;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;
import oracle.toplink.essentials.mappings.ObjectReferenceMapping;
import oracle.toplink.essentials.queryframework.ReadObjectQuery;
import oracle.toplink.essentials.queryframework.ReadQuery;

public abstract class IndirectionPolicy
implements Cloneable,
Serializable {
    protected DatabaseMapping mapping;

    public Object backupCloneAttribute(Object attributeValue, Object clone, Object backup, UnitOfWorkImpl unitOfWork) {
        return this.getMapping().buildBackupCloneForPartObject(attributeValue, clone, backup, unitOfWork);
    }

    protected ReadObjectQuery buildCascadeQuery(MergeManager mergeManager) {
        ReadObjectQuery cascadeQuery = new ReadObjectQuery();
        if (mergeManager.shouldCascadeAllParts()) {
            cascadeQuery.cascadeAllParts();
            cascadeQuery.refreshIdentityMapResult();
        }
        if (mergeManager.shouldCascadePrivateParts() && this.getForeignReferenceMapping().isPrivateOwned()) {
            cascadeQuery.cascadePrivateParts();
            cascadeQuery.refreshIdentityMapResult();
        }
        return cascadeQuery;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public abstract Object cloneAttribute(Object var1, Object var2, Object var3, UnitOfWorkImpl var4, boolean var5);

    public Vector extractPrimaryKeyForReferenceObject(Object referenceObject, AbstractSession session) {
        return this.getOneToOneMapping().extractPrimaryKeysFromRealReferenceObject(referenceObject, session);
    }

    public abstract AbstractRecord extractReferenceRow(Object var1);

    protected CollectionMapping getCollectionMapping() {
        return (CollectionMapping)this.getMapping();
    }

    protected ForeignReferenceMapping getForeignReferenceMapping() {
        return (ForeignReferenceMapping)this.getMapping();
    }

    public DatabaseMapping getMapping() {
        return this.mapping;
    }

    protected ObjectReferenceMapping getOneToOneMapping() {
        return (ObjectReferenceMapping)this.getMapping();
    }

    public abstract Object getOriginalIndirectionObject(Object var1, AbstractSession var2);

    public abstract Object getRealAttributeValueFromObject(Object var1);

    public static Object getValueFromProxy(Object value) {
        return value;
    }

    public void initialize() {
    }

    public void iterateOnAttributeValue(DescriptorIterator iterator, Object attributeValue) {
        if (attributeValue != null) {
            this.getMapping().iterateOnRealAttributeValue(iterator, attributeValue);
        }
    }

    public abstract Object nullValueFromRow();

    public abstract boolean objectIsInstantiated(Object var1);

    public void setMapping(DatabaseMapping mapping) {
        this.mapping = mapping;
    }

    public void setRealAttributeValueInObject(Object target, Object attributeValue) {
        this.getMapping().setAttributeValueInObject(target, attributeValue);
    }

    public boolean usesIndirection() {
        return true;
    }

    public boolean usesTransparentIndirection() {
        return false;
    }

    public Object validateAttributeOfInstantiatedObject(Object attributeValue) throws DescriptorException {
        return attributeValue;
    }

    public void validateContainerPolicy(IntegrityChecker checker) throws DescriptorException {
    }

    public void validateDeclaredAttributeType(Class attributeType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateDeclaredAttributeTypeForCollection(Class attributeType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateGetMethodReturnType(Class returnType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateGetMethodReturnTypeForCollection(Class returnType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateSetMethodParameterType(Class parameterType, IntegrityChecker checker) throws DescriptorException {
    }

    public void validateSetMethodParameterTypeForCollection(Class parameterType, IntegrityChecker checker) throws DescriptorException {
    }

    public abstract Object valueFromQuery(ReadQuery var1, AbstractRecord var2, AbstractSession var3);

    public abstract Object valueFromRow(Object var1);
}

