/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.helper;

import java.io.Serializable;
import java.util.Vector;
import oracle.toplink.essentials.internal.databaseaccess.DatabasePlatform;

public class DatabaseTable
implements Cloneable,
Serializable {
    protected String name;
    protected String tableQualifier;
    protected String qualifiedName;
    protected Vector uniqueConstraints;

    public DatabaseTable() {
        this("", "");
    }

    public DatabaseTable(String possiblyQualifiedName) {
        this.setPossiblyQualifiedName(possiblyQualifiedName);
        this.uniqueConstraints = new Vector();
    }

    public DatabaseTable(String tableName, String qualifier) {
        this.name = tableName;
        this.tableQualifier = qualifier;
        this.uniqueConstraints = new Vector();
    }

    public void addUniqueConstraint(String[] columnNames) {
        this.uniqueConstraints.add(columnNames);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof DatabaseTable) {
            return this.equals((DatabaseTable)object);
        }
        return false;
    }

    public boolean equals(DatabaseTable table) {
        if (this == table) {
            return true;
        }
        return DatabasePlatform.shouldIgnoreCaseOnFieldComparisons() ? this.getName().equalsIgnoreCase(table.getName()) && (this.getTableQualifier().length() == 0 || table.getTableQualifier().length() == 0 || this.getTableQualifier().equalsIgnoreCase(table.getTableQualifier())) : this.getName().equals(table.getName()) && (this.getTableQualifier().length() == 0 || table.getTableQualifier().length() == 0 || this.getTableQualifier().equals(table.getTableQualifier()));
    }

    public String getName() {
        return this.name;
    }

    public String getQualifiedName() {
        if (this.qualifiedName == null) {
            this.qualifiedName = this.tableQualifier.equals("") ? this.getName() : this.getTableQualifier() + "." + this.getName();
        }
        return this.qualifiedName;
    }

    public String getTableQualifier() {
        return this.tableQualifier;
    }

    public Vector getUniqueConstraints() {
        return this.uniqueConstraints;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public boolean hasName() {
        return this.getName().length() != 0 || this.getTableQualifier().length() != 0;
    }

    public boolean isDecorated() {
        return false;
    }

    protected void resetQualifiedName() {
        this.qualifiedName = null;
    }

    public void setName(String name) {
        this.name = name;
        this.resetQualifiedName();
    }

    public void setPossiblyQualifiedName(String possiblyQualifiedName) {
        this.resetQualifiedName();
        int index = possiblyQualifiedName.lastIndexOf(46);
        if (index == -1) {
            this.name = possiblyQualifiedName;
            this.tableQualifier = "";
        } else {
            this.name = possiblyQualifiedName.substring(index + 1, possiblyQualifiedName.length());
            this.tableQualifier = possiblyQualifiedName.substring(0, index);
        }
    }

    public void setTableQualifier(String qualifier) {
        this.tableQualifier = qualifier;
        this.resetQualifiedName();
    }

    public String toString() {
        return "DatabaseTable(" + this.getQualifiedName() + ")";
    }
}

