/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.annotations;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.AnnotationsDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataDescriptor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.MetadataHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsHelper
extends MetadataHelper {
    public static final String PERSISTENCE_PACKAGE_PREFIX = "javax.persistence";
    protected static Hashtable<Class, Boolean> m_classAccessTypes;

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotationsAccessor accessor) {
        return AnnotationsHelper.getAnnotation(annotation, accessor.getAnnotatedElement(), accessor.getMetadataDescriptor());
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotatedElement annotatedElement) {
        return annotatedElement.getAnnotation(annotation);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotatedElement annotatedElement, AnnotationsDescriptor descriptor) {
        if (descriptor.shouldIgnoreAnnotations()) {
            return null;
        }
        return AnnotationsHelper.getAnnotation(annotation, annotatedElement);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, AnnotationsDescriptor descriptor) {
        return AnnotationsHelper.getAnnotation(annotation, descriptor.getJavaClass(), descriptor);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, MetadataAccessor accessor) {
        return AnnotationsHelper.getAnnotation(annotation, (AnnotationsAccessor)accessor);
    }

    public static <T extends Annotation> T getAnnotation(Class annotation, MetadataDescriptor md) {
        return AnnotationsHelper.getAnnotation(annotation, (AnnotationsDescriptor)md);
    }

    protected static Hashtable<Class, Boolean> getClassAccessTypes() {
        if (m_classAccessTypes == null) {
            m_classAccessTypes = new Hashtable();
        }
        return m_classAccessTypes;
    }

    protected static int getDeclaredAnnotationsCount(AnnotatedElement annotatedElement, AnnotationsDescriptor descriptor) {
        if (descriptor.shouldIgnoreAnnotations()) {
            return 0;
        }
        return annotatedElement.getDeclaredAnnotations().length;
    }

    protected static boolean havePersistenceAnnotationsDefined(AnnotatedElement[] annotatedElements) {
        for (AnnotatedElement annotatedElement : annotatedElements) {
            for (Annotation annotation : annotatedElement.getDeclaredAnnotations()) {
                if (!annotation.annotationType().getName().startsWith(PERSISTENCE_PACKAGE_PREFIX)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotationNotPresent(Class annotation, AnnotatedElement annotatedElement) {
        return !annotatedElement.isAnnotationPresent(annotation);
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotatedElement annotatedElement) {
        return annotatedElement.isAnnotationPresent(annotation);
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotatedElement annotatedElement, AnnotationsDescriptor descriptor) {
        if (descriptor.shouldIgnoreAnnotations()) {
            return false;
        }
        return AnnotationsHelper.isAnnotationPresent(annotation, annotatedElement);
    }

    public static boolean isAnnotationPresent(Class annotation, AnnotationsDescriptor descriptor) {
        return AnnotationsHelper.isAnnotationPresent(annotation, descriptor.getJavaClass(), descriptor);
    }

    public static boolean shouldIgnoreAnnotations(Class cls, HashMap<Class, AnnotationsDescriptor> metadataDescriptors) {
        AnnotationsDescriptor descriptor = metadataDescriptors.get(cls);
        if (descriptor != null) {
            return descriptor.shouldIgnoreAnnotations();
        }
        return false;
    }

    public static Boolean usesPropertyAccess(AnnotationsDescriptor md) {
        Class entityClass = md.getJavaClass();
        if (!AnnotationsHelper.getClassAccessTypes().containsKey(entityClass)) {
            if (AnnotationsHelper.havePersistenceAnnotationsDefined(AnnotationsHelper.getFields(entityClass)) || md.isXmlFieldAccess()) {
                AnnotationsHelper.getClassAccessTypes().put(entityClass, false);
            } else if (AnnotationsHelper.havePersistenceAnnotationsDefined(AnnotationsHelper.getDeclaredMethods(entityClass)) || md.isXmlPropertyAccess()) {
                AnnotationsHelper.getClassAccessTypes().put(entityClass, true);
            } else {
                for (Class mappedSuperclass : (ArrayList)md.getMappedSuperclasses()) {
                    if (AnnotationsHelper.havePersistenceAnnotationsDefined(AnnotationsHelper.getFields(mappedSuperclass))) {
                        AnnotationsHelper.getClassAccessTypes().put(entityClass, false);
                        break;
                    }
                    if (!AnnotationsHelper.havePersistenceAnnotationsDefined(AnnotationsHelper.getDeclaredMethods(mappedSuperclass))) continue;
                    AnnotationsHelper.getClassAccessTypes().put(entityClass, true);
                    break;
                }
                if (!AnnotationsHelper.getClassAccessTypes().containsKey(entityClass)) {
                    AnnotationsHelper.getClassAccessTypes().put(entityClass, true);
                }
            }
        }
        return AnnotationsHelper.getClassAccessTypes().get(entityClass);
    }
}

