/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.persistence.PersistenceException;
import javax.persistence.spi.ClassTransformer;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.PersistenceUnitTransactionType;
import javax.sql.DataSource;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.ejb.cmp3.EntityManagerFactoryProvider;
import oracle.toplink.essentials.exceptions.EntityManagerSetupException;
import oracle.toplink.essentials.exceptions.IntegrityException;
import oracle.toplink.essentials.internal.databaseaccess.DatasourcePlatform;
import oracle.toplink.essentials.internal.ejb.cmp3.annotations.EJBAnnotationsProcessor;
import oracle.toplink.essentials.internal.ejb.cmp3.base.CMP3Policy;
import oracle.toplink.essentials.internal.ejb.cmp3.xml.EntityMappingsXMLProcessor;
import oracle.toplink.essentials.internal.security.PrivilegedAccessController;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.DatabaseSessionImpl;
import oracle.toplink.essentials.internal.weaving.TransformerFactory;
import oracle.toplink.essentials.jndi.JNDIConnector;
import oracle.toplink.essentials.logging.AbstractSessionLog;
import oracle.toplink.essentials.platform.database.oracle.OraclePlatform;
import oracle.toplink.essentials.platform.server.CustomServerPlatform;
import oracle.toplink.essentials.platform.server.ServerPlatform;
import oracle.toplink.essentials.platform.server.sunas.SunAS9ServerPlatform;
import oracle.toplink.essentials.sequencing.Sequence;
import oracle.toplink.essentials.sessions.DatabaseLogin;
import oracle.toplink.essentials.sessions.DatasourceLogin;
import oracle.toplink.essentials.sessions.DefaultConnector;
import oracle.toplink.essentials.sessions.Project;
import oracle.toplink.essentials.threetier.ServerSession;
import oracle.toplink.essentials.tools.sessionmanagement.SessionManager;

public class EntityManagerSetupImpl {
    protected EJBAnnotationsProcessor processor = null;
    protected EntityMappingsXMLProcessor entityMappingsProcessor = null;
    protected PersistenceUnitInfo persistenceUnitInfo = null;
    protected Map extendedProperties = null;
    protected int logLevel;
    protected String deployedSessionName = null;
    protected Project sessionProject = null;
    private boolean validationOnly = false;
    public static final String WEAVING = "toplink.weaving";
    public static final String ERROR_LOADING_XML_FILE = "error_loading_xml_file";
    public static final String EXCEPTION_LOADING_ENTITY_CLASS = "exception_loading_entity_class";
    public static final int DEFAULT_DESCRIPTOR_CACHE_SIZE = 1000;

    protected ServerSession buildDefaultSession(Project project) {
        String minConnectionsString;
        ServerSession session = null;
        int maxConnections = 10;
        int minConnections = 5;
        String maxConnectionsString = this.getConfigPropertyAsString("toplink.max-write-connections", "");
        if (!maxConnectionsString.equals("")) {
            maxConnections = Integer.parseInt(maxConnectionsString);
        }
        if (!(minConnectionsString = this.getConfigPropertyAsString("toplink.min-write-connections", "")).equals("")) {
            minConnections = Integer.parseInt(minConnectionsString);
        }
        if (project == null) {
            Project newProject = new Project(new DatabaseLogin());
            session = new ServerSession(newProject, minConnections, maxConnections);
        } else {
            session = (ServerSession)project.createServerSession(minConnections, maxConnections);
        }
        String minReadConnectionsString = this.getConfigPropertyAsString("toplink.min-read-connections", "");
        String maxReadConnectionsString = this.getConfigPropertyAsString("toplink.max-read-connections", "");
        if (!minReadConnectionsString.equals("") & !maxReadConnectionsString.equals("")) {
            int minReadConnections = Integer.parseInt(minReadConnectionsString);
            int maxReadConnections = Integer.parseInt(maxReadConnectionsString);
            session.useExclusiveReadConnectionPool(minReadConnections, maxReadConnections);
        }
        if (this.logLevel >= 0) {
            session.getSessionLog().setLevel(this.logLevel);
        } else {
            session.getSessionLog().setLevel(5);
        }
        session.getLogin().usePlatform(new OraclePlatform());
        String bindAllParameters = this.getConfigPropertyAsString("toplink.bind-all-parameters", "true");
        if (bindAllParameters.equalsIgnoreCase("false")) {
            session.getPlatform().setShouldBindAllParameters(false);
        } else {
            session.getPlatform().setShouldBindAllParameters(true);
        }
        if (this.persistenceUnitInfo != null && this.persistenceUnitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA) {
            session.setServerPlatform(new SunAS9ServerPlatform(session));
        }
        return session;
    }

    public Set buildPersistentClassSet(ClassLoader loader, PersistenceUnitInfo persistenceUnitInfo) {
        HashSet classSet = new HashSet();
        if (persistenceUnitInfo != null && !persistenceUnitInfo.getMappingFileNames().isEmpty()) {
            Iterator<String> mappingFiles = persistenceUnitInfo.getMappingFileNames().iterator();
            String mappingFileResourceName = null;
            while (mappingFiles.hasNext()) {
                try {
                    mappingFileResourceName = mappingFiles.next();
                    URL mappingFileResource = loader.getResource(mappingFileResourceName);
                    classSet.addAll(EntityMappingsXMLProcessor.buildClassSet(mappingFileResource, loader));
                }
                catch (RuntimeException e) {
                    AbstractSessionLog.getLog().log(4, "ejb_orm", ERROR_LOADING_XML_FILE, new Object[]{mappingFileResourceName, e});
                }
            }
        }
        return classSet;
    }

    public ServerSession deploy(Collection entities, ClassLoader realClassLoader) {
        ServerSession session = this.buildDefaultSession(this.sessionProject);
        session.getProject().convertClassNamesToClasses(realClassLoader);
        this.deployedSessionName = this.persistenceUnitInfo.getPersistenceUnitRootUrl() != null ? this.persistenceUnitInfo.getPersistenceUnitRootUrl().toString() + "-" + this.persistenceUnitInfo.getPersistenceUnitName() : this.persistenceUnitInfo.getPersistenceUnitName();
        session.setName(this.deployedSessionName);
        EntityManagerSetupImpl.addSessionToGlobalSessionManager(session);
        this.entityMappingsProcessor.setClassLoader(realClassLoader);
        this.entityMappingsProcessor.addEntityListeners(session);
        this.entityMappingsProcessor.addNamedQueriesToSession(session);
        this.processor.setClassLoader(realClassLoader);
        this.processor.addEntityListeners(session, entities);
        this.processor.addNamedQueriesToSession(session);
        String descriptorCacheSizeString = this.getConfigPropertyAsString("toplink.cache.default-size", "");
        if (!descriptorCacheSizeString.equals("")) {
            int descriptorCacheSize = Integer.parseInt(descriptorCacheSizeString);
            Iterator descriptorsIterator = session.getProject().getOrderedDescriptors().iterator();
            while (descriptorsIterator.hasNext()) {
                ((ClassDescriptor)descriptorsIterator.next()).setIdentityMapSize(descriptorCacheSize);
            }
        } else {
            Iterator descriptorsIterator = session.getProject().getOrderedDescriptors().iterator();
            while (descriptorsIterator.hasNext()) {
                ((ClassDescriptor)descriptorsIterator.next()).setIdentityMapSize(1000);
            }
        }
        Map mergedProperties = EntityManagerFactoryProvider.mergePropertiesIntoMap(this.extendedProperties, this.persistenceUnitInfo.getProperties());
        ServerSession returnSession = this.updateServerSession(session, mergedProperties);
        this.cleanUp();
        if (returnSession.getIntegrityChecker().hasErrors()) {
            returnSession.handleException(new IntegrityException(returnSession.getIntegrityChecker()));
        }
        returnSession.getDatasourcePlatform().getConversionManager().setLoader(realClassLoader);
        return returnSession;
    }

    protected void addProjectToSession(ServerSession session, Project project) {
        DatasourcePlatform sessionPlatform = (DatasourcePlatform)session.getDatasourceLogin().getDatasourcePlatform();
        DatasourcePlatform projectPlatform = (DatasourcePlatform)project.getDatasourceLogin().getDatasourcePlatform();
        if (!sessionPlatform.hasDefaultSequence() && projectPlatform.hasDefaultSequence()) {
            sessionPlatform.setDefaultSequence(projectPlatform.getDefaultSequence());
        }
        if (sessionPlatform.getSequences() == null || sessionPlatform.getSequences().isEmpty()) {
            if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
                sessionPlatform.setSequences(projectPlatform.getSequences());
            }
        } else if (projectPlatform.getSequences() != null && !projectPlatform.getSequences().isEmpty()) {
            for (Sequence sequence : projectPlatform.getSequences().values()) {
                if (sessionPlatform.getSequences().containsKey(sequence.getName())) continue;
                sessionPlatform.addSequence(sequence);
            }
        }
        session.addDescriptors(project);
    }

    protected static void addSessionToGlobalSessionManager(ServerSession ss) {
        AbstractSession session = (AbstractSession)SessionManager.getManager().getSessions().get(ss.getName());
        if (session != null) {
            throw new PersistenceException(EntityManagerSetupException.attemptedRedeployWithoutClose(ss.getName()));
        }
        SessionManager.getManager().addSession(ss);
    }

    protected static void assignCMP3Policy(Project project) {
        for (ClassDescriptor descriptor : project.getDescriptors().values()) {
            if (descriptor.getCMPPolicy() != null) continue;
            descriptor.setCMPPolicy(new CMP3Policy());
        }
    }

    protected static void assignServerPlatform(ServerSession ss, Map m) {
        String serverPlatformClassName = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.server.platform.class.name", m, "");
        if (serverPlatformClassName.equals("")) {
            return;
        }
        ServerPlatform serverPlatform = null;
        try {
            Class cls = PrivilegedAccessController.getClassForName(serverPlatformClassName);
            Constructor constructor = cls.getConstructor(DatabaseSessionImpl.class);
            serverPlatform = (ServerPlatform)constructor.newInstance(ss);
        }
        catch (ClassNotFoundException ex1) {
            throw EntityManagerSetupException.classNotFoundForProperty(serverPlatformClassName, "toplink.server.platform.class.name", ex1);
        }
        catch (Exception ex2) {
            throw EntityManagerSetupException.failedToInstantiateServerPlatform(serverPlatformClassName, "toplink.server.platform.class.name", ex2);
        }
        if (serverPlatform instanceof CustomServerPlatform) {
            CustomServerPlatform customServerPlatform = (CustomServerPlatform)serverPlatform;
            String externalTransactionControllerClassName = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.external.transaction.controller.class.name", m, "");
            if (!externalTransactionControllerClassName.equals("")) {
                try {
                    customServerPlatform.setExternalTransactionControllerClass(PrivilegedAccessController.getClassForName(externalTransactionControllerClassName));
                }
                catch (ClassNotFoundException ex1) {
                    throw EntityManagerSetupException.classNotFoundForProperty(externalTransactionControllerClassName, "toplink.external.transaction.controller.class.name", ex1);
                }
            }
        }
        ss.setServerPlatform(serverPlatform);
        ss.setSessionLog(serverPlatform.getServerLog());
    }

    public ClassTransformer predeploy(Collection entities, ClassLoader privateClassLoader, PersistenceUnitInfo info, Map extendedProperties) {
        this.persistenceUnitInfo = info;
        if (!this.validationOnly && this.persistenceUnitInfo != null && this.persistenceUnitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA && this.persistenceUnitInfo.getJtaDataSource() == null) {
            throw new PersistenceException(EntityManagerSetupException.jtaPersistenceUnitInfoMissingJtaDataSource(this.persistenceUnitInfo.getPersistenceUnitName()));
        }
        this.extendedProperties = extendedProperties;
        this.logLevel = AbstractSessionLog.translateStringToLoggingLevel(this.getConfigPropertyAsString("toplink.logging.level", null));
        AbstractSession session = this.buildDefaultSession(null);
        boolean enableLazyForOneToOne = true;
        String weaving = this.getConfigPropertyAsString(WEAVING, null);
        ClassTransformer transformer = null;
        if (weaving != null && weaving.equalsIgnoreCase("false")) {
            enableLazyForOneToOne = false;
        }
        this.entityMappingsProcessor = new EntityMappingsXMLProcessor(enableLazyForOneToOne);
        this.entityMappingsProcessor.setClassLoader(privateClassLoader);
        Vector<URL> mappingFileURLs = new Vector<URL>();
        String ormStr = "META-INF/orm.xml";
        try {
            Enumeration<URL> resources = privateClassLoader.getResources(ormStr);
            while (resources.hasMoreElements()) {
                mappingFileURLs.add(resources.nextElement());
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        if (this.persistenceUnitInfo != null && !this.persistenceUnitInfo.getMappingFileNames().isEmpty()) {
            Iterator<String> mappingFiles = this.persistenceUnitInfo.getMappingFileNames().iterator();
            String mappingFileResourceName = null;
            while (mappingFiles.hasNext()) {
                try {
                    mappingFileResourceName = mappingFiles.next();
                    URL mappingFileResource = privateClassLoader.getResource(mappingFileResourceName);
                    if (mappingFileResourceName.equals(ormStr)) continue;
                    mappingFileURLs.add(mappingFileResource);
                }
                catch (RuntimeException e) {
                    this.handleORMException(e, session, mappingFileResourceName);
                }
            }
        }
        this.entityMappingsProcessor.processPersistenceUnitMetadata(session, mappingFileURLs, entities);
        Iterator urls = mappingFileURLs.iterator();
        URL url = null;
        while (urls.hasNext()) {
            try {
                url = (URL)urls.next();
                session = (AbstractSession)this.entityMappingsProcessor.processEntityMappings(session, url);
            }
            catch (RuntimeException e) {
                this.handleORMException(e, session, url.toString());
            }
        }
        this.processor = new EJBAnnotationsProcessor(session, privateClassLoader, entities, enableLazyForOneToOne, this.entityMappingsProcessor.getDescriptorMetadataMap());
        session = this.processor.processORAnnotations();
        if (enableLazyForOneToOne) {
            transformer = TransformerFactory.createTransformer(session, entities, privateClassLoader);
        }
        session.getProject().getLogin().setConnector(new DefaultConnector());
        this.sessionProject = session.getProject();
        if (session.getIntegrityChecker().hasErrors()) {
            session.handleException(new IntegrityException(session.getIntegrityChecker()));
        }
        return transformer;
    }

    protected void cleanUp() {
        this.processor = null;
    }

    public ServerSession getServerSession(Map m, ClassLoader classLoader) {
        ServerSession ss = (ServerSession)SessionManager.getManager().getSession(this.deployedSessionName, false);
        return this.updateServerSession(ss, m);
    }

    public String getConfigPropertyAsString(String propertyKey, String defaultValue) {
        String value = null;
        if (this.extendedProperties != null) {
            value = (String)this.extendedProperties.get(propertyKey);
        }
        if (value == null) {
            value = EntityManagerFactoryProvider.getConfigPropertyAsString(propertyKey, this.persistenceUnitInfo.getProperties(), defaultValue);
        }
        return value;
    }

    public String getDeployedSessionName() {
        return this.deployedSessionName;
    }

    protected void handleORMException(RuntimeException e, AbstractSession session, String mappingFileResourceName) {
        String throwXMLExceptions = this.getConfigPropertyAsString("toplink.orm.throw.exceptions", "true");
        if (throwXMLExceptions == null || throwXMLExceptions.equalsIgnoreCase("false")) {
            session.log(4, "ejb_orm", ERROR_LOADING_XML_FILE, new Object[]{mappingFileResourceName, e});
        } else {
            session.handleException(e);
        }
    }

    protected void updateLogin(ServerSession ss, Map m) {
        DatabaseLogin login = ss.getLogin();
        String toplinkPlatform = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.platform.class.name", m, "");
        if (!toplinkPlatform.equals("")) {
            login.setPlatformClassName(toplinkPlatform);
        }
        if (this.persistenceUnitInfo == null || this.validationOnly && this.persistenceUnitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA && this.persistenceUnitInfo.getJtaDataSource() == null) {
            this.updateLoginDefaultConnector(login, m);
            return;
        }
        login.setUsesExternalTransactionController(this.persistenceUnitInfo.getTransactionType() == PersistenceUnitTransactionType.JTA);
        DataSource mainDatasource = null;
        DataSource readDatasource = null;
        if (login.shouldUseExternalTransactionController()) {
            mainDatasource = this.persistenceUnitInfo.getJtaDataSource();
            readDatasource = this.persistenceUnitInfo.getNonJtaDataSource();
        } else {
            if (this.persistenceUnitInfo.getJtaDataSource() != null) {
                ss.log(6, "transaction", "resource_local_persistence_init_info_ignores_jta_data_source", this.persistenceUnitInfo.getPersistenceUnitName());
            }
            if (this.persistenceUnitInfo.getNonJtaDataSource() != null) {
                mainDatasource = this.persistenceUnitInfo.getNonJtaDataSource();
            } else {
                this.updateLoginDefaultConnector(login, m);
                return;
            }
        }
        if (!(login.getConnector() instanceof JNDIConnector)) {
            JNDIConnector jndiConnector = new JNDIConnector(mainDatasource);
            login.setConnector(jndiConnector);
            login.setUsesExternalConnectionPooling(true);
        }
        if (readDatasource != null) {
            DatasourceLogin readLogin = (DatasourceLogin)login.clone();
            readLogin.dontUseExternalTransactionController();
            JNDIConnector jndiConnector = new JNDIConnector(readDatasource);
            readLogin.setConnector(jndiConnector);
            ss.setReadConnectionPool(readLogin);
        }
    }

    protected void updateLoginDefaultConnector(DatasourceLogin login, Map m) {
        if (login.getConnector() instanceof DefaultConnector) {
            DatabaseLogin dbLogin = (DatabaseLogin)login;
            String jdbcDriver = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.jdbc.driver", m, "");
            String user = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.jdbc.user", m, "");
            String password = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.jdbc.password", m, "");
            String connectionString = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.jdbc.url", m, "");
            if (!user.equals("")) {
                dbLogin.setUserName(user);
            }
            if (!password.equals("")) {
                dbLogin.setPassword(password);
            }
            if (!connectionString.equals("")) {
                dbLogin.setConnectionString(connectionString);
            }
            if (!jdbcDriver.equals("")) {
                dbLogin.setDriverClassName(jdbcDriver);
            }
        }
    }

    protected ServerSession updateServerSession(ServerSession ss, Map m) {
        String logLevel;
        if (ss == null || ss.isConnected()) {
            return ss;
        }
        EntityManagerSetupImpl.assignCMP3Policy(ss.getProject());
        this.updateLogin(ss, m);
        if (ss.getLogin().shouldUseExternalTransactionController()) {
            EntityManagerSetupImpl.assignServerPlatform(ss, m);
        }
        if ((logLevel = EntityManagerFactoryProvider.getConfigPropertyAsString("toplink.logging.level", m, null)) != null) {
            ss.getSessionLog().setLevel(AbstractSessionLog.translateStringToLoggingLevel(logLevel));
        }
        return ss;
    }

    public void setValidationOnly(boolean validationOnly) {
        this.validationOnly = validationOnly;
    }
}

