/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer;

import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.TokenList;
import org.netbeans.lib.lexer.token.AbstractToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextLexerInputOperation<T extends TokenId>
extends LexerInputOperation<T> {
    private final CharSequence inputSourceText;
    private int readEndOffset;

    public TextLexerInputOperation(TokenList<T> tokenList) {
        this(tokenList, 0, null, 0, -1);
    }

    public TextLexerInputOperation(TokenList<T> tokenList, int n, Object object, int n2, int n3) {
        super(tokenList, n, object);
        this.inputSourceText = tokenList.inputSourceText();
        if (n3 == -1) {
            n3 = this.inputSourceText.length();
        }
        if (n2 < 0 || n2 > n3 || n3 > this.inputSourceText.length()) {
            throw new IndexOutOfBoundsException("startOffset=" + n2 + ", endOffset=" + n3 + ", inputSourceText.length()=" + this.inputSourceText.length());
        }
        this.readOffset = this.tokenStartOffset = n2;
        this.readEndOffset = n3;
    }

    @Override
    public int read(int n) {
        if (n < this.readEndOffset) {
            return this.inputSourceText.charAt(n);
        }
        return -1;
    }

    @Override
    public char readExisting(int n) {
        return this.inputSourceText.charAt(n);
    }

    @Override
    protected void fillTokenData(AbstractToken<T> abstractToken) {
        abstractToken.setRawOffset(this.tokenStartOffset);
    }

    protected final int readEndIndex() {
        return this.readEndOffset;
    }
}

