/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.standalone.actions;

import java.io.File;
import java.io.FilenameFilter;
import java.util.Arrays;
import org.openide.util.NbBundle;

public class ImportSettingsUtilities {
    public static String[] getAvailableVersions() {
        File f;
        String dir = System.getProperty("netbeans.user");
        if (dir != null && dir.length() > 0 && (f = new File(dir)).exists() && f.getParentFile() != null && f.getParentFile().exists()) {
            Object[] versions = f.getParentFile().list(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    File f = new File(dir, name);
                    String currentVersion = ImportSettingsUtilities.getCurrentVersion();
                    return !name.contains(currentVersion) && ImportSettingsUtilities.isValidConfigurationDirectory(f);
                }
            });
            Arrays.sort(versions);
            return versions;
        }
        return null;
    }

    public static String getCurrentVersion() {
        String s = NbBundle.getBundle((String)"org.netbeans.core.startup.Bundle").getString("currentVersion");
        if (s == null) {
            return "";
        }
        if ((s = s.trim()).length() > 0 && s.lastIndexOf(" ") >= 0) {
            s = s.substring(s.lastIndexOf(" ") + 1);
        }
        return s;
    }

    public static void importSettings(File dir, boolean useStatusWindow) throws Exception {
    }

    public static final boolean isValidConfigurationDirectory(File f) {
        try {
            if (f == null || !f.exists() || !f.isDirectory()) {
                return false;
            }
            File f2 = new File(f, "config/preferences");
            return f2.exists();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

