/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.sample;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapParameterMetaData;
import org.olap4j.OlapStatement;
import org.olap4j.OlapWrapper;
import org.olap4j.Position;
import org.olap4j.PreparedOlapStatement;
import org.olap4j.mdx.AxisNode;
import org.olap4j.mdx.CallNode;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.SelectNode;
import org.olap4j.mdx.Syntax;
import org.olap4j.mdx.parser.MdxParser;
import org.olap4j.mdx.parser.MdxParserFactory;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Member;
import org.olap4j.type.MemberType;

public class SimpleQuerySample {
    public static void main(String[] args) {
        try {
            new SimpleQuerySample().simpleStatement();
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    void simpleStatement() throws SQLException, ClassNotFoundException {
        Class.forName("mondrian.olap4j.Driver");
        Connection connection = DriverManager.getConnection("jdbc:mondrian:embedded");
        OlapConnection olapConnection = ((OlapWrapper)((Object)connection)).unwrap(OlapConnection.class);
        OlapStatement statement = olapConnection.createStatement();
        CellSet result = statement.executeOlapQuery("select {[Measures].[Unit Sales]} on columns,\n CrossJoin([Store].Children, [Gender].Members) on rows\nfrom [Sales]");
        List<CellSetAxis> cellSetAxes = result.getAxes();
        System.out.print("\t");
        CellSetAxis columnsAxis = cellSetAxes.get(Axis.COLUMNS.ordinal());
        for (Position position : columnsAxis.getPositions()) {
            Member measure = position.getMembers().get(0);
            System.out.print(measure.getName());
        }
        CellSetAxis rowsAxis = cellSetAxes.get(Axis.ROWS.axisOrdinal());
        int cellOrdinal = 0;
        for (Position rowPosition : rowsAxis.getPositions()) {
            boolean first = true;
            for (Member member : rowPosition.getMembers()) {
                if (first) {
                    first = false;
                } else {
                    System.out.print('\t');
                }
                System.out.print(member.getName());
            }
            for (Position columnPosition : columnsAxis.getPositions()) {
                Cell cell = result.getCell(cellOrdinal);
                List<Integer> coordList = result.ordinalToCoordinates(cellOrdinal);
                assert (coordList.get(0).intValue() == rowPosition.getOrdinal());
                assert (coordList.get(1).intValue() == columnPosition.getOrdinal());
                ++cellOrdinal;
                System.out.print('\t');
                System.out.print(cell.getFormattedValue());
            }
            System.out.println();
        }
        statement.close();
        connection.close();
    }

    void preparedStatement() throws SQLException, ClassNotFoundException {
        Class.forName("mondrian.olap4j.Driver");
        OlapConnection connection = (OlapConnection)DriverManager.getConnection("jdbc:mondrian:embedded");
        PreparedOlapStatement statement = connection.prepareOlapStatement("select {[Measures].[Unit Sales]} on columns,\n  {TopCount\n(      Parameter(\"Store\", [Store].[USA].[CA]).Children,\n      Parameter(\"Count\", INTEGER))} on rows\nfrom [Sales]");
        OlapParameterMetaData parameterMetaData = statement.getParameterMetaData();
        MemberType type = (MemberType)parameterMetaData.getParameterOlapType(1);
        Dimension dimension = type.getDimension();
        assert (dimension.getName().equals("Store"));
        Member allStores = (Member)dimension.getDefaultHierarchy().getRootMembers().get(0);
        Member memberUsa = allStores.getChildMembers().get("USA");
        Member memberWa = memberUsa.getChildMembers().get("WA");
        Member memberSeattle = memberWa.getChildMembers().get("Seattle");
        statement.setObject(1, memberSeattle);
        statement.setInt(2, 10);
        CellSet result = statement.executeQuery();
        this.printResult(result);
        statement.close();
        connection.close();
    }

    void statementFromParseTree() throws ClassNotFoundException, SQLException {
        Class.forName("mondrian.olap4j.Driver");
        Connection connection = DriverManager.getConnection("jdbc:mondrian:embedded");
        OlapConnection olapConnection = ((OlapWrapper)((Object)connection)).unwrap(OlapConnection.class);
        MdxParserFactory parserFactory = olapConnection.getParserFactory();
        MdxParser parser = parserFactory.createMdxParser(olapConnection);
        SelectNode query = parser.parseSelect("select {[Measures].[Unit Sales]} on columns\nfrom [Sales]");
        query.getAxisList().get(0).setNonEmpty(false);
        OlapStatement statement = olapConnection.createStatement();
        CellSet cellSet = statement.executeOlapQuery(query);
        this.printResult(cellSet);
    }

    private void printResult(CellSet result) {
        List<CellSetAxis> cellSetAxes = result.getAxes();
        System.out.print("\t");
        CellSetAxis columnsAxis = cellSetAxes.get(Axis.COLUMNS.axisOrdinal());
        for (Position position : columnsAxis.getPositions()) {
            Member measure = position.getMembers().get(0);
            System.out.print(measure.getName());
        }
        CellSetAxis rowsAxis = cellSetAxes.get(Axis.ROWS.axisOrdinal());
        ArrayList<Integer> coordList = new ArrayList<Integer>(2);
        int row = 0;
        for (Position rowPosition : rowsAxis.getPositions()) {
            assert (rowPosition.getOrdinal() == row);
            coordList.set(0, row++);
            int memberOrdinal = 0;
            for (Member member : rowPosition.getMembers()) {
                if (memberOrdinal++ > 0) {
                    System.out.print('\t');
                }
                System.out.print(member.getName());
            }
            int column = 0;
            for (Position columnPosition : columnsAxis.getPositions()) {
                assert (columnPosition.getOrdinal() == column);
                coordList.set(1, column++);
                Cell cell = result.getCell(coordList);
                System.out.print('\t');
                System.out.print(cell.getFormattedValue());
            }
            System.out.println();
        }
    }

    void executeSelectNode(OlapConnection connection) {
        OlapStatement stmt;
        SelectNode query = new SelectNode();
        query.setFrom(new IdentifierNode(new IdentifierNode.Segment("Sales")));
        query.getAxisList().add(new AxisNode(null, false, Axis.ROWS, new ArrayList<IdentifierNode>(), new CallNode(null, "{}", Syntax.Braces, new IdentifierNode(new IdentifierNode.Segment("Measures"), new IdentifierNode.Segment("Unit Sales")))));
        try {
            stmt = connection.createStatement();
        }
        catch (OlapException e) {
            System.out.println("Validation failed: " + e);
            return;
        }
        try {
            CellSet cset = stmt.executeOlapQuery(query);
        }
        catch (OlapException e) {
            System.out.println("Execution failed: " + e);
        }
    }
}

