/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.mdx.MdxUtil;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentifierNode
implements ParseTreeNode {
    private final List<Segment> segments;

    public IdentifierNode(Segment ... segments) {
        this(Arrays.asList(segments));
    }

    public IdentifierNode(List<Segment> segments) {
        if (segments.size() < 1) {
            throw new IllegalArgumentException();
        }
        this.segments = Collections.unmodifiableList(new ArrayList<Segment>(segments));
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public List<Segment> getSegmentList() {
        return this.segments;
    }

    @Override
    public ParseRegion getRegion() {
        return ParseRegion.sum(new Iterable<ParseRegion>(){

            @Override
            public Iterator<ParseRegion> iterator() {
                final Iterator segmentIter = IdentifierNode.this.segments.iterator();
                return new Iterator<ParseRegion>(){

                    @Override
                    public boolean hasNext() {
                        return segmentIter.hasNext();
                    }

                    @Override
                    public ParseRegion next() {
                        return ((Segment)segmentIter.next()).region;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public IdentifierNode append(Segment segment) {
        ArrayList<Segment> newSegments = new ArrayList<Segment>(this.segments);
        newSegments.add(segment);
        return new IdentifierNode(newSegments);
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        writer.getPrintWriter().print(this.toString());
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int k = 0;
        for (Segment s : this.segments) {
            if (k++ > 0) {
                buf.append('.');
            }
            switch (s.quoting) {
                case UNQUOTED: {
                    buf.append(s.name);
                    break;
                }
                case KEY: {
                    buf.append("&[");
                    buf.append(MdxUtil.mdxEncodeString(s.name));
                    buf.append("]");
                    break;
                }
                case QUOTED: {
                    buf.append("[");
                    buf.append(MdxUtil.mdxEncodeString(s.name));
                    buf.append("]");
                }
            }
        }
        return buf.toString();
    }

    @Override
    public IdentifierNode deepCopy() {
        return this;
    }

    public static List<Segment> parseIdentifier(String identifier) {
        if (!identifier.startsWith("[")) {
            return Collections.singletonList(new Segment(null, identifier, Quoting.UNQUOTED));
        }
        ArrayList<Segment> list = new ArrayList<Segment>();
        int i = 0;
        while (i < identifier.length()) {
            Quoting type;
            if (identifier.charAt(i) != '&' && identifier.charAt(i) != '[') {
                throw new IllegalArgumentException("Invalid member identifier '" + identifier + "'");
            }
            if (identifier.charAt(i) == '&') {
                ++i;
                type = Quoting.KEY;
            } else {
                type = Quoting.QUOTED;
            }
            if (identifier.charAt(i) != '[') {
                throw new IllegalArgumentException("Invalid member identifier '" + identifier + "'");
            }
            int j = IdentifierNode.getEndIndex(identifier, i + 1);
            if (j == -1) {
                throw new IllegalArgumentException("Invalid member identifier '" + identifier + "'");
            }
            list.add(new Segment(null, Olap4jUtil.replace(identifier.substring(i + 1, j), "]]", "]"), type));
            i = j + 2;
        }
        return list;
    }

    private static int getEndIndex(String s, int i) {
        while (i < s.length()) {
            char ch = s.charAt(i);
            if (ch == ']') {
                if (i + 1 < s.length() && s.charAt(i + 1) == ']') {
                    i += 2;
                    continue;
                }
                return i;
            }
            ++i;
        }
        return -1;
    }

    static String quoteMdxIdentifier(String id) {
        StringBuilder buf = new StringBuilder(id.length() + 20);
        IdentifierNode.quoteMdxIdentifier(id, buf);
        return buf.toString();
    }

    static void quoteMdxIdentifier(String id, StringBuilder buf) {
        buf.append('[');
        int start = buf.length();
        buf.append(id);
        Olap4jUtil.replace(buf, start, "]", "]]");
        buf.append(']');
    }

    static String unparseIdentifierList(List<Segment> ids) {
        StringBuilder sb = new StringBuilder(64);
        IdentifierNode.quoteMdxIdentifier(ids, sb);
        return sb.toString();
    }

    static void quoteMdxIdentifier(List<Segment> ids, StringBuilder sb) {
        for (int i = 0; i < ids.size(); ++i) {
            if (i > 0) {
                sb.append('.');
            }
            sb.append(ids.get(i).toString());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Quoting {
        UNQUOTED,
        QUOTED,
        KEY;

    }

    public static class Segment {
        final String name;
        final Quoting quoting;
        private final ParseRegion region;

        public Segment(ParseRegion region, String name, Quoting quoting) {
            this.region = region;
            this.name = name;
            this.quoting = quoting;
        }

        public Segment(String name) {
            this(null, name, Quoting.QUOTED);
        }

        public String toString() {
            switch (this.quoting) {
                case UNQUOTED: {
                    return this.name;
                }
                case QUOTED: {
                    return IdentifierNode.quoteMdxIdentifier(this.name);
                }
                case KEY: {
                    return '&' + IdentifierNode.quoteMdxIdentifier(this.name);
                }
            }
            throw Olap4jUtil.unexpected(this.quoting);
        }

        void toString(StringBuilder buf) {
            switch (this.quoting) {
                case UNQUOTED: {
                    buf.append(this.name);
                    return;
                }
                case QUOTED: {
                    IdentifierNode.quoteMdxIdentifier(this.name, buf);
                    return;
                }
                case KEY: {
                    buf.append('&');
                    IdentifierNode.quoteMdxIdentifier(this.name, buf);
                    return;
                }
            }
            throw Olap4jUtil.unexpected(this.quoting);
        }

        public ParseRegion getRegion() {
            return this.region;
        }

        public String getName() {
            return this.name;
        }

        public Quoting getQuoting() {
            return this.quoting;
        }
    }
}

