/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.visualeditor.querybuilder;

import org.netbeans.modules.db.sql.visualeditor.Log;
import org.netbeans.modules.db.sql.visualeditor.querybuilder.QueryBuilder;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class TableNode
extends AbstractNode {
    private int SQL_IDENTIFIER_LENGTH = 32;
    private boolean DEBUG = false;
    private String _fullTableName = null;
    private String _corrName = null;
    private QueryBuilder _queryBuilder;

    TableNode(String string) {
        super(Children.LEAF);
        this._fullTableName = string;
    }

    TableNode(String string, String string2, QueryBuilder queryBuilder) {
        super(Children.LEAF);
        this._fullTableName = string;
        this._corrName = string2;
        this._queryBuilder = queryBuilder;
    }

    public String getTableName() {
        return this._fullTableName;
    }

    public String getCorrName() {
        return this._corrName;
    }

    public void setCorrName(String string) {
        String string2;
        Log.getLogger().entering("TableNode", "setCorrName", string);
        String string3 = this.getCorrName();
        String string4 = string2 = string3 == null ? this.getTableName() : string3;
        if (string == null && string3 == null || string != null && string.equals(string3)) {
            return;
        }
        if (string.trim().length() == 0) {
            this._corrName = null;
        } else {
            if (!this.isAliasValid(string.trim())) {
                String string5 = NbBundle.getMessage(TableNode.class, (String)"INVALID_ALIAS");
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)(string5 + "\n\n" + string), 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                return;
            }
            String string6 = this._queryBuilder._queryModel.genUniqueName(string);
            this._corrName = string6 == null ? string : string6;
        }
        this._queryBuilder._queryModel.renameTableSpec(string2, this._corrName);
        this._queryBuilder.generate();
    }

    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = sheet.get("properties");
        try {
            PropertySupport.Reflection reflection = new PropertySupport.Reflection((Object)this, String.class, "getTableName", null);
            reflection.setName("tableName");
            String string = NbBundle.getMessage(TableNode.class, (String)"TABLE_DISPLAY_NAME");
            reflection.setDisplayName(string);
            String string2 = NbBundle.getMessage(TableNode.class, (String)"TABLE_SHORT_DESCRIPTION");
            reflection.setShortDescription(string2);
            set.put((Node.Property)reflection);
            reflection = new PropertySupport.Reflection((Object)this, String.class, "getCorrName", "setCorrName");
            reflection.setName("aliasName");
            String string3 = NbBundle.getMessage(TableNode.class, (String)"ALIAS_DISPLAY_NAME");
            reflection.setDisplayName(string3);
            String string4 = NbBundle.getMessage(TableNode.class, (String)"ALIAS_SHORT_DESCRIPTION");
            reflection.setShortDescription(string4);
            set.put((Node.Property)reflection);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            Exceptions.printStackTrace((Throwable)noSuchMethodException);
        }
        return sheet;
    }

    public boolean isAliasValid(String string) {
        if (string.startsWith("\"") && string.endsWith("\"")) {
            return this.isValidDelimitedIdentifier(string.substring(1, string.length() - 1));
        }
        return this.isValidConventionalIdentifier(string);
    }

    boolean isValidDelimitedIdentifier(String string) {
        return string.length() <= this.SQL_IDENTIFIER_LENGTH;
    }

    boolean isValidConventionalIdentifier(String string) {
        if (string.length() > this.SQL_IDENTIFIER_LENGTH) {
            return false;
        }
        char[] cArray = string.toCharArray();
        if (!Character.isLetter(cArray[0])) {
            if (this.DEBUG) {
                System.out.println("isValidConventionalIdentifier called. charArray[0] = " + cArray[0] + "\n");
            }
            return false;
        }
        for (int i = 1; i < cArray.length; ++i) {
            if (Character.isLetter(cArray[i]) || Character.isDigit(cArray[i]) || cArray[i] == '_') continue;
            return false;
        }
        return true;
    }
}

