/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchType;

public class FileObjectSearchGroup
extends SearchGroup {
    protected void add(SearchType searchType) {
        boolean bl = false;
        for (Class clazz : searchType.getSearchTypeClasses()) {
            if (clazz != FileObject.class) continue;
            bl = true;
            break;
        }
        if (bl) {
            super.add(searchType);
        }
    }

    public void doSearch() {
        FileObject[] fileObjectArray = this.getFileFolders();
        if (fileObjectArray == null) {
            return;
        }
        for (FileObject fileObject : fileObjectArray) {
            if (this.scanFolder(fileObject)) continue;
            return;
        }
    }

    private FileObject[] getFileFolders() {
        Node[] nodeArray = FileObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length);
        for (Node node : nodeArray) {
            DataFolder dataFolder = (DataFolder)node.getCookie(DataFolder.class);
            if (dataFolder == null) continue;
            arrayList.add(dataFolder.getPrimaryFile());
        }
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    private boolean scanFolder(FileObject fileObject) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            if (this.stopped) {
                this.stopped = true;
                return false;
            }
            if (fileObject2.isFolder()) {
                if (this.scanFolder(fileObject2)) continue;
                return false;
            }
            this.processSearchObject(fileObject2);
        }
        return true;
    }

    public Node getNodeForFoundObject(final Object object) {
        if (!(object instanceof FileObject)) {
            return null;
        }
        try {
            return DataObject.find((FileObject)((FileObject)object)).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return new AbstractNode(Children.LEAF){

                public String getName() {
                    return ((FileObject)object).getName();
                }
            };
        }
    }

    private static Node[] normalizeNodes(Node[] nodeArray) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : nodeArray) {
            if (FileObjectSearchGroup.hasParent(node, nodeArray)) continue;
            arrayList.add(node);
        }
        return arrayList.toArray(new Node[arrayList.size()]);
    }

    private static boolean hasParent(Node node, Node[] nodeArray) {
        for (Node node2 = node.getParentNode(); node2 != null; node2 = node2.getParentNode()) {
            for (Node node3 : nodeArray) {
                if (!node3.equals((Object)node2)) continue;
                return true;
            }
        }
        return false;
    }
}

