/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.axi.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.datatype.AnyType;
import org.netbeans.modules.xml.axi.datatype.AnyURIType;
import org.netbeans.modules.xml.axi.datatype.Base64BinaryType;
import org.netbeans.modules.xml.axi.datatype.BooleanType;
import org.netbeans.modules.xml.axi.datatype.ByteType;
import org.netbeans.modules.xml.axi.datatype.Datatype;
import org.netbeans.modules.xml.axi.datatype.DatatypeFactory;
import org.netbeans.modules.xml.axi.datatype.DateTimeType;
import org.netbeans.modules.xml.axi.datatype.DateType;
import org.netbeans.modules.xml.axi.datatype.DecimalType;
import org.netbeans.modules.xml.axi.datatype.DoubleType;
import org.netbeans.modules.xml.axi.datatype.DurationType;
import org.netbeans.modules.xml.axi.datatype.EntitiesType;
import org.netbeans.modules.xml.axi.datatype.EntityType;
import org.netbeans.modules.xml.axi.datatype.FloatType;
import org.netbeans.modules.xml.axi.datatype.GDayType;
import org.netbeans.modules.xml.axi.datatype.GMonthDayType;
import org.netbeans.modules.xml.axi.datatype.GMonthType;
import org.netbeans.modules.xml.axi.datatype.GYearMonthType;
import org.netbeans.modules.xml.axi.datatype.GYearType;
import org.netbeans.modules.xml.axi.datatype.HexBinaryType;
import org.netbeans.modules.xml.axi.datatype.IdRefType;
import org.netbeans.modules.xml.axi.datatype.IdRefsType;
import org.netbeans.modules.xml.axi.datatype.IdType;
import org.netbeans.modules.xml.axi.datatype.IntType;
import org.netbeans.modules.xml.axi.datatype.IntegerType;
import org.netbeans.modules.xml.axi.datatype.LanguageType;
import org.netbeans.modules.xml.axi.datatype.LongType;
import org.netbeans.modules.xml.axi.datatype.NameType;
import org.netbeans.modules.xml.axi.datatype.NcNameType;
import org.netbeans.modules.xml.axi.datatype.NegativeIntegerType;
import org.netbeans.modules.xml.axi.datatype.NmTokenType;
import org.netbeans.modules.xml.axi.datatype.NmTokensType;
import org.netbeans.modules.xml.axi.datatype.NonNegativeIntegerType;
import org.netbeans.modules.xml.axi.datatype.NonPositiveIntegerType;
import org.netbeans.modules.xml.axi.datatype.NormalizedStringType;
import org.netbeans.modules.xml.axi.datatype.NotationType;
import org.netbeans.modules.xml.axi.datatype.PositiveIntegerType;
import org.netbeans.modules.xml.axi.datatype.QNameType;
import org.netbeans.modules.xml.axi.datatype.ShortType;
import org.netbeans.modules.xml.axi.datatype.StringType;
import org.netbeans.modules.xml.axi.datatype.TimeType;
import org.netbeans.modules.xml.axi.datatype.TokenType;
import org.netbeans.modules.xml.axi.datatype.UnsignedByteType;
import org.netbeans.modules.xml.axi.datatype.UnsignedIntType;
import org.netbeans.modules.xml.axi.datatype.UnsignedLongType;
import org.netbeans.modules.xml.axi.datatype.UnsignedShortType;
import org.netbeans.modules.xml.axi.impl.DatatypeBuilder;
import org.netbeans.modules.xml.schema.model.GlobalSimpleType;
import org.netbeans.modules.xml.schema.model.SchemaComponent;
import org.netbeans.modules.xml.schema.model.SchemaModel;
import org.netbeans.modules.xml.schema.model.SchemaModelFactory;
import org.netbeans.modules.xml.schema.model.SimpleType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatatypeFactoryImpl
extends DatatypeFactory {
    private static HashMap<Datatype.Kind, List<Class<? extends SchemaComponent>>> asfCache = new HashMap();

    @Override
    public synchronized List<Class<? extends SchemaComponent>> getApplicableSchemaFacets(SimpleType simpleType) {
        List<Class<? extends SchemaComponent>> list = Collections.emptyList();
        Datatype datatype = new DatatypeBuilder().getDatatype(simpleType);
        if (datatype != null && (list = asfCache.get((Object)datatype.getKind())) == null) {
            list = new ArrayList<Class<? extends SchemaComponent>>();
            List<Datatype.Facet> list2 = datatype.getApplicableFacets();
            for (Datatype.Facet facet : list2) {
                list.add(facet.getComponentType());
            }
            asfCache.put(datatype.getKind(), list);
        }
        return list;
    }

    @Override
    public Datatype createPrimitive(String string) {
        Datatype datatype = null;
        GlobalSimpleType globalSimpleType = DatatypeFactoryImpl.getPrimitiveType(string);
        if (globalSimpleType != null) {
            if (string.equals(Datatype.Kind.STRING.getName())) {
                datatype = new StringType();
            } else if (string.equals(Datatype.Kind.NORMALIZED_STRING.getName())) {
                datatype = new NormalizedStringType();
            } else if (string.equals(Datatype.Kind.TOKEN.getName())) {
                datatype = new TokenType();
            } else if (string.equals(Datatype.Kind.LANGUAGE.getName())) {
                datatype = new LanguageType();
            } else if (string.equals(Datatype.Kind.NAME.getName())) {
                datatype = new NameType();
            } else if (string.equals(Datatype.Kind.NMTOKEN.getName())) {
                datatype = new NmTokenType();
            } else if (string.equals(Datatype.Kind.NCNAME.getName())) {
                datatype = new NcNameType();
            } else if (string.equals(Datatype.Kind.NMTOKENS.getName())) {
                datatype = new NmTokensType();
            } else if (string.equals(Datatype.Kind.ID.getName())) {
                datatype = new IdType();
            } else if (string.equals(Datatype.Kind.IDREF.getName())) {
                datatype = new IdRefType();
            } else if (string.equals(Datatype.Kind.ENTITY.getName())) {
                datatype = new EntityType();
            } else if (string.equals(Datatype.Kind.IDREFS.getName())) {
                datatype = new IdRefsType();
            } else if (string.equals(Datatype.Kind.ENTITIES.getName())) {
                datatype = new EntitiesType();
            } else if (string.equals(Datatype.Kind.DECIMAL.getName())) {
                datatype = new DecimalType();
            } else if (string.equals(Datatype.Kind.INTEGER.getName())) {
                datatype = new IntegerType();
            } else if (string.equals(Datatype.Kind.NON_POSITIVE_INTEGER.getName())) {
                datatype = new NonPositiveIntegerType();
            } else if (string.equals(Datatype.Kind.LONG.getName())) {
                datatype = new LongType();
            } else if (string.equals(Datatype.Kind.NON_NEGATIVE_INTEGER.getName())) {
                datatype = new NonNegativeIntegerType();
            } else if (string.equals(Datatype.Kind.NEGATIVE_INTEGER.getName())) {
                datatype = new NegativeIntegerType();
            } else if (string.equals(Datatype.Kind.INT.getName())) {
                datatype = new IntType();
            } else if (string.equals(Datatype.Kind.SHORT.getName())) {
                datatype = new ShortType();
            } else if (string.equals(Datatype.Kind.BYTE.getName())) {
                datatype = new ByteType();
            } else if (string.equals(Datatype.Kind.UNSIGNED_LONG.getName())) {
                datatype = new UnsignedLongType();
            } else if (string.equals(Datatype.Kind.UNSIGNED_INT.getName())) {
                datatype = new UnsignedIntType();
            } else if (string.equals(Datatype.Kind.UNSIGNED_SHORT.getName())) {
                datatype = new UnsignedShortType();
            } else if (string.equals(Datatype.Kind.UNSIGNED_BYTE.getName())) {
                datatype = new UnsignedByteType();
            } else if (string.equals(Datatype.Kind.POSITIVE_INTEGER.getName())) {
                datatype = new PositiveIntegerType();
            } else if (string.equals(Datatype.Kind.DURATION.getName())) {
                datatype = new DurationType();
            } else if (string.equals(Datatype.Kind.DATE_TIME.getName())) {
                datatype = new DateTimeType();
            } else if (string.equals(Datatype.Kind.TIME.getName())) {
                datatype = new TimeType();
            } else if (string.equals(Datatype.Kind.DATE.getName())) {
                datatype = new DateType();
            } else if (string.equals(Datatype.Kind.G_YEAR_MONTH.getName())) {
                datatype = new GYearMonthType();
            } else if (string.equals(Datatype.Kind.G_YEAR.getName())) {
                datatype = new GYearType();
            } else if (string.equals(Datatype.Kind.G_MONTH_DAY.getName())) {
                datatype = new GMonthDayType();
            } else if (string.equals(Datatype.Kind.G_DAY.getName())) {
                datatype = new GDayType();
            } else if (string.equals(Datatype.Kind.G_MONTH.getName())) {
                datatype = new GMonthType();
            } else if (string.equals(Datatype.Kind.BOOLEAN.getName())) {
                datatype = new BooleanType();
            } else if (string.equals(Datatype.Kind.BASE64_BINARY.getName())) {
                datatype = new Base64BinaryType();
            } else if (string.equals(Datatype.Kind.HEX_BINARY.getName())) {
                datatype = new HexBinaryType();
            } else if (string.equals(Datatype.Kind.FLOAT.getName())) {
                datatype = new FloatType();
            } else if (string.equals(Datatype.Kind.DOUBLE.getName())) {
                datatype = new DoubleType();
            } else if (string.equals(Datatype.Kind.ANYURI.getName())) {
                datatype = new AnyURIType();
            } else if (string.equals(Datatype.Kind.ANYTYPE.getName())) {
                datatype = new AnyType();
            } else if (string.equals(Datatype.Kind.QNAME.getName())) {
                datatype = new QNameType();
            } else if (string.equals(Datatype.Kind.NOTATION.getName())) {
                datatype = new NotationType();
            }
        }
        return datatype;
    }

    @Override
    public Datatype getDatatype(AXIModel aXIModel, SchemaComponent schemaComponent) {
        DatatypeBuilder datatypeBuilder = new DatatypeBuilder(aXIModel);
        return datatypeBuilder.getDatatype(schemaComponent);
    }

    static GlobalSimpleType getPrimitiveType(String string) {
        SchemaModel schemaModel = SchemaModelFactory.getDefault().getPrimitiveTypesModel();
        Collection collection = schemaModel.getSchema().getSimpleTypes();
        for (GlobalSimpleType globalSimpleType : collection) {
            if (!globalSimpleType.getName().equals(string)) continue;
            return globalSimpleType;
        }
        return null;
    }
}

