/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.palette.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.netbeans.modules.palette.DefaultSettings;
import org.netbeans.modules.palette.Item;
import org.netbeans.modules.palette.Settings;
import org.netbeans.modules.palette.Utils;
import org.netbeans.modules.palette.ui.CheckListener;
import org.netbeans.modules.palette.ui.CheckRenderer;
import org.netbeans.spi.palette.PaletteActions;
import org.netbeans.spi.palette.PaletteController;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class Customizer
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider {
    private ExplorerManager explorerManager;
    private Lookup lookup;
    private Node root;
    private PaletteController controller;
    private Settings settings;
    private JButton[] customButtons;
    private JLabel captionLabel;
    private JPanel customActionsPanel;
    private JLabel infoLabel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton newCategoryButton;
    private JButton removeButton;
    private JButton resetButton;
    private JPanel treePanel;

    public static void show(Node node, PaletteController paletteController, Settings settings) {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Utils.getBundleString("CTL_Close_Button"));
        jButton.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ACSD_Close"));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)new Customizer(node, paletteController, settings), Utils.getBundleString("CTL_Customizer_Title"), false, new Object[]{jButton}, (Object)jButton, 0, null, null);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
    }

    public Customizer(Node node, PaletteController paletteController, Settings settings) {
        this.root = node;
        this.controller = paletteController;
        this.settings = settings;
        this.explorerManager = new ExplorerManager();
        ActionMap actionMap = this.getActionMap();
        actionMap.put("copy-to-clipboard", ExplorerUtils.actionCopy((ExplorerManager)this.explorerManager));
        actionMap.put("cut-to-clipboard", ExplorerUtils.actionCut((ExplorerManager)this.explorerManager));
        actionMap.put("paste-from-clipboard", ExplorerUtils.actionPaste((ExplorerManager)this.explorerManager));
        actionMap.put("delete", ExplorerUtils.actionDelete((ExplorerManager)this.explorerManager, (boolean)true));
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.explorerManager, (ActionMap)actionMap);
        this.explorerManager.setRootContext(node);
        this.initComponents();
        this.createCustomButtons();
        CheckTreeView checkTreeView = new CheckTreeView(settings);
        checkTreeView.getAccessibleContext().setAccessibleName(Utils.getBundleString("ACSN_PaletteContentsTree"));
        checkTreeView.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ACSD_PaletteContentsTree"));
        this.treePanel.add((Component)((Object)checkTreeView), "Center");
        this.captionLabel.setLabelFor((Component)((Object)checkTreeView));
        this.explorerManager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("selectedNodes".equals(propertyChangeEvent.getPropertyName())) {
                    Customizer.this.updateInfoLabel(Customizer.this.explorerManager.getSelectedNodes());
                    Customizer.this.updateButtons();
                }
            }
        });
        this.updateButtons();
    }

    public void addNotify() {
        super.addNotify();
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)true);
    }

    public void removeNotify() {
        ExplorerUtils.activateActions((ExplorerManager)this.explorerManager, (boolean)false);
        super.removeNotify();
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private void updateButtons() {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        boolean bl = null != nodeArray && nodeArray.length > 0;
        boolean bl2 = null != nodeArray && nodeArray.length == 1;
        boolean bl3 = null != nodeArray && nodeArray.length == 1;
        for (int i = 0; null != nodeArray && i < nodeArray.length; ++i) {
            Node node;
            Node node2 = nodeArray[i];
            if (!node2.canDestroy()) {
                bl = false;
            }
            if (null == (node = node2.getParentNode()) || Customizer.movePossible(node2, node, true) < 0) {
                bl2 = false;
            }
            if (null != node && Customizer.movePossible(node2, node, false) >= 0) continue;
            bl3 = false;
        }
        this.removeButton.setEnabled(bl);
        this.moveUpButton.setEnabled(bl2);
        this.moveDownButton.setEnabled(bl3);
        this.newCategoryButton.setEnabled(new Utils.NewCategoryAction(this.root).isEnabled());
    }

    private void initComponents() {
        this.captionLabel = new JLabel();
        this.treePanel = new JPanel();
        this.infoLabel = new JLabel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.removeButton = new JButton();
        this.newCategoryButton = new JButton();
        this.customActionsPanel = new JPanel();
        this.resetButton = new JButton();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.captionLabel, (String)Utils.getBundleString("CTL_Caption"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 10, 0, 10);
        this.add((Component)this.captionLabel, gridBagConstraints);
        this.treePanel.setBorder(BorderFactory.createEtchedBorder());
        this.treePanel.setPreferredSize(new Dimension(288, 336));
        this.treePanel.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.add((Component)this.treePanel, gridBagConstraints);
        this.infoLabel.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.add((Component)this.infoLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)Utils.getBundleString("CTL_MoveUp_Button"));
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Customizer.this.moveUpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(28, 12, 0, 10);
        this.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ACSD_MoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)Utils.getBundleString("CTL_MoveDown_Button"));
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Customizer.this.moveDownButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 10);
        this.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ACSD_MoveDown"));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)Utils.getBundleString("CTL_Remove_Button"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Customizer.this.removeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 10);
        this.add((Component)this.removeButton, gridBagConstraints);
        this.removeButton.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ACSD_Remove"));
        Mnemonics.setLocalizedText((AbstractButton)this.newCategoryButton, (String)Utils.getBundleString("CTL_NewCategory_Button"));
        this.newCategoryButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Customizer.this.newCategoryButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 12, 0, 10);
        this.add((Component)this.newCategoryButton, gridBagConstraints);
        this.newCategoryButton.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ACSD_NewCategory"));
        this.customActionsPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        this.add((Component)this.customActionsPanel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.resetButton, (String)Utils.getBundleString("CTL_ResetPalette"));
        this.resetButton.setActionCommand("Reset Palette");
        this.resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Customizer.this.resetButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(28, 12, 0, 10);
        this.add((Component)this.resetButton, gridBagConstraints);
        this.resetButton.getAccessibleContext().setAccessibleName(Utils.getBundleString("ASCN_ResetPalette"));
        this.resetButton.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ASCD_ResetPalette"));
        this.getAccessibleContext().setAccessibleDescription(Utils.getBundleString("ACSD_PaletteCustomizer"));
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        Utils.resetPalette(this.controller, this.settings);
    }

    private void removeButtonActionPerformed(ActionEvent actionEvent) {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        if (nodeArray.length == 0) {
            return;
        }
        if (nodeArray.length == 1 && !nodeArray[0].canDestroy()) {
            return;
        }
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)Utils.getBundleString("MSG_ConfirmPaletteDelete"), Utils.getBundleString("CTL_ConfirmDeleteTitle"), 0);
        if (NotifyDescriptor.YES_OPTION.equals(DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation))) {
            try {
                for (int i = 0; i < nodeArray.length; ++i) {
                    if (!nodeArray[i].canDestroy()) continue;
                    nodeArray[i].destroy();
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(this.getClass().getName()).log(Level.INFO, null, iOException);
            }
        }
    }

    private void moveDownButtonActionPerformed(ActionEvent actionEvent) {
        this.moveNode(false);
    }

    private void moveUpButtonActionPerformed(ActionEvent actionEvent) {
        this.moveNode(true);
    }

    private void newCategoryButtonActionPerformed(ActionEvent actionEvent) {
        new Utils.NewCategoryAction(this.root).actionPerformed(actionEvent);
    }

    private void moveNode(boolean bl) {
        Node[] nodeArray = this.explorerManager.getSelectedNodes();
        if (nodeArray.length != 1) {
            return;
        }
        Node node = nodeArray[0];
        Node node2 = node.getParentNode();
        if (node2 == null) {
            return;
        }
        Index index = (Index)node2.getCookie(Index.class);
        if (index == null) {
            return;
        }
        int n = Customizer.movePossible(node, node2, bl);
        if (n != -1) {
            if (bl) {
                index.moveUp(n);
            } else {
                index.moveDown(n);
            }
        }
    }

    private static int movePossible(Node node, Node node2, boolean bl) {
        if (node2 == null) {
            return -1;
        }
        Node[] nodeArray = node2.getChildren().getNodes();
        for (int i = 0; i < nodeArray.length; ++i) {
            if (!nodeArray[i].getName().equals(node.getName())) continue;
            return bl && i > 0 || !bl && i + 1 < nodeArray.length ? i : -1;
        }
        return -1;
    }

    private void updateInfoLabel(Node[] nodeArray) {
        Item item;
        String string = " ";
        if (nodeArray.length == 1 && (item = (Item)nodeArray[0].getCookie(Item.class)) != null) {
            string = item.getShortDescription();
        }
        this.infoLabel.setText(string);
    }

    private void createCustomButtons() {
        PaletteActions paletteActions = (PaletteActions)this.root.getLookup().lookup(PaletteActions.class);
        if (null == paletteActions) {
            return;
        }
        Action[] actionArray = paletteActions.getImportActions();
        if (null == actionArray || actionArray.length == 0) {
            return;
        }
        this.customButtons = new JButton[actionArray.length];
        for (int i = 0; i < actionArray.length; ++i) {
            this.customButtons[i] = new JButton(actionArray[i]);
            if (null != actionArray[i].getValue("Name")) {
                Mnemonics.setLocalizedText((AbstractButton)this.customButtons[i], (String)actionArray[i].getValue("Name").toString());
            }
            if (null != actionArray[i].getValue("LongDescription")) {
                this.customButtons[i].getAccessibleContext().setAccessibleDescription(actionArray[i].getValue("LongDescription").toString());
            }
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = i;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 12, 0, 10);
            this.customActionsPanel.add((Component)this.customButtons[i], gridBagConstraints);
        }
    }

    private static class CheckTreeView
    extends BeanTreeView {
        public CheckTreeView(Settings settings) {
            if (settings instanceof DefaultSettings) {
                CheckListener checkListener = new CheckListener((DefaultSettings)settings);
                this.tree.addMouseListener(checkListener);
                this.tree.addKeyListener(checkListener);
                CheckRenderer checkRenderer = new CheckRenderer((DefaultSettings)settings);
                this.tree.setCellRenderer(checkRenderer);
            }
        }
    }
}

