/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.File;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import junit.framework.Assert;
import junit.framework.ComparisonFailure;
import mondrian.calc.Calc;
import mondrian.calc.CalcWriter;
import mondrian.calc.ResultStyle;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapUtil;
import mondrian.spi.Dialect;
import mondrian.spi.DialectManager;
import mondrian.spi.impl.FilterDynamicSchemaProcessor;
import mondrian.test.DelegatingTestContext;
import mondrian.util.DelegatingInvocationHandler;
import org.olap4j.OlapConnection;
import org.olap4j.OlapWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestContext {
    private static TestContext instance;
    private PrintWriter pw;
    private Connection foodMartConnection;
    private Dialect dialect;
    protected static final String nl;
    private static final String indent = "                ";
    private static final String lineBreak;
    private static final String lineBreak2;
    private static final String lineBreak3;
    private static final Pattern LineBreakPattern;
    private static final Pattern TabPattern;
    private static final String[] AllDims;
    private static String unadulteratedFoodMartSchema;

    public static synchronized TestContext instance() {
        if (instance == null) {
            instance = new TestContext();
        }
        return instance;
    }

    protected TestContext() {
        MondrianResource.setThreadLocale((Locale)Locale.US);
        this.pw = new PrintWriter(System.out, true);
    }

    public final String getConnectString() {
        return this.getFoodMartConnectionProperties().toString();
    }

    public static String getDefaultConnectString() {
        String jdbcPassword;
        String jdbcUser;
        Util.PropertyList connectProperties;
        String connectString = MondrianProperties.instance().TestConnectString.get();
        if (connectString == null || connectString.equals("")) {
            connectProperties = new Util.PropertyList();
            connectProperties.put("Provider", "mondrian");
        } else {
            connectProperties = Util.parseConnectString(connectString);
        }
        String jdbcURL = MondrianProperties.instance().FoodmartJdbcURL.get();
        if (jdbcURL != null) {
            connectProperties.put("Jdbc", jdbcURL);
        }
        if ((jdbcUser = MondrianProperties.instance().TestJdbcUser.get()) != null) {
            connectProperties.put("JdbcUser", jdbcUser);
        }
        if ((jdbcPassword = MondrianProperties.instance().TestJdbcPassword.get()) != null) {
            connectProperties.put("JdbcPassword", jdbcPassword);
        }
        URL catalogURL = null;
        String catalog = connectProperties.get("catalog");
        if (catalog != null) {
            try {
                catalogURL = new URL(catalog);
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (catalogURL == null) {
            File file = new File("demo/FoodMart.xml");
            if (!file.exists()) {
                file = new File("../demo/FoodMart.xml");
            }
            try {
                catalogURL = Util.toURL(file);
            }
            catch (MalformedURLException e) {
                throw new Error(e.getMessage());
            }
        }
        connectProperties.put("catalog", catalogURL.toString());
        return connectProperties.toString();
    }

    public Connection getConnection() {
        return this.getFoodMartConnection();
    }

    public synchronized void clearConnection() {
        if (this.foodMartConnection != null) {
            try {
                this.foodMartConnection.getDataSource().getConnection().close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.foodMartConnection = null;
        }
    }

    public synchronized Connection getFoodMartConnection() {
        if (this.foodMartConnection == null) {
            this.foodMartConnection = mondrian.olap.DriverManager.getConnection(this.getFoodMartConnectionProperties(), null);
        }
        return this.foodMartConnection;
    }

    public final synchronized Connection getFoodMartConnection(Class dynProcClass) {
        Util.PropertyList properties = this.getFoodMartConnectionProperties();
        properties.put(RolapConnectionProperties.DynamicSchemaProcessor.name(), dynProcClass.getName());
        properties.put(RolapConnectionProperties.UseSchemaPool.name(), "false");
        return mondrian.olap.DriverManager.getConnection(properties, null, null);
    }

    public Util.PropertyList getFoodMartConnectionProperties() {
        Util.PropertyList propertyList = Util.parseConnectString(TestContext.getDefaultConnectString());
        if (MondrianProperties.instance().TestHighCardinalityDimensionList.get() != null && propertyList.get(RolapConnectionProperties.DynamicSchemaProcessor.name()) == null) {
            propertyList.put(RolapConnectionProperties.DynamicSchemaProcessor.name(), HighCardDynamicSchemaProcessor.class.getName());
        }
        return propertyList;
    }

    public synchronized Connection getFoodMartConnection(String catalogContent) {
        Util.PropertyList properties = this.getFoodMartConnectionProperties();
        properties.put(RolapConnectionProperties.CatalogContent.name(), catalogContent);
        return mondrian.olap.DriverManager.getConnection(properties, null, null);
    }

    public synchronized Connection getFoodMartConnection(String catalogContent, String role) {
        Util.PropertyList properties = this.getFoodMartConnectionProperties();
        properties.put(RolapConnectionProperties.CatalogContent.name(), catalogContent);
        properties.put(RolapConnectionProperties.Role.name(), role);
        return mondrian.olap.DriverManager.getConnection(properties, null, null);
    }

    public synchronized Connection getFoodMartConnection(boolean useSchemaPool) {
        Util.PropertyList properties = this.getFoodMartConnectionProperties();
        properties.put(RolapConnectionProperties.UseSchemaPool.name(), useSchemaPool ? "true" : "false");
        return mondrian.olap.DriverManager.getConnection(properties, null, null);
    }

    public static String getFoodMartSchema(String parameterDefs, String cubeDefs, String virtualCubeDefs, String namedSetDefs, String udfDefs, String roleDefs) {
        int i;
        String s = TestContext.getRawFoodMartSchema();
        if (parameterDefs != null) {
            i = s.indexOf("<Dimension name=\"Store\">");
            s = s.substring(0, i) + parameterDefs + s.substring(i);
        }
        if (cubeDefs != null) {
            i = s.indexOf("<Cube name=\"Sales\" defaultMeasure=\"Unit Sales\">");
            s = s.substring(0, i) + cubeDefs + s.substring(i);
        }
        if (virtualCubeDefs != null) {
            i = s.indexOf("<VirtualCube name=\"Warehouse and Sales\" defaultMeasure=\"Store Sales\">");
            s = s.substring(0, i) + virtualCubeDefs + s.substring(i);
        }
        if (namedSetDefs != null) {
            i = s.indexOf("<Role");
            if (i < 0) {
                i = s.indexOf("</Schema>");
            }
            s = s.substring(0, i) + namedSetDefs + s.substring(i);
        }
        if (roleDefs != null) {
            i = s.indexOf("<UserDefinedFunction");
            if (i < 0) {
                i = s.indexOf("</Schema>");
            }
            s = s.substring(0, i) + roleDefs + s.substring(i);
        }
        if (udfDefs != null) {
            i = s.indexOf("</Schema>");
            s = s.substring(0, i) + udfDefs + s.substring(i);
        }
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getRawFoodMartSchema() {
        Class<SnoopingSchemaProcessor> clazz = SnoopingSchemaProcessor.class;
        synchronized (SnoopingSchemaProcessor.class) {
            if (unadulteratedFoodMartSchema == null) {
                TestContext.instance().getFoodMartConnection(SnoopingSchemaProcessor.class);
                unadulteratedFoodMartSchema = SnoopingSchemaProcessor.catalogContent;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return unadulteratedFoodMartSchema;
        }
    }

    public String getFoodMartSchemaSubstitutingCube(String cubeName, String dimensionDefs, String memberDefs) {
        return this.getFoodMartSchemaSubstitutingCube(cubeName, dimensionDefs, memberDefs, null);
    }

    public String getFoodMartSchemaSubstitutingCube(String cubeName, String dimensionDefs, String memberDefs, String namedSetDefs) {
        int i;
        int end;
        String s = TestContext.getRawFoodMartSchema();
        int h = s.indexOf("<Cube name=\"" + cubeName + "\"");
        if (h < 0) {
            h = s.indexOf("<VirtualCube name=\"" + cubeName + "\"");
            if (h < 0) {
                throw new RuntimeException("cube '" + cubeName + "' not found");
            }
            end = s.indexOf("</VirtualCube", h);
        } else {
            end = s.indexOf("</Cube>", h);
        }
        if (dimensionDefs != null) {
            i = s.indexOf("<Dimension ", h);
            s = s.substring(0, i) + dimensionDefs + s.substring(i);
        }
        if (memberDefs != null) {
            i = s.indexOf("<CalculatedMember", h);
            if (i < 0 || i > end) {
                i = end;
            }
            s = s.substring(0, i) + memberDefs + s.substring(i);
        }
        if (namedSetDefs != null) {
            i = s.indexOf("<NamedSet", h);
            if (i < 0 || i > end) {
                i = end;
            }
            s = s.substring(0, i) + namedSetDefs + s.substring(i);
        }
        return s;
    }

    public Result executeQuery(String queryString) {
        Connection connection = this.getConnection();
        queryString = this.upgradeQuery(queryString);
        Query query = connection.parseQuery(queryString);
        return connection.execute(query);
    }

    public void assertThrows(String queryString, String pattern) {
        Throwable throwable;
        try {
            Result result = this.executeQuery(queryString);
            Util.discard((Object)result);
            throwable = null;
        }
        catch (Throwable e) {
            throwable = e;
        }
        TestContext.checkThrowable(throwable, pattern);
    }

    public void assertExprThrows(String expression, String pattern) {
        Throwable throwable = null;
        try {
            String cubeName = this.getDefaultCubeName();
            if (cubeName.indexOf(32) >= 0) {
                cubeName = Util.quoteMdxIdentifier(cubeName);
            }
            Result result = this.executeQuery("with member [Measures].[Foo] as '" + expression + "' select {[Measures].[Foo]} on columns from " + cubeName);
            Cell cell = result.getCell(new int[]{0});
            if (cell.isError()) {
                throwable = (Throwable)cell.getValue();
            }
        }
        catch (Throwable e) {
            throwable = e;
        }
        TestContext.checkThrowable(throwable, pattern);
    }

    public String getDefaultCubeName() {
        return "Sales";
    }

    public Cell executeExprRaw(String expression) {
        return this.executeExprRaw(expression, this.getDefaultCubeName());
    }

    public Cell executeExprRaw(String expression, String cubeName) {
        if (cubeName.indexOf(32) >= 0) {
            cubeName = Util.quoteMdxIdentifier(cubeName);
        }
        String queryString = "with member [Measures].[Foo] as " + Util.singleQuoteString(expression) + " select {[Measures].[Foo]} on columns from " + cubeName;
        Result result = this.executeQuery(queryString);
        return result.getCell(new int[]{0});
    }

    public void assertExprReturns(String expression, String expected) {
        Cell cell = this.executeExprRaw(expression);
        if (expected == null) {
            expected = "";
        }
        TestContext.assertEqualsVerbose(expected, cell.getFormattedValue());
    }

    public void assertAxisReturns(String expression, String expected) {
        Axis axis = this.executeAxis(expression);
        TestContext.assertEqualsVerbose(expected, this.upgradeActual(TestContext.toString(axis.getPositions())));
    }

    public String upgradeActual(String actual) {
        if (!MondrianProperties.instance().SsasCompatibleNaming.get()) {
            actual = Util.replace(actual, "[Time.Weekly]", "[Time].[Weekly]");
            actual = Util.replace(actual, "[All Time.Weeklys]", "[All Weeklys]");
            actual = Util.replace(actual, "<HIERARCHY_NAME>Time.Weekly</HIERARCHY_NAME>", "<HIERARCHY_NAME>Weekly</HIERARCHY_NAME>");
            actual = Util.replace(actual, "[Store.MyHierarchy]", "[Store].[MyHierarchy]");
            actual = Util.replace(actual, "[All Store.MyHierarchys]", "[All MyHierarchys]");
            actual = Util.replace(actual, "[Store2].[All Store2s]", "[Store2].[Store].[All Stores]");
            actual = Util.replace(actual, "[Store Type 2.Store Type 2].[All Store Type 2.Store Type 2s]", "[Store Type 2].[All Store Type 2s]");
            actual = Util.replace(actual, "[TIME.CALENDAR]", "[TIME].[CALENDAR]");
        }
        return actual;
    }

    public String upgradeQuery(String queryString) {
        if (MondrianProperties.instance().SsasCompatibleNaming.get()) {
            String[] names;
            for (String name : names = new String[]{"[Gender]", "[Education Level]", "[Marital Status]", "[Store Type]", "[Yearly Income]"}) {
                queryString = Util.replace(queryString, name + "." + name, name + "." + name + "." + name);
            }
            queryString = Util.replace(queryString, "[Time.Weekly].[All Time.Weeklys]", "[Time].[Weekly].[All Weeklys]");
        }
        return queryString;
    }

    public String compileExpression(String expression, boolean scalar) {
        String cubeName = this.getDefaultCubeName();
        if (cubeName.indexOf(32) >= 0) {
            cubeName = Util.quoteMdxIdentifier(cubeName);
        }
        String queryString = scalar ? "with member [Measures].[Foo] as " + Util.singleQuoteString(expression) + " select {[Measures].[Foo]} on columns from " + cubeName : "SELECT {" + expression + "} ON COLUMNS FROM " + cubeName;
        Connection connection = this.getConnection();
        Query query = connection.parseQuery(queryString);
        Exp exp = scalar ? query.formulas[0].getExpression() : query.axes[0].getSet();
        Calc calc = query.compileExpression(exp, scalar, null);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        CalcWriter calcWriter = new CalcWriter(pw);
        calc.accept(calcWriter);
        pw.flush();
        return sw.toString();
    }

    public Member executeSingletonAxis(String expression) {
        String cubeName = this.getDefaultCubeName();
        Result result = this.executeQuery("select {" + expression + "} on columns from " + cubeName);
        Axis axis = result.getAxes()[0];
        switch (axis.getPositions().size()) {
            case 0: {
                return null;
            }
            case 1: {
                Position position = axis.getPositions().get(0);
                Util.assertTrue(position.size() == 1);
                Member member = (Member)position.get(0);
                Util.assertTrue(member != null);
                return member;
            }
        }
        throw Util.newInternal("expression " + expression + " yielded " + axis.getPositions().size() + " positions");
    }

    public Axis executeAxis(String expression) {
        Result result = this.executeQuery("select {" + expression + "} on columns from " + this.getDefaultCubeName());
        return result.getAxes()[0];
    }

    public void assertAxisThrows(String expression, String pattern) {
        Throwable throwable = null;
        Connection connection = this.getConnection();
        try {
            String cubeName = this.getDefaultCubeName();
            String queryString = "select {" + expression + "} on columns from " + cubeName;
            Query query = connection.parseQuery(queryString);
            connection.execute(query);
        }
        catch (Throwable e) {
            throwable = e;
        }
        TestContext.checkThrowable(throwable, pattern);
    }

    public static void checkThrowable(Throwable throwable, String pattern) {
        String stackTrace;
        if (throwable == null) {
            Assert.fail((String)"query did not yield an exception");
        }
        if ((stackTrace = TestContext.getStackTrace(throwable)).indexOf(pattern) < 0) {
            Assert.fail((String)("query's error does not match pattern '" + pattern + "'; error is [" + stackTrace + "]"));
        }
    }

    public PrintWriter getWriter() {
        return this.pw;
    }

    public void assertQueryReturns(String query, String desiredResult) {
        Result result = this.executeQuery(query);
        String resultString = TestContext.toString(result);
        if (desiredResult != null) {
            TestContext.assertEqualsVerbose(desiredResult, this.upgradeActual(resultString));
        }
    }

    public void assertSimpleQuery() {
        this.assertQueryReturns("select from [Sales]", TestContext.fold("Axis #0:\n{}\n266,773"));
    }

    public static void assertEqualsVerbose(String expected, String actual) {
        TestContext.assertEqualsVerbose(expected, actual, true, null);
    }

    public static void assertEqualsVerbose(String expected, String actual, boolean java, String message) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected != null && expected.equals(actual)) {
            return;
        }
        message = message == null ? "" : message + nl;
        message = message + "Expected:" + nl + expected + nl + "Actual:" + nl + actual + nl;
        if (java) {
            message = message + "Actual java:" + nl + TestContext.toJavaString(actual) + nl;
        }
        throw new ComparisonFailure(message, expected, actual);
    }

    private static String toJavaString(String s) {
        String spurious;
        s = Util.replace(s, "\"", "\\\"");
        s = LineBreakPattern.matcher(s).replaceAll(lineBreak2);
        s = TabPattern.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        if (s.endsWith(spurious = nl + indent + "+ \"\"")) {
            s = s.substring(0, s.length() - spurious.length());
        }
        if (s.indexOf(lineBreak3) >= 0) {
            s = "fold(" + nl + indent + s + ")";
        }
        return s;
    }

    public void assertMatchesVerbose(Pattern expected, String actual) {
        String spurious;
        Util.assertPrecondition(expected != null, "expected != null");
        if (expected.matcher(actual).matches()) {
            return;
        }
        String s = actual;
        s = Util.replace(s, "\"", "\\\"");
        s = LineBreakPattern.matcher(s).replaceAll(lineBreak);
        s = TabPattern.matcher(s).replaceAll("\\\\t");
        s = "\"" + s + "\"";
        if (s.endsWith(spurious = " + " + nl + "\"\"")) {
            s = s.substring(0, s.length() - spurious.length());
        }
        String message = "Expected pattern:" + nl + expected + nl + "Actual: " + nl + actual + nl + "Actual java: " + nl + s + nl;
        throw new ComparisonFailure(message, expected.pattern(), actual);
    }

    public static String getStackTrace(Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static String toString(Result result) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        result.print(pw);
        pw.flush();
        return sw.toString();
    }

    public static String toString(List<Position> positions) {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        for (Position position : positions) {
            if (i > 0) {
                buf.append(nl);
            }
            if (position.size() != 1) {
                buf.append("{");
            }
            for (int j = 0; j < position.size(); ++j) {
                Member member = (Member)position.get(j);
                if (j > 0) {
                    buf.append(", ");
                }
                buf.append(member.getUniqueName());
            }
            if (position.size() != 1) {
                buf.append("}");
            }
            ++i;
        }
        return buf.toString();
    }

    public static String fold(String[] strings) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i > 0) {
                buf.append(nl);
            }
            String string = strings[i];
            buf.append(string);
        }
        return buf.toString();
    }

    public static String fold(String string) {
        if (!nl.equals("\n")) {
            string = Util.replace(string, "\n", nl);
        }
        return string;
    }

    public synchronized Dialect getDialect() {
        if (this.dialect == null) {
            this.dialect = this.getDialectInternal();
        }
        return this.dialect;
    }

    private Dialect getDialectInternal() {
        DataSource dataSource = this.getConnection().getDataSource();
        return DialectManager.createDialect(dataSource, null);
    }

    public static Dialect getFakeDialect() {
        final DatabaseMetaData metaData = (DatabaseMetaData)Proxy.newProxyInstance(null, new Class[]{DatabaseMetaData.class}, (InvocationHandler)new DelegatingInvocationHandler(){

            public boolean supportsResultSetConcurrency(int type, int concurrency) {
                return false;
            }

            public String getDatabaseProductName() {
                return "Access";
            }

            public String getIdentifierQuoteString() {
                return "\"";
            }

            public String getDatabaseProductVersion() {
                return "1.0";
            }

            public boolean isReadOnly() {
                return true;
            }
        });
        java.sql.Connection connection = (java.sql.Connection)Proxy.newProxyInstance(null, new Class[]{java.sql.Connection.class}, (InvocationHandler)new DelegatingInvocationHandler(){

            public DatabaseMetaData getMetaData() {
                return metaData;
            }
        });
        return DialectManager.createDialect(null, connection);
    }

    public void assertSqlEquals(String expectedSql, String actualSql, int expectedRows) throws Exception {
        TestContext.assertEqualsVerbose(actualSql, this.dialectize(actualSql));
        String transformedExpectedSql = TestContext.removeQuotes(this.dialectize(expectedSql));
        String transformedActualSql = TestContext.removeQuotes(actualSql);
        Assert.assertEquals((String)transformedExpectedSql, (String)transformedActualSql);
        this.checkSqlAgainstDatasource(actualSql, expectedRows);
    }

    private static String removeQuotes(String actualSql) {
        String transformedActualSql = actualSql.replaceAll("`", "");
        transformedActualSql = transformedActualSql.replaceAll("\"", "");
        return transformedActualSql;
    }

    private String dialectize(String sql) {
        String search = "fname \\+ ' ' \\+ lname";
        Dialect dialect = this.getDialect();
        Dialect.DatabaseProduct databaseProduct = dialect.getDatabaseProduct();
        switch (databaseProduct) {
            case MYSQL: {
                sql = sql.replaceAll("fname \\+ ' ' \\+ lname", "CONCAT(`customer`.`fname`, ' ', `customer`.`lname`)");
                break;
            }
            case POSTGRESQL: 
            case ORACLE: 
            case LUCIDDB: 
            case TERADATA: {
                sql = sql.replaceAll("fname \\+ ' ' \\+ lname", "`fname` || ' ' || `lname`");
                break;
            }
            case DERBY: {
                sql = sql.replaceAll("fname \\+ ' ' \\+ lname", "`customer`.`fullname`");
                break;
            }
            case INGRES: {
                sql = sql.replaceAll("fname \\+ ' ' \\+ lname", "fullname");
                break;
            }
            case DB2: 
            case DB2_AS400: 
            case DB2_OLD_AS400: {
                sql = sql.replaceAll("fname \\+ ' ' \\+ lname", "CONCAT(CONCAT(`customer`.`fname`, ' '), `customer`.`lname`)");
            }
        }
        sql = dialect.getDatabaseProduct() == Dialect.DatabaseProduct.ORACLE ? sql.replaceAll(" =as= ", " ") : sql.replaceAll(" =as= ", " as ");
        return sql;
    }

    private void checkSqlAgainstDatasource(String actualSql, int expectedRows) throws Exception {
        Util.PropertyList connectProperties = this.getFoodMartConnectionProperties();
        java.sql.Connection jdbcConn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String jdbcDrivers = connectProperties.get(RolapConnectionProperties.JdbcDrivers.name());
            if (jdbcDrivers != null) {
                RolapUtil.loadDrivers(jdbcDrivers);
            }
            String jdbcDriversProp = MondrianProperties.instance().JdbcDrivers.get();
            RolapUtil.loadDrivers(jdbcDriversProp);
            jdbcConn = DriverManager.getConnection(connectProperties.get(RolapConnectionProperties.Jdbc.name()), connectProperties.get(RolapConnectionProperties.JdbcUser.name()), connectProperties.get(RolapConnectionProperties.JdbcPassword.name()));
            stmt = jdbcConn.createStatement();
            if (RolapUtil.SQL_LOGGER.isDebugEnabled()) {
                StringBuffer sqllog = new StringBuffer();
                sqllog.append("mondrian.test.TestContext: executing sql [");
                if (actualSql.indexOf(10) >= 0) {
                    sqllog.append("\n");
                }
                sqllog.append(actualSql);
                sqllog.append(']');
                RolapUtil.SQL_LOGGER.debug((Object)sqllog.toString());
            }
            long startTime = System.currentTimeMillis();
            rs = stmt.executeQuery(actualSql);
            long time = System.currentTimeMillis();
            long execMs = time - startTime;
            Util.addDatabaseTime(execMs);
            String status = ", exec " + execMs + " ms";
            RolapUtil.SQL_LOGGER.debug((Object)status);
            int rows = 0;
            while (rs.next()) {
                ++rows;
            }
            Assert.assertEquals((String)"row count", (int)expectedRows, (int)rows);
        }
        catch (SQLException e) {
            throw new Exception("ERROR in SQL - invalid for database: " + connectProperties.get(RolapConnectionProperties.Jdbc.name()) + "\n" + actualSql, e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception e1) {}
            try {
                if (jdbcConn != null) {
                    jdbcConn.close();
                }
            }
            catch (Exception e1) {}
        }
    }

    public void assertSetExprDependsOn(String expr, String dimList) {
        Connection connection = this.getFoodMartConnection();
        String queryString = "SELECT {" + expr + "} ON COLUMNS FROM [Sales]";
        Query query = connection.parseQuery(queryString);
        query.resolve();
        Exp expression = query.getAxes()[0].getSet();
        this.checkDependsOn(query, expression, dimList, false);
    }

    public void assertMemberExprDependsOn(String expr, String dimList) {
        this.assertSetExprDependsOn("{" + expr + "}", dimList);
    }

    public void assertExprDependsOn(String expr, String dimList) {
        Connection connection = this.getFoodMartConnection();
        String queryString = "WITH MEMBER [Measures].[Foo] AS " + Util.singleQuoteString(expr) + " SELECT FROM [Sales]";
        Query query = connection.parseQuery(queryString);
        query.resolve();
        Formula formula = query.getFormulas()[0];
        Exp expression = formula.getExpression();
        this.checkDependsOn(query, expression, dimList, true);
    }

    private void checkDependsOn(Query query, Exp expression, String expectedDimList, boolean scalar) {
        Calc calc = query.compileExpression(expression, scalar, scalar ? null : ResultStyle.ITERABLE);
        Dimension[] dimensions = query.getCube().getDimensions();
        StringBuilder buf = new StringBuilder("{");
        int dependCount = 0;
        for (Dimension dimension : dimensions) {
            if (!calc.dependsOn(dimension)) continue;
            if (dependCount++ > 0) {
                buf.append(", ");
            }
            buf.append(dimension.getUniqueName());
        }
        buf.append("}");
        String actualDimList = buf.toString();
        Assert.assertEquals((String)expectedDimList, (String)actualDimList);
    }

    public static TestContext create(final String parameterDefs, final String cubeDefs, final String virtualCubeDefs, final String namedSetDefs, final String udfDefs, final String roleDefs) {
        return new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                String schema = 3.getFoodMartSchema(parameterDefs, cubeDefs, virtualCubeDefs, namedSetDefs, udfDefs, roleDefs);
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.CatalogContent.name(), schema);
                return properties;
            }
        };
    }

    public static TestContext create(final String schema) {
        return new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.CatalogContent.name(), schema);
                return properties;
            }
        };
    }

    public static TestContext createSubstitutingCube(String cubeName, String dimensionDefs) {
        return TestContext.createSubstitutingCube(cubeName, dimensionDefs, null);
    }

    public static TestContext createSubstitutingCube(String cubeName, String dimensionDefs, String memberDefs) {
        return TestContext.createSubstitutingCube(cubeName, dimensionDefs, memberDefs, null);
    }

    public static TestContext createSubstitutingCube(final String cubeName, final String dimensionDefs, final String memberDefs, final String namedSetDefs) {
        return new TestContext(){

            public Util.PropertyList getFoodMartConnectionProperties() {
                String schema = this.getFoodMartSchemaSubstitutingCube(cubeName, dimensionDefs, memberDefs, namedSetDefs);
                Util.PropertyList properties = super.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.CatalogContent.name(), schema);
                return properties;
            }
        };
    }

    public TestContext withRole(final String roleName) {
        return new DelegatingTestContext(this){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList properties = this.context.getFoodMartConnectionProperties();
                properties.put(RolapConnectionProperties.Role.name(), roleName);
                return properties;
            }
        };
    }

    public TestContext withCube(final String cubeName) {
        return new DelegatingTestContext(this){

            public String getDefaultCubeName() {
                return cubeName;
            }
        };
    }

    public static String allDimsExcept(String ... dims) {
        for (String dim : dims) {
            assert (TestContext.contains(AllDims, dim)) : "unknown dimension " + dim;
        }
        StringBuilder buf = new StringBuilder("{");
        int j = 0;
        for (String dim : AllDims) {
            if (TestContext.contains(dims, dim)) continue;
            if (j++ > 0) {
                buf.append(", ");
            }
            buf.append(dim);
        }
        buf.append("}");
        return buf.toString();
    }

    public static boolean contains(String[] a, String s) {
        for (String anA : a) {
            if (!anA.equals(s)) continue;
            return true;
        }
        return false;
    }

    public static String allDims() {
        return TestContext.allDimsExcept(new String[0]);
    }

    public List<Exception> getSchemaWarnings() {
        Connection connection = new DelegatingTestContext(this){

            public Util.PropertyList getFoodMartConnectionProperties() {
                Util.PropertyList propertyList = super.getFoodMartConnectionProperties();
                propertyList.put(RolapConnectionProperties.Ignore.name(), "true");
                return propertyList;
            }
        }.getFoodMartConnection();
        return connection.getSchema().getWarnings();
    }

    public OlapConnection getOlap4jConnection() throws SQLException {
        try {
            Class.forName("mondrian.olap4j.MondrianOlap4jDriver");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Driver not found");
        }
        String connectString = this.getConnectString();
        if (connectString.startsWith("Provider=mondrian; ")) {
            connectString = connectString.substring("Provider=mondrian; ".length());
        }
        java.sql.Connection connection = DriverManager.getConnection("jdbc:mondrian:" + connectString);
        return (OlapConnection)((OlapWrapper)connection).unwrap(OlapConnection.class);
    }

    public boolean databaseIsValid() {
        try {
            Connection connection = this.getConnection();
            String cubeName = this.getDefaultCubeName();
            if (cubeName.indexOf(32) >= 0) {
                cubeName = Util.quoteMdxIdentifier(cubeName);
            }
            Query query = connection.parseQuery("select from " + cubeName);
            Result result = connection.execute(query);
            Util.discard((Object)result);
            connection.close();
            return true;
        }
        catch (RuntimeException e) {
            Util.discard((Object)e);
            return false;
        }
    }

    static {
        nl = Util.nl;
        lineBreak = "\"," + nl + "\"";
        lineBreak2 = "\\\\n\"" + nl + indent + "+ \"";
        lineBreak3 = "\\n\"" + nl + indent + "+ \"";
        LineBreakPattern = Pattern.compile("\r\n|\r|\n");
        TabPattern = Pattern.compile("\t");
        AllDims = new String[]{"[Measures]", "[Store]", "[Store Size in SQFT]", "[Store Type]", "[Time]", "[Product]", "[Promotion Media]", "[Promotions]", "[Customers]", "[Education Level]", "[Gender]", "[Marital Status]", "[Yearly Income]"};
    }

    public static class HighCardDynamicSchemaProcessor
    extends FilterDynamicSchemaProcessor {
        protected String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
            String s = super.filter(schemaUrl, connectInfo, stream);
            String highCardDimensionList = MondrianProperties.instance().TestHighCardinalityDimensionList.get();
            if (highCardDimensionList != null && !highCardDimensionList.equals("")) {
                for (String dimension : highCardDimensionList.split(",")) {
                    String match = "<Dimension name=\"" + dimension + "\"";
                    s = s.replaceAll(match, match + " highCardinality=\"true\"");
                }
            }
            return s;
        }
    }

    public static class SnoopingSchemaProcessor
    extends FilterDynamicSchemaProcessor {
        private static String catalogContent;

        protected String filter(String schemaUrl, Util.PropertyList connectInfo, InputStream stream) throws Exception {
            catalogContent = super.filter(schemaUrl, connectInfo, stream);
            return catalogContent;
        }
    }
}

