/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import mondrian.olap.Axis;
import mondrian.olap.Cell;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.DimensionType;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Schema;
import mondrian.test.QueryRunner;

public class StandAlone {
    private static final String[] indents = new String[]{"    ", "        ", "            ", "                "};
    private static Connection cxn;
    private static String cellProp;
    private static boolean printMemberProps;
    private static BufferedReader stdin;
    public static final String ConnectionString = "Provider=mondrian;Jdbc=jdbc:JSQLConnect://engdb04:1433/database=MondrianFoodmart/user=mondrian/password=password;Catalog=file:demo\\FoodMart.xml;JdbcDrivers=com.jnetdirect.jsql.JSQLDriver;";

    public static void main(String[] args) {
        long now = System.currentTimeMillis();
        cxn = mondrian.olap.DriverManager.getConnection(ConnectionString, null);
        System.out.println("Connected in " + (System.currentTimeMillis() - now) + " usec");
        StandAlone.processCommands();
    }

    private static void processCommands() {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        long startTime = System.currentTimeMillis();
        block3: while (true) {
            try {
                String line;
                while ((line = in.readLine()) != null && !line.equals("\\q")) {
                    if (line.startsWith("\\")) {
                        StandAlone.processSlashCommand(line);
                        continue;
                    }
                    StringBuilder buf = new StringBuilder();
                    buf.append(line);
                    while (true) {
                        System.out.print("> ");
                        line = in.readLine();
                        if (line == null) break block3;
                        if (line.equals(".")) break;
                        buf.append(' ');
                        buf.append(line);
                    }
                    long queryStart = System.currentTimeMillis();
                    String queryString = buf.toString();
                    boolean printResults = false;
                    if (buf.substring(0, 1).equals("-")) {
                        queryString = buf.substring(1);
                        printResults = true;
                    }
                    Query query = cxn.parseQuery(queryString);
                    Result result = cxn.execute(query);
                    StandAlone.displayElapsedTime(queryStart, "Elapsed time");
                    StandAlone.printResult(result, printResults);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        StandAlone.displayElapsedTime(startTime, "Connect time");
    }

    private static void displayElapsedTime(long startTime, String message) {
        long elapsed = System.currentTimeMillis() - startTime;
        int msecs = (int)(elapsed % 1000L);
        int seconds = (int)(elapsed / 1000L);
        System.out.println(MessageFormat.format("{2}: {0,number,0}.{1,number,000} ({3})", seconds, msecs, message, elapsed));
    }

    private static void printResult(Result result, boolean outputResults) {
        int numColumns;
        Axis[] axes;
        Axis slicer = result.getSlicerAxis();
        int nonNullCellCount = 0;
        int cellCount = 0;
        int numRows = 0;
        List<Position> slicerpositions = slicer.getPositions();
        int numSlicers = slicer.getPositions().size();
        if (numSlicers > 0 && outputResults) {
            System.out.print("Slicers: {");
            for (Position pos : slicerpositions) {
                StandAlone.printMembers(pos);
            }
            System.out.println("}");
        }
        if ((axes = result.getAxes()).length == 0) {
            numColumns = 0;
            cellCount = 1;
            if (outputResults) {
                System.out.println("No axes.");
                Cell cell = result.getCell(new int[0]);
                StandAlone.printCell(cell);
            }
        } else if (axes.length == 1) {
            List<Position> cols = axes[0].getPositions();
            numColumns = cols.size();
            for (int idx = 0; idx < cols.size(); ++idx) {
                Cell cell;
                Position col = cols.get(idx);
                if (outputResults) {
                    System.out.print("Column " + idx + ": ");
                    StandAlone.printMembers(col);
                }
                if (!(cell = result.getCell(new int[]{idx})).isNull()) {
                    ++nonNullCellCount;
                }
                ++cellCount;
                if (!outputResults) continue;
                StandAlone.printCell(cell);
            }
        } else {
            List<Position> colPositions = axes[0].getPositions();
            List<Position> rowPositions = axes[1].getPositions();
            numColumns = colPositions.size();
            numRows = rowPositions.size();
            int[] coords = new int[2];
            if (outputResults) {
                System.out.println("Column tuples: ");
            }
            for (int colIdx = 0; colIdx < colPositions.size(); ++colIdx) {
                Position col = colPositions.get(colIdx);
                if (outputResults) {
                    System.out.print("Column " + colIdx + ": ");
                    StandAlone.printMembers(col);
                    System.out.println();
                }
                for (int rowIdx = 0; rowIdx < rowPositions.size(); ++rowIdx) {
                    if (outputResults) {
                        System.out.print("(" + colIdx + ", " + rowIdx + ") ");
                        StandAlone.printMembers(rowPositions.get(rowIdx));
                        System.out.print("} = ");
                    }
                    coords[0] = colIdx;
                    coords[1] = rowIdx;
                    Cell cell = result.getCell(coords);
                    if (!cell.isNull()) {
                        ++nonNullCellCount;
                    }
                    ++cellCount;
                    if (!outputResults) continue;
                    StandAlone.printCell(cell);
                }
            }
        }
        System.out.println("cellCount: " + cellCount);
        System.out.println("nonNullCellCount: " + nonNullCellCount);
        System.out.println("numSlicers: " + numSlicers);
        System.out.println("numColumns: " + numColumns);
        System.out.println("numRows: " + numRows);
    }

    private static void printCell(Cell cell) {
        if (cellProp != null) {
            Object cellPropValue = cell.getPropertyValue(cellProp);
            System.out.print("(" + cellPropValue + ")");
        }
        System.out.println(cell.getFormattedValue());
    }

    private static void printMembers(Position pos) {
        boolean needComma = false;
        for (Member member : pos) {
            Property[] props;
            if (needComma) {
                System.out.print(',');
            }
            needComma = true;
            System.out.print(member.getUniqueName());
            if (!printMemberProps || (props = member.getProperties()).length <= 0) continue;
            System.out.print(" {");
            for (int idx = 0; idx < props.length; ++idx) {
                if (idx > 1) {
                    System.out.print(", ");
                }
                Property prop = props[idx];
                System.out.print(prop.getName() + ": " + member.getPropertyValue(prop.getName()));
            }
            System.out.print("}");
        }
    }

    private static void processSlashCommand(String line) throws IOException {
        if (line.equals("\\schema")) {
            StandAlone.printSchema(cxn.getSchema());
        } else if (line.equals("\\dbg")) {
            PrintWriter out = DriverManager.getLogWriter();
            if (out == null) {
                DriverManager.setLogWriter(new PrintWriter(System.err));
                System.out.println("SQL driver logging enabled");
            } else {
                DriverManager.setLogWriter(null);
                System.out.println("SQL driver logging disabled");
            }
            cxn.close();
            cxn = mondrian.olap.DriverManager.getConnection(ConnectionString, null);
        } else if (line.equals("\\cp")) {
            System.out.print("Enter cell property: ");
            cellProp = stdin.readLine();
            if (cellProp == null || cellProp.length() == 0) {
                cellProp = null;
            }
        } else if (line.equals("\\mp")) {
            System.out.println("Print member properties: " + (printMemberProps ^= true));
        } else if (line.startsWith("\\test ")) {
            String useRandom;
            StringTokenizer st = new StringTokenizer(line, " ", false);
            st.nextToken();
            String threads = st.nextToken();
            String seconds = st.nextToken();
            try {
                useRandom = st.nextToken();
            }
            catch (NoSuchElementException nse) {
                useRandom = "false";
            }
            try {
                StandAlone.runTest(Integer.parseInt(threads), Integer.parseInt(seconds), Boolean.valueOf(useRandom));
            }
            catch (NumberFormatException nfe) {
                System.out.println("Please enter a valid integer for the number of threads and the execution time");
            }
        } else {
            System.out.println("Commands:");
            System.out.println("\t\\q        Quit");
            System.out.println("\t\\schema   Print the schema");
            System.out.println("\t\\dbg      Toggle SQL driver debugging");
        }
    }

    private static void runTest(int numThreads, int seconds, boolean randomQueries) {
        QueryRunner[] runners = new QueryRunner[numThreads];
        System.out.println("Running multi-threading test with " + numThreads + " threads for " + seconds + " seconds.");
        System.out.println("Queries will " + (randomQueries ? "" : "not ") + "be random.");
        for (int idx = 0; idx < runners.length; ++idx) {
            runners[idx] = new QueryRunner(idx, seconds, randomQueries);
        }
        for (QueryRunner runner : runners) {
            runner.start();
        }
        for (QueryRunner runner : runners) {
            try {
                runner.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (QueryRunner runner : runners) {
            runner.report(System.out);
        }
    }

    private static void printSchema(Schema schema) {
        int idx;
        Cube[] cubes = schema.getCubes();
        Hierarchy[] hierarchies = schema.getSharedHierarchies();
        System.out.println("Schema: " + schema.getName() + " " + cubes.length + " cubes and " + hierarchies.length + " shared hierarchies");
        System.out.println("---Cubes ");
        for (idx = 0; idx < cubes.length; ++idx) {
            StandAlone.printCube(cubes[idx]);
            System.out.println("-------------------------------------------");
        }
        System.out.println("---Shared hierarchies");
        for (idx = 0; idx < hierarchies.length; ++idx) {
            StandAlone.printHierarchy(0, hierarchies[idx]);
        }
    }

    private static void printCube(Cube cube) {
        Dimension[] dims;
        System.out.println("Cube " + cube.getName());
        for (Dimension dim : dims = cube.getDimensions()) {
            StandAlone.printDimension(dim);
        }
    }

    private static void printDimension(Dimension dim) {
        Hierarchy[] hierarchies;
        DimensionType dimensionType = dim.getDimensionType();
        System.out.println("\tDimension " + dim.getName() + " type: " + dimensionType.name());
        System.out.println("\t    Description: " + dim.getDescription());
        for (Hierarchy hierarchy : hierarchies = dim.getHierarchies()) {
            StandAlone.printHierarchy(1, hierarchy);
        }
    }

    private static void printHierarchy(int indent, Hierarchy hierarchy) {
        Level[] levels;
        String indentString = indents[indent];
        System.out.println(indentString + " Hierarchy " + hierarchy.getName());
        System.out.println(indentString + "    Description: " + hierarchy.getDescription());
        System.out.println(indentString + "    Default member: " + hierarchy.getDefaultMember().getUniqueName());
        for (Level level : levels = hierarchy.getLevels()) {
            StandAlone.printLevel(indent + 1, level);
        }
    }

    private static void printLevel(int indent, Level level) {
        String indentString = indents[indent];
        System.out.println(indentString + "Level " + level.getName());
        System.out.print(level.getUniqueName());
    }

    static {
        printMemberProps = false;
        stdin = new BufferedReader(new InputStreamReader(System.in));
    }
}

