/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.sql.DataSource;
import mondrian.olap.Cell;
import mondrian.olap.Cube;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Level;
import mondrian.olap.MondrianDef;
import mondrian.olap.Result;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapStar;
import mondrian.spi.Dialect;
import mondrian.test.FoodMartTestCase;
import mondrian.test.TestContext;

public class DrillThroughTest
extends FoodMartTestCase {
    public DrillThroughTest() {
    }

    public DrillThroughTest(String name) {
        super(name);
    }

    public void testTrivalCalcMemberDrillThrough() throws Exception {
        Result result = this.executeQuery("WITH MEMBER [Measures].[Formatted Unit Sales] AS '[Measures].[Unit Sales]', FORMAT_STRING='$#,###.000'\nMEMBER [Measures].[Twice Unit Sales] AS '[Measures].[Unit Sales] * 2'\nMEMBER [Measures].[Twice Unit Sales Plus Store Sales]  AS '[Measures].[Twice Unit Sales] + [Measures].[Store Sales]',  FOMRAT_STRING='#'\nMEMBER [Measures].[Foo]  AS '[Measures].[Unit Sales] + ([Measures].[Unit Sales], [Time].PrevMember)'\nMEMBER [Measures].[Unit Sales Percentage]  AS '[Measures].[Unit Sales] / [Measures].[Twice Unit Sales]'\nSELECT {[Measures].[Unit Sales],\n  [Measures].[Formatted Unit Sales],\n  [Measures].[Twice Unit Sales],\n  [Measures].[Twice Unit Sales Plus Store Sales],\n  [Measures].[Foo],\n  [Measures].[Unit Sales Percentage]} on columns,\n {[Product].Children} on rows\nfrom Sales");
        Cell cell = result.getCell(new int[]{0, 0});
        DrillThroughTest.assertTrue((boolean)cell.canDrillThrough());
        DrillThroughTest.assertTrue((boolean)result.getCell(new int[]{1, 0}).canDrillThrough());
        DrillThroughTest.assertTrue((boolean)result.getCell(new int[]{2, 0}).canDrillThrough());
        DrillThroughTest.assertTrue((boolean)result.getCell(new int[]{3, 0}).canDrillThrough());
        DrillThroughTest.assertFalse((boolean)result.getCell(new int[]{4, 0}).canDrillThrough());
        DrillThroughTest.assertTrue((boolean)result.getCell(new int[]{5, 0}).canDrillThrough());
        DrillThroughTest.assertNotNull((Object)result.getCell(new int[]{5, 0}).getDrillThroughSQL(false));
        String sql = cell.getDrillThroughSQL(false);
        String expectedSql = "select `time_by_day`.`the_year` as `Year`, `product_class`.`product_family` as `Product Family`, `sales_fact_1997`.`unit_sales` as `Unit Sales` from `time_by_day` =as= `time_by_day`, `sales_fact_1997` =as= `sales_fact_1997`, `product_class` =as= `product_class`, `product` =as= `product` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `product_class`.`product_family` = 'Drink' order by `time_by_day`.`the_year` ASC, `product_class`.`product_family` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 7978);
        Cell calcCell = result.getCell(new int[]{1, 0});
        DrillThroughTest.assertTrue((boolean)calcCell.canDrillThrough());
        sql = calcCell.getDrillThroughSQL(false);
        DrillThroughTest.assertNotNull((Object)sql);
        expectedSql = "select `time_by_day`.`the_year` as `Year`, `product_class`.`product_family` as `Product Family`, `sales_fact_1997`.`unit_sales` as `Unit Sales` from `time_by_day` =as= `time_by_day`, `sales_fact_1997` =as= `sales_fact_1997`, `product_class` =as= `product_class`, `product` =as= `product` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `product_class`.`product_family` = 'Drink' order by `time_by_day`.`the_year` ASC, `product_class`.`product_family` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 7978);
        DrillThroughTest.assertEquals((int)calcCell.getDrillThroughCount(), (int)7978);
    }

    public void testDrillThrough() throws Exception {
        Result result = this.executeQuery("WITH MEMBER [Measures].[Price] AS '[Measures].[Store Sales] / ([Measures].[Store Sales], [Time].PrevMember)'" + nl + "SELECT {[Measures].[Unit Sales], [Measures].[Price]} on columns," + nl + " {[Product].Children} on rows" + nl + "from Sales");
        Cell cell = result.getCell(new int[]{0, 0});
        DrillThroughTest.assertTrue((boolean)cell.canDrillThrough());
        String sql = cell.getDrillThroughSQL(false);
        String expectedSql = "select `time_by_day`.`the_year` as `Year`, `product_class`.`product_family` as `Product Family`, `sales_fact_1997`.`unit_sales` as `Unit Sales` from `time_by_day` =as= `time_by_day`, `sales_fact_1997` =as= `sales_fact_1997`, `product_class` =as= `product_class`, `product` =as= `product` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `product_class`.`product_family` = 'Drink' order by `time_by_day`.`the_year` ASC, `product_class`.`product_family` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 7978);
        Cell calcCell = result.getCell(new int[]{1, 1});
        DrillThroughTest.assertFalse((boolean)calcCell.canDrillThrough());
        sql = calcCell.getDrillThroughSQL(false);
        DrillThroughTest.assertNull((Object)sql);
    }

    private String getNameExp(Result result, String hierName, String levelName) {
        Cube cube = result.getQuery().getCube();
        RolapStar star = ((RolapCube)cube).getStar();
        Hierarchy h = cube.lookupHierarchy(new Id.Segment(hierName, Id.Quoting.UNQUOTED), false);
        if (h == null) {
            return null;
        }
        for (Level l : h.getLevels()) {
            if (!l.getName().equals(levelName)) continue;
            MondrianDef.Expression exp = ((RolapLevel)l).getNameExp();
            String nameExpStr = exp.getExpression(star.getSqlQuery());
            nameExpStr = nameExpStr.replace('\"', '`');
            return nameExpStr;
        }
        return null;
    }

    public void testDrillThrough2() throws Exception {
        Result result = this.executeQuery("WITH MEMBER [Measures].[Price] AS '[Measures].[Store Sales] / ([Measures].[Unit Sales], [Time].PrevMember)'" + nl + "SELECT {[Measures].[Unit Sales], [Measures].[Price]} on columns," + nl + " {[Product].Children} on rows" + nl + "from Sales");
        String sql = result.getCell(new int[]{0, 0}).getDrillThroughSQL(true);
        String nameExpStr = this.getNameExp(result, "Customers", "Name");
        String expectedSql = "select `store`.`store_country` as `Store Country`, `store`.`store_state` as `Store State`, `store`.`store_city` as `Store City`, `store`.`store_name` as `Store Name`, `store`.`store_sqft` as `Store Sqft`, `store`.`store_type` as `Store Type`, `time_by_day`.`the_year` as `Year`, `time_by_day`.`quarter` as `Quarter`, `time_by_day`.`month_of_year` as `Month`, `product_class`.`product_family` as `Product Family`, `product_class`.`product_department` as `Product Department`, `product_class`.`product_category` as `Product Category`, `product_class`.`product_subcategory` as `Product Subcategory`, `product`.`brand_name` as `Brand Name`, `product`.`product_name` as `Product Name`, `promotion`.`media_type` as `Media Type`, `promotion`.`promotion_name` as `Promotion Name`, `customer`.`country` as `Country`, `customer`.`state_province` as `State Province`, `customer`.`city` as `City`, " + nameExpStr + " as `Name`," + " `customer`.`customer_id` as `Name (Key)`," + " `customer`.`education` as `Education Level`," + " `customer`.`gender` as `Gender`," + " `customer`.`marital_status` as `Marital Status`," + " `customer`.`yearly_income` as `Yearly Income`," + " `sales_fact_1997`.`unit_sales` as `Unit Sales` " + "from `store` =as= `store`," + " `sales_fact_1997` =as= `sales_fact_1997`," + " `time_by_day` =as= `time_by_day`," + " `product_class` =as= `product_class`," + " `product` =as= `product`," + " `promotion` =as= `promotion`," + " `customer` =as= `customer` " + "where `sales_fact_1997`.`store_id` = `store`.`store_id`" + " and `sales_fact_1997`.`time_id` = `time_by_day`.`time_id`" + " and `time_by_day`.`the_year` = 1997" + " and `sales_fact_1997`.`product_id` = `product`.`product_id`" + " and `product`.`product_class_id` = `product_class`.`product_class_id`" + " and `product_class`.`product_family` = 'Drink'" + " and `sales_fact_1997`.`promotion_id` = `promotion`.`promotion_id`" + " and `sales_fact_1997`.`customer_id` = `customer`.`customer_id` " + "order by `store`.`store_country` ASC," + " `store`.`store_state` ASC," + " `store`.`store_city` ASC," + " `store`.`store_name` ASC," + " `store`.`store_sqft` ASC," + " `store`.`store_type` ASC," + " `time_by_day`.`the_year` ASC," + " `time_by_day`.`quarter` ASC," + " `time_by_day`.`month_of_year` ASC," + " `product_class`.`product_family` ASC," + " `product_class`.`product_department` ASC," + " `product_class`.`product_category` ASC," + " `product_class`.`product_subcategory` ASC," + " `product`.`brand_name` ASC," + " `product`.`product_name` ASC," + " `promotion`.`media_type` ASC," + " `promotion`.`promotion_name` ASC," + " `customer`.`country` ASC," + " `customer`.`state_province` ASC," + " `customer`.`city` ASC, " + nameExpStr + " ASC," + " `customer`.`customer_id` ASC," + " `customer`.`education` ASC," + " `customer`.`gender` ASC," + " `customer`.`marital_status` ASC," + " `customer`.`yearly_income` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 7978);
        sql = result.getCell(new int[]{1, 1}).getDrillThroughSQL(true);
        DrillThroughTest.assertNull((Object)sql);
    }

    public void testDrillThrough3() throws Exception {
        Result result = this.executeQuery("select {[Measures].[Unit Sales], [Measures].[Store Cost], [Measures].[Store Sales]} ON COLUMNS, " + nl + "Hierarchize(Union(Union(Crossjoin({[Promotion Media].[All Media]}, {[Product].[All Products]}), " + nl + "Crossjoin({[Promotion Media].[All Media]}, [Product].[All Products].Children)), Crossjoin({[Promotion Media].[All Media]}, [Product].[All Products].[Drink].Children))) ON ROWS " + nl + "from [Sales] where [Time].[1997].[Q4].[12]");
        Cell cell = result.getCell(new int[]{0, 4});
        String sql = cell.getDrillThroughSQL(true);
        String nameExpStr = this.getNameExp(result, "Customers", "Name");
        String expectedSql = "select `store`.`store_country` as `Store Country`, `store`.`store_state` as `Store State`, `store`.`store_city` as `Store City`, `store`.`store_name` as `Store Name`, `store`.`store_sqft` as `Store Sqft`, `store`.`store_type` as `Store Type`, `time_by_day`.`the_year` as `Year`, `time_by_day`.`quarter` as `Quarter`, `time_by_day`.`month_of_year` as `Month`, `product_class`.`product_family` as `Product Family`, `product_class`.`product_department` as `Product Department`, `product_class`.`product_category` as `Product Category`, `product_class`.`product_subcategory` as `Product Subcategory`, `product`.`brand_name` as `Brand Name`, `product`.`product_name` as `Product Name`, `promotion`.`media_type` as `Media Type`, `promotion`.`promotion_name` as `Promotion Name`, `customer`.`country` as `Country`, `customer`.`state_province` as `State Province`, `customer`.`city` as `City`, " + nameExpStr + " as `Name`, `customer`.`customer_id` as `Name (Key)`, " + "`customer`.`education` as `Education Level`, `customer`.`gender` as `Gender`, `customer`.`marital_status` as `Marital Status`, " + "`customer`.`yearly_income` as `Yearly Income`, " + "`sales_fact_1997`.`unit_sales` as `Unit Sales` " + "from `store =as= `store`, " + "`sales_fact_1997` =as= `sales_fact_1997`, " + "`time_by_day` =as= `time_by_day`, " + "`product_class` =as= `product_class`, " + "`product` =as= `product`, " + "`promotion` =as= `promotion`, " + "`customer` =as= `customer` " + "where `sales_fact_1997`.`store_id` = `store`.`store_id` and " + "`sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and " + "`time_by_day`.`the_year` = 1997 and " + "`time_by_day`.`quarter` = 'Q4' and " + "`time_by_day`.`month_of_year` = 12 and " + "`sales_fact_1997`.`product_id` = `product`.`product_id` and " + "`product`.`product_class_id` = `product_class`.`product_class_id` and " + "`product_class`.`product_family` = 'Drink' and " + "`product_class`.`product_department` = 'Dairy' and " + "`sales_fact_1997`.`promotion_id` = `promotion`.`promotion_id` and " + "`sales_fact_1997`.`customer_id` = `customer`.`customer_id` " + "order by `store`.`store_country` ASC, `store`.`store_state` ASC, `store`.`store_city` ASC, `store`.`store_name` ASC, `store`.`store_sqft` ASC, " + "`store`.`store_type` ASC, `time_by_day`.`the_year` ASC, `time_by_day`.`quarter` ASC, `time_by_day`.`month_of_year` ASC, " + "`product_class`.`product_family` ASC, `product_class`.`product_department` ASC, `product_class`.`product_category` ASC, " + "`product_class`.`product_subcategory` ASC, `product`.`brand_name` ASC, `product`.`product_name` ASC, " + "`promotion.media_type` ASC, `promotion`.`promotion_name` ASC, " + "`customer`.`country` ASC, `customer`.`state_province` ASC, `customer`.`city` ASC, " + nameExpStr + " ASC, " + "`customer`.`customer_id` ASC, `customer`.`education` ASC, `customer`.gender` ASC, `customer`.`marital_status` ASC, `customer`.`yearly_income` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 141);
    }

    public void testDrillThroughBug1472311() throws Exception {
        Result result = this.executeQuery("with set [Date Range] as '{[Time].[1997].[Q1], [Time].[1997].[Q2]}'" + nl + "member [Time].[Date Range] as 'Aggregate([Date Range])'" + nl + "select {[Measures].[Unit Sales]} ON COLUMNS," + nl + "Hierarchize(Union(Union(Union({[Store].[All Stores]}, [Store].[All Stores].Children), [Store].[All Stores].[USA].Children), [Store].[All Stores].[USA].[CA].Children)) ON ROWS" + nl + "from [Sales]" + nl + "where [Time].[Date Range]");
        String sql = result.getCell(new int[]{0, 6}).getDrillThroughSQL(true);
        String nameExpStr = this.getNameExp(result, "Customers", "Name");
        String expectedSql = "select `store`.`store_state` as `Store State`, `store`.`store_city` as `Store City`, `store`.`store_name` as `Store Name`, `store`.`store_sqft` as `Store Sqft`, `store`.`store_type` as `Store Type`, `time_by_day`.`the_year` as `Year`, `time_by_day`.`quarter` as `Quarter`, `time_by_day`.`month_of_year` as `Month`, `product_class`.`product_family` as `Product Family`, `product_class`.`product_department` as `Product Department`, `product_class`.`product_category` as `Product Category`, `product_class`.`product_subcategory` as `Product Subcategory`, `product`.`brand_name` as `Brand Name`, `product`.`product_name` as `Product Name`, `promotion`.`media_type` as `Media Type`, `promotion`.`promotion_name` as `Promotion Name`, `customer`.`country` as `Country`, `customer`.`state_province` as `State Province`, `customer`.`city` as `City`, " + nameExpStr + " as `Name`," + " `customer`.`customer_id` as `Name (Key)`," + " `customer`.`education` as `Education Level`," + " `customer`.`gender` as `Gender`," + " `customer`.`marital_status` as `Marital Status`," + " `customer`.`yearly_income` as `Yearly Income`," + " `sales_fact_1997`.`unit_sales` as `Unit Sales` " + "from `store` =as= `store`," + " `sales_fact_1997` =as= `sales_fact_1997`," + " `time_by_day` =as= `time_by_day`," + " `product_class` =as= `product_class`," + " `product` =as= `product`," + " `promotion` =as= `promotion`," + " `customer` =as= `customer` " + "where `sales_fact_1997`.`store_id` = `store`.`store_id` and" + " `store`.`store_state` = 'CA' and" + " `store`.`store_city` = 'Beverly Hills' and" + " `sales_fact_1997`.time_id` = `time_by_day`.`time_id` and" + " `sales_fact_1997`.`product_id` = `product`.`product_id` and" + " `product`.`product_class_id` = `product_class`.`product_class_id` and" + " `sales_fact_1997`.`promotion_id` = `promotion`.`promotion_id` and" + " `sales_fact_1997`.`customer_id` = `customer`.`customer_id`" + " order by" + " `store`.`store_state` ASC," + " `store`.`store_city` ASC," + " `store`.`store_name` ASC," + " `store`.`store_sqft` ASC," + " `store`.`store_type` ASC," + " `time_by_day`.`the_year` ASC," + " `time_by_day`.`quarter` ASC," + " `time_by_day`.`month_of_year` ASC," + " `product_class`.`product_family` ASC," + " `product_class`.`product_department` ASC," + " `product_class`.`product_category` ASC," + " `product_class`.`product_subcategory` ASC," + " `product`.`brand_name` ASC," + " `product`.`product_name` ASC," + " `promotion`.`media_type` ASC," + " `promotion`.`promotion_name` ASC," + " `customer`.`country` ASC," + " `customer`.`state_province` ASC," + " `customer`.`city` ASC, " + nameExpStr + " ASC," + " `customer`.`customer_id` ASC," + " `customer`.`education` ASC," + " `customer`.`gender` ASC," + " `customer`.`marital_status` ASC," + " `customer`.`yearly_income` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 6815);
    }

    public void testDrillThroughMeasureExp() throws Exception {
        Result result = this.executeQuery("SELECT {[Measures].[Promotion Sales]} on columns," + nl + " {[Product].Children} on rows" + nl + "from Sales");
        String sql = result.getCell(new int[]{0, 0}).getDrillThroughSQL(false);
        String expectedSql = "select `time_by_day`.`the_year` as `Year`, `product_class`.`product_family` as `Product Family`, (case when `sales_fact_1997`.`promotion_id` = 0 then 0 else `sales_fact_1997`.`store_sales` end) as `Promotion Sales` from `time_by_day` =as= `time_by_day`, `sales_fact_1997` =as= `sales_fact_1997`, `product_class` =as= `product_class`, `product` =as= `product` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`product_id` = `product`.`product_id` and `product`.`product_class_id` = `product_class`.`product_class_id` and `product_class`.`product_family` = 'Drink' order by `time_by_day`.`the_year` ASC, `product_class`.`product_family` ASC";
        Cube cube = result.getQuery().getCube();
        RolapStar star = ((RolapCube)cube).getStar();
        Dialect dialect = star.getSqlQueryDialect();
        String caseStmt = " \\(case when `sales_fact_1997`.`promotion_id` = 0 then 0 else `sales_fact_1997`.`store_sales` end\\)";
        switch (dialect.getDatabaseProduct()) {
            case ACCESS: {
                expectedSql = expectedSql.replaceAll(" \\(case when `sales_fact_1997`.`promotion_id` = 0 then 0 else `sales_fact_1997`.`store_sales` end\\)", " Iif(`sales_fact_1997`.`promotion_id` = 0, 0, `sales_fact_1997`.`store_sales`)");
                break;
            }
            case INFOBRIGHT: {
                expectedSql = expectedSql.replaceAll(" \\(case when `sales_fact_1997`.`promotion_id` = 0 then 0 else `sales_fact_1997`.`store_sales` end\\)", " `sales_fact_1997`.`store_sales`");
            }
        }
        this.getTestContext().assertSqlEquals(expectedSql, sql, 7978);
    }

    public void testDrillThroughDupKeys() throws Exception {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Store2\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">\n      <Table name=\"store_ragged\"/>\n      <Level name=\"Store Country\" column=\"store_country\" uniqueMembers=\"true\"/>\n      <Level name=\"Store Id\" column=\"store_id\" captionColumn=\"store_name\" uniqueMembers=\"true\" type=\"Integer\"/>\n    </Hierarchy>\n  </Dimension>\n  <Dimension name=\"Store3\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"store_id\">\n      <Table name=\"store\"/>\n      <Level name=\"Store Country\" column=\"store_country\" uniqueMembers=\"true\"/>\n      <Level name=\"Store Id\" column=\"store_id\" captionColumn=\"store_name\" uniqueMembers=\"true\" type=\"Numeric\"/>\n    </Hierarchy>\n  </Dimension>\n");
        Result result = testContext.executeQuery("SELECT {[Store2].[Store Id].Members} on columns," + nl + " NON EMPTY([Store3].[Store Id].Members) on rows" + nl + "from Sales");
        String sql = result.getCell(new int[]{0, 0}).getDrillThroughSQL(false);
        String expectedSql = "select `time_by_day`.`the_year` as `Year`, `store_ragged`.`store_id` as `Store Id`, `store`.`store_id` as `Store Id_0`, `sales_fact_1997`.`unit_sales` as `Unit Sales` from `time_by_day` =as= `time_by_day`, `sales_fact_1997` =as= `sales_fact_1997`, `store_ragged` =as= `store_ragged`, `store` =as= `store` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `sales_fact_1997`.`store_id` = `store_ragged`.`store_id` and `store_ragged`.`store_id` = 19 and `sales_fact_1997`.`store_id` = `store`.`store_id` and `store`.`store_id` = 2 order by `time_by_day`.`the_year` ASC, `store_ragged`.`store_id` ASC, `store`.`store_id` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 0);
    }

    public void testDrillThroughVirtualCube() throws Exception {
        Result result = this.executeQuery("select Crossjoin([Customers].[All Customers].[USA].[OR].Children, {[Measures].[Unit Sales]}) ON COLUMNS,  [Gender].[All Gender].Children ON ROWS from [Warehouse and Sales] where [Time].[1997].[Q4].[12]");
        String sql = result.getCell(new int[]{0, 0}).getDrillThroughSQL(false);
        String expectedSql = "select `time_by_day`.`the_year` as `Year`, `time_by_day`.`quarter` as `Quarter`, `time_by_day`.month_of_year` as `Month`, `customer`.`state_province` as `State Province`, `customer`.`city` as `City`, `customer`.`gender` as `Gender`, `sales_fact_1997`.`unit_sales` as `Unit Sales` from `time_by_day` =as= `time_by_day`, `sales_fact_1997` =as= `sales_fact_1997`, `customer` =as= `customer` where `sales_fact_1997`.`time_id` = `time_by_day`.`time_id` and `time_by_day`.`the_year` = 1997 and `time_by_day`.`quarter` = 'Q4' and `time_by_day`.`month_of_year` = 12 and `sales_fact_1997`.`customer_id` = `customer`.customer_id` and `customer`.`state_province` = 'OR' and `customer`.`city` = 'Albany' and `customer`.`gender` = 'F' order by `time_by_day`.`the_year` ASC, `time_by_day`.`quarter` ASC, `time_by_day`.`month_of_year` ASC, `customer`.`state_province` ASC, `customer`.`city` ASC, `customer`.`gender` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 73);
    }

    public void testBug1438285() throws Exception {
        Dialect dialect = this.getTestContext().getDialect();
        if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.TERADATA) {
            return;
        }
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Store2\" foreignKey=\"store_id\">\n    <Hierarchy hasAll=\"true\" allMemberName=\"All Stores\" >\n      <Table name=\"store_ragged\"/>\n      <Level name=\"Store Id\" column=\"store_id\" nameColumn=\"store_id\" ordinalColumn=\"region_id\" uniqueMembers=\"true\">\n     </Level>    </Hierarchy>\n  </Dimension>\n");
        Result result = testContext.executeQuery("SELECT {[Measures].[Unit Sales]} on columns, {[Store2].members} on rows FROM [Sales]");
        String sql = result.getCell(new int[]{0, 0}).getDrillThroughSQL(true);
        String nameExpStr = this.getNameExp(result, "Customers", "Name");
        String expectedSql = "select `store`.`store_country` as `Store Country`, `store`.`store_state` as `Store State`, `store`.`store_city` as `Store City`, `store`.`store_name` as `Store Name`, `store`.`store_sqft` as `Store Sqft`, `store`.`store_type` as `Store Type`, `time_by_day`.`the_year` as `Year`, `time_by_day`.`quarter` as `Quarter`, `time_by_day`.`month_of_year` as `Month`, `product_class`.`product_family` as `Product Family`, `product_class`.`product_department` as `Product Department`, `product_class`.`product_category` as `Product Category`, `product_class`.`product_subcategory` as `Product Subcategory`, `product`.`brand_name` as `Brand Name`, `product`.`product_name` as `Product Name`, `store_ragged`.`store_id` as `Store Id`, `store_ragged`.`store_id` as `Store Id (Key)`, `promotion`.`media_type` as `Media Type`, `promotion`.`promotion_name` as `Promotion Name`, `customer`.`country` as `Country`, `customer`.`state_province` as `State Province`, `customer`.`city` as `City`, " + nameExpStr + " as `Name`, `customer`.`customer_id` as `Name (Key)`," + " `customer`.`education` as `Education Level`, `customer`.`gender` as `Gender`," + " `customer`.`marital_status` as `Marital Status`," + " `customer`.`yearly_income` as `Yearly Income`," + " `sales_fact_1997`.`unit_sales` as `Unit Sales`" + " from `store` =as= `store`, `sales_fact_1997` =as= `sales_fact_1997`," + " `time_by_day` =as= `time_by_day`, `product_class` =as= `product_class`," + " `product` =as= `product`, `store_ragged` =as= `store_ragged`," + " `promotion` =as= `promotion`, `customer` =as= `customer`" + " where `sales_fact_1997`.`store_id` = `store`.`store_id`" + " and `sales_fact_1997`.`time_id` = `time_by_day`.`time_id`" + " and `time_by_day`.`the_year` = 1997" + " and `sales_fact_1997`.`product_id` = `product`.`product_id`" + " and `product`.`product_class_id` = `product_class`.`product_class_id`" + " and `sales_fact_1997`.`store_id` = `store_ragged`.`store_id`" + " and `sales_fact_1997`.`promotion_id` = `promotion`.`promotion_id`" + " and `sales_fact_1997`.`customer_id` = `customer`.`customer_id`" + " order by `store`.`store_country` ASC, `store`.`store_state` ASC," + " `store`.`store_city` ASC, `store`.`store_name` ASC, `store`.`store_sqft` ASC," + " `store`.`store_type` ASC, `time_by_day`.`the_year` ASC," + " `time_by_day`.`quarter` ASC, `time_by_day`.`month_of_year` ASC," + " `product_class`.`product_family` ASC, `product_class`.`product_department` ASC," + " `product_class`.`product_category` ASC," + " `product_class`.`product_subcategory` ASC, `product`.`brand_name` ASC," + " `product`.`product_name` ASC, `store_ragged`.`store_id` ASC," + " `promotion`.`media_type` ASC, `promotion`.`promotion_name` ASC," + " `customer`.`country` ASC, `customer`.`state_province` ASC," + " `customer`.`city` ASC, " + nameExpStr + " ASC," + " `customer`.`customer_id` ASC, `customer`.`education` ASC," + " `customer`.`gender` ASC, `customer`.`marital_status` ASC," + " `customer`.`yearly_income` ASC";
        this.getTestContext().assertSqlEquals(expectedSql, sql, 86837);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTruncateLevelName() throws Exception {
        TestContext testContext = TestContext.createSubstitutingCube("Sales", "  <Dimension name=\"Education Level2\" foreignKey=\"customer_id\">\n    <Hierarchy hasAll=\"true\" primaryKey=\"customer_id\">\n      <Table name=\"customer\"/>\n      <Level name=\"Education Level but with a very long name that will be too long if converted directly into a column\" column=\"education\" uniqueMembers=\"true\"/>\n    </Hierarchy>\n  </Dimension>", null);
        Result result = testContext.executeQuery("SELECT {[Measures].[Unit Sales]} on columns,\n{[Education Level2].Children} on rows\nFROM [Sales]\nWHERE ([Time].[1997].[Q1].[1], [Product].[Non-Consumable].[Carousel].[Specialty].[Sunglasses].[ADJ].[ADJ Rosy Sunglasses]) ");
        String sql = result.getCell(new int[]{0, 0}).getDrillThroughSQL(false);
        Connection connection = null;
        try {
            DataSource dataSource = this.getConnection().getDataSource();
            connection = dataSource.getConnection();
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(sql);
            int columnCount = resultSet.getMetaData().getColumnCount();
            Dialect dialect = testContext.getDialect();
            if (dialect.getDatabaseProduct() == Dialect.DatabaseProduct.DERBY) {
                DrillThroughTest.assertEquals((int)11, (int)columnCount);
            } else {
                DrillThroughTest.assertEquals((int)6, (int)columnCount);
            }
            String columnName = resultSet.getMetaData().getColumnLabel(5);
            DrillThroughTest.assertTrue((String)columnName, (boolean)columnName.startsWith("Education Level but with a"));
            int n = 0;
            while (resultSet.next()) {
                ++n;
            }
            DrillThroughTest.assertEquals((int)2, (int)n);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    public void testDrillThroughExprs() {
        this.assertCanDrillThrough(true, "Sales", "CoalesceEmpty([Measures].[Unit Sales], [Measures].[Store Sales])");
        this.assertCanDrillThrough(true, "Sales", "[Measures].[Unit Sales] + [Measures].[Unit Sales]");
        this.assertCanDrillThrough(true, "Sales", "[Measures].[Unit Sales] / ([Measures].[Unit Sales] - 5.0)");
        this.assertCanDrillThrough(true, "Sales", "[Measures].[Unit Sales] * [Measures].[Unit Sales]");
        this.assertCanDrillThrough(true, "Warehouse and Sales", "2.0");
        this.assertCanDrillThrough(true, "Warehouse and Sales", "[Measures].[Unit Sales] * 2.0");
        this.assertCanDrillThrough(false, "Warehouse and Sales", "[Measures].[Unit Sales] + [Measures].[Units Ordered]");
        this.assertCanDrillThrough(true, "Warehouse and Sales", "[Measures].[Unit Sales] + [Measures].[Store Sales]");
        this.assertCanDrillThrough(true, "Warehouse and Sales", "[Measures].[Warehouse Cost] + [Measures].[Units Ordered]");
        this.assertCanDrillThrough(false, "Sales", "Sum([Product].Children)");
        this.assertCanDrillThrough(false, "Sales", "Sum({[Store].[USA], [Store].[Canada].[BC]})");
        this.assertCanDrillThrough(false, "Sales", "([Time].[1997].[Q1], [Measures].[Unit Sales])");
    }

    private void assertCanDrillThrough(boolean canDrillThrough, String cubeName, String expr) {
        Result result = this.executeQuery("WITH MEMBER [Measures].[Foo] AS '" + expr + "'\n" + "SELECT {[Measures].[Foo]} on columns,\n" + " {[Product].Children} on rows\n" + "from [" + cubeName + "]");
        Cell cell = result.getCell(new int[]{0, 0});
        DrillThroughTest.assertEquals((boolean)canDrillThrough, (boolean)cell.canDrillThrough());
        String sql = cell.getDrillThroughSQL(false);
        if (canDrillThrough) {
            DrillThroughTest.assertNotNull((Object)sql);
        } else {
            DrillThroughTest.assertNull((Object)sql);
        }
    }
}

