/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Cube;
import mondrian.olap.Id;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.test.ConcurrentMdxTest;
import mondrian.test.FoodMartTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConcurrentValidatingQueryRunner
extends Thread {
    private long mRunTime;
    private long mStartTime;
    private long mStopTime;
    private volatile List mExceptions = new ArrayList();
    private String threadName;
    private int mRunCount;
    private int mSuccessCount;
    private boolean mRandomQueries;
    private boolean mRandomCacheFlush;
    private double mRandomFlushFrequency = 0.5;
    private ConcurrentMdxTest concurrentMdxTest = new ConcurrentMdxTest();
    private FoodMartTestCase.QueryAndResult[] mdxQueries;
    private static Object lock = new Object();

    public ConcurrentValidatingQueryRunner(int numSeconds, boolean useRandomQuery, FoodMartTestCase.QueryAndResult[] queriesAndResults) {
        this.mdxQueries = queriesAndResults;
        this.mRunTime = numSeconds * 1000;
        this.mRandomQueries = useRandomQuery;
        this.mRandomCacheFlush = false;
    }

    public ConcurrentValidatingQueryRunner(int numSeconds, boolean useRandomQuery, boolean randomCacheFlush, FoodMartTestCase.QueryAndResult[] queriesAndResults) {
        this.mdxQueries = queriesAndResults;
        this.mRunTime = numSeconds * 1000;
        this.mRandomQueries = useRandomQuery;
        this.mRandomCacheFlush = randomCacheFlush;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.mStartTime = System.currentTimeMillis();
        this.threadName = Thread.currentThread().getName();
        try {
            int queryIndex = -1;
            while (System.currentTimeMillis() - this.mStartTime < this.mRunTime) {
                try {
                    queryIndex = this.mRandomQueries ? (int)(Math.random() * (double)this.mdxQueries.length) : this.mRunCount % this.mdxQueries.length;
                    ++this.mRunCount;
                    Object object = lock;
                    synchronized (object) {
                        if (this.mRandomCacheFlush && Math.random() < this.mRandomFlushFrequency) {
                            this.flushRandomRegionOfCache();
                        }
                        if (this.mRandomCacheFlush && Math.random() < this.mRandomFlushFrequency) {
                            this.flushSchema();
                        }
                    }
                    object = lock;
                    synchronized (object) {
                        this.concurrentMdxTest.assertQueryReturns(this.mdxQueries[queryIndex].query, this.mdxQueries[queryIndex].result);
                        ++this.mSuccessCount;
                    }
                }
                catch (Exception e) {
                    this.mExceptions.add(new Exception("Exception occurred in iteration " + this.mRunCount + " of thread " + Thread.currentThread().getName(), e));
                }
            }
            this.mStopTime = System.currentTimeMillis();
        }
        catch (Exception e) {
            this.mExceptions.add(e);
        }
        catch (Error e) {
            this.mExceptions.add(e);
        }
    }

    private void report(PrintStream out) {
        String message = MessageFormat.format(" {0} ran {1} queries, {2} successfully in {3} milliseconds", this.threadName, this.mRunCount, this.mSuccessCount, this.mStopTime - this.mStartTime);
        out.println(message);
        for (Object throwable : this.mExceptions) {
            if (throwable instanceof Exception) {
                ((Exception)throwable).printStackTrace(out);
                continue;
            }
            System.out.println(throwable);
        }
    }

    static List<Exception> runTest(int numThreads, int runTimeInSeconds, boolean randomQueries, boolean printReport, FoodMartTestCase.QueryAndResult[] queriesAndResults) {
        return ConcurrentValidatingQueryRunner.runTest(numThreads, runTimeInSeconds, randomQueries, false, printReport, queriesAndResults);
    }

    static List<Exception> runTest(int numThreads, int runTimeInSeconds, boolean randomQueries, boolean randomCacheFlush, boolean printReport, FoodMartTestCase.QueryAndResult[] queriesAndResults) {
        int idx;
        ConcurrentValidatingQueryRunner[] runners = new ConcurrentValidatingQueryRunner[numThreads];
        ArrayList<Exception> allExceptions = new ArrayList<Exception>();
        for (idx = 0; idx < runners.length; ++idx) {
            runners[idx] = new ConcurrentValidatingQueryRunner(runTimeInSeconds, randomQueries, randomCacheFlush, queriesAndResults);
        }
        for (idx = 0; idx < runners.length; ++idx) {
            runners[idx].start();
        }
        for (idx = 0; idx < runners.length; ++idx) {
            try {
                runners[idx].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        for (idx = 0; idx < runners.length; ++idx) {
            allExceptions.addAll(runners[idx].mExceptions);
            if (!printReport) continue;
            runners[idx].report(System.out);
        }
        return allExceptions;
    }

    private void flushSchema() {
        Connection connection = this.concurrentMdxTest.getConnection();
        CacheControl cacheControl = connection.getCacheControl(null);
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        cacheControl.flush(measuresRegion);
        Cube whsalesCube = connection.getSchema().lookupCube("Warehouse and Sales", true);
        measuresRegion = cacheControl.createMeasuresRegion(whsalesCube);
        cacheControl.flush(measuresRegion);
    }

    private void flushRandomRegionOfCache() {
        Connection connection = this.concurrentMdxTest.getConnection();
        CacheControl cacheControl = connection.getCacheControl(null);
        Cube salesCube = connection.getSchema().lookupCube("Sales", true);
        SchemaReader schemaReader = salesCube.getSchemaReader(null);
        CacheControl.CellRegion measuresRegion = cacheControl.createMeasuresRegion(salesCube);
        try {
            String[] tsegments = new String[]{"Time", "1997"};
            Id tid = new Id(Id.Segment.toList(tsegments));
            Member memberTime97 = schemaReader.getMemberByUniqueName(tid.getSegments(), false);
            CacheControl.CellRegion regionTime97 = cacheControl.createMemberRegion(memberTime97, true);
            String[] states = new String[]{"CA", "OR", "WA"};
            int idx = (int)(Math.random() * (double)states.length);
            String[] ssegments = new String[]{"Customers", "All Customers", "USA", states[idx]};
            Id sid = new Id(Id.Segment.toList(ssegments));
            Member memberCustomerState = schemaReader.getMemberByUniqueName(sid.getSegments(), false);
            CacheControl.CellRegion regionCustomerState = cacheControl.createMemberRegion(memberCustomerState, true);
            CacheControl.CellRegion region97State = cacheControl.createCrossjoinRegion(measuresRegion, regionTime97, regionCustomerState);
            cacheControl.flush(region97State);
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

