/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.bracesmatching;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.editor.bracesmatching.MasterMatcher;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsLayer;
import org.netbeans.spi.editor.highlighting.HighlightsLayerFactory;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ZOrder;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.WeakListeners;

public class BracesMatchHighlighting
extends AbstractHighlightsContainer
implements ChangeListener,
PropertyChangeListener,
HighlightsChangeListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(BracesMatchHighlighting.class.getName());
    private static final String BRACES_MATCH_COLORING = "nbeditor-bracesMatching-match";
    private static final String BRACES_MISMATCH_COLORING = "nbeditor-bracesMatching-mismatch";
    private final JTextComponent component;
    private final Document document;
    private Caret caret = null;
    private ChangeListener caretListener;
    private final OffsetsBag bag;
    private final AttributeSet bracesMatchColoring;
    private final AttributeSet bracesMismatchColoring;

    public BracesMatchHighlighting(JTextComponent jTextComponent, Document document) {
        this.document = document;
        String string = BracesMatchHighlighting.getMimeType(jTextComponent);
        MimePath mimePath = string == null ? MimePath.EMPTY : MimePath.parse((String)string);
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors(BRACES_MATCH_COLORING);
        AttributeSet attributeSet2 = fontColorSettings.getFontColors(BRACES_MISMATCH_COLORING);
        this.bracesMatchColoring = attributeSet != null ? attributeSet : SimpleAttributeSet.EMPTY;
        this.bracesMismatchColoring = attributeSet2 != null ? attributeSet2 : SimpleAttributeSet.EMPTY;
        this.bag = new OffsetsBag(document, true);
        this.bag.addHighlightsChangeListener((HighlightsChangeListener)this);
        this.component = jTextComponent;
        this.component.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.component));
        this.caret = jTextComponent.getCaret();
        if (this.caret != null) {
            this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
            this.caret.addChangeListener(this.caretListener);
        }
        this.refresh();
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return this.bag.getHighlights(n, n2);
    }

    public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
        this.fireHighlightsChange(highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.refresh();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.refresh();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.refresh();
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.refresh();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null || "caret".equals(propertyChangeEvent.getPropertyName())) {
            if (this.caret != null) {
                this.caret.removeChangeListener(this.caretListener);
                this.caretListener = null;
            }
            this.caret = this.component.getCaret();
            if (this.caret != null) {
                this.caretListener = WeakListeners.change((ChangeListener)this, (Object)this.caret);
                this.caret.addChangeListener(this.caretListener);
            }
            this.refresh();
        } else if ("nbeditor-bracesMatching-searchDirection".equals(propertyChangeEvent.getPropertyName()) || "nbeditor-bracesMatching-caretBias".equals(propertyChangeEvent.getPropertyName()) || "nbeditor-bracesMatching-maxBackwardLookahead".equals(propertyChangeEvent.getPropertyName()) || "nbeditor-bracesMatching-maxForwardLookahead".equals(propertyChangeEvent.getPropertyName())) {
            this.refresh();
        }
    }

    private void refresh() {
        Caret caret = this.caret;
        if (caret == null) {
            this.bag.clear();
        } else {
            MasterMatcher.get(this.component).highlight(this.document, caret.getDot(), this.bag, this.bracesMatchColoring, this.bracesMismatchColoring);
        }
    }

    private static String getMimeType(JTextComponent jTextComponent) {
        EditorKit editorKit;
        Document document = jTextComponent.getDocument();
        String string = (String)document.getProperty("mimeType");
        if (string == null && (editorKit = jTextComponent.getUI().getEditorKit(jTextComponent)) != null) {
            string = editorKit.getContentType();
        }
        return string;
    }

    public static final class Factory
    implements HighlightsLayerFactory {
        public HighlightsLayer[] createLayers(HighlightsLayerFactory.Context context) {
            return new HighlightsLayer[]{HighlightsLayer.create((String)"org-netbeans-modules-editor-bracesmatching-BracesMatchHighlighting", (ZOrder)ZOrder.SHOW_OFF_RACK.forPosition(400), (boolean)true, (HighlightsContainer)new BracesMatchHighlighting(context.getComponent(), context.getDocument()))};
        }
    }
}

