/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.GuardedDocument;
import org.netbeans.editor.MarkBlock;
import org.netbeans.editor.MarkBlockChain;
import org.netbeans.spi.editor.highlighting.HighlightsContainer;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.openide.util.WeakListeners;

public final class GuardedBlocksHighlighting
extends AbstractHighlightsContainer
implements PropertyChangeListener,
DocumentListener {
    private static final Logger LOG = Logger.getLogger(GuardedBlocksHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.oldlibbridge.GuardedBlocksHighlighting";
    private final Document document;
    private final MarkBlockChain guardedBlocksChain;
    private final MimePath mimePath;
    private AttributeSet attribs = null;

    public GuardedBlocksHighlighting(Document document, String string) {
        this.document = document;
        if (document instanceof GuardedDocument) {
            this.guardedBlocksChain = ((GuardedDocument)document).getGuardedBlockChain();
            this.guardedBlocksChain.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.guardedBlocksChain));
            this.document.addDocumentListener((DocumentListener)WeakListeners.create(DocumentListener.class, (EventListener)this, (Object)this.document));
        } else {
            this.guardedBlocksChain = null;
        }
        this.mimePath = MimePath.parse((String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HighlightsSequence getHighlights(int n, int n2) {
        GuardedBlocksHighlighting guardedBlocksHighlighting = this;
        synchronized (guardedBlocksHighlighting) {
            if (this.guardedBlocksChain != null) {
                return new HSImpl(this.guardedBlocksChain.getChain(), n, n2);
            }
            return HighlightsSequence.EMPTY;
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName() == null || propertyChangeEvent.getPropertyName().equals("MarkBlockChain.PROP_BLOCKS_CHANGED")) {
            int n;
            int n2 = propertyChangeEvent.getOldValue() == null ? -1 : (Integer)propertyChangeEvent.getOldValue();
            int n3 = n = propertyChangeEvent.getNewValue() == null ? -1 : (Integer)propertyChangeEvent.getNewValue();
            if (n2 < 0 || n2 >= this.document.getLength()) {
                n2 = 0;
            }
            if (n <= n2 || n > this.document.getLength()) {
                n = Integer.MAX_VALUE;
            }
            this.fireHighlightsChange(n2, n);
        }
    }

    public void changedUpdate(DocumentEvent documentEvent) {
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        int n;
        int n2 = documentEvent.getOffset();
        if (this.isAffectedByChange(n2, n = documentEvent.getOffset() + documentEvent.getLength())) {
            this.fireHighlightsChange(n2, n);
        }
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        int n;
        int n2 = documentEvent.getOffset();
        if (this.isAffectedByChange(n2, n = documentEvent.getOffset() + documentEvent.getLength())) {
            this.fireHighlightsChange(n2, n);
        }
    }

    private boolean isAffectedByChange(int n, int n2) {
        for (MarkBlock markBlock = this.guardedBlocksChain.getChain(); markBlock != null; markBlock = markBlock.getNext()) {
            int n3 = markBlock.compare(n, n2);
            if ((n3 & 1) != 0 || (n3 & 2) != 0) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("<" + n + ", " + n2 + "> collides with guarded block <" + markBlock.getStartOffset() + ", " + markBlock.getEndOffset() + ">");
                }
                return true;
            }
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("<" + n + ", " + n2 + "> is outside of guarded block <" + markBlock.getStartOffset() + ", " + markBlock.getEndOffset() + ">");
        }
        return false;
    }

    private final class HSImpl
    implements HighlightsSequence {
        private final int startOffset;
        private final int endOffset;
        private boolean init = false;
        private MarkBlock block;

        public HSImpl(MarkBlock markBlock, int n, int n2) {
            this.startOffset = n;
            this.endOffset = n2;
            this.block = markBlock;
        }

        public boolean moveNext() {
            if (!this.init) {
                this.init = true;
                while (null != this.block && this.block.getEndOffset() <= this.startOffset) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Skipping block: " + this.block + ", blockStart = " + this.block.getStartOffset() + ", blockEnd = " + this.block.getEndOffset() + ", startOffset = " + this.startOffset + ", endOffset = " + this.endOffset);
                    }
                    this.block = this.block.getNext();
                }
            } else if (this.block != null) {
                this.block = this.block.getNext();
            }
            if (this.block != null && this.block.getStartOffset() > this.endOffset) {
                this.block = null;
            }
            if (LOG.isLoggable(Level.FINE)) {
                if (this.block != null) {
                    LOG.fine("Next block: " + this.block + ", blockStart = " + this.block.getStartOffset() + ", blockEnd = " + this.block.getEndOffset() + ", startOffset = " + this.startOffset + ", endOffset = " + this.endOffset);
                } else {
                    LOG.fine("Next block: null");
                }
            }
            return this.block != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getStartOffset() {
            GuardedBlocksHighlighting guardedBlocksHighlighting = GuardedBlocksHighlighting.this;
            synchronized (guardedBlocksHighlighting) {
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.block == null) {
                    throw new NoSuchElementException();
                }
                return Math.max(this.block.getStartOffset(), this.startOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getEndOffset() {
            GuardedBlocksHighlighting guardedBlocksHighlighting = GuardedBlocksHighlighting.this;
            synchronized (guardedBlocksHighlighting) {
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.block == null) {
                    throw new NoSuchElementException();
                }
                return Math.min(this.block.getEndOffset(), this.endOffset);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public AttributeSet getAttributes() {
            GuardedBlocksHighlighting guardedBlocksHighlighting = GuardedBlocksHighlighting.this;
            synchronized (guardedBlocksHighlighting) {
                if (!this.init) {
                    throw new NoSuchElementException("Call moveNext() first.");
                }
                if (this.block == null) {
                    throw new NoSuchElementException();
                }
                if (GuardedBlocksHighlighting.this.attribs == null) {
                    FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)GuardedBlocksHighlighting.this.mimePath).lookup(FontColorSettings.class);
                    if (fontColorSettings != null) {
                        GuardedBlocksHighlighting.this.attribs = fontColorSettings.getFontColors("guarded");
                    }
                    if (GuardedBlocksHighlighting.this.attribs == null) {
                        GuardedBlocksHighlighting.this.attribs = SimpleAttributeSet.EMPTY;
                    } else {
                        GuardedBlocksHighlighting.this.attribs = AttributesUtilities.createImmutable((AttributeSet[])new AttributeSet[]{GuardedBlocksHighlighting.this.attribs, AttributesUtilities.createImmutable((Object[])new Object[]{HighlightsContainer.ATTR_EXTENDS_EOL, Boolean.TRUE})});
                    }
                }
                return GuardedBlocksHighlighting.this.attribs;
            }
        }
    }
}

