/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.inputcontrols.impl;

import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.InputControlQueryDataRow;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ItemRenderer
extends JPanel
implements ListCellRenderer {
    private JLabel[] labels = null;
    int columns = 0;

    public ItemRenderer(int columns) {
        GridLayout g = new GridLayout(1, columns);
        this.setLayout(g);
        this.columns = columns;
        this.labels = new JLabel[columns];
        for (int i = 0; i < columns; ++i) {
            this.labels[i] = new JLabel(" ");
            this.add(this.labels[i]);
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        int i;
        Color fg;
        Color bg;
        if (value != null && value instanceof InputControlQueryDataRow) {
            InputControlQueryDataRow icqdr = (InputControlQueryDataRow)value;
            if (value != null) {
                for (int i2 = 0; i2 < this.columns; ++i2) {
                    String s = " ";
                    try {
                        if (icqdr.getColumnValues().get(i2) != null) {
                            s = "" + icqdr.getColumnValues().get(i2);
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    this.getLabels()[i2].setText(s);
                }
                this.updateUI();
            }
        } else {
            this.getLabels()[0].setText(Misc.nvl((Object)value, (String)" "));
            for (int i3 = 1; i3 < this.columns; ++i3) {
                this.getLabels()[i3].setText(" ");
            }
        }
        this.setOpaque(isSelected);
        if (!isSelected) {
            bg = UIManager.getColor("List.background");
            if (bg != null) {
                this.setBackground(bg);
            }
            fg = UIManager.getColor("List.foreground");
            for (i = 0; i < this.columns; ++i) {
                this.getLabels()[i].setForeground(fg);
                this.getLabels()[i].setBackground(bg);
            }
        } else {
            bg = UIManager.getColor("List.selectionBackground");
            if (bg != null) {
                this.setBackground(bg);
            }
            fg = UIManager.getColor("List.selectionForeground");
            for (i = 0; i < this.columns; ++i) {
                this.getLabels()[i].setForeground(fg);
                this.getLabels()[i].setBackground(bg);
            }
        }
        for (int i4 = 0; i4 < this.columns; ++i4) {
            this.getLabels()[i4].setOpaque(isSelected);
        }
        return this;
    }

    public JLabel[] getLabels() {
        return this.labels;
    }

    public void setLabels(JLabel[] labels) {
        this.labels = labels;
    }
}

