/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestartTask
extends BasicTask<GlassfishModule.OperationState> {
    private static final int RESTART_DELAY = 5000;
    private final CommonServerSupport support;

    public RestartTask(CommonServerSupport commonServerSupport, OperationStateListener ... operationStateListenerArray) {
        super(commonServerSupport.getInstanceProperties(), operationStateListenerArray);
        this.support = commonServerSupport;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Logger.getLogger("glassfish").log(Level.FINEST, "RestartTask.call() called on thread \"" + Thread.currentThread().getName() + "\"");
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_RESTART_SERVER_IN_PROGRESS", this.instanceName);
        GlassfishModule.ServerState serverState = this.support.getServerState();
        if (serverState == GlassfishModule.ServerState.STARTING) {
            GlassfishModule.ServerState serverState2 = serverState;
            int n = 480;
            int n2 = 0;
            while (serverState2 == GlassfishModule.ServerState.STARTING && n2++ < n) {
                try {
                    Thread.sleep(250L);
                }
                catch (InterruptedException interruptedException) {
                    Logger.getLogger("glassfish").log(Level.FINER, interruptedException.getLocalizedMessage(), interruptedException);
                }
                serverState2 = this.support.getServerState();
            }
            if (serverState2 != GlassfishModule.ServerState.RUNNING) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_START", this.instanceName);
            }
        } else {
            Object object;
            boolean bl = true;
            if (serverState == GlassfishModule.ServerState.RUNNING) {
                object = this.support.stopServer(null);
                GlassfishModule.OperationState operationState = GlassfishModule.OperationState.FAILED;
                try {
                    operationState = (GlassfishModule.OperationState)((Object)object.get(10000L, TIMEUNIT));
                }
                catch (Exception exception) {
                    Logger.getLogger("glassfish").log(Level.FINER, exception.getLocalizedMessage(), exception);
                }
                if (operationState == GlassfishModule.OperationState.FAILED) {
                    return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_STOP", this.instanceName);
                }
            } else if (serverState == GlassfishModule.ServerState.STOPPING) {
                object = serverState;
                int n = 40;
                int n3 = 0;
                while (object == GlassfishModule.ServerState.STOPPING && n3++ < n) {
                    try {
                        Thread.sleep(250L);
                    }
                    catch (InterruptedException interruptedException) {
                        Logger.getLogger("glassfish").log(Level.FINER, interruptedException.getLocalizedMessage(), interruptedException);
                    }
                    object = this.support.getServerState();
                }
                if (object != GlassfishModule.ServerState.STOPPED) {
                    return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_STOP", this.instanceName);
                }
            } else {
                bl = false;
            }
            if (bl) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            object = this.support.startServer(null);
            GlassfishModule.OperationState operationState = GlassfishModule.OperationState.FAILED;
            try {
                operationState = (GlassfishModule.OperationState)((Object)object.get(120000L, TIMEUNIT));
            }
            catch (Exception exception) {
                Logger.getLogger("glassfish").log(Level.FINER, exception.getLocalizedMessage(), exception);
            }
            if (operationState == GlassfishModule.OperationState.FAILED) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_WONT_START", this.instanceName);
            }
            if (this.support.getServerState() != GlassfishModule.ServerState.RUNNING) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_RESTART_SERVER_FAILED_REASON_UNKNOWN", this.instanceName);
            }
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_RESTARTED", this.instanceName);
    }
}

