/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.welcome;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.welcome.ActionButton;
import com.jaspersoft.ireport.designer.welcome.LinkButton;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

public class RecentReportsPanel
extends JPanel {
    private static final int MAX_REPORTS = 10;
    private PreferenceChangeListener changeListener;

    public RecentReportsPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
    }

    public void addNotify() {
        super.addNotify();
        this.removeAll();
        this.add((Component)this.rebuildContent(), "Center");
        IReportManager.getPreferences().addPreferenceChangeListener(this.getPreferenceChangeListener());
    }

    public void removeNotify() {
        super.removeNotify();
        IReportManager.getPreferences().removePreferenceChangeListener(this.getPreferenceChangeListener());
    }

    private PreferenceChangeListener getPreferenceChangeListener() {
        if (null == this.changeListener) {
            this.changeListener = new PreferenceChangeListener(){

                public void preferenceChange(PreferenceChangeEvent evt) {
                    RecentReportsPanel.this.removeAll();
                    RecentReportsPanel.this.add((Component)RecentReportsPanel.this.rebuildContent(), "Center");
                    RecentReportsPanel.this.invalidate();
                    RecentReportsPanel.this.revalidate();
                    RecentReportsPanel.this.repaint();
                }
            };
        }
        return this.changeListener;
    }

    private JPanel rebuildContent() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setOpaque(false);
        int row = 0;
        String s = IReportManager.getPreferences().get("RecentFiles", null);
        if (s != null) {
            String[] files = s.split("\n");
            for (int i = 0; i < files.length; ++i) {
                if (files[i].trim().length() == 0) continue;
                if (row > 10) break;
                String item = files[i];
                FileObject fo = null;
                try {
                    fo = RecentReportsPanel.convertURL2File(new URL(item));
                }
                catch (MalformedURLException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                if (fo == null || !fo.isValid()) continue;
                this.addProject(panel, row, fo);
                ++row;
            }
        }
        if (0 == row) {
            panel.add((Component)new JLabel(I18n.getString("RecentReportsPanel.noRecentFiles")), new GridBagConstraints(0, row, 1, 1, 1.0, 1.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        } else {
            panel.add((Component)new JLabel(), new GridBagConstraints(0, row, 1, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        }
        return panel;
    }

    private void addProject(JPanel panel, int row, FileObject fileObject) {
        try {
            OpenFileObjectAction action = new OpenFileObjectAction(fileObject);
            ActionButton b = new ActionButton(action, true, fileObject.getURL().toString());
            b.setFont(LinkButton.BUTTON_FONT);
            panel.add((Component)b, new GridBagConstraints(0, row, 1, 1, 1.0, 0.0, 18, 0, new Insets(2, 2, 2, 2), 0, 0));
        }
        catch (FileStateInvalidException ex) {
            // empty catch block
        }
    }

    static URL convertFile2URL(FileObject fo) {
        URL url = URLMapper.findURL((FileObject)fo, (int)1);
        return url;
    }

    static FileObject convertURL2File(URL url) {
        FileObject fo = URLMapper.findFileObject((URL)url);
        return fo;
    }

    private static class OpenFileObjectAction
    extends AbstractAction {
        private FileObject fileObject;

        public OpenFileObjectAction(FileObject fileObject) {
            this.fileObject = fileObject;
            Image icon = null;
            try {
                DataObject dObj = DataObject.find((FileObject)fileObject);
                icon = dObj.getNodeDelegate().getIcon(1);
                this.putValue("SmallIcon", new ImageIcon(icon));
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            this.putValue("Name", fileObject.getName());
        }

        public void actionPerformed(ActionEvent e) {
            if (this.fileObject != null) {
                try {
                    ((OpenCookie)DataObject.find((FileObject)this.fileObject).getCookie(OpenCookie.class)).open();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

