/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.tools.GenericElementParameterDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGenericElementParameter;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.jdesktop.swingx.JXTable;
import org.openide.util.NbBundle;

public class GenericElementParametersPanel
extends JPanel {
    private List parameters = new ArrayList();
    private ExpressionContext expressionContext = null;
    private JButton jButtonAdd;
    private JButton jButtonCopyFromMaster;
    private JButton jButtonDelete;
    private JButton jButtonModify;
    private JLabel jLabelTitle;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable;

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void setExpressionContext(ExpressionContext expressionContext) {
        this.expressionContext = expressionContext;
    }

    public List getParameters() {
        return this.parameters;
    }

    public void setParameters(List oldParameters) {
        this.parameters.clear();
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        model.setRowCount(0);
        for (JRDesignGenericElementParameter oldParameter : oldParameters) {
            JRDesignGenericElementParameter parameter = new JRDesignGenericElementParameter();
            parameter.setName(oldParameter.getName());
            if (oldParameter.getValueExpression() != null) {
                JRDesignExpression exp = new JRDesignExpression();
                exp.setText(oldParameter.getValueExpression().getText());
                exp.setValueClassName(oldParameter.getValueExpression().getValueClassName());
                parameter.setValueExpression((JRExpression)exp);
            }
            this.parameters.add(parameter);
            model.addRow(new Object[]{parameter, Misc.getExpressionText(parameter.getValueExpression())});
        }
    }

    public GenericElementParametersPanel() {
        this.initComponents();
        this.jTable.getColumnModel().getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value != null && value instanceof JRGenericElementParameter) {
                    label.setText(((JRGenericElementParameter)value).getName());
                }
                return label;
            }
        });
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTable.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                GenericElementParametersPanel.this.jTableSelectionValueChanged(e);
            }
        });
    }

    public void jTableSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTable.getSelectedRowCount() > 0) {
            this.jButtonModify.setEnabled(true);
            this.jButtonDelete.setEnabled(true);
        } else {
            this.jButtonModify.setEnabled(false);
            this.jButtonDelete.setEnabled(false);
        }
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTable = new JXTable();
        this.jPanel1 = new JPanel();
        this.jButtonAdd = new JButton();
        this.jButtonModify = new JButton();
        this.jButtonDelete = new JButton();
        this.jButtonCopyFromMaster = new JButton();
        this.setLayout(new GridBagLayout());
        this.jLabelTitle.setText(NbBundle.getMessage(GenericElementParametersPanel.class, (String)"GenericElementParametersPanel.jLabelTitle.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 4);
        this.add((Component)this.jLabelTitle, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(375, 275));
        this.jTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Expression"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable.setOpaque(false);
        this.jTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                GenericElementParametersPanel.this.jTableMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButtonAdd.setText(NbBundle.getMessage(GenericElementParametersPanel.class, (String)"GenericElementParametersPanel.jButtonAdd.text"));
        this.jButtonAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericElementParametersPanel.this.jButtonAddActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonAdd, gridBagConstraints);
        this.jButtonModify.setText(NbBundle.getMessage(GenericElementParametersPanel.class, (String)"GenericElementParametersPanel.jButtonModify.text"));
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericElementParametersPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonModify, gridBagConstraints);
        this.jButtonDelete.setText(NbBundle.getMessage(GenericElementParametersPanel.class, (String)"GenericElementParametersPanel.jButtonDelete.text"));
        this.jButtonDelete.setEnabled(false);
        this.jButtonDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericElementParametersPanel.this.jButtonDeleteActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel1.add((Component)this.jButtonDelete, gridBagConstraints);
        this.jButtonCopyFromMaster.setText(NbBundle.getMessage(GenericElementParametersPanel.class, (String)"GenericElementParametersPanel.jButtonCopyFromMaster.text"));
        this.jButtonCopyFromMaster.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GenericElementParametersPanel.this.jButtonCopyFromMasterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jButtonCopyFromMaster, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
    }

    private void jButtonAddActionPerformed(ActionEvent evt) {
        Window pWin = SwingUtilities.getWindowAncestor(this);
        GenericElementParameterDialog jrpd = null;
        jrpd = pWin instanceof Dialog ? new GenericElementParameterDialog((Dialog)pWin, this.getParameters()) : new GenericElementParameterDialog((Frame)pWin, this.getParameters());
        jrpd.setExpressionContext(this.getExpressionContext());
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRDesignGenericElementParameter parameter = jrpd.getParameter();
            this.parameters.add(parameter);
            DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
            model.addRow(new Object[]{parameter, Misc.getExpressionText(parameter.getValueExpression())});
        }
    }

    private void jButtonDeleteActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        while (this.jTable.getSelectedRow() >= 0) {
            int row = this.jTable.getSelectedRow();
            row = ((JXTable)this.jTable).convertRowIndexToModel(row);
            this.parameters.remove(model.getValueAt(row, 0));
            model.removeRow(row);
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        int row = this.jTable.getSelectedRow();
        if (row < 0) {
            return;
        }
        row = ((JXTable)this.jTable).convertRowIndexToModel(row);
        JRDesignGenericElementParameter parameter = (JRDesignGenericElementParameter)model.getValueAt(row, 0);
        int paramIndex = this.parameters.indexOf(parameter);
        GenericElementParameterDialog jrpd = null;
        Window pWin = SwingUtilities.getWindowAncestor(this);
        jrpd = pWin instanceof Dialog ? new GenericElementParameterDialog((Dialog)pWin, this.getParameters()) : (pWin instanceof Frame ? new GenericElementParameterDialog((Frame)pWin, this.getParameters()) : new GenericElementParameterDialog((Dialog)null, this.getParameters()));
        jrpd.setExpressionContext(this.getExpressionContext());
        jrpd.setParameter(parameter);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            parameter = jrpd.getParameter();
            this.parameters.remove(paramIndex);
            this.parameters.add(paramIndex, parameter);
            model.setValueAt(parameter, row, 0);
            model.setValueAt(Misc.getExpressionText(parameter.getValueExpression()), row, 1);
            this.jTable.updateUI();
        }
    }

    private void jButtonCopyFromMasterActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.jTable.getModel();
        List reportParameters = IReportManager.getInstance().getActiveReport().getParametersList();
        for (int i = 0; i < reportParameters.size(); ++i) {
            JRDesignParameter jrParameter = (JRDesignParameter)reportParameters.get(i);
            if (jrParameter.isSystemDefined() || this.findParameter(this.parameters, jrParameter.getName())) continue;
            JRDesignGenericElementParameter parameter = new JRDesignGenericElementParameter();
            parameter.setName(jrParameter.getName());
            JRDesignExpression exp = new JRDesignExpression();
            exp.setText("$P{" + jrParameter.getName() + "}");
            exp.setValueClassName(jrParameter.getValueClassName());
            parameter.setValueExpression((JRExpression)exp);
            this.parameters.add(parameter);
            model.addRow(new Object[]{parameter, Misc.getExpressionText(parameter.getValueExpression())});
        }
        this.jTable.updateUI();
    }

    private void jTableMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt) && this.jTable.getSelectedRowCount() > 0) {
            this.jButtonModifyActionPerformed(null);
        }
    }

    private boolean findParameter(List parameters, String name) {
        for (int i = 0; i < parameters.size(); ++i) {
            JRGenericElementParameter param = (JRGenericElementParameter)parameters.get(i);
            if (!param.getName().equals(name)) continue;
            return true;
        }
        return false;
    }
}

