/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.styles;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.locale.I18n;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public class AddStyleToReportAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        JasperDesign jd = IReportManager.getInstance().getActiveReport();
        for (int i = 0; i < nodes.length; ++i) {
            JRStyle style = (JRStyle)nodes[i].getLookup().lookup(JRStyle.class);
            if (style == null) continue;
            try {
                jd.addStyle(style);
                continue;
            }
            catch (JRException ex) {
                ex.printStackTrace();
                IReportManager.getInstance().notifyReportChange();
            }
        }
    }

    protected boolean enable(Node[] nodes) {
        if (IReportManager.getInstance().getActiveReport() == null) {
            return false;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getLookup().lookup(JRStyle.class) != null) continue;
            return false;
        }
        return nodes.length > 0;
    }

    public String getName() {
        return I18n.getString("AddStyleToReportAction.addSyleToReport");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }
}

