/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.sheet.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import org.openide.ErrorManager;
import org.openide.nodes.PropertySupport;

public class TextFieldEvaluationTimeProperty
extends PropertySupport {
    private final JRDesignDataset dataset;
    private final JRDesignTextField element;
    private ComboBoxPropertyEditor editor;

    public TextFieldEvaluationTimeProperty(JRDesignTextField element, JRDesignDataset dataset) {
        super("evaluationTime", Byte.class, I18n.getString("Global.Property.EvaluationTime"), I18n.getString("Global.Property.EvaluationTimedetail"), true, true);
        this.element = element;
        this.dataset = dataset;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
    }

    public boolean isDefaultValue() {
        return this.element.getEvaluationTime() == 1;
    }

    public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
        this.setPropertyValue((byte)1);
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            ArrayList<Tag> l = new ArrayList<Tag>();
            l.add(new Tag(new Byte(1), I18n.getString("Global.Property.Now")));
            l.add(new Tag(new Byte(2), I18n.getString("Global.Property.Report")));
            l.add(new Tag(new Byte(3), I18n.getString("Global.Property.Page")));
            l.add(new Tag(new Byte(4), I18n.getString("Global.Property.Column")));
            l.add(new Tag(new Byte(5), I18n.getString("Global.Property.Group")));
            l.add(new Tag(new Byte(6), I18n.getString("Global.Property.Band")));
            l.add(new Tag(new Byte(7), I18n.getString("Global.Property.Auto")));
            this.editor = new ComboBoxPropertyEditor(false, l);
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return new Byte(this.element.getEvaluationTime());
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val instanceof Byte) {
            this.setPropertyValue((Byte)val);
        }
    }

    private void setPropertyValue(Byte val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Byte oldValue = this.element.getEvaluationTime();
        Byte newValue = val;
        ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.element, "EvaluationTime", Byte.TYPE, oldValue, newValue);
        JRGroup oldGroupValue = this.element.getEvaluationGroup();
        JRGroup newGroupValue = null;
        if (val == 5) {
            if (this.dataset.getGroupsList().size() == 0) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("Global.Property.NogroupsTextFielddetail"));
                throw iae;
            }
            newGroupValue = (JRGroup)this.dataset.getGroupsList().get(0);
        }
        this.element.setEvaluationTime(newValue.byteValue());
        if (oldGroupValue != newGroupValue) {
            ObjectPropertyUndoableEdit urobGroup = new ObjectPropertyUndoableEdit(this.element, "EvaluationGroup", JRGroup.class, oldGroupValue, newGroupValue);
            this.element.setEvaluationGroup(newGroupValue);
            urob.concatenate(urobGroup);
        }
        IReportManager.getInstance().addUndoableEdit(urob);
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }
}

