/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.properties.ByteProperty;
import com.jaspersoft.ireport.designer.sheet.properties.ExpressionProperty;
import com.jaspersoft.ireport.designer.sheet.properties.StringProperty;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRCrosstabOrigin;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.Pair;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.actions.ReorderAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CrosstabGroupNode
extends IRAbstractNode
implements PropertyChangeListener {
    public static final int ROW_GROUP = 1;
    public static final int COLUMN_GROUP = 2;
    JasperDesign jd = null;
    private JRDesignCrosstab crosstab = null;
    private JRDesignCrosstabGroup group = null;
    private int type = 0;

    public abstract List<JRDesignCrosstabGroup> getGroups();

    public abstract int getType();

    public CrosstabGroupNode(JasperDesign jd, JRDesignCrosstab crosstab, JRDesignCrosstabGroup group, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{jd, crosstab, group})}));
        this.jd = jd;
        this.group = group;
        this.crosstab = crosstab;
        this.setDisplayName(group.getName());
        super.setName(group.getName());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/crosstabrows-16.png");
        group.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new NameProperty(this.getGroup(), this.jd, this.getCrosstab()));
        set.put((Node.Property)new TotalPositionProperty(this.getGroup(), this.getCrosstab()));
        set.put((Node.Property)new BucketExpressionProperty((JRDesignCrosstabBucket)this.getGroup().getBucket(), this.getCrosstab(), this.jd));
        set.put((Node.Property)new BucketComparatorExpressionProperty((JRDesignCrosstabBucket)this.getGroup().getBucket(), this.getCrosstab(), this.jd));
        set.put((Node.Property)new BucketOrderProperty((JRDesignCrosstabBucket)this.getGroup().getBucket(), this.getCrosstab()));
        set.put((Node.Property)new BucketOrderByExpressionProperty((JRDesignCrosstabBucket)this.getGroup().getBucket(), this.getCrosstab(), this.jd));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return true;
    }

    public boolean canRename() {
        return true;
    }

    public void destroy() throws IOException {
        if (this.getType() == 2) {
            this.getCrosstab().removeColumnGroup((JRCrosstabColumnGroup)((JRDesignCrosstabColumnGroup)this.getGroup()));
        } else {
            this.getCrosstab().removeRowGroup((JRCrosstabRowGroup)((JRDesignCrosstabRowGroup)this.getGroup()));
        }
        List cells = this.getCrosstab().getCellsList();
        String name = this.getGroup().getName();
        for (int i = 0; i < cells.size(); ++i) {
            String totalGroup;
            JRDesignCrosstabCell cell = (JRDesignCrosstabCell)cells.get(i);
            if (cell == null) continue;
            String string = totalGroup = this.getType() == 2 ? cell.getColumnTotalGroup() : cell.getRowTotalGroup();
            if (totalGroup == null || !totalGroup.equals(name)) continue;
            cells.remove(cell);
            --i;
        }
        super.destroy();
    }

    public boolean canDestroy() {
        return this.getGroups().size() > 1;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(CopyAction.class), SystemAction.get(CutAction.class), SystemAction.get(RenameAction.class), SystemAction.get(ReorderAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void setName(String s) {
        Sheet.Set props = this.getSheet().get("properties");
        if (props != null) {
            Node.Property[] properties = props.getProperties();
            for (int i = 0; i < properties.length; ++i) {
                Node.Property p = properties[i];
                if (p.getName() == null || !p.getName().equals("name")) continue;
                try {
                    p.setValue((Object)s);
                    continue;
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex.getMessage());
                }
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getGroup().getName());
            this.setDisplayName(this.getGroup().getName());
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public JRDesignCrosstabGroup getGroup() {
        return this.group;
    }

    public JRDesignCrosstab getCrosstab() {
        return this.crosstab;
    }

    public static final class BucketOrderProperty
    extends ByteProperty {
        private final JRDesignCrosstabBucket bucket;
        private final JRDesignCrosstab crosstab;

        public BucketOrderProperty(JRDesignCrosstabBucket bucket, JRDesignCrosstab crosstab) {
            super(bucket);
            this.setName("order");
            this.setDisplayName("Order");
            this.setShortDescription("The sorting type");
            this.crosstab = crosstab;
            this.bucket = bucket;
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(new Byte(1), "Ascending"));
            tags.add(new Tag(new Byte(2), "Descending"));
            return tags;
        }

        public Byte getByte() {
            return this.bucket.getOrder();
        }

        public Byte getOwnByte() {
            return this.bucket.getOrder();
        }

        public Byte getDefaultByte() {
            return (byte)1;
        }

        public void setByte(Byte b) {
            this.bucket.setOrder(b.byteValue());
        }
    }

    public static final class BucketOrderByExpressionProperty
    extends ExpressionProperty {
        private final JRDesignCrosstabBucket bucket;
        private final JRDesignCrosstab crosstab;
        private final JasperDesign jd;

        public BucketOrderByExpressionProperty(JRDesignCrosstabBucket bucket, JRDesignCrosstab crosstab, JasperDesign jd) {
            super((Object)bucket, new ExpressionContext(ModelUtils.getCrosstabDataset(crosstab, jd)));
            this.setName("orderByExpression");
            this.setDisplayName("Order by exp.");
            this.setShortDescription("The 'Order by' expression can be used to specify a custom sorting of the data. The expressions's type should be compatible with java.lang.Comparable (otherwise a custom comparator expression would be required)");
            this.crosstab = crosstab;
            this.bucket = bucket;
            this.jd = jd;
            crosstab.getEventSupport().addPropertyChangeListener("dataset", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BucketOrderByExpressionProperty.this.setValue("EXPRESSION_CONTEXT", ModelUtils.getElementDataset((JRDesignElement)BucketOrderByExpressionProperty.this.getCrosstab(), BucketOrderByExpressionProperty.this.getJasperDesign()));
                }
            });
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public String getDefaultExpressionClassName() {
            return "java.lang.Comparable";
        }

        public JRDesignExpression getExpression() {
            return (JRDesignExpression)this.bucket.getOrderByExpression();
        }

        public void setExpression(JRDesignExpression expression) {
            this.bucket.setOrderByExpression((JRExpression)expression);
        }

        public JRDesignCrosstabBucket getBucket() {
            return this.bucket;
        }

        public JRDesignCrosstab getCrosstab() {
            return this.crosstab;
        }

        public Object getDefaultValue() {
            return null;
        }

        public boolean isDefaultValue() {
            return this.getValue() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (newValue != null && newValue instanceof String && ((String)newValue).trim().length() == 0) {
                super.setValue(null);
            }
            super.setValue(newValue);
        }
    }

    public static final class BucketComparatorExpressionProperty
    extends ExpressionProperty {
        private final JRDesignCrosstabBucket bucket;
        private final JRDesignCrosstab crosstab;
        private final JasperDesign jd;

        public BucketComparatorExpressionProperty(JRDesignCrosstabBucket bucket, JRDesignCrosstab crosstab, JasperDesign jd) {
            super((Object)bucket, new ExpressionContext(ModelUtils.getCrosstabDataset(crosstab, jd)));
            this.setName("comparatorExpression");
            this.setDisplayName("Comparator exp.");
            this.setShortDescription("The comparator expression. The expressions's type should be compatible with java.util.Comparator.");
            this.crosstab = crosstab;
            this.bucket = bucket;
            this.jd = jd;
            crosstab.getEventSupport().addPropertyChangeListener("dataset", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BucketComparatorExpressionProperty.this.setValue("EXPRESSION_CONTEXT", ModelUtils.getElementDataset((JRDesignElement)BucketComparatorExpressionProperty.this.getCrosstab(), BucketComparatorExpressionProperty.this.getJasperDesign()));
                }
            });
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public String getDefaultExpressionClassName() {
            return "java.util.Comparator";
        }

        public JRDesignExpression getExpression() {
            return (JRDesignExpression)this.bucket.getComparatorExpression();
        }

        public void setExpression(JRDesignExpression expression) {
            this.bucket.setComparatorExpression((JRExpression)expression);
        }

        public JRDesignCrosstabBucket getBucket() {
            return this.bucket;
        }

        public JRDesignCrosstab getCrosstab() {
            return this.crosstab;
        }

        public Object getDefaultValue() {
            return null;
        }

        public boolean isDefaultValue() {
            return this.getValue() == null;
        }

        public void restoreDefaultValue() throws IllegalAccessException, InvocationTargetException {
            this.setValue(null);
        }

        public boolean supportsDefaultValue() {
            return true;
        }

        public void setValue(Object newValue) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (newValue != null && newValue instanceof String && ((String)newValue).trim().length() == 0) {
                super.setValue(null);
            }
            super.setValue(newValue);
        }
    }

    public static final class BucketExpressionProperty
    extends ExpressionProperty {
        private final JRDesignCrosstabBucket bucket;
        private final JRDesignCrosstab crosstab;
        private final JasperDesign jd;

        public BucketExpressionProperty(JRDesignCrosstabBucket bucket, JRDesignCrosstab crosstab, JasperDesign jd) {
            super((Object)bucket, new ExpressionContext(ModelUtils.getCrosstabDataset(crosstab, jd)));
            this.setName("expression");
            this.setDisplayName("Bucket expression");
            this.setShortDescription("The expression used to group the rows/columns.");
            this.crosstab = crosstab;
            this.bucket = bucket;
            this.jd = jd;
            crosstab.getEventSupport().addPropertyChangeListener("dataset", new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    BucketExpressionProperty.this.setValue("EXPRESSION_CONTEXT", ModelUtils.getElementDataset((JRDesignElement)BucketExpressionProperty.this.getCrosstab(), BucketExpressionProperty.this.getJasperDesign()));
                }
            });
        }

        public JasperDesign getJasperDesign() {
            return this.jd;
        }

        public String getDefaultExpressionClassName() {
            return "java.lang.String";
        }

        public JRDesignExpression getExpression() {
            return (JRDesignExpression)this.bucket.getExpression();
        }

        public void setExpression(JRDesignExpression expression) {
            this.bucket.setExpression(expression);
        }

        public JRDesignCrosstabBucket getBucket() {
            return this.bucket;
        }

        public JRDesignCrosstab getCrosstab() {
            return this.crosstab;
        }
    }

    public static final class TotalPositionProperty
    extends ByteProperty {
        private final JRDesignCrosstabGroup group;
        private final JRDesignCrosstab crosstab;

        public TotalPositionProperty(JRDesignCrosstabGroup group, JRDesignCrosstab crosstab) {
            super(group);
            this.setName("totalPosition");
            this.setDisplayName("Total Position");
            this.setShortDescription("This property set the position of the total column or row for this group. If no total is required, set the position type to None");
            this.crosstab = crosstab;
            this.group = group;
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(new Byte(2), "End"));
            tags.add(new Tag(new Byte(1), "Start"));
            tags.add(new Tag(new Byte(0), "None"));
            return tags;
        }

        public Byte getByte() {
            return this.group.getTotalPosition();
        }

        public Byte getOwnByte() {
            return this.group.getTotalPosition();
        }

        public Byte getDefaultByte() {
            return (byte)0;
        }

        public void setByte(Byte positionType) {
            this.group.setTotalPosition(positionType.byteValue());
        }
    }

    public static final class NameProperty
    extends StringProperty {
        private JRDesignCrosstabGroup group = null;
        private JRDesignCrosstab crosstab = null;
        private JasperDesign jd = null;

        public NameProperty(JRDesignCrosstabGroup group, JasperDesign jd, JRDesignCrosstab crosstab) {
            super(group);
            this.setName("name");
            this.setDisplayName("Name");
            this.setShortDescription("Name of the group");
            this.group = group;
            this.crosstab = crosstab;
            this.jd = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public JRDesignCrosstab getCrosstab() {
            return this.crosstab;
        }

        public JRDesignCrosstabGroup getGroup() {
            return this.group;
        }

        public String getString() {
            return this.getGroup().getName();
        }

        public String getOwnString() {
            return this.getGroup().getName();
        }

        public String getDefaultString() {
            return this.getGroup().getName();
        }

        public boolean supportsDefaultValue() {
            return false;
        }

        public void validate(Object value) {
            super.validate(value);
            if (value == null || value.equals("")) {
                IllegalArgumentException iae = this.annotateException("Group name not valid.");
                throw iae;
            }
            String s = value + "";
            if (s.equals(this.getGroup().getName())) {
                return;
            }
            if (!ModelUtils.isValidNewCrosstabObjectName(this.crosstab, s)) {
                IllegalArgumentException iae = this.annotateException("Group name already in use.");
                throw iae;
            }
        }

        public void setString(String newName) {
            int i;
            Object obj;
            Map map;
            String oldName = this.getGroup().getName();
            if (oldName.equals(newName)) {
                return;
            }
            if (this.crosstab.getColumnGroupIndicesMap().containsKey(oldName)) {
                map = this.crosstab.getColumnGroupIndicesMap();
            } else if (this.crosstab.getRowGroupIndicesMap().containsKey(oldName)) {
                map = this.crosstab.getRowGroupIndicesMap();
            } else {
                return;
            }
            if (map != null && (obj = map.get(oldName)) != null) {
                map.put(newName, obj);
                map.remove(oldName);
                List cells = this.crosstab.getCellsList();
                for (i = 0; i < cells.size(); ++i) {
                    JRDesignCrosstabCell cell = (JRDesignCrosstabCell)cells.get(i);
                    String rowName_new = cell.getRowTotalGroup();
                    String columnName_new = cell.getColumnTotalGroup();
                    String rowName_old = cell.getRowTotalGroup();
                    String columnName_old = cell.getColumnTotalGroup();
                    boolean updateCell = false;
                    if (cell.getColumnTotalGroup() != null && cell.getColumnTotalGroup().equals(oldName)) {
                        cell.setColumnTotalGroup(newName);
                        columnName_new = newName;
                        updateCell = true;
                    } else if (cell.getRowTotalGroup() != null && cell.getRowTotalGroup().equals(oldName)) {
                        cell.setRowTotalGroup(newName);
                        rowName_new = newName;
                        updateCell = true;
                    }
                    if (!updateCell) continue;
                    Pair cellKey = new Pair((Object)rowName_old, (Object)columnName_old);
                    this.getCrosstab().getCellsMap().remove(cellKey);
                    cellKey = new Pair((Object)rowName_new, (Object)columnName_new);
                    this.getCrosstab().getCellsMap().put(cellKey, cell);
                    if (cell.getContents() == null) continue;
                    JRDesignCellContents contents = (JRDesignCellContents)cell.getContents();
                    contents.setOrigin(new JRCrosstabOrigin(this.getCrosstab(), 7, rowName_new, columnName_new));
                    contents.getEventSupport().firePropertyChange("name", null, null);
                }
                this.getGroup().setName(newName);
                if (this.getGroup().getTotalHeader() != null) {
                    this.getGroup().setTotalHeader((JRDesignCellContents)this.getGroup().getTotalHeader());
                    ((JRDesignCellContents)this.getGroup().getTotalHeader()).getEventSupport().firePropertyChange("name", (Object)oldName, (Object)newName);
                }
                if (this.getGroup().getHeader() != null) {
                    this.getGroup().setHeader((JRDesignCellContents)this.getGroup().getHeader());
                    ((JRDesignCellContents)this.getGroup().getHeader()).getEventSupport().firePropertyChange("name", (Object)oldName, (Object)newName);
                }
            }
            String className = null;
            if (this.getGroup().getBucket() != null && this.getGroup().getBucket().getExpression() != null) {
                className = this.getGroup().getBucket().getExpression().getValueClassName();
            }
            ModelUtils.fixElementsExpressions(this.crosstab, oldName, newName, (byte)4, className);
            List expressions = JRExpressionCollector.collectExpressions((JRReport)this.jd, (JRCrosstab)this.crosstab);
            for (i = 0; i < expressions.size(); ++i) {
                JRDesignExpression exp = (JRDesignExpression)expressions.get(i);
                ModelUtils.replaceChunkText(exp, oldName, newName, (byte)4, className);
            }
        }
    }
}

