/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.export.AbstractExportParametersPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;

public class TextExportParametersPanel
extends AbstractExportParametersPanel {
    private JCheckBox jCheckBoxNothingBetweenPages;
    private JLabel jLabelBetweenPagesText;
    private JLabel jLabelCharacterHeight;
    private JLabel jLabelCharacterWidth;
    private JLabel jLabelDefault1;
    private JLabel jLabelDefault2;
    private JLabel jLabelDefault3;
    private JLabel jLabelDefault4;
    private JLabel jLabelDefault5;
    private JLabel jLabelLineSeparator;
    private JLabel jLabelNote;
    private JLabel jLabelPageHeight;
    private JLabel jLabelPageWidth;
    private JLabel jLabelTitle;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerCharacterHeight;
    private JSpinner jSpinnerCharacterWidth;
    private JSpinner jSpinnerPageHeight;
    private JSpinner jSpinnerPageWidth;
    private JTextArea jTextAreaBetweenPagesText;
    private JTextField jTextFieldLineSeparator;

    public TextExportParametersPanel() {
        this.initComponents();
        this.jTextAreaBetweenPagesText.setFont(new Font("Monospaced", 0, 12));
        ChangeListener snmcl = new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                TextExportParametersPanel.this.notifyChange();
            }
        };
        this.jSpinnerCharacterWidth.getModel().addChangeListener(snmcl);
        this.jSpinnerCharacterHeight.getModel().addChangeListener(snmcl);
        SpinnerNumberModel snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerPageWidth.setModel(snm);
        snm.addChangeListener(snmcl);
        snm = new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1);
        this.jSpinnerPageHeight.setModel(snm);
        snm.addChangeListener(snmcl);
        DocumentListener textfieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }

            public void insertUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent evt) {
                TextExportParametersPanel.this.notifyChange();
            }
        };
        this.jTextAreaBetweenPagesText.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                if (TextExportParametersPanel.this.jTextAreaBetweenPagesText.getText().length() > 0) {
                    TextExportParametersPanel.this.jCheckBoxNothingBetweenPages.setSelected(false);
                }
                TextExportParametersPanel.this.notifyChange();
            }

            public void insertUpdate(DocumentEvent evt) {
                if (TextExportParametersPanel.this.jTextAreaBetweenPagesText.getText().length() > 0) {
                    TextExportParametersPanel.this.jCheckBoxNothingBetweenPages.setSelected(false);
                }
                TextExportParametersPanel.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent evt) {
                if (TextExportParametersPanel.this.jTextAreaBetweenPagesText.getText().length() > 0) {
                    TextExportParametersPanel.this.jCheckBoxNothingBetweenPages.setSelected(false);
                }
                TextExportParametersPanel.this.notifyChange();
            }
        });
        this.jTextFieldLineSeparator.getDocument().addDocumentListener(textfieldListener);
        this.jLabelNote.setText(I18n.getString("TextExportParametersPanel.jLabelNode.text", (Object)Misc.addSlashesString(System.getProperty("line.separator"))));
        this.applyI18n();
    }

    public void applyI18n() {
        this.jLabelTitle.setText(I18n.getString("TextExportParametersPanel.jLabelTitle.text"));
        this.jLabelCharacterWidth.setText(I18n.getString("TextExportParametersPanel.jLabelCharacterWidth.text"));
        this.jLabelCharacterHeight.setText(I18n.getString("TextExportParametersPanel.jLabelCharacterHeight.text"));
        this.jLabelPageWidth.setText(I18n.getString("TextExportParametersPanel.jLabelPageWidth.text"));
        this.jLabelPageHeight.setText(I18n.getString("TextExportParametersPanel.jLabelPageHeight.text"));
        this.jLabelBetweenPagesText.setText(I18n.getString("TextExportParametersPanel.jLabelBetweenPagesText.text"));
        this.jLabelLineSeparator.setText(I18n.getString("TextExportParametersPanel.jLabelLineSeparator.text"));
        this.jLabelDefault1.setText(I18n.getString("TextExportParametersPanel.jLabelDefault1.text"));
        this.jLabelDefault2.setText(I18n.getString("TextExportParametersPanel.jLabelDefault2.text"));
        this.jLabelDefault3.setText(I18n.getString("TextExportParametersPanel.jLabelDefault3.text"));
        this.jLabelDefault4.setText(I18n.getString("TextExportParametersPanel.jLabelDefault4.text"));
        this.jLabelDefault5.setText(I18n.getString("TextExportParametersPanel.jLabelDefault5.text"));
        this.jCheckBoxNothingBetweenPages.setText(I18n.getString("TextExportParametersPanel.jCheckBoxNothingBetweenPages.text"));
    }

    private void initComponents() {
        this.jLabelTitle = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabelCharacterWidth = new JLabel();
        this.jSpinnerCharacterWidth = new JSpinner();
        this.jLabelCharacterHeight = new JLabel();
        this.jSpinnerCharacterHeight = new JSpinner();
        this.jLabelPageWidth = new JLabel();
        this.jSpinnerPageWidth = new JSpinner();
        this.jLabelPageHeight = new JLabel();
        this.jSpinnerPageHeight = new JSpinner();
        this.jLabelBetweenPagesText = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaBetweenPagesText = new JTextArea();
        this.jLabelLineSeparator = new JLabel();
        this.jTextFieldLineSeparator = new JTextField();
        this.jLabelDefault1 = new JLabel();
        this.jLabelDefault2 = new JLabel();
        this.jLabelDefault3 = new JLabel();
        this.jLabelDefault4 = new JLabel();
        this.jLabelDefault5 = new JLabel();
        this.jCheckBoxNothingBetweenPages = new JCheckBox();
        this.jLabelNote = new JLabel();
        this.jLabelTitle.setFont(new Font("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 1, 12));
        this.jLabelTitle.setText("\u6587\u5b57\u5217\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u30d1\u30e9\u30e1\u30fc\u30bf");
        this.jLabelCharacterWidth.setText("Character Width");
        this.jSpinnerCharacterWidth.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
        this.jLabelCharacterHeight.setText("Character Height");
        this.jSpinnerCharacterHeight.setModel(new SpinnerNumberModel(Float.valueOf(0.0f), Float.valueOf(0.0f), null, Float.valueOf(1.0f)));
        this.jLabelPageWidth.setText("Page Width");
        this.jLabelPageHeight.setText("Page Height");
        this.jLabelBetweenPagesText.setText("Between Pages Text");
        this.jTextAreaBetweenPagesText.setColumns(20);
        this.jTextAreaBetweenPagesText.setFont(new Font("Monospaced", 0, 12));
        this.jTextAreaBetweenPagesText.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextAreaBetweenPagesText);
        this.jLabelLineSeparator.setText("Line Separator");
        this.jLabelDefault1.setText("(0 to use default)");
        this.jLabelDefault2.setText("(0 to use default)");
        this.jLabelDefault3.setText("(0 to use default)");
        this.jLabelDefault4.setText("(0 to use default)");
        this.jLabelDefault5.setText("Usually \"\\n\" in Unix and \"\\r\\n\" in Windows");
        this.jCheckBoxNothingBetweenPages.setText("Don't put any text between pages");
        this.jCheckBoxNothingBetweenPages.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextExportParametersPanel.this.jCheckBoxNothingBetweenPagesActionPerformed(evt);
            }
        });
        this.jLabelNote.setText("Default new line: {0}. For specific new line characters, use \\n or \\r\\n.");
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap(293, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 458, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelBetweenPagesText).addContainerGap(340, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelLineSeparator).addPreferredGap(0).add((Component)this.jTextFieldLineSeparator)).add(1, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelCharacterWidth).add((Component)this.jLabelCharacterHeight).add((Component)this.jLabelPageWidth).add((Component)this.jLabelPageHeight)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSpinnerCharacterHeight, -2, 45, -2).add((Component)this.jSpinnerPageWidth, -2, 45, -2).add((Component)this.jSpinnerPageHeight, -2, 45, -2).add((Component)this.jSpinnerCharacterWidth, -2, 81, -2)))).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelDefault1).add((Component)this.jLabelDefault2).add((Component)this.jLabelDefault3).add((Component)this.jLabelDefault4).add((Component)this.jLabelDefault5)).addContainerGap(42, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jCheckBoxNothingBetweenPages).addContainerGap(253, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 434, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelNote).addContainerGap(92, Short.MAX_VALUE)));
        layout.linkSize(new Component[]{this.jSpinnerCharacterHeight, this.jSpinnerCharacterWidth, this.jSpinnerPageHeight, this.jSpinnerPageWidth}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCharacterWidth).add((Component)this.jSpinnerCharacterWidth, -2, -1, -2).add((Component)this.jLabelDefault1)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCharacterHeight).add((Component)this.jSpinnerCharacterHeight, -2, -1, -2).add((Component)this.jLabelDefault2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPageWidth).add((Component)this.jSpinnerPageWidth, -2, -1, -2).add((Component)this.jLabelDefault3)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelPageHeight).add((Component)this.jSpinnerPageHeight, -2, -1, -2).add((Component)this.jLabelDefault4)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelLineSeparator).add((Component)this.jTextFieldLineSeparator, -2, -1, -2).add((Component)this.jLabelDefault5)).addPreferredGap(0).add((Component)this.jLabelBetweenPagesText).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 161, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabelNote).add(12, 12, 12).add((Component)this.jCheckBoxNothingBetweenPages).addContainerGap()));
    }

    private void jCheckBoxNothingBetweenPagesActionPerformed(ActionEvent evt) {
        this.notifyChange();
    }

    public void load() {
        this.setInit(true);
        Preferences pref = IReportManager.getPreferences();
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerCharacterHeight.getModel();
        model.setValue(Float.valueOf(pref.getFloat("net.sf.jasperreports.export.text.character.height", 0.0f)));
        model = (SpinnerNumberModel)this.jSpinnerCharacterWidth.getModel();
        model.setValue(Float.valueOf(pref.getFloat("net.sf.jasperreports.export.text.character.width", 0.0f)));
        model = (SpinnerNumberModel)this.jSpinnerPageHeight.getModel();
        model.setValue(pref.getInt("net.sf.jasperreports.export.text.page.height", 0));
        model = (SpinnerNumberModel)this.jSpinnerPageWidth.getModel();
        model.setValue(pref.getInt("net.sf.jasperreports.export.text.page.width", 0));
        this.jTextAreaBetweenPagesText.setText(Misc.addSlashesString(pref.get("net.sf.jasperreports.export.txt.betweenPagesText", "")));
        this.jCheckBoxNothingBetweenPages.setSelected(pref.getBoolean("net.sf.jasperreports.export.txt.nothingBetweenPages", false));
        this.jTextFieldLineSeparator.setText(Misc.addSlashesString(pref.get("net.sf.jasperreports.export.txt.lineSeparator", System.getProperty("line.separator"))));
        this.setInit(false);
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        SpinnerNumberModel model = (SpinnerNumberModel)this.jSpinnerCharacterHeight.getModel();
        pref.putFloat("net.sf.jasperreports.export.text.character.height", model.getNumber().floatValue());
        model = (SpinnerNumberModel)this.jSpinnerCharacterWidth.getModel();
        pref.putFloat("net.sf.jasperreports.export.text.character.width", model.getNumber().floatValue());
        model = (SpinnerNumberModel)this.jSpinnerPageHeight.getModel();
        pref.putInt("net.sf.jasperreports.export.text.page.height", model.getNumber().intValue());
        model = (SpinnerNumberModel)this.jSpinnerPageWidth.getModel();
        pref.putInt("net.sf.jasperreports.export.text.page.width", model.getNumber().intValue());
        pref.put("net.sf.jasperreports.export.txt.betweenPagesText", Misc.removeSlashesString(this.jTextAreaBetweenPagesText.getText()));
        pref.put("net.sf.jasperreports.export.txt.lineSeparator", Misc.removeSlashesString(this.jTextFieldLineSeparator.getText()));
        pref.putBoolean("net.sf.jasperreports.export.txt.nothingBetweenPages", this.jCheckBoxNothingBetweenPages.isSelected());
    }

    public boolean valid() {
        return true;
    }

    public String getDisplayName() {
        return I18n.getString("TextExportParametersPanel.title");
    }
}

