/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.IReportOptionsPanelController;
import com.jaspersoft.ireport.designer.options.export.AbstractExportParametersPanel;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.jasperreports.engine.util.JRProperties;
import org.jdesktop.layout.GroupLayout;

public class CSVExportParametersPanel
extends AbstractExportParametersPanel {
    IReportOptionsPanelController controller = null;
    private JButton jButtonReset;
    private JLabel jLabelFielDelimiter;
    private JLabel jLabelRecordDelimiter;
    private JLabel jLabelSpecialCharacters;
    private JLabel jLabelTitle;
    private JSeparator jSeparator1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public CSVExportParametersPanel() {
        this.initComponents();
        DocumentListener textfieldListener = new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                CSVExportParametersPanel.this.notifyChange();
            }

            public void insertUpdate(DocumentEvent evt) {
                CSVExportParametersPanel.this.notifyChange();
            }

            public void removeUpdate(DocumentEvent evt) {
                CSVExportParametersPanel.this.notifyChange();
            }
        };
        this.jTextField1.getDocument().addDocumentListener(textfieldListener);
        this.jTextField2.getDocument().addDocumentListener(textfieldListener);
        this.applyI18n();
    }

    public void applyI18n() {
        this.jLabelTitle.setText(I18n.getString("CSVExportParametersPanel.jLabelTitle.text"));
        this.jLabelFielDelimiter.setText(I18n.getString("CSVExportParametersPanel.jLabelFielDelimiter.text"));
        this.jLabelRecordDelimiter.setText(I18n.getString("CSVExportParametersPanel.jLabelRecordDelimiter.text"));
        this.jLabelSpecialCharacters.setText(I18n.getString("CSVExportParametersPanel.jLabelSpecialCharacters.text"));
        this.jButtonReset.setText(I18n.getString("CSVExportParametersPanel.jButtonReset.text"));
    }

    private void initComponents() {
        this.jSeparator1 = new JSeparator();
        this.jLabelTitle = new JLabel();
        this.jLabelFielDelimiter = new JLabel();
        this.jTextField1 = new JTextField();
        this.jLabelRecordDelimiter = new JLabel();
        this.jTextField2 = new JTextField();
        this.jLabelSpecialCharacters = new JLabel();
        this.jButtonReset = new JButton();
        this.jLabelTitle.setFont(new Font("\uff2d\uff33 \uff30\u30b4\u30b7\u30c3\u30af", 1, 12));
        this.jLabelTitle.setText("CSV\u30a8\u30af\u30b9\u30dd\u30fc\u30c8\u30d1\u30e9\u30e1\u30fc\u30bf");
        this.jLabelFielDelimiter.setText("\u30d5\u30a3\u30fc\u30eb\u30c9\u533a\u5207\u308a");
        this.jLabelRecordDelimiter.setText("\u30ec\u30b3\u30fc\u30c9\u533a\u5207\u308a");
        this.jLabelSpecialCharacters.setText("<html>\u7279\u6b8a\u6587\u5b57\uff1a<br><b>\\n</b>\t\u30e9\u30a4\u30f3\u30d5\u30a3\u30fc\u30c9<br><b>\\r</b>\t\u30ad\u30e3\u30ea\u30c3\u30b8\u30ea\u30bf\u30fc\u30f3<br><b>\\t</b>\t\u30bf\u30d6<br><b>\\\\</b>\t\u5186");
        this.jButtonReset.setText("\u521d\u671f\u8a2d\u5b9a\u306b\u623b\u3059");
        this.jButtonReset.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CSVExportParametersPanel.this.jButtonResetActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addContainerGap(273, Short.MAX_VALUE)).add((Component)this.jSeparator1, -1, 425, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jLabelRecordDelimiter).add((Component)this.jLabelFielDelimiter)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(2, false).add(1, (Component)this.jTextField1).add(1, (Component)this.jTextField2, -1, 44, Short.MAX_VALUE)).addContainerGap(289, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabelSpecialCharacters, -2, -1, -2).addContainerGap(322, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jButtonReset).addContainerGap(300, Short.MAX_VALUE)));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabelTitle).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelFielDelimiter).add((Component)this.jTextField1, -2, -1, -2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelRecordDelimiter).add((Component)this.jTextField2, -2, -1, -2)).add(18, 18, 18).add((Component)this.jLabelSpecialCharacters, -2, -1, -2).add(18, 18, 18).add((Component)this.jButtonReset).addContainerGap(93, Short.MAX_VALUE)));
    }

    private void jButtonResetActionPerformed(ActionEvent evt) {
        this.jTextField1.setText(Misc.addSlashesString(JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.field.delimiter")));
        this.jTextField2.setText(Misc.addSlashesString(JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.record.delimiter")));
        this.notifyChange();
    }

    public void load() {
        this.setInit(true);
        Preferences pref = IReportManager.getPreferences();
        this.jTextField1.setText(Misc.addSlashesString(pref.get("net.sf.jasperreports.export.csv.field.delimiter", JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.field.delimiter"))));
        this.jTextField2.setText(Misc.addSlashesString(pref.get("net.sf.jasperreports.export.csv.record.delimiter", JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.record.delimiter"))));
        this.setInit(false);
    }

    public void store() {
        Preferences pref = IReportManager.getPreferences();
        pref.put("net.sf.jasperreports.export.csv.field.delimiter", Misc.removeSlashesString(this.jTextField1.getText()));
        pref.put("net.sf.jasperreports.export.csv.record.delimiter", Misc.removeSlashesString(this.jTextField2.getText()));
    }

    public boolean valid() {
        return true;
    }

    public String getDisplayName() {
        return I18n.getString("CSVExportParametersPanel.title");
    }
}

