/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrtx;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.jrtx.JRTXEditorSupport;
import com.jaspersoft.ireport.designer.jrtx.StylesChildren;
import com.jaspersoft.ireport.designer.jrtx.TemplateNode;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRTemplateReference;
import org.openide.ErrorManager;
import org.openide.actions.DeleteAction;
import org.openide.actions.RenameAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class TemplateReferenceNode
extends AbstractNode
implements PropertyChangeListener {
    private JRSimpleTemplate template;
    private JRTemplateReference reference = null;

    public TemplateReferenceNode(JRSimpleTemplate template, JRTemplateReference reference, Lookup doLkp) {
        super(Children.LEAF, (Lookup)new ProxyLookup(new Lookup[]{doLkp, Lookups.fixed((Object[])new Object[]{template, reference})}));
        this.template = template;
        this.reference = reference;
        this.init();
    }

    public String getName() {
        return this.getReference().getLocation();
    }

    public String getDisplayName() {
        return "Reference (" + this.getReference().getLocation() + ")";
    }

    private void init() {
        super.setName(this.getReference().getLocation());
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/jasperreports_jrtx.png");
    }

    public void destroy() throws IOException {
        this.getTemplate().removeIncludedTemplate(this.getReference());
        JRTXEditorSupport ed = (JRTXEditorSupport)((Object)this.getLookup().lookup(JRTXEditorSupport.class));
        if (ed != null) {
            ed.notifyModelChangeToTheView();
        }
        if (this.getParentNode() != null && this.getParentNode() instanceof TemplateNode) {
            ((StylesChildren)this.getParentNode().getChildren()).recalculateKeys();
        }
        super.destroy();
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new LocationProperty(this.getReference(), this.getTemplate(), this));
        sheet.put(set);
        return sheet;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return true;
    }

    public boolean canDestroy() {
        return true;
    }

    public Transferable clipboardCut() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)4);
    }

    public Transferable clipboardCopy() throws IOException {
        return NodeTransfer.transferable((Node)this, (int)1);
    }

    public Action[] getActions(boolean popup) {
        return new Action[]{SystemAction.get(RenameAction.class), null, SystemAction.get(DeleteAction.class)};
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        return tras;
    }

    public void setName(String s) {
        if (s.equals("")) {
            throw new IllegalArgumentException("Invalid location");
        }
        String oldName = this.getReference().getLocation();
        this.getReference().setLocation(s);
        ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getReference(), "Location", String.class, oldName, this.getReference().getLocation());
        this.propertyChange(new PropertyChangeEvent(this, "name", null, this.getReference().getLocation()));
    }

    public IllegalArgumentException annotateException(String msg) {
        IllegalArgumentException iae = new IllegalArgumentException(msg);
        ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
        return iae;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        JRTXEditorSupport ed = (JRTXEditorSupport)((Object)this.getLookup().lookup(JRTXEditorSupport.class));
        if (ed != null) {
            ed.notifyModelChangeToTheView();
        }
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("name")) {
            super.setName(this.getReference().getLocation());
            super.fireNameChange(null, super.getName());
            super.fireDisplayNameChange(null, this.getDisplayName());
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
    }

    public JRTemplateReference getReference() {
        return this.reference;
    }

    public void setReference(JRTemplateReference reference) {
        this.reference = reference;
    }

    public JRSimpleTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(JRSimpleTemplate template) {
        this.template = template;
    }

    public static final class LocationProperty
    extends PropertySupport.ReadWrite {
        private JRTemplateReference reference = null;
        JRSimpleTemplate template = null;
        TemplateReferenceNode node = null;

        public LocationProperty(JRTemplateReference reference, JRSimpleTemplate template, TemplateReferenceNode node) {
            super("name", String.class, "Location", "Location");
            this.setReference(reference);
            this.template = template;
            this.node = node;
            this.setValue("oneline", Boolean.TRUE);
        }

        public boolean canWrite() {
            return true;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.getReference().getLocation();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val == null || val.equals("")) {
                IllegalArgumentException iae = this.annotateException(I18n.getString("StyleNode.Exception.NameNotValid"));
                throw iae;
            }
            String s = val + "";
            String oldName = this.getReference().getLocation();
            this.getReference().setLocation(s);
            ObjectPropertyUndoableEdit opue = new ObjectPropertyUndoableEdit(this.getReference(), "Location", String.class, oldName, this.getReference().getLocation());
            IReportManager.getInstance().addUndoableEdit(opue);
            if (this.node != null) {
                this.node.propertyChange(new PropertyChangeEvent((Object)this, "name", null, this.getReference().getLocation()));
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }

        public JRTemplateReference getReference() {
            return this.reference;
        }

        public void setReference(JRTemplateReference reference) {
            this.reference = reference;
        }
    }
}

