/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.borders;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.utils.RoundGradientPaint;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.border.Border;
import net.sf.jasperreports.engine.design.JasperDesign;

public class ReportBorder
implements Border {
    private ReportObjectScene scene = null;
    private static Insets insets = new Insets(10, 10, 10, 10);

    public ReportBorder() {
        this(null);
    }

    public ReportBorder(ReportObjectScene scene) {
        this.setScene(scene);
    }

    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        JasperDesign jd;
        if (this.getScene() != null && IReportManager.getInstance().isBackgroundSeparated() && (jd = this.getScene().getJasperDesign()).getBackground() != null && jd.getBackground().getHeight() > 0) {
            int dh = ModelUtils.getDesignHeight(jd);
            int bdh = jd.getBackground().getHeight();
            bdh += jd.getTopMargin();
            dh -= (bdh += jd.getBottomMargin());
            this.paintShadowBorder(g, x, y, width, dh -= 20);
            this.paintShadowBorder(g, x, y + dh + 20, width, bdh + 20);
            return;
        }
        this.paintShadowBorder(g, x, y, width, height);
    }

    public void paintShadowBorder(Graphics g, int x, int y, int width, int height) {
        Rectangle2D.Double r = new Rectangle2D.Double(x + 10, y, width - 20, 10.0);
        GradientPaint gp = new GradientPaint(0.0f, y + 2, new Color(0, 0, 0, 0), 0.0f, (float)((double)y + 9.5), new Color(0, 0, 0, 60));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + 10, y + height - 10, width - 20, 10.0);
        gp = new GradientPaint(0.0f, (float)((RectangularShape)r).getY(), new Color(0, 0, 0, 60), 0.0f, (float)(((RectangularShape)r).getY() + 7.5), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x, y + 10, 10.0, height - 20);
        gp = new GradientPaint((float)(((RectangularShape)r).getX() + 2.0), 0.0f, new Color(0, 0, 0, 0), (float)(((RectangularShape)r).getX() + 9.5), 0.0f, new Color(0, 0, 0, 60));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + width - 10, y + 10, 10.0, height - 20);
        gp = new GradientPaint((float)((RectangularShape)r).getX(), 0.0f, new Color(0, 0, 0, 60), (float)(((RectangularShape)r).getX() + 7.5), 0.0f, new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(gp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x, y, 10.0, 10.0);
        RoundGradientPaint rgp = new RoundGradientPaint((float)x + 9.8f, (float)y + 9.8f, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.8f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + width - 10, y, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 0.5, ((RectangularShape)r).getY() + 9.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x + width - 10, y + height - 10, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 0.5, ((RectangularShape)r).getY() + 0.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
        r = new Rectangle2D.Double(x, y + height - 10, 10.0, 10.0);
        rgp = new RoundGradientPaint(((RectangularShape)r).getX() + 9.5, ((RectangularShape)r).getY() + 0.5, new Color(0, 0, 0, 60), new Point2D.Float(0.0f, 6.5f), new Color(0, 0, 0, 0));
        ((Graphics2D)g).setPaint(rgp);
        ((Graphics2D)g).fill(r);
    }

    public Insets getBorderInsets(Component c) {
        return insets;
    }

    public boolean isBorderOpaque() {
        return true;
    }

    public ReportObjectScene getScene() {
        return this.scene;
    }

    public void setScene(ReportObjectScene scene) {
        this.scene = scene;
    }
}

