/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.actions.CopyFormatAction;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.sheet.properties.AbstractProperty;
import com.jaspersoft.ireport.designer.undo.PropertyUndoableEdit;
import com.jaspersoft.ireport.locale.I18n;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class PasteFormatAction
extends NodeAction {
    public String getName() {
        return I18n.getString("PasteFormatAction.name");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        PropertyUndoableEdit undo = null;
        for (int k = 0; k < activatedNodes.length; ++k) {
            Node node = activatedNodes[k];
            Node.PropertySet[] sets = node.getPropertySets();
            for (int i = 0; i < CopyFormatAction.propertyNames.length; ++i) {
                Node.Property p;
                if (!CopyFormatAction.formattingValues.containsKey(CopyFormatAction.propertyNames[i]) || (p = ModelUtils.findProperty(sets, CopyFormatAction.propertyNames[i])) == null) continue;
                try {
                    Object oldValue = p.getValue();
                    Object newValue = CopyFormatAction.formattingValues.get(CopyFormatAction.propertyNames[i]);
                    if (newValue == null) continue;
                    p.setValue(newValue);
                    if (!(p instanceof AbstractProperty)) continue;
                    if (undo == null) {
                        undo = new PropertyUndoableEdit((AbstractProperty)p, oldValue, newValue);
                        continue;
                    }
                    undo.concatenate(new PropertyUndoableEdit((AbstractProperty)p, oldValue, newValue));
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        if (undo != null) {
            IReportManager.getInstance().addUndoableEdit(undo);
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        if (CopyFormatAction.formattingValues.isEmpty()) {
            return false;
        }
        if (activatedNodes == null || activatedNodes.length < 1) {
            return false;
        }
        for (int i = 0; i < activatedNodes.length; ++i) {
            if (activatedNodes[i] instanceof ElementNode) continue;
            return false;
        }
        return true;
    }
}

