/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.GroupNode;
import com.jaspersoft.ireport.locale.I18n;
import java.util.List;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class MoveGroupUpAction
extends NodeAction {
    private static MoveGroupUpAction instance = null;

    private MoveGroupUpAction() {
    }

    public String getName() {
        return I18n.getString("MoveGroupUpAction.Name.CTL_MoveGroupUpAction");
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        GroupNode groupNode = (GroupNode)activatedNodes[0];
        JRDesignGroup grp = groupNode.getGroup();
        JRDesignDataset dataset = groupNode.getDataset();
        List groups = dataset.getGroupsList();
        int index = groups.indexOf(grp);
        if (index > 0) {
            groups.remove(grp);
            groups.add(index - 1, grp);
        }
        dataset.getEventSupport().firePropertyChange("groups", null, null);
        IReportManager.getInstance().notifyReportChange();
    }

    protected boolean enable(Node[] activatedNodes) {
        if (activatedNodes == null || activatedNodes.length != 1) {
            return false;
        }
        if (activatedNodes[0] instanceof GroupNode && ((GroupNode)activatedNodes[0]).getGroup() != null) {
            GroupNode groupNode = (GroupNode)activatedNodes[0];
            JRDesignGroup grp = groupNode.getGroup();
            JRDesignDataset dataset = groupNode.getDataset();
            List groups = dataset.getGroupsList();
            int index = groups.indexOf(grp);
            return index != 0;
        }
        return false;
    }
}

