/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.sql.editor.ui.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.JMenuItem;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.api.sql.execute.SQLExecution;
import org.netbeans.modules.db.sql.editor.ui.actions.SQLExecutionBaseAction;
import org.openide.awt.Actions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;

public class RunSQLSelectionAction
extends SQLExecutionBaseAction {
    private static final Logger LOGGER = Logger.getLogger(RunSQLSelectionAction.class.getName());
    private static final boolean LOG = LOGGER.isLoggable(Level.FINE);

    protected void initialize() {
        this.putValue("Name", NbBundle.getMessage(RunSQLSelectionAction.class, (String)"LBL_RunSQLSelectionAction"));
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getDisplayName(SQLExecution sQLExecution) {
        if (sQLExecution == null || sQLExecution.isSelection()) {
            return NbBundle.getMessage(RunSQLSelectionAction.class, (String)"LBL_RunSelectionAction");
        }
        return NbBundle.getMessage(RunSQLSelectionAction.class, (String)"LBL_RunCurrentStatementAction");
    }

    public void actionPerformed(SQLExecution sQLExecution) {
        DatabaseConnection databaseConnection;
        if (LOG) {
            LOGGER.log(Level.FINE, "actionPerformed for " + sQLExecution);
        }
        if ((databaseConnection = sQLExecution.getDatabaseConnection()) != null) {
            sQLExecution.executeSelection();
        } else {
            RunSQLSelectionAction.notifyNoDatabaseConnection();
        }
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new SelectionContextAwareDelegate(this, lookup);
    }

    private static final class SelectionContextAwareDelegate
    extends SQLExecutionBaseAction.ContextAwareDelegate
    implements Presenter.Popup {
        public SelectionContextAwareDelegate(RunSQLSelectionAction runSQLSelectionAction, Lookup lookup) {
            super(runSQLSelectionAction, lookup);
        }

        public JMenuItem getPopupPresenter() {
            return new Actions.MenuItem((Action)this, false);
        }
    }
}

