/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DBConnection;
import org.netbeans.lib.ddl.DatabaseSpecificationFactory;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DatabaseOption;
import org.netbeans.modules.db.explorer.DbActionLoaderSupport;
import org.netbeans.modules.db.explorer.DbNodeLoader;
import org.netbeans.modules.db.explorer.DbNodeLoaderSupport;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.ConnectionOwnerOperations;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.RegisteredNodeInfo;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.nodes.Node;
import org.openide.nodes.NodeAdapter;
import org.openide.nodes.NodeEvent;
import org.openide.nodes.NodeListener;
import org.openide.options.SystemOption;
import org.openide.util.Exceptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RootNodeInfo
extends DatabaseNodeInfo
implements ConnectionOwnerOperations,
ChangeListener {
    static final long serialVersionUID = -8079386805046070315L;
    static RootNodeInfo rootInfo = null;
    private static DatabaseOption option = null;
    private Collection<DbNodeLoader> nodeLoaders;
    private final Map<Node, RegisteredNodeInfo> node2RegNodeInfo = new HashMap<Node, RegisteredNodeInfo>();
    private final Map<DatabaseConnection, ConnectionNodeInfo> conn2Info = new HashMap<DatabaseConnection, ConnectionNodeInfo>();
    private static Logger LOGGER = Logger.getLogger(RootNodeInfo.class.getName());

    public static RootNodeInfo getInstance() throws DatabaseException {
        if (rootInfo == null) {
            rootInfo = (RootNodeInfo)DatabaseNodeInfo.createNodeInfo(null, "root");
        }
        return rootInfo;
    }

    Map<DatabaseConnection, ConnectionNodeInfo> getConn2InfoCache() {
        return Collections.unmodifiableMap(this.conn2Info);
    }

    public RootNodeInfo() {
        try {
            SpecificationFactory specificationFactory = new SpecificationFactory();
            if (specificationFactory == null) {
                throw new Exception(RootNodeInfo.bundle().getString("EXC_NoSpecificationFactory"));
            }
            this.setSpecificationFactory(new SpecificationFactory());
            ConnectionList.getDefault().addConnectionListener(new ConnectionListener(){

                public void connectionsChanged() {
                    RootNodeInfo.this.stateChanged(new ChangeEvent(this));
                }
            });
            this.initDebugListening();
        }
        catch (Exception exception) {
            Exceptions.printStackTrace((Throwable)exception);
        }
    }

    private void initDebugListening() {
        final DatabaseSpecificationFactory databaseSpecificationFactory = this.getSpecificationFactory();
        if (option == null || databaseSpecificationFactory == null) {
            return;
        }
        option.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == null) {
                    databaseSpecificationFactory.setDebugMode(option.getDebugMode());
                    return;
                }
                if (propertyChangeEvent.getPropertyName().equals("debugMode")) {
                    databaseSpecificationFactory.setDebugMode((Boolean)propertyChangeEvent.getNewValue());
                }
            }
        });
        databaseSpecificationFactory.setDebugMode(option.getDebugMode());
    }

    public static synchronized DatabaseOption getOption() {
        if (option == null) {
            option = (DatabaseOption)SystemOption.findObject(DatabaseOption.class, (boolean)true);
        }
        return option;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initChildren(Vector vector) throws DatabaseException {
        try {
            FileObject fileObject;
            DataFolder dataFolder;
            DatabaseConnection databaseConnection;
            Object object;
            Object object2;
            vector.addAll(this.getRegisteredNodeInfos());
            DataFolder dataFolder2 = ConnectionList.getDefault().getConnections();
            for (int i = 0; i < ((DatabaseConnection[])dataFolder2).length; ++i) {
                object2 = dataFolder2[i];
                object = this.createConnectionNodeInfo((DatabaseConnection)object2);
                vector.add(object);
            }
            Repository repository = this.conn2Info;
            synchronized (repository) {
                object2 = this.conn2Info.entrySet().iterator();
                while (object2.hasNext()) {
                    object = (Map.Entry)object2.next();
                    databaseConnection = (DatabaseConnection)object.getKey();
                    boolean bl = false;
                    dataFolder = dataFolder2;
                    int n = ((DatabaseConnection[])dataFolder).length;
                    for (int i = 0; i < n; ++i) {
                        DatabaseConnection databaseConnection2 = dataFolder[i];
                        if (!databaseConnection.equals(databaseConnection2)) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    object2.remove();
                }
            }
            repository = Repository.getDefault();
            object2 = repository.getDefaultFileSystem();
            object = object2.getRoot();
            databaseConnection = object.getFileObject("Database");
            if (databaseConnection != null && (dataFolder = DataFolder.findFolder((FileObject)(fileObject = databaseConnection.getFileObject("Adaptors")))) != null) {
                vector.add(dataFolder.getNodeDelegate());
            }
        }
        catch (Exception exception) {
            throw new DatabaseException(exception);
        }
    }

    private List<RegisteredNodeInfo> getRegisteredNodeInfos() {
        boolean bl = false;
        if (this.nodeLoaders == null) {
            this.nodeLoaders = DbNodeLoaderSupport.getLoaders();
            bl = true;
        }
        ArrayList<RegisteredNodeInfo> arrayList = new ArrayList<RegisteredNodeInfo>();
        for (DbNodeLoader dbNodeLoader : this.nodeLoaders) {
            if (bl) {
                dbNodeLoader.addChangeListener(this);
            }
            for (Node node : dbNodeLoader.getAllNodes()) {
                arrayList.add(this.getRegisteredNodeInfo(node));
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisteredNodeInfo getRegisteredNodeInfo(Node node) {
        RegisteredNodeInfo registeredNodeInfo = null;
        Map<Node, RegisteredNodeInfo> map = this.node2RegNodeInfo;
        synchronized (map) {
            registeredNodeInfo = this.node2RegNodeInfo.get(node);
            if (registeredNodeInfo == null) {
                registeredNodeInfo = new RegisteredNodeInfo((DatabaseNodeInfo)this, node);
                this.node2RegNodeInfo.put(node, registeredNodeInfo);
                node.addNodeListener((NodeListener)new NodeAdapter(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void nodeDestroyed(NodeEvent nodeEvent) {
                        Node node = nodeEvent.getNode();
                        Map map = RootNodeInfo.this.node2RegNodeInfo;
                        synchronized (map) {
                            RootNodeInfo.this.node2RegNodeInfo.remove(node);
                        }
                    }
                });
            }
        }
        return registeredNodeInfo;
    }

    @Override
    public Vector getActions() {
        Vector vector = super.getActions();
        List<Action> list = DbActionLoaderSupport.getAllActions();
        Vector<Action> vector2 = new Vector<Action>();
        for (Action action : vector) {
            if (action == null) {
                vector2.addAll(list);
            }
            vector2.add(action);
        }
        return vector2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectionNodeInfo createConnectionNodeInfo(DatabaseConnection databaseConnection) throws DatabaseException {
        Map<DatabaseConnection, ConnectionNodeInfo> map = this.conn2Info;
        synchronized (map) {
            ConnectionNodeInfo connectionNodeInfo = this.conn2Info.get(databaseConnection);
            if (connectionNodeInfo != null) {
                return connectionNodeInfo;
            }
            connectionNodeInfo = (ConnectionNodeInfo)RootNodeInfo.createNodeInfo(this, "connection");
            connectionNodeInfo.setDatabaseConnection(databaseConnection);
            if (DatabaseConnection.test(databaseConnection.getConnection(), databaseConnection.getName())) {
                connectionNodeInfo.connect(databaseConnection);
            }
            this.conn2Info.put(databaseConnection, connectionNodeInfo);
            return connectionNodeInfo;
        }
    }

    @Override
    public void addConnection(DBConnection dBConnection) throws DatabaseException {
        DatabaseConnection databaseConnection = (DatabaseConnection)dBConnection;
        this.getChildren();
        if (ConnectionList.getDefault().contains(databaseConnection)) {
            throw new DatabaseException(RootNodeInfo.bundle().getString("EXC_ConnectionAlreadyExists"));
        }
        ConnectionList.getDefault().add(databaseConnection);
    }

    public void removeConnection(DatabaseConnection databaseConnection) throws DatabaseException {
        if (databaseConnection == null) {
            throw new NullPointerException();
        }
        ConnectionList.getDefault().remove(databaseConnection);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        try {
            this.refreshChildren();
        }
        catch (DatabaseException databaseException) {
            LOGGER.log(Level.INFO, null, databaseException);
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)databaseException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
    }

    @Override
    public void refreshChildren() throws DatabaseException {
        super.refreshChildren();
        this.addChild(RootNodeInfo.createNodeInfo(this, "driverlist"));
    }

    @Override
    public String getDisplayName() {
        return RootNodeInfo.bundle().getString("NDN_Databases");
    }

    @Override
    public String getShortDescription() {
        return RootNodeInfo.bundle().getString("ND_Root");
    }
}

