/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.lib.ddl.DDLException;
import org.netbeans.modules.db.ExceptionListener;
import org.netbeans.modules.db.explorer.ConnectionList;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DbUtilities;
import org.netbeans.modules.db.explorer.actions.DatabaseAction;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialog;
import org.netbeans.modules.db.explorer.dlg.ConnectionDialogMediator;
import org.netbeans.modules.db.explorer.dlg.NewConnectionPanel;
import org.netbeans.modules.db.explorer.dlg.SchemaPanel;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.infos.ConnectionNodeInfo;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;
import org.netbeans.modules.db.explorer.infos.DriverNodeInfo;
import org.netbeans.modules.db.explorer.infos.RootNodeInfo;
import org.netbeans.modules.db.explorer.nodes.RootNode;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.RequestProcessor;

public class ConnectUsingDriverAction
extends DatabaseAction {
    static final long serialVersionUID = 8245005834483564671L;
    private static final Logger LOGGER = Logger.getLogger(ConnectUsingDriverAction.class.getName());

    protected boolean enable(Node[] nodeArray) {
        return nodeArray != null && nodeArray.length == 1;
    }

    public void performAction(Node[] nodeArray) {
        String string;
        String string2;
        Node node = nodeArray[0];
        DriverNodeInfo driverNodeInfo = (DriverNodeInfo)node.getCookie(DatabaseNodeInfo.class);
        JDBCDriver jDBCDriver = driverNodeInfo.getJDBCDriver();
        if (jDBCDriver != null) {
            string2 = jDBCDriver.getName();
            string = jDBCDriver.getClassName();
        } else {
            string2 = driverNodeInfo.getName();
            string = driverNodeInfo.getURL();
        }
        new NewConnectionDialogDisplayer().showDialog(string2, string);
    }

    public static final class NewConnectionDialogDisplayer
    extends ConnectionDialogMediator {
        ConnectionDialog dlg;
        ConnectionNodeInfo cni;
        boolean advancedPanel = false;
        boolean okPressed = false;
        RequestProcessor.Task activeTask = null;
        private NewConnectionPanel basePanel = null;
        private SchemaPanel schemaPanel = null;
        private DatabaseConnection cinfo = null;

        public void showDialog(String string, String string2) {
            this.showDialog(string, string2, null, null, null);
        }

        public DatabaseConnection showDialog(JDBCDriver jDBCDriver, String string, String string2, String string3) {
            String string4 = jDBCDriver != null ? jDBCDriver.getName() : null;
            String string5 = jDBCDriver != null ? jDBCDriver.getClassName() : null;
            return this.showDialog(string4, string5, string, string2, string3);
        }

        public DatabaseConnection showDialog(String string, String string2, String string3, String string4, String string5) {
            JDBCDriver[] jDBCDriverArray;
            String string6 = null;
            if (null != string3 && null != string2) {
                jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers(string2);
                string6 = string2;
            } else {
                jDBCDriverArray = JDBCDriverManager.getDefault().getDrivers();
            }
            String string7 = null;
            String string8 = null;
            if (string == null || string2 == null) {
                for (int i = 0; i < jDBCDriverArray.length; ++i) {
                    if (!JDBCDriverSupport.isAvailable(jDBCDriverArray[i])) continue;
                    if (string7 == null) {
                        string7 = jDBCDriverArray[i].getName();
                        string8 = jDBCDriverArray[i].getClassName();
                    }
                    if (!"org.apache.derby.jdbc.ClientDriver".equals(jDBCDriverArray[i].getClassName())) continue;
                    string7 = jDBCDriverArray[i].getName();
                    string8 = jDBCDriverArray[i].getClassName();
                    break;
                }
            } else {
                string7 = string;
                string8 = string2;
            }
            this.cinfo = new DatabaseConnection();
            this.cinfo.setDriverName(string7);
            this.cinfo.setDriver(string8);
            if (string4 != null) {
                this.cinfo.setUser(string4);
            }
            if (string5 != null) {
                this.cinfo.setPassword(string5);
            }
            if (null != string3) {
                this.cinfo.setDatabase(string3);
            }
            this.basePanel = new NewConnectionPanel(this, string6, this.cinfo);
            this.schemaPanel = new SchemaPanel(this, this.cinfo);
            PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("argumentChanged")) {
                        NewConnectionDialogDisplayer.this.schemaPanel.setSchemas(new Vector(), "");
                        NewConnectionDialogDisplayer.this.schemaPanel.resetProgress();
                        try {
                            Connection connection = NewConnectionDialogDisplayer.this.cinfo.getConnection();
                            if (connection != null && !connection.isClosed()) {
                                connection.close();
                            }
                        }
                        catch (SQLException sQLException) {
                            LOGGER.log(Level.FINE, null, sQLException);
                        }
                    }
                }
            };
            this.basePanel.addPropertyChangeListener(propertyChangeListener);
            PropertyChangeListener propertyChangeListener2 = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals("connecting")) {
                        NewConnectionDialogDisplayer.this.fireConnectionStarted();
                    } else if (propertyChangeEvent.getPropertyName().equals("failed")) {
                        NewConnectionDialogDisplayer.this.setConnected(false);
                        NewConnectionDialogDisplayer.this.fireConnectionFailed();
                    } else {
                        if (propertyChangeEvent.getPropertyName().equals("connected")) {
                            NewConnectionDialogDisplayer.this.setConnected(true);
                            boolean bl = NewConnectionDialogDisplayer.this.retrieveSchemas(NewConnectionDialogDisplayer.this.schemaPanel, NewConnectionDialogDisplayer.this.cinfo, NewConnectionDialogDisplayer.this.cinfo.getUser());
                            NewConnectionDialogDisplayer.this.fireConnectionFinished();
                            if (bl) {
                                NewConnectionDialogDisplayer.this.cinfo.setSchema(NewConnectionDialogDisplayer.this.schemaPanel.getSchema());
                            } else if (!NewConnectionDialogDisplayer.this.schemaPanel.schemasAvailable()) {
                                try {
                                    ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(NewConnectionDialogDisplayer.this.cinfo);
                                }
                                catch (DatabaseException databaseException) {
                                    LOGGER.log(Level.INFO, null, databaseException);
                                    DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), databaseException.getMessage());
                                    NewConnectionDialogDisplayer.this.cinfo.setConnection(null);
                                }
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                    return;
                                }
                            }
                            NewConnectionDialogDisplayer.this.dlg.setSelectedComponent(NewConnectionDialogDisplayer.this.schemaPanel);
                            return;
                        }
                        NewConnectionDialogDisplayer.this.okPressed = false;
                    }
                }
            };
            ExceptionListener exceptionListener = new ExceptionListener(){

                public void exceptionOccurred(Exception exception) {
                    if (exception instanceof DDLException) {
                        Logger.getLogger("global").log(Level.INFO, null, exception.getCause());
                    } else {
                        Logger.getLogger("global").log(Level.INFO, null, exception);
                    }
                    String string = null;
                    if (exception instanceof ClassNotFoundException) {
                        string = MessageFormat.format(DatabaseAction.bundle().getString("EXC_ClassNotFound"), exception.getMessage());
                    } else {
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append(DbUtilities.formatError(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), exception.getMessage()));
                        if (exception instanceof DDLException && exception.getCause() instanceof SQLException) {
                            for (SQLException sQLException = ((SQLException)exception.getCause()).getNextException(); sQLException != null; sQLException = sQLException.getNextException()) {
                                stringBuffer.append("\n\n" + sQLException.getMessage());
                            }
                        }
                        string = stringBuffer.toString();
                    }
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 0));
                }
            };
            this.cinfo.addPropertyChangeListener(propertyChangeListener2);
            this.cinfo.addExceptionListener(exceptionListener);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                        NewConnectionDialogDisplayer.this.okPressed = true;
                        NewConnectionDialogDisplayer.this.basePanel.setConnectionInfo();
                        try {
                            if (NewConnectionDialogDisplayer.this.cinfo.getConnection() == null || NewConnectionDialogDisplayer.this.cinfo.getConnection().isClosed()) {
                                NewConnectionDialogDisplayer.this.activeTask = NewConnectionDialogDisplayer.this.cinfo.connectAsync();
                            } else {
                                NewConnectionDialogDisplayer.this.cinfo.setSchema(NewConnectionDialogDisplayer.this.schemaPanel.getSchema());
                                ((RootNodeInfo)RootNode.getInstance().getInfo()).addConnection(NewConnectionDialogDisplayer.this.cinfo);
                                if (NewConnectionDialogDisplayer.this.dlg != null) {
                                    NewConnectionDialogDisplayer.this.cancelActiveTask();
                                    NewConnectionDialogDisplayer.this.dlg.close();
                                }
                            }
                        }
                        catch (SQLException sQLException) {
                            NewConnectionDialogDisplayer.this.activeTask = NewConnectionDialogDisplayer.this.cinfo.connectAsync();
                        }
                        catch (DatabaseException databaseException) {
                            LOGGER.log(Level.INFO, null, databaseException);
                            DbUtilities.reportError(DatabaseAction.bundle().getString("ERR_UnableToAddConnection"), databaseException.getMessage());
                            NewConnectionDialogDisplayer.this.closeConnection();
                        }
                        return;
                    }
                    if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION && NewConnectionDialogDisplayer.this.dlg != null) {
                        NewConnectionDialogDisplayer.this.cancelActiveTask();
                    }
                }
            };
            ChangeListener changeListener = new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (((JTabbedPane)changeEvent.getSource()).getSelectedComponent().equals(NewConnectionDialogDisplayer.this.schemaPanel)) {
                        NewConnectionDialogDisplayer.this.advancedPanel = true;
                        NewConnectionDialogDisplayer.this.basePanel.setConnectionInfo();
                    } else {
                        NewConnectionDialogDisplayer.this.advancedPanel = false;
                    }
                }
            };
            this.dlg = new ConnectionDialog(this, this.basePanel, this.schemaPanel, this.basePanel.getTitle(), new HelpCtx("new_db_save_password"), actionListener, changeListener);
            this.basePanel.setWindow(this.dlg.getWindow());
            this.dlg.setVisible(true);
            this.cinfo.removeExceptionListener(exceptionListener);
            this.cinfo.removePropertyChangeListener(propertyChangeListener2);
            return ConnectionList.getDefault().getConnection(this.cinfo);
        }

        private void cancelActiveTask() {
            if (this.activeTask != null) {
                this.activeTask.cancel();
                this.activeTask = null;
            }
            this.basePanel.terminateProgress();
            this.schemaPanel.terminateProgress();
        }

        public void closeConnection() {
            Connection connection;
            if (this.cinfo != null && (connection = this.cinfo.getConnection()) != null) {
                try {
                    connection.close();
                    this.cinfo.setConnection(null);
                }
                catch (SQLException sQLException) {
                    this.cinfo.setConnection(null);
                }
            }
            this.setConnected(false);
        }

        protected RequestProcessor.Task retrieveSchemasAsync(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.activeTask = super.retrieveSchemasAsync(schemaPanel, databaseConnection, string);
            return this.activeTask;
        }

        protected boolean retrieveSchemas(SchemaPanel schemaPanel, DatabaseConnection databaseConnection, String string) {
            this.fireConnectionStep(DatabaseAction.bundle().getString("ConnectionProgress_Schemas"));
            Vector<String> vector = new Vector<String>();
            try {
                ResultSet resultSet = databaseConnection.getConnection().getMetaData().getSchemas();
                if (resultSet != null) {
                    while (resultSet.next()) {
                        vector.add(resultSet.getString(1).trim());
                    }
                }
            }
            catch (SQLException sQLException) {
                String string2 = MessageFormat.format(DatabaseAction.bundle().getString("ERR_UnableObtainSchemas"), sQLException.getMessage());
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string2, 0));
            }
            return schemaPanel.setSchemas(vector, string);
        }
    }
}

