/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.xam.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.xml.xam.dom.DocumentComponent;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChangeInfo {
    private Node changed;
    private Element parent;
    private DocumentComponent parentComponent;
    private boolean domainElement;
    private boolean added;
    private List<Element> rootToParent;
    private List<Node> otherNonDomainElementNodes;

    public ChangeInfo(Element element, Node node, boolean bl, List<Element> list, List<Node> list2) {
        this.parent = element;
        this.changed = node;
        this.domainElement = bl;
        if (!this.domainElement) {
            this.otherNonDomainElementNodes = list2;
        }
        this.rootToParent = list;
    }

    public Element getParent() {
        return this.parent;
    }

    public Node getChangedNode() {
        return this.changed;
    }

    public Element getChangedElement() {
        if (this.changed instanceof Element) {
            return (Element)this.changed;
        }
        return null;
    }

    public boolean isDomainElement() {
        return this.domainElement;
    }

    public void setDomainElement(boolean bl) {
        this.domainElement = bl;
    }

    public void setRootToParentPath(List<Element> list) {
        this.rootToParent = list;
    }

    public List<Element> getRootToParentPath() {
        return this.rootToParent;
    }

    public List<Element> getParentToRootPath() {
        ArrayList<Element> arrayList = new ArrayList<Element>(this.rootToParent);
        Collections.reverse(arrayList);
        return arrayList;
    }

    public boolean isDomainElementAdded() {
        return this.domainElement && this.added;
    }

    public void setAdded(boolean bl) {
        this.added = bl;
    }

    public boolean isAdded() {
        return this.added;
    }

    public void markParentAsChanged() {
        assert (this.parent != null);
        this.changed = this.parent;
        assert (this.rootToParent.size() > 1);
        assert (this.parent == this.rootToParent.get(this.rootToParent.size() - 1));
        this.rootToParent.remove(this.rootToParent.size() - 1);
        this.parent = this.rootToParent.get(this.rootToParent.size() - 1);
    }

    public void setParentComponent(DocumentComponent documentComponent) {
        this.parentComponent = documentComponent;
    }

    public DocumentComponent getParentComponent() {
        return this.parentComponent;
    }

    public List<Node> getOtherNonDomainElementNodes() {
        return this.otherNonDomainElementNodes;
    }

    public Node getActualChangedNode() {
        if (this.isDomainElement()) {
            return this.changed;
        }
        if (this.otherNonDomainElementNodes == null || this.otherNonDomainElementNodes.isEmpty()) {
            return this.changed;
        }
        return this.otherNonDomainElementNodes.get(this.otherNonDomainElementNodes.size() - 1);
    }

    public void markNonDomainChildAsChanged() {
        assert (this.otherNonDomainElementNodes != null && this.otherNonDomainElementNodes.size() > 0);
        assert (this.changed instanceof Element);
        this.rootToParent.add((Element)this.changed);
        this.parent = (Element)this.changed;
        this.changed = this.otherNonDomainElementNodes.remove(0);
        this.parentComponent = null;
    }

    public String toString() {
        String string;
        String string2 = string = this.added ? "ADD: " : "REMOVE: ";
        if (this.changed instanceof Element) {
            return string + ((Element)this.changed).getTagName();
        }
        if (this.changed instanceof Attr) {
            return string + ((Attr)this.changed).getNodeName() + "=" + ((Attr)this.changed).getNodeValue();
        }
        return string + this.changed.getNodeValue();
    }
}

