/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.ExceptionConverter;
import com.lowagie.text.Image;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseField;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.BasicPdfWriter;
import com.lowagie.text.pdf.ByteBuffer;
import com.lowagie.text.pdf.CMYKColor;
import com.lowagie.text.pdf.DocumentFont;
import com.lowagie.text.pdf.ExtendedColor;
import com.lowagie.text.pdf.FdfReader;
import com.lowagie.text.pdf.FdfWriter;
import com.lowagie.text.pdf.FontDetails;
import com.lowagie.text.pdf.GrayColor;
import com.lowagie.text.pdf.IntHashtable;
import com.lowagie.text.pdf.PRIndirectReference;
import com.lowagie.text.pdf.PRStream;
import com.lowagie.text.pdf.PRTokeniser;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfArray;
import com.lowagie.text.pdf.PdfBoolean;
import com.lowagie.text.pdf.PdfDate;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfEncodings;
import com.lowagie.text.pdf.PdfFormField;
import com.lowagie.text.pdf.PdfIndirectReference;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfNumber;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfPKCS7;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamperImp;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PushbuttonField;
import com.lowagie.text.pdf.RandomAccessFileOrArray;
import com.lowagie.text.pdf.TextField;
import com.lowagie.text.pdf.XfaForm;
import com.lowagie.text.pdf.XfdfReader;
import com.lowagie.text.pdf.codec.Base64;
import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.w3c.dom.Node;

public class AcroFields {
    PdfReader reader;
    BasicPdfWriter writer;
    HashMap fields;
    private int topFirst;
    private HashMap sigNames;
    private boolean append;
    public static final int DA_FONT = 0;
    public static final int DA_SIZE = 1;
    public static final int DA_COLOR = 2;
    private HashMap extensionFonts = new HashMap();
    private XfaForm xfa;
    public static final int FIELD_TYPE_NONE = 0;
    public static final int FIELD_TYPE_PUSHBUTTON = 1;
    public static final int FIELD_TYPE_CHECKBOX = 2;
    public static final int FIELD_TYPE_RADIOBUTTON = 3;
    public static final int FIELD_TYPE_TEXT = 4;
    public static final int FIELD_TYPE_LIST = 5;
    public static final int FIELD_TYPE_COMBO = 6;
    public static final int FIELD_TYPE_SIGNATURE = 7;
    private boolean lastWasString;
    private boolean generateAppearances = true;
    private HashMap localFonts = new HashMap();
    private float extraMarginLeft;
    private float extraMarginTop;
    private ArrayList substitutionFonts;
    private static final HashMap stdFieldFontNames = new HashMap();
    private int totalRevisions;
    private Map fieldCache;
    private static final PdfName[] buttonRemove;

    AcroFields(PdfReader pdfReader, BasicPdfWriter basicPdfWriter) {
        this.reader = pdfReader;
        this.writer = basicPdfWriter;
        try {
            this.xfa = new XfaForm(pdfReader);
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        if (basicPdfWriter instanceof PdfStamperImp) {
            this.append = ((PdfStamperImp)basicPdfWriter).isAppend();
        }
        this.fill();
    }

    void fill() {
        Object object;
        Object object2;
        PdfObject pdfObject;
        PdfDictionary pdfDictionary;
        PdfObject pdfObject2;
        this.fields = new HashMap();
        PdfDictionary pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObjectRelease(this.reader.getCatalog().get(PdfName.ACROFORM));
        if (pdfDictionary2 == null) {
            return;
        }
        PdfArray pdfArray = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary2.get(PdfName.FIELDS));
        if (pdfArray == null || pdfArray.size() == 0) {
            return;
        }
        for (int i = 1; i <= this.reader.getNumberOfPages(); ++i) {
            PdfDictionary pdfDictionary3 = this.reader.getPageNRelease(i);
            pdfObject2 = (PdfArray)PdfReader.getPdfObjectRelease(pdfDictionary3.get(PdfName.ANNOTS), pdfDictionary3);
            if (pdfObject2 == null) continue;
            for (int j = 0; j < ((PdfArray)pdfObject2).size(); ++j) {
                Object object3;
                pdfDictionary = ((PdfArray)pdfObject2).getAsDict(j);
                if (pdfDictionary == null) {
                    PdfReader.releaseLastXrefPartial(((PdfArray)pdfObject2).getAsIndirectObject(j));
                    continue;
                }
                if (!PdfName.WIDGET.equals(pdfDictionary.getAsName(PdfName.SUBTYPE))) {
                    PdfReader.releaseLastXrefPartial(((PdfArray)pdfObject2).getAsIndirectObject(j));
                    continue;
                }
                pdfObject = pdfDictionary;
                object2 = new PdfDictionary();
                ((PdfDictionary)object2).putAll(pdfDictionary);
                object = "";
                PdfDictionary pdfDictionary4 = null;
                PdfObject pdfObject3 = null;
                while (pdfDictionary != null) {
                    ((PdfDictionary)object2).mergeDifferent(pdfDictionary);
                    object3 = pdfDictionary.getAsString(PdfName.T);
                    if (object3 != null) {
                        object = ((PdfString)object3).toUnicodeString() + "." + (String)object;
                    }
                    if (pdfObject3 == null && pdfDictionary.get(PdfName.V) != null) {
                        pdfObject3 = PdfReader.getPdfObjectRelease(pdfDictionary.get(PdfName.V));
                    }
                    if (pdfDictionary4 == null && object3 != null) {
                        pdfDictionary4 = pdfDictionary;
                        if (pdfDictionary.get(PdfName.V) == null && pdfObject3 != null) {
                            pdfDictionary4.put(PdfName.V, pdfObject3);
                        }
                    }
                    pdfDictionary = pdfDictionary.getAsDict(PdfName.PARENT);
                }
                if (((String)object).length() > 0) {
                    object = ((String)object).substring(0, ((String)object).length() - 1);
                }
                if ((object3 = (Item)this.fields.get(object)) == null) {
                    object3 = new Item();
                    this.fields.put(object, object3);
                }
                if (pdfDictionary4 == null) {
                    ((Item)object3).addValue((PdfDictionary)pdfObject);
                } else {
                    ((Item)object3).addValue(pdfDictionary4);
                }
                ((Item)object3).addWidget((PdfDictionary)pdfObject);
                ((Item)object3).addWidgetRef(((PdfArray)pdfObject2).getAsIndirectObject(j));
                if (pdfDictionary2 != null) {
                    ((PdfDictionary)object2).mergeDifferent(pdfDictionary2);
                }
                ((Item)object3).addMerged((PdfDictionary)object2);
                ((Item)object3).addPage(i);
                ((Item)object3).addTabOrder(j);
            }
        }
        PdfNumber pdfNumber = pdfDictionary2.getAsNumber(PdfName.SIGFLAGS);
        if (pdfNumber == null || (pdfNumber.intValue() & 1) != 1) {
            return;
        }
        for (int i = 0; i < pdfArray.size(); ++i) {
            pdfObject2 = pdfArray.getAsDict(i);
            if (pdfObject2 == null) {
                PdfReader.releaseLastXrefPartial(pdfArray.getAsIndirectObject(i));
                continue;
            }
            if (!PdfName.WIDGET.equals(((PdfDictionary)pdfObject2).getAsName(PdfName.SUBTYPE))) {
                PdfReader.releaseLastXrefPartial(pdfArray.getAsIndirectObject(i));
                continue;
            }
            PdfArray pdfArray2 = (PdfArray)PdfReader.getPdfObjectRelease(((PdfDictionary)pdfObject2).get(PdfName.KIDS));
            if (pdfArray2 != null) continue;
            pdfDictionary = new PdfDictionary();
            pdfDictionary.putAll((PdfDictionary)pdfObject2);
            pdfObject = ((PdfDictionary)pdfObject2).getAsString(PdfName.T);
            if (pdfObject == null || this.fields.containsKey(object2 = ((PdfString)pdfObject).toUnicodeString())) continue;
            object = new Item();
            this.fields.put(object2, object);
            ((Item)object).addValue(pdfDictionary);
            ((Item)object).addWidget(pdfDictionary);
            ((Item)object).addWidgetRef(pdfArray.getAsIndirectObject(i));
            ((Item)object).addMerged(pdfDictionary);
            ((Item)object).addPage(-1);
            ((Item)object).addTabOrder(-1);
        }
    }

    public String[] getAppearanceStates(String string) {
        Object object;
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        PdfDictionary pdfDictionary = item.getValue(0);
        PdfString pdfString = pdfDictionary.getAsString(PdfName.OPT);
        if (pdfString != null) {
            hashMap.put(pdfString.toUnicodeString(), null);
        } else {
            PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.OPT);
            if (pdfArray != null) {
                for (int i = 0; i < pdfArray.size(); ++i) {
                    object = pdfArray.getAsString(i);
                    if (object == null) continue;
                    hashMap.put(((PdfString)object).toUnicodeString(), null);
                }
            }
        }
        for (int i = 0; i < item.size(); ++i) {
            PdfDictionary pdfDictionary2 = item.getWidget(i);
            if ((pdfDictionary2 = pdfDictionary2.getAsDict(PdfName.AP)) == null || (pdfDictionary2 = pdfDictionary2.getAsDict(PdfName.N)) == null) continue;
            object = pdfDictionary2.getKeys().iterator();
            while (object.hasNext()) {
                String string2 = PdfName.decodeName(((PdfName)object.next()).toString());
                hashMap.put(string2, null);
            }
        }
        String[] stringArray = new String[hashMap.size()];
        return hashMap.keySet().toArray(stringArray);
    }

    private String[] getListOption(String string, int n) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return null;
        }
        PdfArray pdfArray = item.getMerged(0).getAsArray(PdfName.OPT);
        if (pdfArray == null) {
            return null;
        }
        String[] stringArray = new String[pdfArray.size()];
        for (int i = 0; i < pdfArray.size(); ++i) {
            PdfObject pdfObject = pdfArray.getDirectObject(i);
            try {
                if (pdfObject.isArray()) {
                    pdfObject = ((PdfArray)pdfObject).getDirectObject(n);
                }
                if (pdfObject.isString()) {
                    stringArray[i] = ((PdfString)pdfObject).toUnicodeString();
                    continue;
                }
                stringArray[i] = pdfObject.toString();
                continue;
            }
            catch (Exception exception) {
                stringArray[i] = "";
            }
        }
        return stringArray;
    }

    public String[] getListOptionExport(String string) {
        return this.getListOption(string, 0);
    }

    public String[] getListOptionDisplay(String string) {
        return this.getListOption(string, 1);
    }

    public boolean setListOption(String string, String[] stringArray, String[] stringArray2) {
        if (stringArray == null && stringArray2 == null) {
            return false;
        }
        if (stringArray != null && stringArray2 != null && stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException("The export and the display array must have the same size.");
        }
        int n = this.getFieldType(string);
        if (n != 6 && n != 5) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        String[] stringArray3 = null;
        if (stringArray == null && stringArray2 != null) {
            stringArray3 = stringArray2;
        } else if (stringArray != null && stringArray2 == null) {
            stringArray3 = stringArray;
        }
        PdfArray pdfArray = new PdfArray();
        if (stringArray3 != null) {
            for (int i = 0; i < stringArray3.length; ++i) {
                pdfArray.add(new PdfString(stringArray3[i], "UnicodeBig"));
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                PdfArray pdfArray2 = new PdfArray();
                pdfArray2.add(new PdfString(stringArray[i], "UnicodeBig"));
                pdfArray2.add(new PdfString(stringArray2[i], "UnicodeBig"));
                pdfArray.add(pdfArray2);
            }
        }
        item.writeToAll(PdfName.OPT, pdfArray, 5);
        return true;
    }

    public int getFieldType(String string) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return 0;
        }
        PdfDictionary pdfDictionary = item.getMerged(0);
        PdfName pdfName = pdfDictionary.getAsName(PdfName.FT);
        if (pdfName == null) {
            return 0;
        }
        int n = 0;
        PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.FF);
        if (pdfNumber != null) {
            n = pdfNumber.intValue();
        }
        if (PdfName.BTN.equals(pdfName)) {
            if ((n & 0x10000) != 0) {
                return 1;
            }
            if ((n & 0x8000) != 0) {
                return 3;
            }
            return 2;
        }
        if (PdfName.TX.equals(pdfName)) {
            return 4;
        }
        if (PdfName.CH.equals(pdfName)) {
            if ((n & 0x20000) != 0) {
                return 6;
            }
            return 5;
        }
        if (PdfName.SIG.equals(pdfName)) {
            return 7;
        }
        return 0;
    }

    public void exportAsFdf(FdfWriter fdfWriter) {
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            String string = (String)entry.getKey();
            PdfObject pdfObject = item.getMerged(0).get(PdfName.V);
            if (pdfObject == null) continue;
            String string2 = this.getField(string);
            if (this.lastWasString) {
                fdfWriter.setFieldAsString(string, string2);
                continue;
            }
            fdfWriter.setFieldAsName(string, string2);
        }
    }

    public boolean renameField(String string, String string2) {
        int n;
        int n2 = string.lastIndexOf(46) + 1;
        if (n2 != (n = string2.lastIndexOf(46) + 1)) {
            return false;
        }
        if (!string.substring(0, n2).equals(string2.substring(0, n))) {
            return false;
        }
        if (this.fields.containsKey(string2)) {
            return false;
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        string2 = string2.substring(n);
        PdfString pdfString = new PdfString(string2, "UnicodeBig");
        item.writeToAll(PdfName.T, pdfString, 5);
        item.markUsed(this, 4);
        this.fields.remove(string);
        this.fields.put(string2, item);
        return true;
    }

    public static Object[] splitDAelements(String string) {
        try {
            PRTokeniser pRTokeniser = new PRTokeniser(PdfEncodings.convertToBytes(string, null));
            ArrayList<String> arrayList = new ArrayList<String>();
            Object[] objectArray = new Object[3];
            while (pRTokeniser.nextToken()) {
                if (pRTokeniser.getTokenType() == 4) continue;
                if (pRTokeniser.getTokenType() == 10) {
                    float f;
                    float f2;
                    float f3;
                    String string2 = pRTokeniser.getStringValue();
                    if (string2.equals("Tf")) {
                        if (arrayList.size() >= 2) {
                            objectArray[0] = arrayList.get(arrayList.size() - 2);
                            objectArray[1] = new Float((String)arrayList.get(arrayList.size() - 1));
                        }
                    } else if (string2.equals("g")) {
                        if (arrayList.size() >= 1 && (f3 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue()) != 0.0f) {
                            objectArray[2] = new GrayColor(f3);
                        }
                    } else if (string2.equals("rg")) {
                        if (arrayList.size() >= 3) {
                            f3 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                            f2 = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                            f = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                            objectArray[2] = new Color(f3, f2, f);
                        }
                    } else if (string2.equals("k") && arrayList.size() >= 4) {
                        f3 = new Float((String)arrayList.get(arrayList.size() - 4)).floatValue();
                        f2 = new Float((String)arrayList.get(arrayList.size() - 3)).floatValue();
                        f = new Float((String)arrayList.get(arrayList.size() - 2)).floatValue();
                        float f4 = new Float((String)arrayList.get(arrayList.size() - 1)).floatValue();
                        objectArray[2] = new CMYKColor(f3, f2, f, f4);
                    }
                    arrayList.clear();
                    continue;
                }
                arrayList.add(pRTokeniser.getStringValue());
            }
            return objectArray;
        }
        catch (IOException iOException) {
            throw new ExceptionConverter(iOException);
        }
    }

    public void decodeGenericDictionary(PdfDictionary pdfDictionary, BaseField baseField) throws IOException, DocumentException {
        String[] stringArray;
        Object object;
        Object object2;
        PdfObject pdfObject;
        Object object3;
        int n = 0;
        PdfString pdfString = pdfDictionary.getAsString(PdfName.DA);
        if (pdfString != null) {
            object3 = AcroFields.splitDAelements(pdfString.toUnicodeString());
            if (object3[1] != null) {
                baseField.setFontSize(((Float)object3[1]).floatValue());
            }
            if (object3[2] != null) {
                baseField.setTextColor((Color)object3[2]);
            }
            if (object3[0] != null && (pdfObject = pdfDictionary.getAsDict(PdfName.DR)) != null && (pdfObject = ((PdfDictionary)pdfObject).getAsDict(PdfName.FONT)) != null) {
                object2 = ((PdfDictionary)pdfObject).get(new PdfName((String)object3[0]));
                if (object2 != null && ((PdfObject)object2).type() == 10) {
                    PdfDictionary pdfDictionary2;
                    PdfDictionary pdfDictionary3;
                    object = (PRIndirectReference)object2;
                    stringArray = new DocumentFont((PRIndirectReference)object2);
                    baseField.setFont((BaseFont)stringArray);
                    Integer n2 = new Integer(((PdfIndirectReference)object).getNumber());
                    BaseFont baseFont = (BaseFont)this.extensionFonts.get(n2);
                    if (baseFont == null && !this.extensionFonts.containsKey(n2) && (pdfDictionary3 = (pdfDictionary2 = (PdfDictionary)PdfReader.getPdfObject((PdfObject)object2)).getAsDict(PdfName.FONTDESCRIPTOR)) != null) {
                        PRStream pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.FONTFILE2));
                        if (pRStream == null) {
                            pRStream = (PRStream)PdfReader.getPdfObject(pdfDictionary3.get(PdfName.FONTFILE3));
                        }
                        if (pRStream == null) {
                            this.extensionFonts.put(n2, null);
                        } else {
                            try {
                                baseFont = BaseFont.createFont("font.ttf", "Identity-H", true, false, PdfReader.getStreamBytes(pRStream), null);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            this.extensionFonts.put(n2, baseFont);
                        }
                    }
                    if (baseField instanceof TextField) {
                        ((TextField)baseField).setExtensionFont(baseFont);
                    }
                } else {
                    object = (BaseFont)this.localFonts.get(object3[0]);
                    if (object == null) {
                        stringArray = (String[])stdFieldFontNames.get(object3[0]);
                        if (stringArray != null) {
                            try {
                                String string = "winansi";
                                if (stringArray.length > 1) {
                                    string = stringArray[1];
                                }
                                object = BaseFont.createFont(stringArray[0], string, false);
                                baseField.setFont((BaseFont)object);
                            }
                            catch (Exception exception) {}
                        }
                    } else {
                        baseField.setFont((BaseFont)object);
                    }
                }
            }
        }
        if ((object3 = pdfDictionary.getAsDict(PdfName.MK)) != null) {
            pdfObject = ((PdfDictionary)object3).getAsArray(PdfName.BC);
            object2 = this.getMKColor((PdfArray)pdfObject);
            baseField.setBorderColor((Color)object2);
            if (object2 != null) {
                baseField.setBorderWidth(1.0f);
            }
            pdfObject = ((PdfDictionary)object3).getAsArray(PdfName.BG);
            baseField.setBackgroundColor(this.getMKColor((PdfArray)pdfObject));
            object = ((PdfDictionary)object3).getAsNumber(PdfName.R);
            if (object != null) {
                baseField.setRotation(((PdfNumber)object).intValue());
            }
        }
        pdfObject = pdfDictionary.getAsNumber(PdfName.F);
        n = 0;
        baseField.setVisibility(2);
        if (pdfObject != null) {
            n = ((PdfNumber)pdfObject).intValue();
            if ((n & 4) != 0 && (n & 2) != 0) {
                baseField.setVisibility(1);
            } else if ((n & 4) != 0 && (n & 0x20) != 0) {
                baseField.setVisibility(3);
            } else if ((n & 4) != 0) {
                baseField.setVisibility(0);
            }
        }
        pdfObject = pdfDictionary.getAsNumber(PdfName.FF);
        n = 0;
        if (pdfObject != null) {
            n = ((PdfNumber)pdfObject).intValue();
        }
        baseField.setOptions(n);
        if ((n & 0x1000000) != 0) {
            object2 = pdfDictionary.getAsNumber(PdfName.MAXLEN);
            int n3 = 0;
            if (object2 != null) {
                n3 = ((PdfNumber)object2).intValue();
            }
            baseField.setMaxCharacterLength(n3);
        }
        if ((pdfObject = pdfDictionary.getAsNumber(PdfName.Q)) != null) {
            if (((PdfNumber)pdfObject).intValue() == 1) {
                baseField.setAlignment(1);
            } else if (((PdfNumber)pdfObject).intValue() == 2) {
                baseField.setAlignment(2);
            }
        }
        if ((object2 = pdfDictionary.getAsDict(PdfName.BS)) != null) {
            PdfNumber pdfNumber = ((PdfDictionary)object2).getAsNumber(PdfName.W);
            if (pdfNumber != null) {
                baseField.setBorderWidth(pdfNumber.floatValue());
            }
            if (PdfName.D.equals(stringArray = ((PdfDictionary)object2).getAsName(PdfName.S))) {
                baseField.setBorderStyle(1);
            } else if (PdfName.B.equals(stringArray)) {
                baseField.setBorderStyle(2);
            } else if (PdfName.I.equals(stringArray)) {
                baseField.setBorderStyle(3);
            } else if (PdfName.U.equals(stringArray)) {
                baseField.setBorderStyle(4);
            }
        } else {
            PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.BORDER);
            if (pdfArray != null) {
                if (pdfArray.size() >= 3) {
                    baseField.setBorderWidth(pdfArray.getAsNumber(2).floatValue());
                }
                if (pdfArray.size() >= 4) {
                    baseField.setBorderStyle(1);
                }
            }
        }
    }

    PdfAppearance getAppearance(PdfDictionary pdfDictionary, String string, String string2) throws IOException, DocumentException {
        String[] stringArray;
        Object object;
        PdfObject pdfObject;
        this.topFirst = 0;
        TextField textField = null;
        if (this.fieldCache == null || !this.fieldCache.containsKey(string2)) {
            textField = new TextField(this.writer, null, null);
            textField.setExtraMargin(this.extraMarginLeft, this.extraMarginTop);
            textField.setBorderWidth(0.0f);
            textField.setSubstitutionFonts(this.substitutionFonts);
            this.decodeGenericDictionary(pdfDictionary, textField);
            pdfObject = pdfDictionary.getAsArray(PdfName.RECT);
            object = PdfReader.getNormalizedRectangle((PdfArray)pdfObject);
            if (textField.getRotation() == 90 || textField.getRotation() == 270) {
                object = ((Rectangle)object).rotate();
            }
            textField.setBox((Rectangle)object);
            if (this.fieldCache != null) {
                this.fieldCache.put(string2, textField);
            }
        } else {
            textField = (TextField)this.fieldCache.get(string2);
            textField.setWriter(this.writer);
        }
        pdfObject = pdfDictionary.getAsName(PdfName.FT);
        if (PdfName.TX.equals(pdfObject)) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (!PdfName.CH.equals(pdfObject)) {
            throw new DocumentException("An appearance was requested without a variable text field.");
        }
        object = pdfDictionary.getAsArray(PdfName.OPT);
        int n = 0;
        PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.FF);
        if (pdfNumber != null) {
            n = pdfNumber.intValue();
        }
        if ((n & 0x20000) != 0 && object == null) {
            textField.setText(string);
            return textField.getAppearance();
        }
        if (object != null) {
            int n2;
            stringArray = new String[((PdfArray)object).size()];
            String[] stringArray2 = new String[((PdfArray)object).size()];
            for (n2 = 0; n2 < ((PdfArray)object).size(); ++n2) {
                PdfObject pdfObject2 = ((PdfArray)object).getPdfObject(n2);
                if (pdfObject2.isString()) {
                    stringArray[n2] = stringArray2[n2] = ((PdfString)pdfObject2).toUnicodeString();
                    continue;
                }
                PdfArray pdfArray = (PdfArray)pdfObject2;
                stringArray2[n2] = pdfArray.getAsString(0).toUnicodeString();
                stringArray[n2] = pdfArray.getAsString(1).toUnicodeString();
            }
            if ((n & 0x20000) != 0) {
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (!string.equals(stringArray2[n2])) continue;
                    string = stringArray[n2];
                    break;
                }
                textField.setText(string);
                return textField.getAppearance();
            }
            n2 = 0;
            for (int i = 0; i < stringArray2.length; ++i) {
                if (!string.equals(stringArray2[i])) continue;
                n2 = i;
                break;
            }
            textField.setChoices(stringArray);
            textField.setChoiceExports(stringArray2);
            textField.setChoiceSelection(n2);
        }
        stringArray = textField.getListAppearance();
        this.topFirst = textField.getTopFirst();
        return stringArray;
    }

    Color getMKColor(PdfArray pdfArray) {
        if (pdfArray == null) {
            return null;
        }
        switch (pdfArray.size()) {
            case 1: {
                return new GrayColor(pdfArray.getAsNumber(0).floatValue());
            }
            case 3: {
                return new Color(ExtendedColor.normalize(pdfArray.getAsNumber(0).floatValue()), ExtendedColor.normalize(pdfArray.getAsNumber(1).floatValue()), ExtendedColor.normalize(pdfArray.getAsNumber(2).floatValue()));
            }
            case 4: {
                return new CMYKColor(pdfArray.getAsNumber(0).floatValue(), pdfArray.getAsNumber(1).floatValue(), pdfArray.getAsNumber(2).floatValue(), pdfArray.getAsNumber(3).floatValue());
            }
        }
        return null;
    }

    public String getField(String string) {
        if (this.xfa.isXfaPresent()) {
            if ((string = this.xfa.findFieldName(string, this)) == null) {
                return null;
            }
            string = XfaForm.Xml2Som.getShortName(string);
            return XfaForm.getNodeText(this.xfa.findDatasetsNode(string));
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return null;
        }
        this.lastWasString = false;
        PdfDictionary pdfDictionary = item.getMerged(0);
        PdfObject pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.V));
        if (pdfObject == null) {
            return "";
        }
        if (pdfObject instanceof PRStream) {
            try {
                byte[] byArray = PdfReader.getStreamBytes((PRStream)pdfObject);
                return new String(byArray);
            }
            catch (IOException iOException) {
                throw new ExceptionConverter(iOException);
            }
        }
        PdfName pdfName = pdfDictionary.getAsName(PdfName.FT);
        if (PdfName.BTN.equals(pdfName)) {
            PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.FF);
            int n = 0;
            if (pdfNumber != null) {
                n = pdfNumber.intValue();
            }
            if ((n & 0x10000) != 0) {
                return "";
            }
            String string2 = "";
            if (pdfObject instanceof PdfName) {
                string2 = PdfName.decodeName(pdfObject.toString());
            } else if (pdfObject instanceof PdfString) {
                string2 = ((PdfString)pdfObject).toUnicodeString();
            }
            PdfArray pdfArray = item.getValue(0).getAsArray(PdfName.OPT);
            if (pdfArray != null) {
                int n2 = 0;
                try {
                    n2 = Integer.parseInt(string2);
                    PdfString pdfString = pdfArray.getAsString(n2);
                    string2 = pdfString.toUnicodeString();
                    this.lastWasString = true;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return string2;
        }
        if (pdfObject instanceof PdfString) {
            this.lastWasString = true;
            return ((PdfString)pdfObject).toUnicodeString();
        }
        if (pdfObject instanceof PdfName) {
            return PdfName.decodeName(pdfObject.toString());
        }
        return "";
    }

    public String[] getListSelection(String string) {
        String string2 = this.getField(string);
        String[] stringArray = string2 == null ? new String[]{} : new String[]{string2};
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return stringArray;
        }
        PdfArray pdfArray = item.getMerged(0).getAsArray(PdfName.I);
        if (pdfArray == null) {
            return stringArray;
        }
        stringArray = new String[pdfArray.size()];
        String[] stringArray2 = this.getListOptionExport(string);
        int n = 0;
        ListIterator listIterator = pdfArray.listIterator();
        while (listIterator.hasNext()) {
            PdfNumber pdfNumber = (PdfNumber)listIterator.next();
            stringArray[n++] = stringArray2[pdfNumber.intValue()];
        }
        return stringArray;
    }

    public boolean setFieldProperty(String string, String string2, Object object, int[] nArray) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        try {
            Item item = (Item)this.fields.get(string);
            if (item == null) {
                return false;
            }
            InstHit instHit = new InstHit(nArray);
            if (string2.equalsIgnoreCase("textfont")) {
                for (int i = 0; i < item.size(); ++i) {
                    Object object2;
                    PdfDictionary pdfDictionary;
                    if (!instHit.isHit(i)) continue;
                    PdfDictionary pdfDictionary2 = item.getMerged(i);
                    PdfString pdfString = pdfDictionary2.getAsString(PdfName.DA);
                    PdfDictionary pdfDictionary3 = pdfDictionary2.getAsDict(PdfName.DR);
                    if (pdfString == null || pdfDictionary3 == null) continue;
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] == null) continue;
                    BaseFont baseFont = (BaseFont)object;
                    PdfName pdfName = (PdfName)PdfAppearance.stdFieldFontNames.get(baseFont.getPostscriptFontName());
                    if (pdfName == null) {
                        pdfName = new PdfName(baseFont.getPostscriptFontName());
                    }
                    if ((pdfDictionary = pdfDictionary3.getAsDict(PdfName.FONT)) == null) {
                        pdfDictionary = new PdfDictionary();
                        pdfDictionary3.put(PdfName.FONT, pdfDictionary);
                    }
                    PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfDictionary.get(pdfName);
                    PdfDictionary pdfDictionary4 = this.reader.getCatalog().getAsDict(PdfName.ACROFORM);
                    this.markUsed(pdfDictionary4);
                    pdfDictionary3 = pdfDictionary4.getAsDict(PdfName.DR);
                    if (pdfDictionary3 == null) {
                        pdfDictionary3 = new PdfDictionary();
                        pdfDictionary4.put(PdfName.DR, pdfDictionary3);
                    }
                    this.markUsed(pdfDictionary3);
                    PdfDictionary pdfDictionary5 = pdfDictionary3.getAsDict(PdfName.FONT);
                    if (pdfDictionary5 == null) {
                        pdfDictionary5 = new PdfDictionary();
                        pdfDictionary3.put(PdfName.FONT, pdfDictionary5);
                    }
                    this.markUsed(pdfDictionary5);
                    PdfIndirectReference pdfIndirectReference2 = (PdfIndirectReference)pdfDictionary5.get(pdfName);
                    if (pdfIndirectReference2 != null) {
                        if (pdfIndirectReference == null) {
                            pdfDictionary.put(pdfName, pdfIndirectReference2);
                        }
                    } else if (pdfIndirectReference == null) {
                        if (baseFont.getFontType() == 4) {
                            object2 = new FontDetails(null, ((DocumentFont)baseFont).getIndirectReference(), baseFont);
                        } else {
                            baseFont.setSubset(false);
                            object2 = this.writer.addSimple(baseFont);
                            this.localFonts.put(pdfName.toString().substring(1), baseFont);
                        }
                        pdfDictionary5.put(pdfName, ((FontDetails)object2).getIndirectReference());
                        pdfDictionary.put(pdfName, ((FontDetails)object2).getIndirectReference());
                    }
                    object2 = pdfAppearance.getInternalBuffer();
                    ((ByteBuffer)object2).append(pdfName.getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                    if (objectArray[2] != null) {
                        pdfAppearance.setColorFill((Color)objectArray[2]);
                    }
                    PdfString pdfString2 = new PdfString(pdfAppearance.toString());
                    item.getMerged(i).put(PdfName.DA, pdfString2);
                    item.getWidget(i).put(PdfName.DA, pdfString2);
                    this.markUsed(item.getWidget(i));
                }
            } else if (string2.equalsIgnoreCase("textcolor")) {
                for (int i = 0; i < item.size(); ++i) {
                    PdfDictionary pdfDictionary;
                    PdfString pdfString;
                    if (!instHit.isHit(i) || (pdfString = (pdfDictionary = item.getMerged(i)).getAsString(PdfName.DA)) == null) continue;
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] == null) continue;
                    ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                    byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)objectArray[1]).floatValue()).append(" Tf ");
                    pdfAppearance.setColorFill((Color)object);
                    PdfString pdfString3 = new PdfString(pdfAppearance.toString());
                    item.getMerged(i).put(PdfName.DA, pdfString3);
                    item.getWidget(i).put(PdfName.DA, pdfString3);
                    this.markUsed(item.getWidget(i));
                }
            } else if (string2.equalsIgnoreCase("textsize")) {
                for (int i = 0; i < item.size(); ++i) {
                    PdfDictionary pdfDictionary;
                    PdfString pdfString;
                    if (!instHit.isHit(i) || (pdfString = (pdfDictionary = item.getMerged(i)).getAsString(PdfName.DA)) == null) continue;
                    Object[] objectArray = AcroFields.splitDAelements(pdfString.toUnicodeString());
                    PdfAppearance pdfAppearance = new PdfAppearance();
                    if (objectArray[0] == null) continue;
                    ByteBuffer byteBuffer = pdfAppearance.getInternalBuffer();
                    byteBuffer.append(new PdfName((String)objectArray[0]).getBytes()).append(' ').append(((Float)object).floatValue()).append(" Tf ");
                    if (objectArray[2] != null) {
                        pdfAppearance.setColorFill((Color)objectArray[2]);
                    }
                    PdfString pdfString4 = new PdfString(pdfAppearance.toString());
                    item.getMerged(i).put(PdfName.DA, pdfString4);
                    item.getWidget(i).put(PdfName.DA, pdfString4);
                    this.markUsed(item.getWidget(i));
                }
            } else if (string2.equalsIgnoreCase("bgcolor") || string2.equalsIgnoreCase("bordercolor")) {
                PdfName pdfName = string2.equalsIgnoreCase("bgcolor") ? PdfName.BG : PdfName.BC;
                for (int i = 0; i < item.size(); ++i) {
                    if (!instHit.isHit(i)) continue;
                    PdfDictionary pdfDictionary = item.getMerged(i);
                    PdfDictionary pdfDictionary6 = pdfDictionary.getAsDict(PdfName.MK);
                    if (pdfDictionary6 == null) {
                        if (object == null) {
                            return true;
                        }
                        pdfDictionary6 = new PdfDictionary();
                        item.getMerged(i).put(PdfName.MK, pdfDictionary6);
                        item.getWidget(i).put(PdfName.MK, pdfDictionary6);
                        this.markUsed(item.getWidget(i));
                    } else {
                        this.markUsed(pdfDictionary6);
                    }
                    if (object == null) {
                        pdfDictionary6.remove(pdfName);
                        continue;
                    }
                    pdfDictionary6.put(pdfName, PdfFormField.getMKColor((Color)object));
                }
            } else {
                return false;
            }
            return true;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean setFieldProperty(String string, String string2, int n, int[] nArray) {
        if (this.writer == null) {
            throw new RuntimeException("This AcroFields instance is read-only.");
        }
        Item item = (Item)this.fields.get(string);
        if (item == null) {
            return false;
        }
        InstHit instHit = new InstHit(nArray);
        if (string2.equalsIgnoreCase("flags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            for (int i = 0; i < item.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                item.getMerged(i).put(PdfName.F, pdfNumber);
                item.getWidget(i).put(PdfName.F, pdfNumber);
                this.markUsed(item.getWidget(i));
            }
        } else if (string2.equalsIgnoreCase("setflags")) {
            for (int i = 0; i < item.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfNumber pdfNumber = item.getWidget(i).getAsNumber(PdfName.F);
                int n2 = 0;
                if (pdfNumber != null) {
                    n2 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n2 | n);
                item.getMerged(i).put(PdfName.F, pdfNumber);
                item.getWidget(i).put(PdfName.F, pdfNumber);
                this.markUsed(item.getWidget(i));
            }
        } else if (string2.equalsIgnoreCase("clrflags")) {
            for (int i = 0; i < item.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfDictionary pdfDictionary = item.getWidget(i);
                PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.F);
                int n3 = 0;
                if (pdfNumber != null) {
                    n3 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n3 & ~n);
                item.getMerged(i).put(PdfName.F, pdfNumber);
                pdfDictionary.put(PdfName.F, pdfNumber);
                this.markUsed(pdfDictionary);
            }
        } else if (string2.equalsIgnoreCase("fflags")) {
            PdfNumber pdfNumber = new PdfNumber(n);
            for (int i = 0; i < item.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                item.getMerged(i).put(PdfName.FF, pdfNumber);
                item.getValue(i).put(PdfName.FF, pdfNumber);
                this.markUsed(item.getValue(i));
            }
        } else if (string2.equalsIgnoreCase("setfflags")) {
            for (int i = 0; i < item.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfDictionary pdfDictionary = item.getValue(i);
                PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.FF);
                int n4 = 0;
                if (pdfNumber != null) {
                    n4 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n4 | n);
                item.getMerged(i).put(PdfName.FF, pdfNumber);
                pdfDictionary.put(PdfName.FF, pdfNumber);
                this.markUsed(pdfDictionary);
            }
        } else if (string2.equalsIgnoreCase("clrfflags")) {
            for (int i = 0; i < item.size(); ++i) {
                if (!instHit.isHit(i)) continue;
                PdfDictionary pdfDictionary = item.getValue(i);
                PdfNumber pdfNumber = pdfDictionary.getAsNumber(PdfName.FF);
                int n5 = 0;
                if (pdfNumber != null) {
                    n5 = pdfNumber.intValue();
                }
                pdfNumber = new PdfNumber(n5 & ~n);
                item.getMerged(i).put(PdfName.FF, pdfNumber);
                pdfDictionary.put(PdfName.FF, pdfNumber);
                this.markUsed(pdfDictionary);
            }
        } else {
            return false;
        }
        return true;
    }

    public void mergeXfaData(Node node) throws IOException, DocumentException {
        XfaForm.Xml2SomDatasets xml2SomDatasets = new XfaForm.Xml2SomDatasets(node);
        Iterator iterator = xml2SomDatasets.getOrder().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = XfaForm.getNodeText((Node)xml2SomDatasets.getName2Node().get(string));
            this.setField(string, string2);
        }
    }

    public void setFields(FdfReader fdfReader) throws IOException, DocumentException {
        HashMap hashMap = fdfReader.getFields();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = fdfReader.getFieldValue(string);
            if (string2 == null) continue;
            this.setField(string, string2);
        }
    }

    public void setFields(XfdfReader xfdfReader) throws IOException, DocumentException {
        HashMap hashMap = xfdfReader.getFields();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            List list;
            String string = (String)iterator.next();
            String string2 = xfdfReader.getFieldValue(string);
            if (string2 != null) {
                this.setField(string, string2);
            }
            if ((list = xfdfReader.getListValues(string)) == null) continue;
            this.setListSelection(string2, list.toArray(new String[list.size()]));
        }
    }

    public boolean regenerateField(String string) throws IOException, DocumentException {
        String string2 = this.getField(string);
        return this.setField(string, string2, string2);
    }

    public boolean setField(String string, String string2) throws IOException, DocumentException {
        return this.setField(string, string2, null);
    }

    public boolean setField(String string, String string2, String string3) throws IOException, DocumentException {
        int n;
        PdfObject pdfObject;
        Object object;
        Object object2;
        if (this.writer == null) {
            throw new DocumentException("This AcroFields instance is read-only.");
        }
        if (this.xfa.isXfaPresent()) {
            if ((string = this.xfa.findFieldName(string, this)) == null) {
                return false;
            }
            object2 = XfaForm.Xml2Som.getShortName(string);
            object = this.xfa.findDatasetsNode((String)object2);
            if (object == null) {
                object = this.xfa.getDatasetsSom().insertNode(this.xfa.getDatasetsNode(), (String)object2);
            }
            this.xfa.setNodeText((Node)object, string2);
        }
        if ((object2 = (Item)this.fields.get(string)) == null) {
            return false;
        }
        object = ((Item)object2).getMerged(0);
        PdfName pdfName = ((PdfDictionary)object).getAsName(PdfName.FT);
        if (PdfName.TX.equals(pdfName)) {
            pdfObject = ((PdfDictionary)object).getAsNumber(PdfName.MAXLEN);
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if (n > 0) {
                string2 = string2.substring(0, Math.min(n, string2.length()));
            }
        }
        if (string3 == null) {
            string3 = string2;
        }
        if (PdfName.TX.equals(pdfName) || PdfName.CH.equals(pdfName)) {
            pdfObject = new PdfString(string2, "UnicodeBig");
            for (n = 0; n < ((Item)object2).size(); ++n) {
                PdfDictionary pdfDictionary = ((Item)object2).getValue(n);
                pdfDictionary.put(PdfName.V, pdfObject);
                pdfDictionary.remove(PdfName.I);
                this.markUsed(pdfDictionary);
                object = ((Item)object2).getMerged(n);
                ((PdfDictionary)object).remove(PdfName.I);
                ((PdfDictionary)object).put(PdfName.V, pdfObject);
                PdfDictionary pdfDictionary2 = ((Item)object2).getWidget(n);
                if (this.generateAppearances) {
                    PdfObject pdfObject2;
                    PdfAppearance pdfAppearance = this.getAppearance((PdfDictionary)object, string3, string);
                    if (PdfName.CH.equals(pdfName)) {
                        pdfObject2 = new PdfNumber(this.topFirst);
                        pdfDictionary2.put(PdfName.TI, pdfObject2);
                        ((PdfDictionary)object).put(PdfName.TI, pdfObject2);
                    }
                    if ((pdfObject2 = pdfDictionary2.getAsDict(PdfName.AP)) == null) {
                        pdfObject2 = new PdfDictionary();
                        pdfDictionary2.put(PdfName.AP, pdfObject2);
                        ((PdfDictionary)object).put(PdfName.AP, pdfObject2);
                    }
                    ((PdfDictionary)pdfObject2).put(PdfName.N, pdfAppearance.getIndirectReference());
                    this.writer.releaseTemplate(pdfAppearance);
                } else {
                    pdfDictionary2.remove(PdfName.AP);
                    ((PdfDictionary)object).remove(PdfName.AP);
                }
                this.markUsed(pdfDictionary2);
            }
            return true;
        }
        if (PdfName.BTN.equals(pdfName)) {
            PdfName pdfName2;
            PdfObject pdfObject3;
            int n2;
            pdfObject = ((Item)object2).getMerged(0).getAsNumber(PdfName.FF);
            n = 0;
            if (pdfObject != null) {
                n = ((PdfNumber)pdfObject).intValue();
            }
            if ((n & 0x10000) != 0) {
                Image image;
                try {
                    image = Image.getInstance(Base64.decode(string2));
                }
                catch (Exception exception) {
                    return false;
                }
                PushbuttonField pushbuttonField = this.getNewPushbuttonFromField(string);
                pushbuttonField.setImage(image);
                this.replacePushbuttonField(string, pushbuttonField.getField());
                return true;
            }
            PdfName pdfName3 = new PdfName(string2);
            ArrayList<String> arrayList = new ArrayList<String>();
            PdfArray pdfArray = ((Item)object2).getValue(0).getAsArray(PdfName.OPT);
            if (pdfArray != null) {
                for (n2 = 0; n2 < pdfArray.size(); ++n2) {
                    pdfObject3 = pdfArray.getAsString(n2);
                    if (pdfObject3 != null) {
                        arrayList.add(pdfObject3.toUnicodeString());
                        continue;
                    }
                    arrayList.add(null);
                }
            }
            n2 = arrayList.indexOf(string2);
            pdfObject3 = null;
            if (n2 >= 0) {
                pdfObject3 = new PdfName(String.valueOf(n2));
                pdfName2 = pdfObject3;
            } else {
                pdfName2 = pdfName3;
            }
            for (int i = 0; i < ((Item)object2).size(); ++i) {
                object = ((Item)object2).getMerged(i);
                PdfDictionary pdfDictionary = ((Item)object2).getWidget(i);
                PdfDictionary pdfDictionary3 = ((Item)object2).getValue(i);
                this.markUsed(((Item)object2).getValue(i));
                if (pdfObject3 != null) {
                    PdfString pdfString = new PdfString(string2, "UnicodeBig");
                    pdfDictionary3.put(PdfName.V, pdfString);
                    ((PdfDictionary)object).put(PdfName.V, pdfString);
                } else {
                    pdfDictionary3.put(PdfName.V, pdfName3);
                    ((PdfDictionary)object).put(PdfName.V, pdfName3);
                }
                this.markUsed(pdfDictionary);
                if (this.isInAP(pdfDictionary, pdfName2)) {
                    ((PdfDictionary)object).put(PdfName.AS, pdfName2);
                    pdfDictionary.put(PdfName.AS, pdfName2);
                    continue;
                }
                ((PdfDictionary)object).put(PdfName.AS, PdfName.Off);
                pdfDictionary.put(PdfName.AS, PdfName.Off);
            }
            return true;
        }
        return false;
    }

    public boolean setListSelection(String string, String[] stringArray) throws IOException, DocumentException {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return false;
        }
        PdfName pdfName = item.getMerged(0).getAsName(PdfName.FT);
        if (!PdfName.CH.equals(pdfName)) {
            return false;
        }
        String[] stringArray2 = this.getListOptionExport(string);
        PdfArray pdfArray = new PdfArray();
        for (int i = 0; i < stringArray.length; ++i) {
            for (int j = 0; j < stringArray2.length; ++j) {
                if (!stringArray2[j].equals(stringArray[i])) continue;
                pdfArray.add(new PdfNumber(j));
            }
        }
        item.writeToAll(PdfName.I, pdfArray, 5);
        item.writeToAll(PdfName.V, null, 5);
        item.writeToAll(PdfName.AP, null, 3);
        item.markUsed(this, 6);
        return true;
    }

    boolean isInAP(PdfDictionary pdfDictionary, PdfName pdfName) {
        PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.AP);
        if (pdfDictionary2 == null) {
            return false;
        }
        PdfDictionary pdfDictionary3 = pdfDictionary2.getAsDict(PdfName.N);
        return pdfDictionary3 != null && pdfDictionary3.get(pdfName) != null;
    }

    public HashMap getFields() {
        return this.fields;
    }

    public Item getFieldItem(String string) {
        if (this.xfa.isXfaPresent() && (string = this.xfa.findFieldName(string, this)) == null) {
            return null;
        }
        return (Item)this.fields.get(string);
    }

    public String getTranslatedFieldName(String string) {
        String string2;
        if (this.xfa.isXfaPresent() && (string2 = this.xfa.findFieldName(string, this)) != null) {
            string = string2;
        }
        return string;
    }

    public float[] getFieldPositions(String string) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return null;
        }
        float[] fArray = new float[item.size() * 5];
        int n = 0;
        for (int i = 0; i < item.size(); ++i) {
            try {
                PdfDictionary pdfDictionary = item.getWidget(i);
                PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.RECT);
                if (pdfArray == null) continue;
                Rectangle rectangle = PdfReader.getNormalizedRectangle(pdfArray);
                int n2 = item.getPage(i);
                int n3 = this.reader.getPageRotation(n2);
                fArray[n++] = n2;
                if (n3 != 0) {
                    Rectangle rectangle2 = this.reader.getPageSize(n2);
                    switch (n3) {
                        case 270: {
                            rectangle = new Rectangle(rectangle2.getTop() - rectangle.getBottom(), rectangle.getLeft(), rectangle2.getTop() - rectangle.getTop(), rectangle.getRight());
                            break;
                        }
                        case 180: {
                            rectangle = new Rectangle(rectangle2.getRight() - rectangle.getLeft(), rectangle2.getTop() - rectangle.getBottom(), rectangle2.getRight() - rectangle.getRight(), rectangle2.getTop() - rectangle.getTop());
                            break;
                        }
                        case 90: {
                            rectangle = new Rectangle(rectangle.getBottom(), rectangle2.getRight() - rectangle.getLeft(), rectangle.getTop(), rectangle2.getRight() - rectangle.getRight());
                        }
                    }
                    rectangle.normalize();
                }
                fArray[n++] = rectangle.getLeft();
                fArray[n++] = rectangle.getBottom();
                fArray[n++] = rectangle.getRight();
                fArray[n++] = rectangle.getTop();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (n < fArray.length) {
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            return fArray2;
        }
        return fArray;
    }

    private int removeRefFromArray(PdfArray pdfArray, PdfObject pdfObject) {
        if (pdfObject == null || !pdfObject.isIndirect()) {
            return pdfArray.size();
        }
        PdfIndirectReference pdfIndirectReference = (PdfIndirectReference)pdfObject;
        for (int i = 0; i < pdfArray.size(); ++i) {
            PdfObject pdfObject2 = pdfArray.getPdfObject(i);
            if (!pdfObject2.isIndirect() || ((PdfIndirectReference)pdfObject2).getNumber() != pdfIndirectReference.getNumber()) continue;
            pdfArray.remove(i--);
        }
        return pdfArray.size();
    }

    public boolean removeFieldsFromPage(int n) {
        if (n < 1) {
            return false;
        }
        String[] stringArray = new String[this.fields.size()];
        this.fields.keySet().toArray(stringArray);
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl2 = this.removeField(stringArray[i], n);
            bl = bl || bl2;
        }
        return bl;
    }

    public boolean removeField(String string, int n) {
        Item item = this.getFieldItem(string);
        if (item == null) {
            return false;
        }
        PdfDictionary pdfDictionary = (PdfDictionary)PdfReader.getPdfObject(this.reader.getCatalog().get(PdfName.ACROFORM), this.reader.getCatalog());
        if (pdfDictionary == null) {
            return false;
        }
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.FIELDS);
        if (pdfArray == null) {
            return false;
        }
        for (int i = 0; i < item.size(); ++i) {
            PdfArray pdfArray2;
            int n2 = item.getPage(i);
            if (n != -1 && n != n2) continue;
            PdfIndirectReference pdfIndirectReference = item.getWidgetRef(i);
            PdfDictionary pdfDictionary2 = item.getWidget(i);
            PdfDictionary pdfDictionary3 = this.reader.getPageN(n2);
            PdfArray pdfArray3 = pdfDictionary3.getAsArray(PdfName.ANNOTS);
            if (pdfArray3 != null) {
                if (this.removeRefFromArray(pdfArray3, pdfIndirectReference) == 0) {
                    pdfDictionary3.remove(PdfName.ANNOTS);
                    this.markUsed(pdfDictionary3);
                } else {
                    this.markUsed(pdfArray3);
                }
            }
            PdfReader.killIndirect(pdfIndirectReference);
            PdfIndirectReference pdfIndirectReference2 = pdfIndirectReference;
            while ((pdfIndirectReference = pdfDictionary2.getAsIndirectObject(PdfName.PARENT)) != null && this.removeRefFromArray(pdfArray2 = (pdfDictionary2 = pdfDictionary2.getAsDict(PdfName.PARENT)).getAsArray(PdfName.KIDS), pdfIndirectReference2) == 0) {
                pdfIndirectReference2 = pdfIndirectReference;
                PdfReader.killIndirect(pdfIndirectReference);
            }
            if (pdfIndirectReference == null) {
                this.removeRefFromArray(pdfArray, pdfIndirectReference2);
                this.markUsed(pdfArray);
            }
            if (n == -1) continue;
            item.remove(i);
            --i;
        }
        if (n == -1 || item.size() == 0) {
            this.fields.remove(string);
        }
        return true;
    }

    public boolean removeField(String string) {
        return this.removeField(string, -1);
    }

    public boolean isGenerateAppearances() {
        return this.generateAppearances;
    }

    public void setGenerateAppearances(boolean bl) {
        this.generateAppearances = bl;
        PdfDictionary pdfDictionary = this.reader.getCatalog().getAsDict(PdfName.ACROFORM);
        if (bl) {
            pdfDictionary.remove(PdfName.NEEDAPPEARANCES);
        } else {
            pdfDictionary.put(PdfName.NEEDAPPEARANCES, PdfBoolean.PDFTRUE);
        }
    }

    public ArrayList getSignatureNames() {
        Object object;
        Object object2;
        Object[] objectArray;
        if (this.sigNames != null) {
            return new ArrayList(this.sigNames.keySet());
        }
        this.sigNames = new HashMap();
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            int n;
            PdfArray pdfArray;
            PdfString pdfString;
            PdfDictionary pdfDictionary;
            objectArray = iterator.next();
            object2 = (Item)objectArray.getValue();
            object = ((Item)object2).getMerged(0);
            if (!PdfName.SIG.equals(((PdfDictionary)object).get(PdfName.FT)) || (pdfDictionary = ((PdfDictionary)object).getAsDict(PdfName.V)) == null || (pdfString = pdfDictionary.getAsString(PdfName.CONTENTS)) == null || (pdfArray = pdfDictionary.getAsArray(PdfName.BYTERANGE)) == null || (n = pdfArray.size()) < 2) continue;
            int n2 = pdfArray.getAsNumber(n - 1).intValue() + pdfArray.getAsNumber(n - 2).intValue();
            arrayList.add(new Object[]{objectArray.getKey(), new int[]{n2, 0}});
        }
        Collections.sort(arrayList, new SorterComparator());
        if (!arrayList.isEmpty()) {
            this.totalRevisions = ((int[])((Object[])arrayList.get(arrayList.size() - 1))[1])[0] == this.reader.getFileLength() ? arrayList.size() : arrayList.size() + 1;
            for (int i = 0; i < arrayList.size(); ++i) {
                objectArray = (Object[])arrayList.get(i);
                object2 = (String)objectArray[0];
                object = (int[])objectArray[1];
                object[1] = i + 1;
                this.sigNames.put(object2, object);
            }
        }
        return new ArrayList(this.sigNames.keySet());
    }

    public ArrayList getBlankSignatureNames() {
        this.getSignatureNames();
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.fields.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Item item = (Item)entry.getValue();
            PdfDictionary pdfDictionary = item.getMerged(0);
            if (!PdfName.SIG.equals(pdfDictionary.getAsName(PdfName.FT)) || this.sigNames.containsKey(entry.getKey())) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList;
    }

    public PdfDictionary getSignatureDictionary(String string) {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return null;
        }
        Item item = (Item)this.fields.get(string);
        PdfDictionary pdfDictionary = item.getMerged(0);
        return pdfDictionary.getAsDict(PdfName.V);
    }

    public boolean signatureCoversWholeDocument(String string) {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return false;
        }
        return ((int[])this.sigNames.get(string))[0] == this.reader.getFileLength();
    }

    public PdfPKCS7 verifySignature(String string) {
        return this.verifySignature(string, null);
    }

    public PdfPKCS7 verifySignature(String string, String string2) {
        PdfDictionary pdfDictionary = this.getSignatureDictionary(string);
        if (pdfDictionary == null) {
            return null;
        }
        try {
            PdfObject pdfObject;
            PdfString pdfString;
            PdfName pdfName = pdfDictionary.getAsName(PdfName.SUBFILTER);
            PdfString pdfString2 = pdfDictionary.getAsString(PdfName.CONTENTS);
            PdfPKCS7 pdfPKCS7 = null;
            if (pdfName.equals(PdfName.ADBE_X509_RSA_SHA1)) {
                pdfString = pdfDictionary.getAsString(PdfName.CERT);
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), pdfString.getBytes(), string2);
            } else {
                pdfPKCS7 = new PdfPKCS7(pdfString2.getOriginalBytes(), string2);
            }
            this.updateByteRange(pdfPKCS7, pdfDictionary);
            pdfString = pdfDictionary.getAsString(PdfName.M);
            if (pdfString != null) {
                pdfPKCS7.setSignDate(PdfDate.decode(pdfString.toString()));
            }
            if ((pdfObject = PdfReader.getPdfObject(pdfDictionary.get(PdfName.NAME))) != null) {
                if (pdfObject.isString()) {
                    pdfPKCS7.setSignName(((PdfString)pdfObject).toUnicodeString());
                } else if (pdfObject.isName()) {
                    pdfPKCS7.setSignName(PdfName.decodeName(pdfObject.toString()));
                }
            }
            if ((pdfString = pdfDictionary.getAsString(PdfName.REASON)) != null) {
                pdfPKCS7.setReason(pdfString.toUnicodeString());
            }
            if ((pdfString = pdfDictionary.getAsString(PdfName.LOCATION)) != null) {
                pdfPKCS7.setLocation(pdfString.toUnicodeString());
            }
            return pdfPKCS7;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    private void updateByteRange(PdfPKCS7 pdfPKCS7, PdfDictionary pdfDictionary) {
        PdfArray pdfArray = pdfDictionary.getAsArray(PdfName.BYTERANGE);
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        try {
            randomAccessFileOrArray.reOpen();
            byte[] byArray = new byte[8192];
            for (int i = 0; i < pdfArray.size(); ++i) {
                int n;
                int n2 = pdfArray.getAsNumber(i).intValue();
                randomAccessFileOrArray.seek(n2);
                for (int j = pdfArray.getAsNumber(++i).intValue(); j > 0 && (n = randomAccessFileOrArray.read(byArray, 0, Math.min(j, byArray.length))) > 0; j -= n) {
                    pdfPKCS7.update(byArray, 0, n);
                }
            }
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
        finally {
            try {
                randomAccessFileOrArray.close();
            }
            catch (Exception exception) {}
        }
    }

    private void markUsed(PdfObject pdfObject) {
        if (!this.append) {
            return;
        }
        ((PdfStamperImp)this.writer).markUsed(pdfObject);
    }

    public int getTotalRevisions() {
        this.getSignatureNames();
        return this.totalRevisions;
    }

    public int getRevision(String string) {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return 0;
        }
        return ((int[])this.sigNames.get(string))[1];
    }

    public InputStream extractRevision(String string) throws IOException {
        this.getSignatureNames();
        string = this.getTranslatedFieldName(string);
        if (!this.sigNames.containsKey(string)) {
            return null;
        }
        int n = ((int[])this.sigNames.get(string))[0];
        RandomAccessFileOrArray randomAccessFileOrArray = this.reader.getSafeFile();
        randomAccessFileOrArray.reOpen();
        randomAccessFileOrArray.seek(0);
        return new RevisionStream(randomAccessFileOrArray, n);
    }

    public Map getFieldCache() {
        return this.fieldCache;
    }

    public void setFieldCache(Map map) {
        this.fieldCache = map;
    }

    public void setExtraMargin(float f, float f2) {
        this.extraMarginLeft = f;
        this.extraMarginTop = f2;
    }

    public void addSubstitutionFont(BaseFont baseFont) {
        if (this.substitutionFonts == null) {
            this.substitutionFonts = new ArrayList();
        }
        this.substitutionFonts.add(baseFont);
    }

    public ArrayList getSubstitutionFonts() {
        return this.substitutionFonts;
    }

    public void setSubstitutionFonts(ArrayList arrayList) {
        this.substitutionFonts = arrayList;
    }

    public XfaForm getXfa() {
        return this.xfa;
    }

    public PushbuttonField getNewPushbuttonFromField(String string) {
        return this.getNewPushbuttonFromField(string, 0);
    }

    public PushbuttonField getNewPushbuttonFromField(String string, int n) {
        try {
            if (this.getFieldType(string) != 1) {
                return null;
            }
            Item item = this.getFieldItem(string);
            if (n >= item.size()) {
                return null;
            }
            int n2 = n * 5;
            float[] fArray = this.getFieldPositions(string);
            Rectangle rectangle = new Rectangle(fArray[n2 + 1], fArray[n2 + 2], fArray[n2 + 3], fArray[n2 + 4]);
            PushbuttonField pushbuttonField = new PushbuttonField(this.writer, rectangle, null);
            PdfDictionary pdfDictionary = item.getMerged(n);
            this.decodeGenericDictionary(pdfDictionary, pushbuttonField);
            PdfDictionary pdfDictionary2 = pdfDictionary.getAsDict(PdfName.MK);
            if (pdfDictionary2 != null) {
                PdfObject pdfObject;
                PdfDictionary pdfDictionary3;
                PdfNumber pdfNumber;
                PdfString pdfString = pdfDictionary2.getAsString(PdfName.CA);
                if (pdfString != null) {
                    pushbuttonField.setText(pdfString.toUnicodeString());
                }
                if ((pdfNumber = pdfDictionary2.getAsNumber(PdfName.TP)) != null) {
                    pushbuttonField.setLayout(pdfNumber.intValue() + 1);
                }
                if ((pdfDictionary3 = pdfDictionary2.getAsDict(PdfName.IF)) != null) {
                    PdfBoolean pdfBoolean;
                    PdfArray pdfArray;
                    pdfObject = pdfDictionary3.getAsName(PdfName.SW);
                    if (pdfObject != null) {
                        int n3 = 1;
                        if (((PdfName)pdfObject).equals(PdfName.B)) {
                            n3 = 3;
                        } else if (((PdfName)pdfObject).equals(PdfName.S)) {
                            n3 = 4;
                        } else if (((PdfName)pdfObject).equals(PdfName.N)) {
                            n3 = 2;
                        }
                        pushbuttonField.setScaleIcon(n3);
                    }
                    if ((pdfObject = pdfDictionary3.getAsName(PdfName.S)) != null && ((PdfName)pdfObject).equals(PdfName.A)) {
                        pushbuttonField.setProportionalIcon(false);
                    }
                    if ((pdfArray = pdfDictionary3.getAsArray(PdfName.A)) != null && pdfArray.size() == 2) {
                        float f = pdfArray.getAsNumber(0).floatValue();
                        float f2 = pdfArray.getAsNumber(1).floatValue();
                        pushbuttonField.setIconHorizontalAdjustment(f);
                        pushbuttonField.setIconVerticalAdjustment(f2);
                    }
                    if ((pdfBoolean = pdfDictionary3.getAsBoolean(PdfName.FB)) != null && pdfBoolean.booleanValue()) {
                        pushbuttonField.setIconFitToBounds(true);
                    }
                }
                if ((pdfObject = pdfDictionary2.get(PdfName.I)) != null && pdfObject.isIndirect()) {
                    pushbuttonField.setIconReference((PRIndirectReference)pdfObject);
                }
            }
            return pushbuttonField;
        }
        catch (Exception exception) {
            throw new ExceptionConverter(exception);
        }
    }

    public boolean replacePushbuttonField(String string, PdfFormField pdfFormField) {
        return this.replacePushbuttonField(string, pdfFormField, 0);
    }

    public boolean replacePushbuttonField(String string, PdfFormField pdfFormField, int n) {
        if (this.getFieldType(string) != 1) {
            return false;
        }
        Item item = this.getFieldItem(string);
        if (n >= item.size()) {
            return false;
        }
        PdfDictionary pdfDictionary = item.getMerged(n);
        PdfDictionary pdfDictionary2 = item.getValue(n);
        PdfDictionary pdfDictionary3 = item.getWidget(n);
        for (int i = 0; i < buttonRemove.length; ++i) {
            pdfDictionary.remove(buttonRemove[i]);
            pdfDictionary2.remove(buttonRemove[i]);
            pdfDictionary3.remove(buttonRemove[i]);
        }
        Iterator iterator = pdfFormField.getKeys().iterator();
        while (iterator.hasNext()) {
            PdfName pdfName = (PdfName)iterator.next();
            if (pdfName.equals(PdfName.T) || pdfName.equals(PdfName.RECT)) continue;
            if (pdfName.equals(PdfName.FF)) {
                pdfDictionary2.put(pdfName, pdfFormField.get(pdfName));
            } else {
                pdfDictionary3.put(pdfName, pdfFormField.get(pdfName));
            }
            pdfDictionary.put(pdfName, pdfFormField.get(pdfName));
        }
        return true;
    }

    static {
        stdFieldFontNames.put("CoBO", new String[]{"Courier-BoldOblique"});
        stdFieldFontNames.put("CoBo", new String[]{"Courier-Bold"});
        stdFieldFontNames.put("CoOb", new String[]{"Courier-Oblique"});
        stdFieldFontNames.put("Cour", new String[]{"Courier"});
        stdFieldFontNames.put("HeBO", new String[]{"Helvetica-BoldOblique"});
        stdFieldFontNames.put("HeBo", new String[]{"Helvetica-Bold"});
        stdFieldFontNames.put("HeOb", new String[]{"Helvetica-Oblique"});
        stdFieldFontNames.put("Helv", new String[]{"Helvetica"});
        stdFieldFontNames.put("Symb", new String[]{"Symbol"});
        stdFieldFontNames.put("TiBI", new String[]{"Times-BoldItalic"});
        stdFieldFontNames.put("TiBo", new String[]{"Times-Bold"});
        stdFieldFontNames.put("TiIt", new String[]{"Times-Italic"});
        stdFieldFontNames.put("TiRo", new String[]{"Times-Roman"});
        stdFieldFontNames.put("ZaDb", new String[]{"ZapfDingbats"});
        stdFieldFontNames.put("HySm", new String[]{"HYSMyeongJo-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("HyGo", new String[]{"HYGoThic-Medium", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaGo", new String[]{"HeiseiKakuGo-W5", "UniKS-UCS2-H"});
        stdFieldFontNames.put("KaMi", new String[]{"HeiseiMin-W3", "UniJIS-UCS2-H"});
        stdFieldFontNames.put("MHei", new String[]{"MHei-Medium", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("MSun", new String[]{"MSung-Light", "UniCNS-UCS2-H"});
        stdFieldFontNames.put("STSo", new String[]{"STSong-Light", "UniGB-UCS2-H"});
        buttonRemove = new PdfName[]{PdfName.MK, PdfName.F, PdfName.FF, PdfName.Q, PdfName.BS, PdfName.BORDER};
    }

    private static class SorterComparator
    implements Comparator {
        private SorterComparator() {
        }

        public int compare(Object object, Object object2) {
            int n = ((int[])((Object[])object)[1])[0];
            int n2 = ((int[])((Object[])object2)[1])[0];
            return n - n2;
        }
    }

    private static class RevisionStream
    extends InputStream {
        private byte[] b = new byte[1];
        private RandomAccessFileOrArray raf;
        private int length;
        private int rangePosition = 0;
        private boolean closed;

        private RevisionStream(RandomAccessFileOrArray randomAccessFileOrArray, int n) {
            this.raf = randomAccessFileOrArray;
            this.length = n;
        }

        public int read() throws IOException {
            int n = this.read(this.b);
            if (n != 1) {
                return -1;
            }
            return this.b[0] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.rangePosition >= this.length) {
                this.close();
                return -1;
            }
            int n3 = Math.min(n2, this.length - this.rangePosition);
            this.raf.readFully(byArray, n, n3);
            this.rangePosition += n3;
            return n3;
        }

        public void close() throws IOException {
            if (!this.closed) {
                this.raf.close();
                this.closed = true;
            }
        }
    }

    private static class InstHit {
        IntHashtable hits;

        public InstHit(int[] nArray) {
            if (nArray == null) {
                return;
            }
            this.hits = new IntHashtable();
            for (int i = 0; i < nArray.length; ++i) {
                this.hits.put(nArray[i], 1);
            }
        }

        public boolean isHit(int n) {
            if (this.hits == null) {
                return true;
            }
            return this.hits.containsKey(n);
        }
    }

    public static class Item {
        public static final int WRITE_MERGED = 1;
        public static final int WRITE_WIDGET = 2;
        public static final int WRITE_VALUE = 4;
        public ArrayList values = new ArrayList();
        public ArrayList widgets = new ArrayList();
        public ArrayList widget_refs = new ArrayList();
        public ArrayList merged = new ArrayList();
        public ArrayList page = new ArrayList();
        public ArrayList tabOrder = new ArrayList();

        public void writeToAll(PdfName pdfName, PdfObject pdfObject, int n) {
            int n2;
            PdfDictionary pdfDictionary = null;
            if ((n & 1) != 0) {
                for (n2 = 0; n2 < this.merged.size(); ++n2) {
                    pdfDictionary = this.getMerged(n2);
                    pdfDictionary.put(pdfName, pdfObject);
                }
            }
            if ((n & 2) != 0) {
                for (n2 = 0; n2 < this.widgets.size(); ++n2) {
                    pdfDictionary = this.getWidget(n2);
                    pdfDictionary.put(pdfName, pdfObject);
                }
            }
            if ((n & 4) != 0) {
                for (n2 = 0; n2 < this.values.size(); ++n2) {
                    pdfDictionary = this.getValue(n2);
                    pdfDictionary.put(pdfName, pdfObject);
                }
            }
        }

        public void markUsed(AcroFields acroFields, int n) {
            int n2;
            if ((n & 4) != 0) {
                for (n2 = 0; n2 < this.size(); ++n2) {
                    acroFields.markUsed(this.getValue(n2));
                }
            }
            if ((n & 2) != 0) {
                for (n2 = 0; n2 < this.size(); ++n2) {
                    acroFields.markUsed(this.getWidget(n2));
                }
            }
        }

        public int size() {
            return this.values.size();
        }

        void remove(int n) {
            this.values.remove(n);
            this.widgets.remove(n);
            this.widget_refs.remove(n);
            this.merged.remove(n);
            this.page.remove(n);
            this.tabOrder.remove(n);
        }

        public PdfDictionary getValue(int n) {
            return (PdfDictionary)this.values.get(n);
        }

        void addValue(PdfDictionary pdfDictionary) {
            this.values.add(pdfDictionary);
        }

        public PdfDictionary getWidget(int n) {
            return (PdfDictionary)this.widgets.get(n);
        }

        void addWidget(PdfDictionary pdfDictionary) {
            this.widgets.add(pdfDictionary);
        }

        public PdfIndirectReference getWidgetRef(int n) {
            return (PdfIndirectReference)this.widget_refs.get(n);
        }

        void addWidgetRef(PdfIndirectReference pdfIndirectReference) {
            this.widget_refs.add(pdfIndirectReference);
        }

        public PdfDictionary getMerged(int n) {
            return (PdfDictionary)this.merged.get(n);
        }

        void addMerged(PdfDictionary pdfDictionary) {
            this.merged.add(pdfDictionary);
        }

        public Integer getPage(int n) {
            return (Integer)this.page.get(n);
        }

        void addPage(int n) {
            this.page.add(new Integer(n));
        }

        void forcePage(int n, int n2) {
            this.page.set(n, new Integer(n2));
        }

        public Integer getTabOrder(int n) {
            return (Integer)this.tabOrder.get(n);
        }

        void addTabOrder(int n) {
            this.tabOrder.add(new Integer(n));
        }
    }
}

