/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.text.BadLocationException;
import org.netbeans.modules.properties.BundleStructure;
import org.netbeans.modules.properties.Element;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.StructHandler;
import org.openide.ErrorManager;
import org.openide.text.PositionBounds;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesStructure
extends Element {
    private Map<String, Element.ItemElem> items;
    private StructHandler handler;
    static final long serialVersionUID = -78380271920882131L;

    public PropertiesStructure(PositionBounds positionBounds, Map<String, Element.ItemElem> map) {
        super(positionBounds);
        for (Element.ItemElem itemElem : map.values()) {
            itemElem.setParent(this);
        }
        this.items = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(PropertiesStructure propertiesStructure) {
        StructHandler structHandler = this.getParent();
        synchronized (structHandler) {
            BundleStructure bundleStructure = this.getParentBundleStructure();
            synchronized (bundleStructure) {
                boolean bl = false;
                Map<String, Element.ItemElem> map = propertiesStructure.items;
                HashMap<String, Element.ItemElem> hashMap = new HashMap<String, Element.ItemElem>();
                HashMap<String, Element.ItemElem> hashMap2 = new HashMap<String, Element.ItemElem>();
                Map<Object, Object> map2 = new HashMap();
                for (Element.ItemElem itemElem : map.values()) {
                    itemElem.setParent(this);
                    Element.ItemElem itemElem2 = this.getItem(itemElem.getKey());
                    if (itemElem2 == null) {
                        hashMap2.put(itemElem.getKey(), itemElem);
                        continue;
                    }
                    if (!itemElem.equals(itemElem2)) {
                        hashMap.put(itemElem.getKey(), itemElem);
                    }
                    this.items.remove(itemElem2.getKey());
                }
                map2 = this.items;
                if (map2.size() > 0 || hashMap2.size() > 0) {
                    bl = true;
                }
                this.items = map;
                this.bounds = propertiesStructure.getBounds();
                if (bl) {
                    this.structureChanged(hashMap, hashMap2, map2);
                } else {
                    for (Element.ItemElem itemElem : hashMap.values()) {
                        this.itemChanged(itemElem);
                    }
                }
            }
        }
    }

    void setParent(StructHandler structHandler) {
        this.handler = structHandler;
    }

    public StructHandler getParent() {
        if (this.handler == null) {
            throw new IllegalStateException();
        }
        return this.handler;
    }

    private BundleStructure getParentBundleStructure() {
        PropertiesDataObject propertiesDataObject = (PropertiesDataObject)this.getParent().getEntry().getDataObject();
        return propertiesDataObject.getBundleStructure();
    }

    @Override
    public String getDocumentString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element.ItemElem itemElem : this.items.values()) {
            stringBuilder.append(itemElem.getDocumentString());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Element.ItemElem itemElem : this.items.values()) {
            stringBuilder.append(itemElem.toString());
            stringBuilder.append("- - -\n");
        }
        return stringBuilder.toString();
    }

    public Element.ItemElem getItem(String string) {
        return this.items.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean renameItem(String string, String string2) {
        StructHandler structHandler = this.getParent();
        synchronized (structHandler) {
            BundleStructure bundleStructure = this.getParentBundleStructure();
            synchronized (bundleStructure) {
                Element.ItemElem itemElem = this.getItem(string2);
                if (itemElem == null) {
                    itemElem = this.getItem(string);
                    if (itemElem == null) {
                        return false;
                    }
                    this.items.remove(string);
                    this.items.put(string2, itemElem);
                    itemElem.setKey(string2);
                    return true;
                }
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteItem(String string) {
        StructHandler structHandler = this.getParent();
        synchronized (structHandler) {
            BundleStructure bundleStructure = this.getParentBundleStructure();
            synchronized (bundleStructure) {
                Element.ItemElem itemElem = this.getItem(string);
                if (itemElem == null) {
                    return false;
                }
                try {
                    itemElem.getBounds().setText("");
                    this.items.remove(string);
                    this.structureChanged();
                    return true;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                    return false;
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                    return false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addItem(String string, String string2, String string3) {
        Element.ItemElem itemElem = this.getItem(string);
        if (itemElem != null) {
            return false;
        }
        itemElem = new Element.ItemElem(null, new Element.KeyElem(null, string), new Element.ValueElem(null, string2), new Element.CommentElem(null, string3));
        try {
            StructHandler structHandler = this.getParent();
            synchronized (structHandler) {
                BundleStructure bundleStructure = this.getParentBundleStructure();
                synchronized (bundleStructure) {
                    PositionBounds positionBounds = this.getBounds();
                    PositionBounds positionBounds2 = positionBounds.getText().endsWith("\n") ? positionBounds.insertAfter(itemElem.getDocumentString()) : positionBounds.insertAfter("\n").insertAfter(itemElem.getDocumentString());
                    itemElem.bounds = positionBounds2;
                    itemElem.setParent(this);
                    this.items.put(string, itemElem);
                    this.structureChanged();
                    return true;
                }
            }
        }
        catch (IOException iOException) {
            return false;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    public Iterator<Element.ItemElem> allItems() {
        return this.items.values().iterator();
    }

    void itemChanged(Element.ItemElem itemElem) {
        this.getParentBundleStructure().notifyItemChanged(this, itemElem);
    }

    void structureChanged() {
        this.getParentBundleStructure().notifyOneFileChanged(this.getParent());
    }

    void structureChanged(Map<String, Element.ItemElem> map, Map<String, Element.ItemElem> map2, Map<String, Element.ItemElem> map3) {
        this.getParentBundleStructure().notifyOneFileChanged(this.getParent(), map, map2, map3);
    }

    void itemKeyChanged(String string, Element.ItemElem itemElem) {
        HashMap<String, Element.ItemElem> hashMap = new HashMap<String, Element.ItemElem>();
        HashMap<String, Element.ItemElem> hashMap2 = new HashMap<String, Element.ItemElem>();
        HashMap<String, Element.ItemElem> hashMap3 = new HashMap<String, Element.ItemElem>();
        Element.ItemElem itemElem2 = this.getItem(string);
        if (itemElem2 == null) {
            Element.ItemElem itemElem3 = new Element.ItemElem(null, new Element.KeyElem(null, string), new Element.ValueElem(null, ""), new Element.CommentElem(null, ""));
            hashMap3.put(string, itemElem3);
        } else {
            hashMap.put(itemElem2.getKey(), itemElem2);
        }
        hashMap2.put(itemElem.getKey(), itemElem);
        this.structureChanged(hashMap, hashMap2, hashMap3);
    }
}

