/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table;

import com.jaspersoft.ireport.components.table.wizard.TableWizardIterator;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.palette.actions.CreateReportElementAction;
import com.jaspersoft.ireport.designer.palette.actions.CreateTextFieldAction;
import com.jaspersoft.ireport.designer.undo.AddDatasetUndoableEdit;
import com.jaspersoft.ireport.designer.undo.AddStyleUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Dialog;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateTableAction
extends CreateReportElementAction {
    public JRDesignElement createReportElement(JasperDesign jd) {
        boolean cancelled;
        TableWizardIterator iterator = new TableWizardIterator();
        WizardDescriptor wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)iterator);
        iterator.initialize(wizardDescriptor, jd);
        wizardDescriptor.setTitleFormat(new MessageFormat("{0} ({1})"));
        wizardDescriptor.setTitle("Table wizard");
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!cancelled) {
            AddStyleUndoableEdit edit2;
            AddStyleUndoableEdit edit = null;
            JRDesignComponentElement component = new JRDesignComponentElement();
            StandardTable componentImpl = new StandardTable();
            int type = this.getIntProperty(wizardDescriptor, "table_type", 1);
            int columns = this.getIntProperty(wizardDescriptor, "columns", 4);
            int height = 20;
            List<JRDesignStyle> styles = this.getStylesProperty(wizardDescriptor);
            height += this.getBooleanProperty(wizardDescriptor, "th", true) ? 30 : 0;
            height += this.getBooleanProperty(wizardDescriptor, "ch", true) ? 30 : 0;
            height += this.getBooleanProperty(wizardDescriptor, "cf", true) ? 30 : 0;
            height += this.getBooleanProperty(wizardDescriptor, "tf", true) ? 30 : 0;
            if (type == 1) {
                for (int i = 0; i < columns; ++i) {
                    BaseColumn column = this.createColumn(wizardDescriptor, null, null);
                    componentImpl.addColumn(column);
                }
                JRDesignDataset newDataset = new JRDesignDataset(false);
                String name = "Table Dataset ";
                int i = 1;
                while (true) {
                    if (!jd.getDatasetMap().containsKey(name + i)) break;
                    ++i;
                }
                newDataset.setName(name + i);
                try {
                    jd.addDataset(newDataset);
                    edit2 = new AddDatasetUndoableEdit(newDataset, jd);
                    if (edit == null) {
                        edit = edit2;
                    } else {
                        edit.concatenate((UndoableEdit)edit2);
                    }
                }
                catch (JRException ex) {
                    // empty catch block
                }
                JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
                datasetRun.setDatasetName(newDataset.getName());
                JRDesignExpression exp = new JRDesignExpression();
                exp.setValueClassName("net.sf.jasperreports.engine.JRDataSource");
                exp.setText("new net.sf.jasperreports.engine.JREmptyDataSource(1)");
                datasetRun.setDataSourceExpression((JRExpression)exp);
                componentImpl.setDatasetRun((JRDatasetRun)datasetRun);
            } else if (type == 0) {
                int i;
                List fields = (List)wizardDescriptor.getProperty("selectedFields");
                JRDesignDatasetRun datasetRun = new JRDesignDatasetRun();
                String con_exp = (String)wizardDescriptor.getProperty("table_connection_expression");
                String ds_exp = (String)wizardDescriptor.getProperty("table_datasource_expression");
                JRDesignDataset dataset = (JRDesignDataset)wizardDescriptor.getProperty("dataset");
                List groups = dataset.getGroupsList();
                for (i = 0; i < groups.size(); ++i) {
                    height += this.getBooleanProperty(wizardDescriptor, "gh", true) ? 30 : 0;
                    height += this.getBooleanProperty(wizardDescriptor, "gf", true) ? 30 : 0;
                }
                if (con_exp != null) {
                    datasetRun.setConnectionExpression((JRExpression)Misc.createExpression((String)"java.sql.Connection", (String)con_exp));
                } else if (ds_exp != null) {
                    datasetRun.setDataSourceExpression((JRExpression)Misc.createExpression((String)"net.sf.jasperreports.engine.JRDataSource", (String)ds_exp));
                } else {
                    datasetRun.setDataSourceExpression((JRExpression)Misc.createExpression((String)"net.sf.jasperreports.engine.JRDataSource", (String)"new net.sf.jasperreports.engine.JREmptyDataSource(1)"));
                }
                datasetRun.setDatasetName(dataset.getName());
                if (fields == null || fields.size() == 0) {
                    for (i = 0; i < 4; ++i) {
                        BaseColumn column = this.createColumn(wizardDescriptor, null, null);
                        componentImpl.addColumn(column);
                    }
                } else {
                    for (JRDesignField field : fields) {
                        BaseColumn column = this.createColumn(wizardDescriptor, field, dataset);
                        componentImpl.addColumn(column);
                    }
                }
                componentImpl.setDatasetRun((JRDatasetRun)datasetRun);
            }
            for (JRDesignStyle style : styles) {
                try {
                    jd.addStyle((JRStyle)style);
                    edit2 = new AddStyleUndoableEdit(style, jd);
                    if (edit == null) {
                        edit = edit2;
                        continue;
                    }
                    edit.concatenate((UndoableEdit)edit2);
                }
                catch (JRException ex) {
                    ex.printStackTrace();
                }
            }
            if (styles.size() > 0) {
                component.setStyle((JRStyle)styles.get(0));
            }
            component.setKey((String)wizardDescriptor.getProperty("basename"));
            component.setComponent((Component)componentImpl);
            component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "table"));
            component.setWidth(columns * 90);
            component.setHeight(height);
            if (edit != null) {
                IReportManager.getInstance().addUndoableEdit((UndoableEdit)edit);
            }
            return component;
        }
        return null;
    }

    public BaseColumn createColumn(WizardDescriptor wizardDescriptor, JRDesignField field, JRDesignDataset dataset) {
        JRDesignStaticText text;
        DesignCell cell;
        StandardColumn column = new StandardColumn();
        column.setWidth(Integer.valueOf(90));
        List<JRDesignStyle> styles = this.getStylesProperty(wizardDescriptor);
        if (this.getBooleanProperty(wizardDescriptor, "th", true)) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(30));
            if (styles.size() > 1) {
                cell.setStyle((JRStyle)styles.get(1));
            }
            column.setTableHeader((Cell)cell);
        }
        if (this.getBooleanProperty(wizardDescriptor, "tf", true)) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(30));
            if (styles.size() > 1) {
                cell.setStyle((JRStyle)styles.get(1));
            }
            column.setTableFooter((Cell)cell);
        }
        if (this.getBooleanProperty(wizardDescriptor, "ch", true)) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(30));
            if (styles.size() > 2) {
                cell.setStyle((JRStyle)styles.get(2));
            }
            column.setColumnHeader((Cell)cell);
            if (field != null) {
                text = new JRDesignStaticText((JRDefaultStyleProvider)this.getJasperDesign());
                text.setText(field.getName());
                text.setWidth(90);
                text.setHeight(30);
                cell.addElement((JRDesignElement)text);
            }
        }
        if (this.getBooleanProperty(wizardDescriptor, "cf", true)) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(30));
            if (styles.size() > 2) {
                cell.setStyle((JRStyle)styles.get(2));
            }
            column.setColumnFooter((Cell)cell);
        }
        cell = new DesignCell();
        cell.setHeight(Integer.valueOf(20));
        if (styles.size() > 3) {
            cell.setStyle((JRStyle)styles.get(3));
        }
        column.setDetailCell((Cell)cell);
        if (field != null) {
            text = new JRDesignTextField((JRDefaultStyleProvider)this.getJasperDesign());
            JRDesignExpression exp = Misc.createExpression((String)field.getValueClassName(), (String)("$F{" + field.getName() + "}"));
            CreateTextFieldAction.setMatchingClassExpression((JRDesignExpression)exp, (String)field.getValueClassName(), (boolean)true);
            text.setExpression((JRExpression)exp);
            text.setWidth(90);
            text.setHeight(20);
            cell.addElement((JRDesignElement)text);
        }
        if (dataset != null) {
            List groups = dataset.getGroupsList();
            for (int i = 0; i < groups.size(); ++i) {
                DesignCell cell2;
                JRDesignGroup group;
                if (this.getBooleanProperty(wizardDescriptor, "gh", true)) {
                    group = (JRDesignGroup)groups.get(i);
                    cell2 = new DesignCell();
                    cell2.setHeight(Integer.valueOf(30));
                    if (styles.size() > 1) {
                        cell2.setStyle((JRStyle)styles.get(1));
                    }
                    column.setGroupHeader(group.getName(), (Cell)cell2);
                    JRDesignTextField text2 = new JRDesignTextField((JRDefaultStyleProvider)this.getJasperDesign());
                    if (group.getExpression() != null) {
                        JRDesignExpression exp = (JRDesignExpression)group.getExpression().clone();
                        CreateTextFieldAction.setMatchingClassExpression((JRDesignExpression)exp, (String)exp.getValueClassName(), (boolean)true);
                        text2.setExpression((JRExpression)exp);
                        text2.setWidth(90);
                        text2.setHeight(20);
                        cell2.addElement((JRDesignElement)text2);
                    }
                }
                if (!this.getBooleanProperty(wizardDescriptor, "gf", true)) continue;
                group = (JRDesignGroup)groups.get(i);
                cell2 = new DesignCell();
                cell2.setHeight(Integer.valueOf(30));
                if (styles.size() > 1) {
                    cell2.setStyle((JRStyle)styles.get(1));
                }
                column.setGroupFooter(group.getName(), (Cell)cell2);
            }
        }
        return column;
    }

    public int getIntProperty(WizardDescriptor wizard, String name, int defValue) {
        if (wizard.getProperty(name) != null && wizard.getProperty(name) instanceof Number) {
            return ((Number)wizard.getProperty(name)).intValue();
        }
        return defValue;
    }

    public boolean getBooleanProperty(WizardDescriptor wizard, String name, boolean defValue) {
        if (wizard.getProperty(name) != null && wizard.getProperty(name) instanceof Boolean) {
            return (Boolean)wizard.getProperty(name);
        }
        return defValue;
    }

    public List<JRDesignStyle> getStylesProperty(WizardDescriptor wizard) {
        ArrayList<JRDesignStyle> styles = new ArrayList<JRDesignStyle>();
        if (!this.getBooleanProperty(wizard, "create_styles", true)) {
            return styles;
        }
        if (wizard.getProperty("styles") != null && wizard.getProperty("styles") instanceof List) {
            return (List)wizard.getProperty("styles");
        }
        return styles;
    }
}

