/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.barcode.barcode4j;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.UndoableEdit;
import net.sf.jasperreports.components.barcode4j.BarcodeComponent;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.openide.nodes.PropertySupport;
import org.openide.util.WeakListeners;

public final class Barcode4JEvaluationGroupProperty
extends PropertySupport
implements PropertyChangeListener {
    private final JRDesignDataset dataset;
    private final BarcodeComponent component;
    private ComboBoxPropertyEditor editor;

    public Barcode4JEvaluationGroupProperty(BarcodeComponent component, JRDesignDataset dataset) {
        super("evaluationGroup", JRGroup.class, "Evaluation group", "Evaluate the expression when the specified group changes", true, true);
        this.component = component;
        this.dataset = dataset;
        this.setValue("suppressCustomEditor", Boolean.TRUE);
        dataset.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)dataset.getEventSupport()));
    }

    public boolean canWrite() {
        return this.component.getEvaluationTime() == 5;
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new ComboBoxPropertyEditor(false, (List)this.getListOfTags());
        }
        return this.editor;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        return this.component.getEvaluationGroup() == null ? "" : this.component.getEvaluationGroup();
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (val instanceof String) {
            String oldValue = this.component.getEvaluationGroup();
            String newValue = (String)val;
            this.component.setEvaluationGroup(newValue);
            ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit((Object)this.component, "EvaluationGroup", String.class, (Object)oldValue, (Object)newValue);
            IReportManager.getInstance().addUndoableEdit((UndoableEdit)urob);
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (this.editor == null) {
            return;
        }
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("name")) {
            this.editor.setTagValues((List)this.getListOfTags());
        }
    }

    private ArrayList getListOfTags() {
        ArrayList<Tag> l = new ArrayList<Tag>();
        List groups = this.dataset.getGroupsList();
        for (int i = 0; i < groups.size(); ++i) {
            JRDesignGroup group = (JRDesignGroup)groups.get(i);
            l.add(new Tag((Object)group.getName(), group.getName()));
            group.getEventSupport().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)group.getEventSupport()));
        }
        return l;
    }
}

