/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.text.NumberFormat;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.CRC32;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;
import javax.swing.filechooser.FileFilter;

public class FontRename4 {
    static final long BIG_FILE_SIZE = 0x500000L;
    static final int BUFFER_SIZE = 65536;
    static final String COPYRIGHT_NOTICE = "Copyright (c) 2009 by Keith Fenske.  Released under GNU Public License.";
    static final int[][] DEFAULT_ACCEPT = new int[][]{{3, 1, 1033, 4}, {3, 0, 1033, 4}, {1, 0, 0, 4}};
    static final String[] DEFAULT_CHARSET = new String[]{"US-ASCII", "US-ASCII", "US-ASCII"};
    static final String DEFAULT_FILE = "FontRename4.txt";
    static final int DEFAULT_HEIGHT = -1;
    static final int DEFAULT_LEFT = 50;
    static final int DEFAULT_TOP = 50;
    static final int DEFAULT_WIDTH = -1;
    static final String EMPTY_STATUS = " ";
    static final String[] FONT_SIZES = new String[]{"10", "12", "14", "16", "18", "20", "24", "30"};
    static final long INT_MASK = 0xFFFFFFFFL;
    static final int MIN_FRAME = 200;
    static final String PROGRAM_TITLE = "Change File Names for OpenType and TrueType Fonts - by: Keith Fenske";
    static final char REPLACE_CHAR = '-';
    static final String[] REPORT_CHOICES = new String[]{"only summary, errors", "successful changes", "failures to change", "all files, summary", "all files, details"};
    static final String SYSTEM_FONT = "Dialog";
    static final int TIMER_DELAY = 700;
    static final String UNICODE_BMP = "UTF-16";
    static String[] acceptCharset;
    static int[][] acceptEntries;
    static boolean allTypesFlag;
    static JButton cancelButton;
    static boolean cancelFlag;
    static int changeCount;
    static boolean checksumFlag;
    static boolean consoleFlag;
    static TreeMap convertMap;
    static String dataFile;
    static JButton exitButton;
    static JFileChooser fileChooser;
    static int fileCount;
    static int folderCount;
    static FileFilter fontFilter;
    static String fontName;
    static JComboBox fontNameDialog;
    static int fontSize;
    static JComboBox fontSizeDialog;
    static String forcedName;
    static NumberFormat formatComma;
    static NumberFormat formatPointOne;
    static String genericName;
    static boolean hiddenFlag;
    static JFrame mainFrame;
    static boolean mswinFlag;
    static JButton openButton;
    static File[] openFileList;
    static Thread openFilesThread;
    static JTextArea outputText;
    static boolean readonlyFlag;
    static JCheckBox recurseCheckbox;
    static boolean recurseFlag;
    static JComboBox reportDialog;
    static int reportIndex;
    static JButton saveButton;
    static JLabel statusDialog;
    static String statusPending;
    static Timer statusTimer;

    public static void main(String[] stringArray) {
        Object object;
        String string;
        int n;
        acceptCharset = DEFAULT_CHARSET;
        acceptEntries = DEFAULT_ACCEPT;
        allTypesFlag = false;
        Font font = null;
        cancelFlag = false;
        folderCount = 0;
        fileCount = 0;
        changeCount = 0;
        checksumFlag = false;
        consoleFlag = false;
        convertMap = new TreeMap();
        dataFile = DEFAULT_FILE;
        fontFilter = new FontRename4Filter();
        fontName = "Verdana";
        fontSize = 16;
        forcedName = null;
        genericName = null;
        hiddenFlag = false;
        boolean bl = false;
        mswinFlag = System.getProperty("os.name").startsWith("Windows");
        readonlyFlag = false;
        recurseFlag = false;
        reportIndex = 1;
        statusPending = EMPTY_STATUS;
        int n2 = -1;
        int n3 = 50;
        int n4 = 50;
        int n5 = -1;
        formatComma = NumberFormat.getInstance();
        formatComma.setGroupingUsed(true);
        formatPointOne = NumberFormat.getInstance();
        formatPointOne.setGroupingUsed(true);
        formatPointOne.setMaximumFractionDigits(1);
        formatPointOne.setMinimumFractionDigits(1);
        for (n = 0; n < stringArray.length; ++n) {
            string = stringArray[n].toLowerCase();
            if (string.length() == 0) continue;
            if (string.equals("?") || string.equals("-?") || string.equals("/?") || string.equals("-help") || mswinFlag && string.equals("/help")) {
                FontRename4.showHelp();
                System.exit(0);
                continue;
            }
            if (string.equals("-a") || mswinFlag && string.equals("/a") || string.equals("-a1") || mswinFlag && string.equals("/a1")) {
                allTypesFlag = true;
                continue;
            }
            if (string.equals("-a0") || mswinFlag && string.equals("/a0")) {
                allTypesFlag = false;
                continue;
            }
            if (string.equals("-c") || mswinFlag && string.equals("/c") || string.equals("-c1") || mswinFlag && string.equals("/c1")) {
                checksumFlag = true;
                continue;
            }
            if (string.equals("-c0") || mswinFlag && string.equals("/c0")) {
                checksumFlag = false;
                continue;
            }
            if (string.startsWith("-d") || mswinFlag && string.startsWith("/d")) {
                dataFile = stringArray[n].substring(2);
                continue;
            }
            if (string.startsWith("-f") || mswinFlag && string.startsWith("/f")) {
                forcedName = FontRename4.collapseString(stringArray[n].substring(2));
                if (forcedName.length() != 0) continue;
                System.err.println("Empty forced name: " + stringArray[n]);
                FontRename4.showHelp();
                System.exit(-1);
                continue;
            }
            if (string.startsWith("-g") || mswinFlag && string.startsWith("/g")) {
                genericName = FontRename4.collapseString(stringArray[n].substring(2));
                if (genericName.length() != 0) continue;
                System.err.println("Empty generic name: " + stringArray[n]);
                FontRename4.showHelp();
                System.exit(-1);
                continue;
            }
            if (string.equals("-h") || mswinFlag && string.equals("/h") || string.equals("-h1") || mswinFlag && string.equals("/h1")) {
                hiddenFlag = true;
                continue;
            }
            if (string.equals("-h0") || mswinFlag && string.equals("/h0")) {
                hiddenFlag = false;
                continue;
            }
            if (string.startsWith("-m") || mswinFlag && string.startsWith("/m")) {
                try {
                    reportIndex = Integer.parseInt(string.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    reportIndex = -1;
                }
                if (reportIndex >= 0 && reportIndex < REPORT_CHOICES.length) continue;
                System.err.println("Message option must be from -m0 to -m" + (REPORT_CHOICES.length - 1) + " not: " + stringArray[n]);
                FontRename4.showHelp();
                System.exit(-1);
                continue;
            }
            if (string.equals("-r") || mswinFlag && string.equals("/r") || string.equals("-r1") || mswinFlag && string.equals("/r1")) {
                readonlyFlag = true;
                continue;
            }
            if (string.equals("-r0") || mswinFlag && string.equals("/r0")) {
                readonlyFlag = false;
                continue;
            }
            if (string.equals("-s") || mswinFlag && string.equals("/s") || string.equals("-s1") || mswinFlag && string.equals("/s1")) {
                recurseFlag = true;
                continue;
            }
            if (string.equals("-s0") || mswinFlag && string.equals("/s0")) {
                recurseFlag = false;
                continue;
            }
            if (string.startsWith("-u") || mswinFlag && string.startsWith("/u")) {
                int n6 = -1;
                try {
                    n6 = Integer.parseInt(string.substring(2));
                }
                catch (NumberFormatException numberFormatException) {
                    n6 = -1;
                }
                if (n6 < 10 || n6 > 99) {
                    System.err.println("Dialog font size must be from 10 to 99: " + stringArray[n]);
                    FontRename4.showHelp();
                    System.exit(-1);
                }
                font = new Font(SYSTEM_FONT, 0, n6);
                fontSize = n6;
                continue;
            }
            if (string.startsWith("-w") || mswinFlag && string.startsWith("/w")) {
                Pattern pattern = Pattern.compile("\\s*\\(\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*,\\s*(\\d{1,5})\\s*\\)\\s*");
                object = pattern.matcher(string.substring(2));
                if (((Matcher)object).matches()) {
                    n3 = Integer.parseInt(((Matcher)object).group(1));
                    n4 = Integer.parseInt(((Matcher)object).group(2));
                    n5 = Integer.parseInt(((Matcher)object).group(3));
                    n2 = Integer.parseInt(((Matcher)object).group(4));
                    continue;
                }
                System.err.println("Invalid window position or size: " + stringArray[n]);
                FontRename4.showHelp();
                System.exit(-1);
                continue;
            }
            if (string.equals("-x") || mswinFlag && string.equals("/x")) {
                bl = true;
                continue;
            }
            if (string.startsWith("-") || mswinFlag && string.startsWith("/")) {
                System.err.println("Option not recognized: " + stringArray[n]);
                FontRename4.showHelp();
                System.exit(-1);
                continue;
            }
            if (!consoleFlag) {
                consoleFlag = true;
                FontRename4.loadConfig();
            }
            FontRename4.processFileOrFolder(new File(stringArray[n]));
        }
        if (consoleFlag) {
            FontRename4.printAlways("Found " + FontRename4.prettyPlural(fileCount, "file") + " and " + FontRename4.prettyPlural(folderCount, "folder") + " with " + FontRename4.prettyPlural(changeCount, "change") + ".");
            System.exit(changeCount);
        }
        FontRename4User fontRename4User = new FontRename4User();
        fileChooser = new JFileChooser();
        statusTimer = new Timer(700, fontRename4User);
        if (!fontName.equals(new Font(fontName, 0, fontSize).getFamily())) {
            fontName = SYSTEM_FONT;
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(Box.createVerticalStrut(9));
        object = new JPanel(new FlowLayout(1, 40, 5));
        openButton = new JButton("Open Font File/Folder...");
        openButton.addActionListener(fontRename4User);
        if (font != null) {
            openButton.setFont(font);
        }
        openButton.setMnemonic(79);
        openButton.setToolTipText("Start finding/opening files.");
        ((Container)object).add(openButton);
        cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(fontRename4User);
        cancelButton.setEnabled(false);
        if (font != null) {
            cancelButton.setFont(font);
        }
        cancelButton.setMnemonic(67);
        cancelButton.setToolTipText("Stop finding/opening files.");
        ((Container)object).add(cancelButton);
        saveButton = new JButton("Save Output...");
        saveButton.addActionListener(fontRename4User);
        if (font != null) {
            saveButton.setFont(font);
        }
        saveButton.setMnemonic(83);
        saveButton.setToolTipText("Save output text to a file.");
        ((Container)object).add(saveButton);
        exitButton = new JButton("Exit");
        exitButton.addActionListener(fontRename4User);
        if (font != null) {
            exitButton.setFont(font);
        }
        exitButton.setMnemonic(88);
        exitButton.setToolTipText("Close this program.");
        ((Container)object).add(exitButton);
        jPanel.add((Component)object);
        jPanel.add(Box.createVerticalStrut(2));
        JPanel jPanel2 = new JPanel(new FlowLayout(1, 5, 5));
        fontNameDialog = new JComboBox<String>(GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames());
        fontNameDialog.setEditable(false);
        if (font != null) {
            fontNameDialog.setFont(font);
        }
        fontNameDialog.setSelectedItem(fontName);
        fontNameDialog.setToolTipText("Font name for displayed text.");
        fontNameDialog.addActionListener(fontRename4User);
        jPanel2.add(fontNameDialog);
        TreeSet<String> treeSet = new TreeSet<String>();
        string = String.valueOf(fontSize);
        treeSet.add(string);
        for (n = 0; n < FONT_SIZES.length; ++n) {
            treeSet.add(FONT_SIZES[n]);
        }
        fontSizeDialog = new JComboBox<Object>(treeSet.toArray());
        fontSizeDialog.setEditable(false);
        if (font != null) {
            fontSizeDialog.setFont(font);
        }
        fontSizeDialog.setSelectedItem(string);
        fontSizeDialog.setToolTipText("Point size for displayed text.");
        fontSizeDialog.addActionListener(fontRename4User);
        jPanel2.add(fontSizeDialog);
        jPanel2.add(Box.createHorizontalStrut(20));
        recurseCheckbox = new JCheckBox("subfolders", recurseFlag);
        if (font != null) {
            recurseCheckbox.setFont(font);
        }
        recurseCheckbox.setToolTipText("Select to search folders and subfolders.");
        recurseCheckbox.addActionListener(fontRename4User);
        jPanel2.add(recurseCheckbox);
        jPanel2.add(Box.createHorizontalStrut(20));
        reportDialog = new JComboBox<String>(REPORT_CHOICES);
        reportDialog.setEditable(false);
        if (font != null) {
            reportDialog.setFont(font);
        }
        reportDialog.setSelectedIndex(reportIndex);
        reportDialog.setToolTipText("Select level of detail for messages.");
        reportDialog.addActionListener(fontRename4User);
        jPanel2.add(reportDialog);
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(6));
        JPanel jPanel3 = new JPanel(new FlowLayout(1, 10, 0));
        jPanel3.add(jPanel);
        outputText = new JTextArea(12, 40);
        outputText.setEditable(false);
        outputText.setFont(new Font(fontName, 0, fontSize));
        outputText.setLineWrap(false);
        outputText.setMargin(new Insets(5, 6, 5, 6));
        outputText.setText("Rename OpenType and TrueType font files with their internal\n\"font full name\" using only plain text characters (ASCII) plus\nan extension for the type (*.OTF, *.TTC, *.TTF), or using the\nfull Unicode character set.  This gives consistent names to font\nfiles, no matter what their source.  The contents of the files\nare not changed, only the names in the system file directory.\nDon't use this program on system folders with installed fonts.\n\nChoose your options; then open files or folders to search.\n\nCopyright (c) 2009 by Keith Fenske.  Released under GNU Public License.\n");
        JPanel jPanel4 = new JPanel(new BorderLayout(0, 0));
        statusDialog = new JLabel(EMPTY_STATUS, 2);
        if (font != null) {
            statusDialog.setFont(font);
        }
        statusDialog.setToolTipText("Running status as files are processed by the Open button.");
        jPanel4.add(Box.createVerticalStrut(4), "North");
        jPanel4.add(Box.createHorizontalStrut(10), "West");
        jPanel4.add((Component)statusDialog, "Center");
        jPanel4.add(Box.createHorizontalStrut(10), "East");
        jPanel4.add(Box.createVerticalStrut(3), "South");
        mainFrame = new JFrame(PROGRAM_TITLE);
        Container container = mainFrame.getContentPane();
        container.setLayout(new BorderLayout(0, 0));
        container.add((Component)jPanel3, "North");
        container.add((Component)new JScrollPane(outputText), "Center");
        container.add((Component)jPanel4, "South");
        mainFrame.setDefaultCloseOperation(3);
        mainFrame.setLocation(n3, n4);
        if (n2 < 200 || n5 < 200) {
            mainFrame.pack();
        } else {
            mainFrame.setSize(n5, n2);
        }
        if (bl) {
            mainFrame.setExtendedState(6);
        }
        mainFrame.validate();
        mainFrame.setVisible(true);
        FontRename4.loadConfig();
    }

    static String calculateChecksum(File file) {
        String string = file.getPath();
        long l = file.length();
        String string2 = "CRC32BAD";
        long l2 = 0L;
        long l3 = 0L;
        String string3 = null;
        if (!consoleFlag) {
            FontRename4.setStatusMessage("Checksum " + formatComma.format(l) + " bytes for " + string);
        }
        try {
            int n;
            byte[] byArray = new byte[65536];
            CRC32 cRC32 = new CRC32();
            FileInputStream fileInputStream = new FileInputStream(file);
            while ((n = fileInputStream.read(byArray, 0, 65536)) > 0) {
                if (cancelFlag) {
                    fileInputStream.close();
                    FontRename4.printDebug(string + " - CRC32 calculation cancelled by user");
                    return string2;
                }
                cRC32.update(byArray, 0, n);
                if (consoleFlag || (l3 += (long)n) - l2 <= 0x500000L) continue;
                if (string3 == null) {
                    string3 = " of " + FontRename4.formatMegabytes(l) + " MB for " + string;
                }
                l2 = l3;
                FontRename4.setStatusMessage("Checksum " + FontRename4.formatMegabytes(l3) + string3);
            }
            fileInputStream.close();
            string2 = "00000000" + Long.toHexString(cRC32.getValue());
            string2 = string2.substring(string2.length() - 8);
        }
        catch (IOException iOException) {
            FontRename4.printDebug(string + " - file I/O error: " + iOException.getMessage());
            return string2;
        }
        FontRename4.printDebug(string + " - size " + formatComma.format(l) + " checksum " + string2);
        return string2;
    }

    static String collapseString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        boolean bl2 = true;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                bl = !bl2;
                continue;
            }
            if (bl) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(c);
            bl = false;
            bl2 = false;
        }
        return stringBuffer.toString();
    }

    static String convertFilename(String string) {
        String string2;
        char c;
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        for (n = 0; n < n2; ++n) {
            c = string.charAt(n);
            string2 = (String)convertMap.get(new Integer(c));
            if (string2 == null) {
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string2);
        }
        string2 = stringBuffer.toString();
        stringBuffer.setLength(0);
        n2 = string2.length();
        for (n = 0; n < n2; ++n) {
            c = string2.charAt(n);
            if (Character.isISOControl(c) || c == '\"' || c == '*' || c == '/' || c == ':' || c == '<' || c == '>' || c == '?' || c == '\\' || c == '|') {
                stringBuffer.append('-');
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    static void doCancelButton() {
        cancelFlag = true;
        FontRename4.printAlways("Cancelled by user.", true);
    }

    static void doOpenButton() {
        fileChooser.resetChoosableFileFilters();
        fileChooser.addChoosableFileFilter(fontFilter);
        fileChooser.setDialogTitle("Open Font Files or Folders...");
        fileChooser.setFileFilter(allTypesFlag ? fileChooser.getAcceptAllFileFilter() : fontFilter);
        fileChooser.setFileHidingEnabled(!hiddenFlag);
        fileChooser.setFileSelectionMode(2);
        fileChooser.setMultiSelectionEnabled(true);
        if (fileChooser.showOpenDialog(mainFrame) != 0) {
            return;
        }
        openFileList = FontRename4.sortFileList(fileChooser.getSelectedFiles());
        cancelButton.setEnabled(true);
        cancelFlag = false;
        folderCount = 0;
        fileCount = 0;
        changeCount = 0;
        openButton.setEnabled(false);
        outputText.setText("");
        FontRename4.setStatusMessage(EMPTY_STATUS);
        statusTimer.start();
        openFilesThread = new Thread((Runnable)new FontRename4User(), "doOpenRunner");
        openFilesThread.setPriority(1);
        openFilesThread.start();
    }

    static void doOpenRunner() {
        for (int i = 0; i < openFileList.length && !cancelFlag; ++i) {
            FontRename4.processFileOrFolder(openFileList[i]);
        }
        FontRename4.printAlways("Found " + FontRename4.prettyPlural(fileCount, "file") + " and " + FontRename4.prettyPlural(folderCount, "folder") + " with " + FontRename4.prettyPlural(changeCount, "change") + ".", true);
        cancelButton.setEnabled(false);
        openButton.setEnabled(true);
        statusTimer.stop();
        FontRename4.setStatusMessage(EMPTY_STATUS);
    }

    static void doSaveButton() {
        fileChooser.resetChoosableFileFilters();
        fileChooser.setDialogTitle("Save Output as Text File...");
        fileChooser.setFileHidingEnabled(true);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setMultiSelectionEnabled(false);
        if (fileChooser.showSaveDialog(mainFrame) != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        if (file.isDirectory()) {
            JOptionPane.showMessageDialog(mainFrame, file.getName() + " is a directory or folder.\nPlease select a normal file.");
            return;
        }
        if (file.isHidden()) {
            JOptionPane.showMessageDialog(mainFrame, file.getName() + " is a hidden or protected file.\nPlease select a normal file.");
            return;
        }
        if (file.isFile()) {
            if (!file.canWrite()) {
                JOptionPane.showMessageDialog(mainFrame, file.getName() + " is locked or write protected.\nCan't write to this file.");
                return;
            }
            if (JOptionPane.showConfirmDialog(mainFrame, file.getName() + " already exists.\nDo you want to replace this with a new file?") != 0) {
                return;
            }
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            outputText.write(fileWriter);
            fileWriter.close();
        }
        catch (IOException iOException) {
            FontRename4.printAlways("Can't write to text file: " + iOException.getMessage(), true);
        }
    }

    static String formatHexBytes(byte[] byArray) {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            stringBuffer.append(cArray[by >> 4 & 0xF]);
            stringBuffer.append(cArray[by & 0xF]);
        }
        return stringBuffer.toString();
    }

    static String formatMegabytes(long l) {
        return formatPointOne.format((double)l / 1048576.0);
    }

    static void loadConfig() {
        int n;
        int n2;
        Pattern pattern = Pattern.compile("\\s*(-?\\d+)\\s+(-?\\d+)\\s+(-?\\d+)\\s+(-?\\d+)(?:\\s+([-.:_0-9A-Za-z]+))?(?:\\s+#.*)?\\s*");
        Vector<int[]> vector = new Vector<int[]>();
        StringBuffer stringBuffer = new StringBuffer();
        Vector<String> vector2 = new Vector<String>();
        convertMap = new TreeMap();
        Pattern pattern2 = Pattern.compile("\\s*[Uu]\\+([0-9A-Fa-f]+)\\s*=\\s*\"([^\"]*)\"(?:\\s+#.*)?\\s*");
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(dataFile), "UTF-8"));
            bufferedReader.mark(4);
            n2 = bufferedReader.read();
            if (n2 >= 0 && n2 != 65279 && n2 != 65534) {
                bufferedReader.reset();
            }
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                Matcher matcher;
                char c;
                stringBuffer.setLength(0);
                n = string.length();
                for (n2 = 0; n2 < n && Character.isWhitespace(string.charAt(n2)); ++n2) {
                }
                while (n2 < n && Character.isLetterOrDigit(c = string.charAt(n2))) {
                    stringBuffer.append(Character.toLowerCase(c));
                    ++n2;
                }
                String string2 = stringBuffer.toString();
                if (string2.equals("accept")) {
                    matcher = pattern.matcher(string.substring(n2));
                    if (matcher.matches()) {
                        object = new int[4];
                        for (n2 = 0; n2 < 4; ++n2) {
                            try {
                                object[n2] = Integer.parseInt(matcher.group(n2 + 1));
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                object[n2] = -999999999;
                            }
                        }
                        String string3 = matcher.group(5);
                        if (string3 != null && string3.length() == 0) {
                            string3 = null;
                        }
                        if (object[0] >= 0 && object[0] <= 65535 && object[1] >= -1 && object[1] <= 65535 && object[2] >= -1 && object[2] <= 65535 && object[3] >= 0 && object[3] <= 65535 && (string3 == null || Charset.isSupported(string3))) {
                            vector.add((int[])object);
                            vector2.add(string3);
                            continue;
                        }
                        System.err.println("Invalid name table accept value: " + string);
                        continue;
                    }
                    System.err.println("Invalid name table accept syntax: " + string);
                    continue;
                }
                if (string2.equals("convert")) {
                    matcher = pattern2.matcher(string.substring(n2));
                    if (matcher.matches()) {
                        try {
                            n2 = Integer.parseInt(matcher.group(1), 16);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n2 = -999999999;
                        }
                        if (n2 >= 0 && n2 <= 65535) {
                            object = new Integer(n2);
                            if (convertMap.containsKey(object)) {
                                System.err.println("Duplicate character conversion: " + string);
                                continue;
                            }
                            convertMap.put(object, matcher.group(2));
                            continue;
                        }
                        System.err.println("Invalid character convert value: " + string);
                        continue;
                    }
                    System.err.println("Invalid character convert syntax: " + string);
                    continue;
                }
                if (string2.length() > 0) {
                    System.err.println("Unknown configuration command: " + string);
                    continue;
                }
                if (n2 >= n || string.charAt(n2) == '#') continue;
                System.err.println("Invalid configuration comment: " + string);
            }
            bufferedReader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            if (!dataFile.equals(DEFAULT_FILE)) {
                System.err.println("Configuration data file not found: " + dataFile);
                System.err.println("in current working directory " + System.getProperty("user.dir"));
            }
        }
        catch (IOException iOException) {
            System.err.println("Unable to read configuration data from file " + dataFile);
            System.err.println("in current working directory " + System.getProperty("user.dir"));
            System.err.println(iOException.getMessage());
        }
        if (vector.size() == 0) {
            acceptCharset = DEFAULT_CHARSET;
            acceptEntries = DEFAULT_ACCEPT;
        } else {
            n = vector.size();
            acceptCharset = new String[n];
            acceptEntries = new int[n][];
            for (n2 = 0; n2 < n; ++n2) {
                FontRename4.acceptCharset[n2] = (String)vector2.get(n2);
                FontRename4.acceptEntries[n2] = (int[])vector.get(n2);
            }
        }
    }

    static String prettyPlural(long l, String string) {
        return FontRename4.prettyPlural(l, string, string + "s");
    }

    static String prettyPlural(long l, String string, String string2) {
        String[] stringArray = new String[]{"zero", "one", "two"};
        String string3 = l >= 0L && l < (long)stringArray.length ? stringArray[(int)l] : formatComma.format(l);
        string3 = l == 1L ? string3 + EMPTY_STATUS + string : string3 + EMPTY_STATUS + string2;
        return string3;
    }

    static void printAlways(String string) {
        FontRename4.printAlways(string, false);
    }

    static void printAlways(String string, boolean bl) {
        if (consoleFlag) {
            System.out.println(string);
        } else {
            outputText.append(string + "\n");
            if (bl) {
                outputText.select(999999999, 999999999);
            }
        }
    }

    static void printChange(String string) {
        if (reportIndex == 1 || reportIndex > 2) {
            FontRename4.printAlways(string);
        }
    }

    static void printFailure(String string) {
        if (reportIndex >= 2) {
            FontRename4.printAlways(string);
        }
    }

    static void printSummary(String string) {
        if (reportIndex >= 3) {
            FontRename4.printAlways(string);
        }
    }

    static void printDebug(String string) {
        if (!cancelFlag && reportIndex >= 4) {
            FontRename4.printAlways(string);
        }
    }

    static void processFileOrFolder(File file) {
        if (cancelFlag) {
            return;
        }
        String string = file.getPath().toLowerCase();
        if (string.startsWith("/system") || string.indexOf("/library/fonts") >= 0 || string.indexOf(":\\windows") > 0 || string.indexOf(":\\winnt") > 0) {
            FontRename4.printAlways(file.getPath() + " - not safe with system folders");
            return;
        }
        if (file.isDirectory()) {
            ++folderCount;
            FontRename4.setStatusMessage("Searching folder " + file.getPath());
            File[] fileArray = FontRename4.sortFileList(file.listFiles());
            for (int i = 0; i < fileArray.length; ++i) {
                if (cancelFlag) {
                    return;
                }
                File file2 = fileArray[i];
                if (!hiddenFlag && file2.isHidden()) {
                    FontRename4.printSummary(file2.getPath() + " - ignoring hidden file or folder");
                    continue;
                }
                if (file2.isDirectory()) {
                    if (recurseFlag) {
                        FontRename4.printSummary(file2.getPath() + " - searching subfolder");
                        FontRename4.processFileOrFolder(file2);
                        continue;
                    }
                    FontRename4.printSummary(file2.getPath() + " - ignoring subfolder");
                    continue;
                }
                if (file2.isFile()) {
                    FontRename4.processUnknownFile(file2, allTypesFlag);
                    continue;
                }
                FontRename4.printSummary(file2.getPath() + " - not a file or folder");
            }
        } else if (file.isFile()) {
            FontRename4.processUnknownFile(file, true);
        } else {
            FontRename4.printAlways(file.getPath() + " - not a file or folder");
        }
    }

    static void processTrueType(File file, String string) {
        String string2 = file.getPath();
        long l = file.length();
        boolean bl = checksumFlag;
        if (cancelFlag) {
            return;
        }
        FontRename4.printDebug(string2 + " - processTrueType called, oldName = <" + string + ">");
        try {
            int n;
            RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
            String string3 = null;
            long l2 = -1L;
            if (l < 16L) {
                FontRename4.printDebug(string2 + " - file too small for OTF/TTC/TTF signature");
            } else {
                long l3 = (long)randomAccessFile.readInt() & 0xFFFFFFFFL;
                if (l3 == 65536L || l3 == 1953658213L) {
                    string3 = "ttf";
                    l2 = 0L;
                } else if (l3 == 0x4F54544FL) {
                    string3 = "otf";
                    l2 = 0L;
                } else if (l3 == 1953784678L) {
                    string3 = "ttc";
                    randomAccessFile.skipBytes(8);
                    l2 = (long)randomAccessFile.readInt() & 0xFFFFFFFFL;
                } else {
                    FontRename4.printDebug(string2 + " - not recognized as OTF/TTC/TTF font, signature = 0x" + Long.toHexString(l3));
                }
            }
            if (l2 >= 0L) {
                FontRename4.printDebug(string2 + " - Offset Table is at 0x" + Long.toHexString(l2) + ", file type is <" + string3 + ">");
            }
            long l4 = -1L;
            if (!cancelFlag && forcedName == null && l2 >= 0L) {
                if (l < l2 + 12L) {
                    FontRename4.printDebug(string2 + " - file too small for Offset Table header");
                } else {
                    randomAccessFile.seek(l2 + 4L);
                    int n2 = randomAccessFile.readUnsignedShort();
                    if (n2 < 1 || n2 > 299) {
                        FontRename4.printDebug(string2 + " - too many entries in Offset Table (" + n2 + ")");
                    } else if (l < l2 + 12L + (long)(16 * n2)) {
                        FontRename4.printDebug(string2 + " - file too small for Offset Table entries");
                    } else {
                        randomAccessFile.skipBytes(6);
                        for (n = 0; n < n2; ++n) {
                            if (((long)randomAccessFile.readInt() & 0xFFFFFFFFL) == 1851878757L) {
                                randomAccessFile.skipBytes(4);
                                l4 = (long)randomAccessFile.readInt() & 0xFFFFFFFFL;
                                break;
                            }
                            randomAccessFile.skipBytes(12);
                        }
                        if (l4 > 0L) {
                            FontRename4.printDebug(string2 + " - \"name\" table is at 0x" + Long.toHexString(l4));
                        } else {
                            FontRename4.printDebug(string2 + " - \"name\" table not found");
                        }
                    }
                }
            }
            String string4 = null;
            if (!cancelFlag && forcedName == null && l4 > 0L) {
                if (l < l4 + 6L) {
                    FontRename4.printDebug(string2 + " - file too small for \"name\" header");
                } else {
                    randomAccessFile.seek(l4 + 2L);
                    int n3 = randomAccessFile.readUnsignedShort();
                    if (n3 < 1 || n3 > 9999) {
                        FontRename4.printDebug(string2 + " - too many entries in \"name\" table (" + n3 + ")");
                    } else if (l < l4 + 6L + (long)(12 * n3)) {
                        FontRename4.printDebug(string2 + " - file too small for \"name\" table entries");
                    } else {
                        long l5 = randomAccessFile.readUnsignedShort();
                        int n4 = acceptEntries.length;
                        int n5 = -1;
                        int n6 = -1;
                        int n7 = -1;
                        int n8 = -1;
                        for (int i = 0; i < n3; ++i) {
                            randomAccessFile.seek(l4 + 6L + (long)(12 * i));
                            int n9 = randomAccessFile.readUnsignedShort();
                            int n10 = randomAccessFile.readUnsignedShort();
                            int n11 = randomAccessFile.readUnsignedShort();
                            int n12 = randomAccessFile.readUnsignedShort();
                            int n13 = randomAccessFile.readUnsignedShort();
                            int n14 = randomAccessFile.readUnsignedShort();
                            String string5 = null;
                            for (int j = 0; j < n4; ++j) {
                                if (acceptEntries[j][0] >= 0 && n9 != acceptEntries[j][0] || acceptEntries[j][1] >= 0 && n10 != acceptEntries[j][1] || acceptEntries[j][2] >= 0 && n11 != acceptEntries[j][2] || acceptEntries[j][3] >= 0 && n12 != acceptEntries[j][3]) continue;
                                FontRename4.printDebug(string2 + " - comparing (" + n9 + ", " + n10 + ", " + n11 + ", " + n12 + ") against table (" + acceptEntries[j][0] + ", " + acceptEntries[j][1] + ", " + acceptEntries[j][2] + ", " + acceptEntries[j][3] + (acceptCharset[j] == null ? ")" : ") " + acceptCharset[j]));
                                if (string5 == null) {
                                    String string6 = null;
                                    if (n9 == 0) {
                                        string6 = UNICODE_BMP;
                                    } else if (n9 == 1) {
                                        switch (n10) {
                                            case 0: {
                                                string6 = "MacRoman";
                                                break;
                                            }
                                            case 1: {
                                                string6 = "Shift_JIS";
                                                break;
                                            }
                                            case 2: {
                                                string6 = "Big5";
                                                break;
                                            }
                                            case 3: {
                                                string6 = "EUC-KR";
                                                break;
                                            }
                                            case 4: {
                                                string6 = "MacArabic";
                                                break;
                                            }
                                            case 5: {
                                                string6 = "MacHebrew";
                                                break;
                                            }
                                            case 6: {
                                                string6 = "MacGreek";
                                                break;
                                            }
                                            case 7: {
                                                string6 = "MacCyrillic";
                                                break;
                                            }
                                            case 21: {
                                                string6 = "MacThai";
                                                break;
                                            }
                                            case 25: {
                                                string6 = "GBK";
                                                break;
                                            }
                                        }
                                    } else if (n9 == 3) {
                                        switch (n10) {
                                            case 0: {
                                                string6 = UNICODE_BMP;
                                                break;
                                            }
                                            case 1: {
                                                string6 = UNICODE_BMP;
                                                break;
                                            }
                                            case 2: {
                                                string6 = "Shift_JIS";
                                                break;
                                            }
                                            case 3: {
                                                string6 = "GBK";
                                                break;
                                            }
                                            case 4: {
                                                string6 = "Big5";
                                                break;
                                            }
                                            case 5: {
                                                string6 = "EUC-KR";
                                                break;
                                            }
                                            case 6: {
                                                string6 = "x-Johab";
                                                break;
                                            }
                                            case 10: {
                                                string6 = UNICODE_BMP;
                                                break;
                                            }
                                        }
                                    }
                                    if (string6 == null) {
                                        FontRename4.printDebug(string2 + " - no character set for entry (" + n9 + ", " + n10 + ", " + n11 + ", " + n12 + ")");
                                        break;
                                    }
                                    if (n13 < 1 || n13 > 255 || l < l4 + l5 + (long)n14 + (long)n13) {
                                        FontRename4.printDebug(string2 + " - bad length 0x" + Integer.toHexString(n13) + " or offset 0x" + Integer.toHexString(n14) + " for entry (" + n9 + ", " + n10 + ", " + n11 + ", " + n12 + ")");
                                        break;
                                    }
                                    byte[] byArray = new byte[n13];
                                    randomAccessFile.seek(l4 + l5 + (long)n14);
                                    randomAccessFile.read(byArray);
                                    FontRename4.printDebug(string2 + " - name entry (" + n9 + ", " + n10 + ", " + n11 + ", " + n12 + ") " + string6 + " 0x" + FontRename4.formatHexBytes(byArray));
                                    byte[] byArray2 = byArray;
                                    int n15 = byArray.length;
                                    if (!string6.equals(UNICODE_BMP)) {
                                        byArray2 = new byte[byArray.length];
                                        n15 = 0;
                                        for (n = 0; n < byArray.length; ++n) {
                                            if (byArray[n] == 0 || byArray[n] == 127) continue;
                                            byArray2[n15++] = byArray[n];
                                        }
                                    }
                                    try {
                                        string5 = new String(byArray2, 0, n15, string6);
                                        FontRename4.printDebug(string2 + " - decoded font name is <" + string5 + ">");
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        FontRename4.printDebug(string2 + " - encoding <" + string6 + "> not supported on this computer");
                                    }
                                }
                                if (string5 == null || string5.length() == 0) break;
                                if (acceptCharset[j] != null) {
                                    if (string5.equals(new String(string5.getBytes(acceptCharset[j]), acceptCharset[j]))) {
                                        FontRename4.printDebug(string2 + " - name matches character set <" + acceptCharset[j] + ">");
                                    } else {
                                        FontRename4.printDebug(string2 + " - name not in character set <" + acceptCharset[j] + ">");
                                        continue;
                                    }
                                }
                                if (j < n4) {
                                    n4 = j;
                                    n5 = n10;
                                    n6 = n11;
                                    n7 = n12;
                                    n8 = n9;
                                    string4 = string5;
                                }
                                if (n4 == 0) break;
                            }
                            if (n4 == 0) break;
                        }
                        if (string4 != null) {
                            FontRename4.printDebug(string2 + " - using entry (" + n8 + ", " + n5 + ", " + n6 + ", " + n7 + ") with name <" + string4 + ">");
                            String string7 = FontRename4.convertFilename(string4);
                            if (!string4.equals(string7)) {
                                string4 = string7;
                                FontRename4.printDebug(string2 + " - replacing some characters <" + string4 + ">");
                            }
                            if (!string4.equals(string7 = FontRename4.collapseString(string4))) {
                                string4 = string7;
                                FontRename4.printDebug(string2 + " - removing extra spaces <" + string4 + ">");
                            }
                        }
                    }
                }
            }
            if (string3 != null) {
                if (forcedName != null) {
                    bl = true;
                    string4 = forcedName;
                    FontRename4.printDebug(string2 + " - ignoring font name, using forced <" + string4 + "> plus checksum");
                } else if (string4 == null || string4.length() <= 0) {
                    if (genericName != null) {
                        bl = true;
                        string4 = genericName;
                        FontRename4.printDebug(string2 + " - no valid font name, using generic <" + string4 + "> plus checksum");
                    } else if (bl) {
                        string4 = "Unknown";
                        FontRename4.printDebug(string2 + " - no valid font name, using default <" + string4 + "> plus checksum");
                    } else {
                        string4 = null;
                    }
                }
            }
            randomAccessFile.close();
            if (cancelFlag) {
                return;
            }
            File file2 = null;
            if (string3 != null && string4 != null) {
                if (bl) {
                    string4 = string4 + "_" + FontRename4.calculateChecksum(file);
                }
                File file3 = file.getParentFile();
                for (n = 0; n < 100; ++n) {
                    if (cancelFlag) {
                        return;
                    }
                    file2 = n > 0 ? new File(file3, string4 + "(" + n + ")." + string3) : new File(file3, string4 + "." + string3);
                    if (string.equals(file2.getName())) {
                        FontRename4.printSummary(string2 + " - file name is correct");
                        break;
                    }
                    if (file.equals(file2)) {
                        FontRename4.renameFile(file, file2);
                        break;
                    }
                    if (!file2.exists()) {
                        FontRename4.renameFile(file, file2);
                        break;
                    }
                    file2 = null;
                }
                if (file2 == null) {
                    FontRename4.printFailure(string2 + " - can't rename as <" + string4 + "." + string3 + "> or similar");
                }
            } else {
                FontRename4.printFailure(string2 + " - can't find usable font name");
            }
        }
        catch (IOException iOException) {
            FontRename4.printFailure(string2 + " - can't read file");
        }
    }

    static void processUnknownFile(File file, boolean bl) {
        String string;
        String string2;
        if (cancelFlag) {
            return;
        }
        ++fileCount;
        String string3 = file.getPath();
        FontRename4.setStatusMessage("Reading file " + string3);
        try {
            string2 = file.getCanonicalFile().getName();
        }
        catch (IOException iOException) {
            string2 = file.getName();
        }
        int n = string2.lastIndexOf(46);
        if (n >= 0) {
            String string4 = string2.substring(0, n);
            string = string2.substring(n + 1).toLowerCase();
        } else {
            String string5 = string2;
            string = "";
        }
        if (bl || string.equals("otf") || string.equals("ttc") || string.equals("ttf")) {
            FontRename4.processTrueType(file, string2);
        } else if (string.equals("afm") || string.equals("cfg") || string.equals("inf") || string.equals("mmm") || string.equals("pfa") || string.equals("pfb") || string.equals("pfm")) {
            FontRename4.printSummary(string3 + " - ignoring PostScript font file (not supported)");
        } else if (string.equals("fon")) {
            FontRename4.printSummary(string3 + " - ignoring bitmapped font file (not supported)");
        } else if (string.equals("txt")) {
            FontRename4.printSummary(string3 + " - can't read Elmer Fudd, Hacker, Klingon, or Pig Latin");
        } else {
            FontRename4.printSummary(string3 + " - not a recognized font file type <" + string.toUpperCase() + ">");
        }
    }

    static void renameFile(File file, File file2) {
        String string = file2.getName();
        String string2 = file.getPath();
        if (!readonlyFlag && !file.canWrite()) {
            FontRename4.printFailure(string2 + " - can't rename read-only file to <" + string + ">");
        } else if (file.renameTo(file2)) {
            ++changeCount;
            FontRename4.printChange(string2 + " - renamed to <" + string + ">");
        } else {
            FontRename4.printFailure(string2 + " - failed to rename as <" + string + ">");
        }
    }

    static void setStatusMessage(String string) {
        statusPending = string;
        if (!consoleFlag && !statusTimer.isRunning()) {
            statusDialog.setText(string);
        }
    }

    static void showHelp() {
        System.err.println();
        System.err.println(PROGRAM_TITLE);
        System.err.println();
        System.err.println("  java  FontRename4  [options]  file or folder names");
        System.err.println();
        System.err.println("Options:");
        System.err.println("  -? = -help = show summary of command-line syntax");
        System.err.println("  -a0 = only check files with known extensions .OTF .TTC .TTF (default)");
        System.err.println("  -a1 = -a = check all file types, ignore current file name extensions");
        System.err.println("  -c0 = don't append CRC32 checksum to file names (default)");
        System.err.println("  -c1 = -c = append CRC32 checksum to file names (may be slow)");
        System.err.println("  -d# = text file with configuration data; default is -d\"FontRename4.txt\"");
        System.err.println("  -f# = ignore internal names; force given name \"#\" plus checksum");
        System.err.println("  -g# = generic name \"#\" plus checksum if no valid font name found");
        System.err.println("  -h0 = ignore hidden files or folders (default)");
        System.err.println("  -h1 = -h = process hidden files and folders");
        System.err.println("  -m0 = show only program summary, critical errors");
        System.err.println("  -m1 = show files with successful changes (default)");
        System.err.println("  -m2 = show only files that couldn't be changed");
        System.err.println("  -m3 = show all files, with summary for each file");
        System.err.println("  -m4 = show all files, with details for each file");
        System.err.println("  -r0 = don't try to rename read-only files (default)");
        System.err.println("  -r1 = -r = rename read-only files if permitted by system");
        System.err.println("  -s0 = do only given files or folders, no subfolders (default)");
        System.err.println("  -s1 = -s = process files, folders, and subfolders");
        System.err.println("  -u# = font size for buttons, dialogs, etc; default is local system;");
        System.err.println("      example: -u16");
        System.err.println("  -w(#,#,#,#) = normal window position: left, top, width, height;");
        System.err.println("      example: -w(50,50,700,500)");
        System.err.println("  -x = maximize application window; default is normal window");
        System.err.println();
        System.err.println("Output may be redirected with the \">\" operator.  If no file or folder names");
        System.err.println("are given on the command line, then a graphical interface will open.");
        System.err.println();
        System.err.println(COPYRIGHT_NOTICE);
    }

    static File[] sortFileList(File[] fileArray) {
        File[] fileArray2;
        if (fileArray == null) {
            fileArray2 = new File[]{};
        } else if (fileArray.length < 2) {
            fileArray2 = fileArray;
        } else {
            TreeMap<String, File> treeMap = new TreeMap<String, File>();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < fileArray.length; ++i) {
                stringBuffer.setLength(0);
                if (fileArray[i].isDirectory()) {
                    stringBuffer.append("2 ");
                } else {
                    stringBuffer.append("1 ");
                }
                String string = fileArray[i].getName();
                stringBuffer.append(string.toLowerCase());
                stringBuffer.append(EMPTY_STATUS);
                stringBuffer.append(string);
                treeMap.put(stringBuffer.toString(), fileArray[i]);
            }
            fileArray2 = treeMap.values().toArray(new File[0]);
        }
        return fileArray2;
    }

    static void userButton(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == cancelButton) {
            FontRename4.doCancelButton();
        } else if (object == exitButton) {
            System.exit(0);
        } else if (object == fontNameDialog) {
            fontName = (String)fontNameDialog.getSelectedItem();
            outputText.setFont(new Font(fontName, 0, fontSize));
        } else if (object == fontSizeDialog) {
            fontSize = Integer.parseInt((String)fontSizeDialog.getSelectedItem());
            outputText.setFont(new Font(fontName, 0, fontSize));
        } else if (object == openButton) {
            FontRename4.doOpenButton();
        } else if (object == recurseCheckbox) {
            recurseFlag = recurseCheckbox.isSelected();
        } else if (object == reportDialog) {
            reportIndex = reportDialog.getSelectedIndex();
        } else if (object == saveButton) {
            FontRename4.doSaveButton();
        } else if (object == statusTimer) {
            if (!statusPending.equals(statusDialog.getText())) {
                statusDialog.setText(statusPending);
            }
        } else {
            System.err.println("Error in userButton(): unknown ActionEvent: " + actionEvent);
        }
    }
}

