/*
 * Decompiled with CFR 0.152.
 */
package jdepend.framework;

import java.io.IOException;
import jdepend.framework.DependencyConstraint;
import jdepend.framework.JDepend;
import jdepend.framework.JDependTestCase;
import jdepend.framework.JavaPackage;
import jdepend.framework.PackageFilter;

public class ConstraintTest
extends JDependTestCase {
    private JDepend jdepend;

    public ConstraintTest(String name) {
        super(name);
    }

    protected void setUp() {
        super.setUp();
        PackageFilter filter = new PackageFilter();
        filter.addPackage("java.*");
        filter.addPackage("javax.*");
        this.jdepend = new JDepend(filter);
    }

    public void testMatchPass() {
        DependencyConstraint constraint = new DependencyConstraint();
        JavaPackage expectedA = constraint.addPackage("A");
        JavaPackage expectedB = constraint.addPackage("B");
        expectedA.dependsUpon(expectedB);
        JavaPackage actualA = new JavaPackage("A");
        JavaPackage actualB = new JavaPackage("B");
        actualA.dependsUpon(actualB);
        this.jdepend.addPackage(actualA);
        this.jdepend.addPackage(actualB);
        ConstraintTest.assertEquals((boolean)true, (boolean)this.jdepend.dependencyMatch(constraint));
    }

    public void testMatchFail() {
        DependencyConstraint constraint = new DependencyConstraint();
        JavaPackage expectedA = constraint.addPackage("A");
        JavaPackage expectedB = constraint.addPackage("B");
        JavaPackage expectedC = constraint.addPackage("C");
        expectedA.dependsUpon(expectedB);
        JavaPackage actualA = new JavaPackage("A");
        JavaPackage actualB = new JavaPackage("B");
        JavaPackage actualC = new JavaPackage("C");
        actualA.dependsUpon(actualB);
        actualA.dependsUpon(actualC);
        this.jdepend.addPackage(actualA);
        this.jdepend.addPackage(actualB);
        this.jdepend.addPackage(actualC);
        ConstraintTest.assertEquals((boolean)false, (boolean)this.jdepend.dependencyMatch(constraint));
    }

    public void testJDependConstraints() throws IOException {
        this.jdepend.addDirectory(this.getBuildDir());
        this.jdepend.analyze();
        DependencyConstraint constraint = new DependencyConstraint();
        JavaPackage junitframework = constraint.addPackage("junit.framework");
        JavaPackage junitui = constraint.addPackage("junit.textui");
        JavaPackage framework = constraint.addPackage("jdepend.framework");
        JavaPackage text = constraint.addPackage("jdepend.textui");
        JavaPackage xml = constraint.addPackage("jdepend.xmlui");
        JavaPackage swing = constraint.addPackage("jdepend.swingui");
        framework.dependsUpon(junitframework);
        framework.dependsUpon(junitui);
        text.dependsUpon(framework);
        xml.dependsUpon(text);
        swing.dependsUpon(framework);
        ConstraintTest.assertEquals((boolean)true, (boolean)this.jdepend.dependencyMatch(constraint));
    }
}

