/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugRanker;
import edu.umd.cs.findbugs.cloud.Cloud;
import edu.umd.cs.findbugs.cloud.db.DBCloud;
import edu.umd.cs.findbugs.gui2.FilterActivity;
import edu.umd.cs.findbugs.gui2.FilterListener;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;

public class ViewFilter {
    final MainFrame mf;
    RankFilter rank = RankFilter.ALL;
    CloudFilter eval = CloudFilter.ALL;
    OverallClassificationFilter classificationFilter = OverallClassificationFilter.ALL;
    FirstSeenFilter firstSeen = FirstSeenFilter.ALL;
    String[] classSearchStrings;
    static final Pattern legalClassSearchString = Pattern.compile("[\\p{javaLowerCase}\\p{javaUpperCase}0-9.$/_]*");

    public ViewFilter(MainFrame mf) {
        this.mf = mf;
    }

    void setPackagesToDisplay(String value) {
        if ((value = value.replace('/', '.').trim()).length() == 0) {
            this.classSearchStrings = new String[0];
        } else {
            String[] parts;
            for (String p : parts = value.split("[ ,:]+")) {
                if (legalClassSearchString.matcher(p).matches()) continue;
                throw new IllegalArgumentException("Class search string isn't a legal classname substring: " + p);
            }
            this.classSearchStrings = parts;
        }
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public RankFilter getRank() {
        return this.rank;
    }

    public void setRank(RankFilter rank) {
        this.rank = rank;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public CloudFilter getEvaluation() {
        return this.eval;
    }

    public void setEvaluation(CloudFilter eval) {
        if (this.eval == eval) {
            return;
        }
        this.eval = eval;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public void setClassification(OverallClassificationFilter classificationFilter) {
        if (this.classificationFilter == classificationFilter) {
            return;
        }
        this.classificationFilter = classificationFilter;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public FirstSeenFilter getFirstSeen() {
        return this.firstSeen;
    }

    public void setFirstSeen(FirstSeenFilter firstSeen) {
        this.firstSeen = firstSeen;
        FilterActivity.notifyListeners(FilterListener.Action.FILTERING, null);
    }

    public String[] getPackagePrefixes() {
        return this.classSearchStrings;
    }

    public boolean showIgnoringPackagePrefixes(BugInstance b) {
        if (!this.firstSeen.show(this.mf, b)) {
            return false;
        }
        if (!this.rank.show(this.mf, b)) {
            return false;
        }
        if (!this.eval.show(this.mf, b)) {
            return false;
        }
        return this.classificationFilter.show(this.mf, b);
    }

    public static boolean matchedPrefixes(String[] classSearchStrings, @DottedClassName String className) {
        return ClassName.matchedPrefixes(classSearchStrings, className);
    }

    public boolean show(BugInstance b) {
        String className = b.getPrimaryClass().getClassName();
        return ClassName.matchedPrefixes(this.classSearchStrings, className) && this.showIgnoringPackagePrefixes(b);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum FirstSeenFilter implements ViewFilterEnum
    {
        LAST_DAY(1, "\u6700\u65b0"),
        LAST_3_DAYS(3, "\uff13\u65e5\u524d\u307e\u3067"),
        LAST_WEEK(7, "\u5148\u9031k"),
        LAST_MONTH(30, "\u5148\u6708"),
        LAST_THREE_MONTHS(91, "\uff19\uff10\u65e5\u524d\u307e\u3067"),
        ALL(400000, "\u3059\u3079\u3066");

        final int maxDays;
        final String displayName;

        private FirstSeenFilter(int days, String displayName) {
            this.maxDays = days;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            long firstSeen = mf.bugCollection.getCloud().getFirstSeen(b);
            long time = System.currentTimeMillis() - firstSeen;
            long days = TimeUnit.SECONDS.convert(time, TimeUnit.MILLISECONDS) / 3600L / 24L;
            return days < (long)this.maxDays;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum CloudFilter implements ViewFilterEnum
    {
        MY_REVIEWS("\u81ea\u5206\u3067\u5206\u985e"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getReviewers(b).contains(cloud.getUser());
            }
        }
        ,
        NOT_REVIEWED_BY_ME("\u4ed6\u4eba\u306b\u3088\u308b\u5206\u985e"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.getReviewers(b).contains(cloud.getUser());
            }
        }
        ,
        NO_REVIEWS("\u5206\u985e\u3055\u308c\u3066\u3044\u306a\u3044"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getReviewers(b).isEmpty();
            }

            public boolean supported(Cloud cloud) {
                return cloud instanceof DBCloud && cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        HAS_REVIEWS("\u3060\u308c\u304b\u304c\u5206\u985e"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.getReviewers(b).isEmpty();
            }

            public boolean supported(Cloud cloud) {
                return cloud instanceof DBCloud && cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        NO_ONE_COMMITTED_TO_FIXING("\u5bfe\u7b56\u306a\u3057"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.isClaimed(b);
            }

            public boolean supported(Cloud cloud) {
                return cloud instanceof DBCloud && cloud.getMode() != Cloud.Mode.SECRET;
            }
        }
        ,
        I_WILL_FIX("\u81ea\u5206\u304c\u4fee\u6b63"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getIWillFix(b);
            }
        }
        ,
        HAS_FILED_BUGS("\u30d0\u30b0\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u767b\u9332"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getBugLinkStatus(b).bugIsFiled();
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        NO_FILED_BUGS("\u30d0\u30b0\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u306b\u672a\u767b\u9332"){

            boolean show(DBCloud cloud, BugInstance b) {
                return !cloud.getBugLinkStatus(b).bugIsFiled();
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        WILL_NOT_FIX("\u30d0\u30b0\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3067\u3001\u4fee\u6b63\u3057\u306a\u3044\u3068\u767b\u9332"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getWillNotBeFixed(b);
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        BUG_STATUS_IS_UNASSIGNED("\u30d0\u30b0\u30c7\u30fc\u30bf\u30d9\u30fc\u30b9\u3067\u5272\u5f53\u3066\u3089\u308c\u3066\u3044\u306a\u3044"){

            boolean show(DBCloud cloud, BugInstance b) {
                return cloud.getBugIsUnassigned(b);
            }

            public boolean supported(Cloud cloud) {
                return cloud.supportsBugLinks();
            }
        }
        ,
        ALL("\u3059\u3079\u3066"){

            boolean show(DBCloud cloud, BugInstance b) {
                return true;
            }
        };

        final String displayName;

        private CloudFilter(String displayName) {
            this.displayName = displayName;
        }

        abstract boolean show(DBCloud var1, BugInstance var2);

        public boolean supported(Cloud cloud) {
            return true;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            Cloud c = mf.bugCollection.getCloud();
            if (c instanceof DBCloud) {
                return this.show((DBCloud)c, b);
            }
            return true;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum OverallClassificationFilter implements ViewFilterEnum
    {
        SHOULD_FIX("\u7dcf\u62ec\uff1a\u4fee\u6b63\u3059\u308b\u3079\u304d"){

            boolean show(DBCloud cloud, BugInstance b) {
                double score = cloud.getClassificationScore(b);
                return score >= (double)Cloud.UserDesignation.SHOULD_FIX.score();
            }
        }
        ,
        DONT_FIX("\u7dcf\u62ec\uff1a\u4fee\u6b63\u3057\u306a\u3044"){

            boolean show(DBCloud cloud, BugInstance b) {
                double score = cloud.getClassificationScore(b);
                return score <= (double)Cloud.UserDesignation.MOSTLY_HARMLESS.score();
            }
        }
        ,
        OBSOLETE("\u7dcf\u62ec\uff1a\u4f7f\u7528\u3055\u308c\u3066\u3044\u306a\u3044(obsolete)\u30b3\u30fc\u30c9"){

            boolean show(DBCloud cloud, BugInstance b) {
                double score = cloud.getPortionObsoleteClassifications(b);
                return score >= 0.5;
            }
        }
        ,
        UNCERTAIN("\u7dcf\u62ec\uff1a\u4e0d\u660e"){

            boolean show(DBCloud cloud, BugInstance b) {
                if (SHOULD_FIX.show(cloud, b) || DONT_FIX.show(cloud, b) || OBSOLETE.show(cloud, b)) {
                    return false;
                }
                return cloud.getNumberReviewers(b) >= 2;
            }
        }
        ,
        HIGH_VARIANCE("\u8b70\u8ad6\u7684"){

            boolean show(DBCloud cloud, BugInstance b) {
                double variance = cloud.getClassificationDisagreement(b);
                return variance > 0.26;
            }
        }
        ,
        ALL("\u3059\u3079\u3066"){

            boolean show(DBCloud cloud, BugInstance b) {
                return true;
            }
        };

        final String displayName;

        private OverallClassificationFilter(String displayName) {
            this.displayName = displayName;
        }

        abstract boolean show(DBCloud var1, BugInstance var2);

        public boolean supported(Cloud cloud) {
            return true;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            Cloud c = mf.bugCollection.getCloud();
            if (c instanceof DBCloud) {
                return this.show((DBCloud)c, b);
            }
            return true;
        }

        public String toString() {
            return this.displayName;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum RankFilter implements ViewFilterEnum
    {
        SCARIEST(4, "\u91cd\u5927"),
        SCARY(9, "\u8b66\u6212"),
        TROUBLING(14, "\u554f\u984c\u3042\u308a"),
        ALL(Integer.MAX_VALUE, "\u3059\u3079\u3066\u306e\u30d0\u30b0\u91cd\u8981\u5ea6");

        final int maxRank;
        final String displayName;

        private RankFilter(int maxRank, String displayName) {
            this.maxRank = maxRank;
            this.displayName = displayName;
        }

        @Override
        public boolean show(MainFrame mf, BugInstance b) {
            int rank = BugRanker.findRank(b);
            return rank <= this.maxRank;
        }

        public String toString() {
            if (this.maxRank < Integer.MAX_VALUE) {
                return this.displayName + " (Ranks 1 - " + this.maxRank + ")";
            }
            return this.displayName;
        }
    }

    static interface ViewFilterEnum {
        public boolean show(MainFrame var1, BugInstance var2);
    }
}

