/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.gui2.BugTreeModel;
import edu.umd.cs.findbugs.gui2.Driver;
import edu.umd.cs.findbugs.gui2.MainFrame;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.SwingThread;
import java.awt.Component;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreeModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SorterTableColumnModel
implements TableColumnModel {
    private ArrayList<Sortables> order = new ArrayList();
    private final Sortables[] sortables = Sortables.values();
    private boolean[] showOrder = new boolean[this.sortables.length];
    private ArrayList<TableColumn> columnList = new ArrayList();
    private DefaultListSelectionModel dlsm;
    private ArrayList<TableColumnModelListener> watchers = new ArrayList();
    private boolean frozen = false;

    public SorterTableColumnModel(Sortables[] columnHeaders) {
        for (int x = 0; x < columnHeaders.length; ++x) {
            Sortables c = columnHeaders[x];
            for (int y = 0; y < this.sortables.length; ++y) {
                if (!c.equals(this.sortables[y])) continue;
                this.showOrder[y] = true;
            }
            TableColumn tc = new TableColumn(x);
            FBTableCellRenderer temp = new FBTableCellRenderer();
            tc.setHeaderRenderer(temp);
            tc.setIdentifier(c);
            tc.setHeaderValue(c);
            tc.setResizable(false);
            tc.sizeWidthToFit();
            this.columnList.add(tc);
        }
        this.dlsm = new DefaultListSelectionModel();
        this.dlsm.setSelectionMode(0);
        this.orderUpdate();
    }

    public void createFrom(SorterTableColumnModel other) {
        int x;
        if (this.getOrder().equals(other.getOrder())) {
            return;
        }
        this.columnList.clear();
        for (x = 0; x < this.order.size(); ++x) {
            for (TableColumnModelListener l : this.watchers) {
                l.columnRemoved(new TableColumnModelEvent(this, x, x));
            }
        }
        for (x = 0; x < this.showOrder.length; ++x) {
            this.showOrder[x] = false;
        }
        for (x = 0; x < other.order.size(); ++x) {
            Sortables c = other.order.get(x);
            for (int y = 0; y < this.sortables.length; ++y) {
                if (!c.equals(this.sortables[y])) continue;
                this.showOrder[y] = true;
            }
            TableColumn tc = new TableColumn(x);
            tc.setHeaderRenderer(new FBTableCellRenderer());
            tc.setIdentifier(c);
            tc.setHeaderValue(c);
            tc.setResizable(false);
            tc.sizeWidthToFit();
            this.columnList.add(tc);
            for (TableColumnModelListener l : this.watchers) {
                l.columnAdded(new TableColumnModelEvent(this, x, x));
            }
        }
        this.dlsm = new DefaultListSelectionModel();
        this.dlsm.setSelectionMode(0);
        this.orderUpdate();
    }

    public SorterTableColumnModel(ArrayList<Sortables> columnHeaders) {
        this(columnHeaders.toArray(new Sortables[columnHeaders.size()]));
    }

    @Override
    public void addColumn(TableColumn arg0) {
        throw new UnsupportedOperationException("Can't change sorter table columns using addColumn");
    }

    @Override
    public void removeColumn(TableColumn arg0) {
        throw new UnsupportedOperationException("Can't change sorter table columns using removeColumn");
    }

    boolean[] getVisibleColumns() {
        return this.showOrder;
    }

    void setIndexChanged(int index) {
        block7: {
            boolean on;
            Sortables s;
            block6: {
                this.showOrder[index] = !this.showOrder[index];
                s = MainFrame.getInstance().sortables()[index];
                on = this.showOrder[index];
                if (!on) break block6;
                TableColumn tc = new TableColumn(this.columnList.size());
                tc.setHeaderRenderer(new FBTableCellRenderer());
                tc.setIdentifier(s);
                tc.setHeaderValue(s);
                tc.setResizable(false);
                tc.sizeWidthToFit();
                this.columnList.add(tc);
                for (int x = 0; x < this.columnList.size(); ++x) {
                    this.columnList.get(x).setModelIndex(x);
                }
                this.orderUpdate();
                for (TableColumnModelListener l : this.watchers) {
                    l.columnAdded(new TableColumnModelEvent(this, this.columnList.size() - 1, this.columnList.size() - 1));
                }
                break block7;
            }
            if (on) break block7;
            for (int x = 0; x < this.columnList.size(); ++x) {
                this.columnList.get(x).setModelIndex(x);
            }
            for (int counter = 0; counter < this.columnList.size(); ++counter) {
                TableColumn tc = this.columnList.get(counter);
                if (!tc.getIdentifier().equals(s)) continue;
                this.columnList.remove(counter);
                for (int x = counter; x < this.columnList.size(); ++x) {
                    this.columnList.get(x).setModelIndex(x);
                }
                this.orderUpdate();
                for (TableColumnModelListener l : this.watchers) {
                    l.columnRemoved(new TableColumnModelEvent(this, counter, counter));
                }
            }
        }
    }

    @Override
    public void moveColumn(int fromIndex, int toIndex) {
        MainFrame.getInstance().updateDesignationDisplay();
        MainFrame.getInstance().saveComments();
        TableColumn from = this.columnList.get(fromIndex);
        TableColumn to = this.columnList.get(toIndex);
        this.columnList.set(fromIndex, to);
        to.setModelIndex(fromIndex);
        this.columnList.set(toIndex, from);
        from.setModelIndex(toIndex);
        this.orderUpdate();
        for (TableColumnModelListener w : new ArrayList<TableColumnModelListener>(this.watchers)) {
            w.columnMoved(new TableColumnModelEvent(this, fromIndex, toIndex));
        }
    }

    @Override
    public void setColumnMargin(int arg0) {
        throw new UnsupportedOperationException("NoBah");
    }

    @Override
    public int getColumnCount() {
        return this.columnList.size();
    }

    @Override
    public Enumeration<TableColumn> getColumns() {
        return Collections.enumeration(this.columnList);
    }

    @Override
    public int getColumnIndex(Object columnIdentifier) {
        if (columnIdentifier == null) {
            throw new IllegalArgumentException("Dont send null to getColumnIndex, null shouldn't be in the sorting table.");
        }
        for (int x = 0; x < this.columnList.size(); ++x) {
            if (!this.columnList.get(x).getIdentifier().equals(columnIdentifier)) continue;
            return x;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public TableColumn getColumn(int x) {
        return this.columnList.get(x);
    }

    @Override
    public int getColumnMargin() {
        return 0;
    }

    @Override
    public int getColumnIndexAtX(int XPosition) {
        for (TableColumn tc : this.columnList) {
            if ((XPosition -= tc.getWidth()) >= 0) continue;
            return tc.getModelIndex();
        }
        return -1;
    }

    @Override
    public int getTotalColumnWidth() {
        int total = 0;
        for (TableColumn tc : this.columnList) {
            total += tc.getWidth();
        }
        return total;
    }

    @Override
    public void setColumnSelectionAllowed(boolean arg0) {
        throw new UnsupportedOperationException("BAH");
    }

    @Override
    public boolean getColumnSelectionAllowed() {
        return true;
    }

    @Override
    public int[] getSelectedColumns() {
        int index = this.dlsm.getMinSelectionIndex();
        if (index == -1) {
            return new int[0];
        }
        return new int[]{index};
    }

    @Override
    public int getSelectedColumnCount() {
        if (this.dlsm.getMinSelectionIndex() == -1) {
            return 0;
        }
        return 1;
    }

    @Override
    public void setSelectionModel(ListSelectionModel arg0) {
        throw new UnsupportedOperationException("No... NO NO NO NO");
    }

    @Override
    public ListSelectionModel getSelectionModel() {
        return this.dlsm;
    }

    @Override
    public void addColumnModelListener(TableColumnModelListener listener) {
        this.watchers.add(listener);
    }

    @Override
    public void removeColumnModelListener(TableColumnModelListener listener) {
        this.watchers.remove(listener);
    }

    public void columnSelectionChanged(ListSelectionEvent arg0) {
        throw new UnsupportedOperationException("columnSelectionChangedBAH");
    }

    ArrayList<Sortables> getOrder() {
        return this.order;
    }

    List<Sortables> getOrderBeforeDivider() {
        if (!this.order.contains(Sortables.DIVIDER)) {
            return this.order;
        }
        return this.order.subList(0, this.order.indexOf(Sortables.DIVIDER));
    }

    List<Sortables> getOrderAfterDivider() {
        if (!this.order.contains(Sortables.DIVIDER) || this.order.indexOf(Sortables.DIVIDER) == this.order.size() - 1) {
            return new ArrayList<Sortables>();
        }
        return this.order.subList(this.order.indexOf(Sortables.DIVIDER) + 1, this.order.size());
    }

    private void orderUpdate() {
        if (!this.frozen) {
            this.order = new ArrayList();
            for (int x = 0; x < this.columnList.size(); ++x) {
                this.order.add((Sortables)this.columnList.get(x).getIdentifier());
            }
        }
    }

    public void freezeOrder() {
        this.frozen = true;
    }

    @SwingThread
    public void thawOrder() {
        this.frozen = false;
        this.orderUpdate();
        TreeModel model = MainFrame.getInstance().getTree().getModel();
        if (model instanceof BugTreeModel) {
            ((BugTreeModel)model).checkSorter();
        }
    }

    static class FBTableCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer defaultRenderer = new JTableHeader().getDefaultRenderer();

        FBTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component comp = this.defaultRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (comp instanceof JLabel) {
                JLabel cell = (JLabel)comp;
                cell.setFont(cell.getFont().deriveFont(Driver.getFontSize()));
                cell.setFont(cell.getFont().deriveFont(1));
                cell.setBorder(BorderFactory.createCompoundBorder(cell.getBorder(), BorderFactory.createEmptyBorder(0, 6, 0, 6)));
                cell.setHorizontalAlignment(0);
                if (value == Sortables.DIVIDER) {
                    URL arrows = MainFrame.class.getResource("arrows.png");
                    if (arrows != null) {
                        cell.setText("");
                        cell.setIcon(new ImageIcon(arrows));
                    } else {
                        cell.setText("<->");
                    }
                }
            }
            return comp;
        }
    }
}

