/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.gui2;

import edu.umd.cs.findbugs.L10N;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.gui2.BugSet;
import edu.umd.cs.findbugs.gui2.FilterFactory;
import edu.umd.cs.findbugs.gui2.FilterMatcher;
import edu.umd.cs.findbugs.gui2.Sortables;
import edu.umd.cs.findbugs.gui2.StackedFilterMatcher;
import java.util.ArrayList;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BugAspects
implements Iterable<SortableValue> {
    private static final long serialVersionUID = -5503915081879996968L;
    private int count = -1;
    private ArrayList<SortableValue> lst = new ArrayList();

    public SortableValue last() {
        return this.lst.get(this.lst.size() - 1);
    }

    public int size() {
        return this.lst.size();
    }

    public SortableValue get(int i) {
        return this.lst.get(i);
    }

    public String toString() {
        if (this.lst.isEmpty()) {
            return L10N.getLocalString("tree.bugs", "Bugs") + " (" + this.count + ")";
        }
        if (this.count == -1) {
            return this.last().value;
        }
        return this.last().key.formatValue(this.last().value) + " (" + this.count + ")";
    }

    public void setCount(int count) {
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public BugAspects() {
    }

    public BugAspects(BugAspects a) {
        this.lst = new ArrayList<SortableValue>(a.lst);
        this.count = a.count;
    }

    public void add(SortableValue sp) {
        this.lst.add(sp);
    }

    public BugAspects addToNew(SortableValue sp) {
        BugAspects result = new BugAspects(this);
        result.lst.add(sp);
        return result;
    }

    public Matcher getMatcher() {
        return FilterFactory.makeAndMatcher(this.lst);
    }

    public StackedFilterMatcher getStackedFilterMatcher() {
        FilterMatcher[] filters = new FilterMatcher[this.lst.size()];
        for (int i = 0; i < filters.length; ++i) {
            filters[i] = new FilterMatcher(this.lst.get(i));
        }
        StackedFilterMatcher sfm = new StackedFilterMatcher(filters);
        return sfm;
    }

    public BugSet getMatchingBugs(BugSet theSet) {
        return theSet.getBugsMatchingFilter(this.getStackedFilterMatcher());
    }

    @Override
    public Iterator<SortableValue> iterator() {
        return this.lst.iterator();
    }

    static class SortableValue {
        public final Sortables key;
        public final String value;

        public SortableValue(Sortables key, String value) {
            this.key = key;
            this.value = value;
        }

        public int hashCode() {
            return this.key.hashCode() + this.value.hashCode();
        }

        public boolean equals(Object that) {
            if (!(that instanceof SortableValue)) {
                return false;
            }
            SortableValue thatStringPair = (SortableValue)that;
            return this.key.equals(thatStringPair.key) && this.value.equals(thatStringPair.value);
        }

        public String toString() {
            return this.key + ":" + this.value;
        }
    }
}

